/*****************************************************************************************
*
* \file    dia_IRoutineControl.h
*
* \brief   interface of dia_IRoutineControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IRoutineControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL__
#define __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_ROUTINE_CONTROL ((dia::IID) 0xf9d8db22)
class dia_IRoutineControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_ROUTINE_CONTROL; }
public:
   //! start the specified routine
   virtual tDiaResult startRoutine (dia_UID uid, std::vector<tU8>& params, tU8 timerValue = DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ) = 0;
   //! stop the specified routine
   virtual tDiaResult stopRoutine (dia_UID uid, std::vector<tU8>& params ) = 0;
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestRoutineResult (dia_UID uid, std::vector<tU8>& results ) = 0;
   //! query for a certain routine
   virtual tDiaResult queryRoutine (dia_UID uid, dia_Routine** ppRoutine ) = 0;
   //! query for a certain routine
   virtual tDiaResult queryRoutineByDID (tU16 did, dia_Routine** ppRoutine ) = 0;
   //! query for a certain routine
   virtual tDiaResult onRoutineTimeout (dia_UID uid ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IRoutineControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL__ */
