/*****************************************************************************************
*
* \file    dia_INavigationListener.h
*
* \brief   listener of dia_INavigationListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_INavigation.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_NAVIGATION_LISTENER__
#define __INCLUDED_DIA_INTERFACE_NAVIGATION_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_NAVIGATION__
#include "dia_INavigation.h"
#endif

#define IID_NAVIGATION_LISTENER ((dia::IID) 0x81d0dbf1)
/**
 *
 *  \class dia_INavigationListener
 *
 */

class dia_INavigationListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_NAVIGATION_LISTENER; }
public:
   //! route calculation is started
   virtual void vOnRouteCalculationStarted (tDiaResult result ) = 0;
   //! route calculation procedure is finished
   virtual void vOnRouteCalculationStatus (tU8 u8RouteCalculationStatus, tU32 u32RouteLength, tU32 u32RouteDuration ) = 0;
   //! result of setting the current position
   virtual void vOnCurrentPositionResult (tDiaResult result ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_INavigationListener( void ) {}
};
/**
 *
 *  \class dia_INavigationListenerImpl
 *
 */

class dia_INavigationListenerImpl
   : public dia_INavigationListener
{
public:
   //! route calculation is started
   virtual void vOnRouteCalculationStarted (tDiaResult /*result*/ ) {}
   //! route calculation procedure is finished
   virtual void vOnRouteCalculationStatus (tU8 /*u8RouteCalculationStatus*/, tU32 /*u32RouteLength*/, tU32 /*u32RouteDuration*/ ) {}
   //! result of setting the current position
   virtual void vOnCurrentPositionResult (tDiaResult /*result*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_INavigationListenerImpl( void ) {}
};
/**
 *
 *  \class dia_INavigationNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_INavigationNotifier
   : public dia_INavigationListener,
     public dia_Notifier<dia_INavigationListener>
{
public:
   //! route calculation is started
   virtual void vOnRouteCalculationStarted (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRouteCalculationStarted(result);
      }
   }
   //! route calculation procedure is finished
   virtual void vOnRouteCalculationStatus (tU8 u8RouteCalculationStatus, tU32 u32RouteLength, tU32 u32RouteDuration)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRouteCalculationStatus(u8RouteCalculationStatus, u32RouteLength, u32RouteDuration);
      }
   }
   //! result of setting the current position
   virtual void vOnCurrentPositionResult (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnCurrentPositionResult(result);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_NAVIGATION_LISTENER__ */
