/*****************************************************************************************
*
* \file    dia_IMediaAudioCd.h
*
* \brief   interface of dia_IMediaAudioCd
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IMediaAudioCd.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_CD__
#define __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_CD__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SYSADAPTER_MEDIA_AUDIO_CD ((dia::IID) 0x2dc93254)
class dia_IMediaAudioCd
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_MEDIA_AUDIO_CD; }
public:
   /**
    * Asynchronous request to skip one track up
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult audioTrackUp ( ) = 0;
   /**
    * Asynchronous request to skip one track down
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult audioTrackDown ( ) = 0;
   /**
    * Asynchronous request to select the given track
    * \param u16TrackNumber Track number to jump to
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult selectAudioTrack (const tU16 trackNumber ) = 0;
   /**
    * Asynchronous request to read the current track number
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult requestTrackNumber ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IMediaAudioCd( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_CD__ */
