/*****************************************************************************************
*
* \file    dia_IInputHandling.h
*
* \brief   interface of dia_IInputHandling
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author wgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IInputHandling.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_INPUT_HANDLING__
#define __INCLUDED_DIA_INTERFACE_INPUT_HANDLING__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_INPUT_HANDLING ((dia::IID) 0x14d7bf0)
//------------------------------------------------------------------------------
enum dia_eInputHandlingTouchInfo
{
   DIA_EN_TOUCH_INFO_UNKNOWN = 0,
   DIA_EN_TOUCH_INFO_TOUCHED,
   DIA_EN_TOUCH_INFO_NOT_TOUCHED,
   DIA_EN_TOUCH_INFO_MOVE,
   DIA_EN_TOUCH_INFO_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingKeyInfo
{
   DIA_EN_KEY_INFO_UNKNOWN = 0,
   DIA_EN_KEY_INFO_PRESSED,
   DIA_EN_KEY_INFO_RELEASED,
   DIA_EN_KEY_INFO_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingKeyCode
{
   DIA_EN_KEY_CODE_UNKNOWN = 0,
   DIA_EN_KEY_CODE_RADIO,
   DIA_EN_KEY_CODE_AM_FM,
   DIA_EN_KEY_CODE_MEDIA,
   DIA_EN_KEY_CODE_CAR,
   DIA_EN_KEY_CODE_SETUP,
   DIA_EN_KEY_CODE_PHONE,
   DIA_EN_KEY_CODE_SOUND,
   DIA_EN_KEY_CODE_MUTE,
   DIA_EN_KEY_CODE_TP,
   DIA_EN_KEY_CODE_MENU,
   DIA_EN_KEY_CODE_LEFT_ENCODER,
   DIA_EN_KEY_CODE_RIGHT_ENCODER,
   DIA_EN_KEY_CODE_EJECT,
   DIA_EN_KEY_CODE_CD,
   DIA_EN_KEY_CODE_CAMERA,
   DIA_EN_KEY_CODE_AUX,
   DIA_EN_KEY_CODE_PREV,
   DIA_EN_KEY_CODE_NEXT,
   DIA_EN_KEY_CODE_INFO,
   DIA_EN_KEY_CODE_MAP,
   DIA_EN_KEY_CODE_BACK,
   DIA_EN_KEY_CODE_DAY_NIGHT,
   DIA_EN_KEY_CODE_NAV,
   DIA_EN_KEY_CODE_XM,
   DIA_EN_KEY_CODE_APP,
   DIA_EN_KEY_CODE_COUNT = 26
};
//------------------------------------------------------------------------------
enum dia_eVdInuptHandlingKeyCode
{
   DIA_KEY_CODE_UNKNOWN = 0,
   DIA_KEY_CODE_PHONE,
   DIA_KEY_CODE_CD,
   DIA_KEY_CODE_CAMERA,
   DIA_KEY_CODE_AUX,
   DIA_KEY_CODE_PREV,
   DIA_KEY_CODE_NEXT,
   DIA_KEY_CODE_RADIO,
   DIA_KEY_CODE_INFO,
   DIA_KEY_CODE_SETUP,
   DIA_KEY_CODE_MAP,
   DIA_KEY_CODE_BACK,
   DIA_KEY_CODE_DAY_NIGHT,
   DIA_KEY_CODE_NAV,
   DIA_KEY_CODE_ENTER,
   DIA_KEY_CODE_XM,
   DIA_KEY_CODE_AM_FM,
   DIA_KEY_CODE_MENU,
   DIA_KEY_CODE_APP,
   DIA_KEY_CODE_AUDIO,
   DIA_KEY_CODE_DISP,
   DIA_KEY_VIRTUAL_STM,
   DIA_KEY_CODE_POWER,
   DIA_KEY_CODE_EJECT,
   DIA_SWC_KEY_CODE_MODE,
   DIA_SWC_KEY_CODE_OK,
   DIA_SWC_KEY_CODE_SEEK_UP,
   DIA_SWC_KEY_CODE_SEEK_DOWN,
   DIA_SWC_KEY_CODE_TEL_VR,
   DIA_SWC_KEY_CODE_VOL_DOWN,
   DIA_SWC_KEY_CODE_VOL_UP,
   DIA_SWC_KEY_CODE_TEL_HANG_UP,
   DIA_SWC_KEY_CODE_BACK,
   DIA_SWC_KEY_CODE_UP,
   DIA_SWC_KEY_CODE_DOWN,
   DIA_SWC_KEY_CODE_MUTE,
   DIA_SWC_KEY_CODE_AUDIO_SRC_UP,
   DIA_SWC_KEY_CODE_AUDIO_SRC_DOWN,
   DIA_SWC_KEY_CODE_RADIO,
   DIA_JOYSTICK_KEY_CODE_UP,
   DIA_JOYSTICK_KEY_CODE_DOWN,
   DIA_JOYSTICK_KEY_CODE_LEFT,
   DIA_JOYSTICK_KEY_CODE_RIGHT,
   DIA_JOYSTICK_KEY_CODE_UPPER_LEFT,
   DIA_JOYSTICK_KEY_CODE_UPPER_RIGHT,
   DIA_JOYSTICK_KEY_CODE_LOWER_LEFT,
   DIA_JOYSTICK_KEY_CODE_LOWER_RIGHT,
   DIA_JOYSTICK_KEY_CODE_ENTER,
   DIA_JOYSTICK_KEY_CODE_MAP,
   DIA_JOYSTICK_KEY_CODE_HOME,
   DIA_JOYSTICK_KEY_CODE_BACK,
   DIA_JOYSTICK_KEY_CODE_DAY_NIGHT,
   DIA_JOYSTICK_KEY_CODE_DISP,
   DIA_JOYSTICK_KEY_CODE_OPTION_LONGPRESS,
   DIA_JOYSTICK_KEY_CODE_HOME_LONGPRESS,
   DIA_JOYSTICK_KEY_CODE_BACK_LONGPRESS,
   DIA_JOYSTICK_KEY_CODE_ENTER_LONGPRESS,
   DIA_KEY_CODE_COUNT = 57
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingSWCKeyCode
{
   DIA_EN_SWC_KEY_CODE_UNKNOWN = DIA_EN_KEY_CODE_COUNT+1,
   DIA_EN_SWC_KEY_CODE_OK,
   DIA_EN_SWC_KEY_CODE_SEEK_UP,
   DIA_EN_SWC_KEY_CODE_SEEK_DOWN,
   DIA_EN_SWC_KEY_CODE_TEL_VR,
   DIA_EN_SWC_KEY_CODE_VOL_DOWN,
   DIA_EN_SWC_KEY_CODE_VOL_UP,
   DIA_EN_SWC_KEY_CODE_TEL_HANG_UP,
   DIA_EN_SWC_KEY_CODE_COUNT = 9
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingEncoder
{
   DIA_EN_ENCODER_UNKNOWN = 0,
   DIA_EN_ENCODER_1,
   DIA_EN_ENCODER_2,
   DIA_EN_ENCODER_SWC_VOLUME,
   DIA_EN_ENCODER_SWC_UP_DOWN,
   DIA_EN_ENCODER_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingLockInfoControl
{
   DIA_EN_INFO_CONTROL_UNKNOWN = 0,
   DIA_EN_INFO_CONTROL_LOCK,
   DIA_EN_INFO_CONTROL_UNLOCK,
   DIA_EN_INFO_CONTROL_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingGestureRecord
{
   DIA_EN_GESTURE_RECORD_UNKNOWN = 0,
   DIA_EN_GESTURE_RECORD_START,
   DIA_EN_GESTURE_RECORD_STOP,
   DIA_EN_GESTURE_RECORD_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingGestureReplay
{
   DIA_EN_GESTURE_REPLAY_UNKNOWN = 0,
   DIA_EN_GESTURE_REPLAY_START,
   DIA_EN_GESTURE_REPLAY_STOP,
   DIA_EN_GESTURE_REPLAY_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eInputHandlingTouchPressInfo
{
   DIA_EN_TOUCH_UNKNOWN = 0,
   DIA_EN_TOUCH_RELEASED = 0,
   DIA_EN_TOUCH_PRESSED,
   DIA_EN_TOUCH_INVALID,
   DIA_EN_TOUCH_COUNT = 4
};
struct dia_tTouchPressHistoryInfo
{
public:
   //! default constructor
   dia_tTouchPressHistoryInfo() :
      mType(DIA_EN_TOUCH_INFO_UNKNOWN),
      mXCoord(0),
      mYCoord(0),
      mXDelta(0),
      mYDelta(0)
   {}

   //! class constructor
   dia_tTouchPressHistoryInfo(
      dia_eInputHandlingTouchInfo mType_,
      tS32 mXCoord_,
      tS32 mYCoord_,
      tS32 mXDelta_,
      tS32 mYDelta_
   ) :
      mType(mType_),
      mXCoord(mXCoord_),
      mYCoord(mYCoord_),
      mXDelta(mXDelta_),
      mYDelta(mYDelta_)
   {}
   dia_eInputHandlingTouchInfo mType;
   tS32 mXCoord;
   tS32 mYCoord;
   tS32 mXDelta;
   tS32 mYDelta;
};
struct dia_tEncoderDirHistoryInfo
{
public:
   //! default constructor
   dia_tEncoderDirHistoryInfo() :
      mType(0),
      mSteps(0)
   {}

   //! class constructor
   dia_tEncoderDirHistoryInfo(
      tU8 mType_,
      tS8 mSteps_
   ) :
      mType(mType_),
      mSteps(mSteps_)
   {}
   tU8 mType;
   tS8 mSteps;
};
struct dia_tPressedKey
{
public:
   //! default constructor
   dia_tPressedKey() :
      mCode(DIA_KEY_CODE_UNKNOWN),
      mStatus(0)
   {}

   //! class constructor
   dia_tPressedKey(
      dia_eVdInuptHandlingKeyCode mCode_,
      tU8 mStatus_
   ) :
      mCode(mCode_),
      mStatus(mStatus_)
   {}
   dia_eVdInuptHandlingKeyCode mCode;
   tU8 mStatus;
};
class dia_IInputHandling
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_INPUT_HANDLING; }
public:
   //! returns the list of pressed keys
   virtual tDiaResult getPressedKeys ( ) = 0;
   //! returns status of encoders
   virtual tDiaResult getEncoderStatus ( ) = 0;
   //! returns direction status of encoders
   virtual tDiaResult getEncoderDirStatus ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! returns touch position and touch status
   virtual tDiaResult getTouchInfo ( ) = 0;
   //! simulate key press or key release by passing diagnose defined key code
   virtual tDiaResult setKeyDia (const dia_eInputHandlingKeyCode eKeyCode, const dia_eInputHandlingKeyInfo eKeyInfo ) = 0;
   //! simulate key press or key release by passing internally defined key code
   virtual tDiaResult setKeyIntern (const tU16 u16KeyCode, const dia_eInputHandlingKeyInfo eKeyInfo ) = 0;
   //! simulate key press or key release by passing internally defined key code
   virtual tDiaResult setKeyInternalCode (const dia_eVdInuptHandlingKeyCode KeyID, const dia_eInputHandlingKeyInfo eKeyInfo ) = 0;
   //! lock the operating unit 1
   virtual tDiaResult lockControlUnit (const dia_eInputHandlingLockInfoControl eLock ) = 0;
   //! set simulated encoder (control knob) value on the operating unit
   virtual tDiaResult setEncoder (const dia_eInputHandlingEncoder eEncoder, const tS8 s8ControlValue ) = 0;
   //! start the touch panel calibration
   virtual tDiaResult startTouchPanelAlignment ( ) = 0;
   //! start the input event simulation (requirement from VD_Input)
   virtual tDiaResult enableInputEvents ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! simulate touch press or release by passing x:y coordinates
   virtual tDiaResult setTouchIntern (const tU16 /*u16X*/, const tU16 /*u16Y*/, const dia_eInputHandlingTouchInfo /*eTouchInfo*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! simulate touch slide by passing duration [ms], start and end x:y coordinates
   virtual tDiaResult setTouchSlideIntern (const tU16 /*u16XStart*/, const tU16 /*u16YStart*/, const tU16 /*u16XEnd*/, const tU16 /*u16YEnd*/, const tU16 /*u16Duration*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Record sequence of User Inputs, Touch, Key, Encoder and store them in some file (e.g. /tmp/GuestureName) on target.
   virtual tDiaResult recordGesture (const dia_eInputHandlingGestureRecord /*eStartStop*/, const std::string& /*filePath*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Replay series of touch events from file stored in Target File system (e.g. /tmp/GuestureName)
   virtual tDiaResult replayGesture (const dia_eInputHandlingGestureReplay /*eStartStop*/, const std::string& /*filePath*/ ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_IInputHandling( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_INPUT_HANDLING__ */
