/*****************************************************************************************
*
* \file    dia_IGNSS.h
*
* \brief   interface of dia_IGNSS
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IGNSS.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_GNSS__
#define __INCLUDED_DIA_INTERFACE_GNSS__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_GNSS ((dia::IID) 0x67755ab6)
//------------------------------------------------------------------------------
enum tenGNSSAntennaState
{
   FI_EN_GPS_ANTENNA_UNKNOWN = 0,
   FI_EN_GPS_ANTENNA_NORMAL = 0UL,
   FI_EN_GPS_ANTENNA_OPEN = 1UL,
   FI_EN_GPS_ANTENNA_SHORT = 2UL,
   FI_EN_GPS_ANTENNA_BURNING = 3UL,
   FI_EN_GPS_ANTENNA_BATTERY_SHORT = 4UL,
   FI_EN_GPS_ANTENNA_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_eGNSSMode
{
   DIA_EN_GNSS_MODE_UNKNOWN = 0,
   DIA_EN_GNSS_MODE_GPS = 0,
   DIA_EN_GNSS_MODE_GLONASS = 1,
   DIA_EN_GNSS_MODE_COUNT = 3
};
struct dia_tGNSSReceiverState
{
public:
   //! default constructor
   dia_tGNSSReceiverState() :
      m_u8SatellitesHealthy(0),
      m_u8SatellitesVisible(0),
      m_u8SatellitesReceived(0),
      m_u8SatellitesUsed(0),
      m_u8FixStatus(0)
   {}

   //! class constructor
   dia_tGNSSReceiverState(
      tU8 m_u8SatellitesHealthy_,
      tU8 m_u8SatellitesVisible_,
      tU8 m_u8SatellitesReceived_,
      tU8 m_u8SatellitesUsed_,
      tU8 m_u8FixStatus_
   ) :
      m_u8SatellitesHealthy(m_u8SatellitesHealthy_),
      m_u8SatellitesVisible(m_u8SatellitesVisible_),
      m_u8SatellitesReceived(m_u8SatellitesReceived_),
      m_u8SatellitesUsed(m_u8SatellitesUsed_),
      m_u8FixStatus(m_u8FixStatus_)
   {}
   tU8 m_u8SatellitesHealthy;
   tU8 m_u8SatellitesVisible;
   tU8 m_u8SatellitesReceived;
   tU8 m_u8SatellitesUsed;
   tU8 m_u8FixStatus;
};
struct dia_tGPSReceptionLevel
{
public:
   //! default constructor
   dia_tGPSReceptionLevel() :
      SatellitesUsed(0),
      FixStatus(0)
   {}

   //! class constructor
   dia_tGPSReceptionLevel(
      tU8 SatellitesUsed_,
      tU8 FixStatus_
   ) :
      SatellitesUsed(SatellitesUsed_),
      FixStatus(FixStatus_)
   {}
   tU8 SatellitesUsed;
   tU8 FixStatus;
};
struct dia_tGNSSBestSattelletes
{
public:
   //! default constructor
   dia_tGNSSBestSattelletes() :
      m_u8SatellitesNumber(0),
      m_u8SignalQuality(0)
   {}

   //! class constructor
   dia_tGNSSBestSattelletes(
      tU8 m_u8SatellitesNumber_,
      tU8 m_u8SignalQuality_
   ) :
      m_u8SatellitesNumber(m_u8SatellitesNumber_),
      m_u8SignalQuality(m_u8SignalQuality_)
   {}
   tU8 m_u8SatellitesNumber;
   tU8 m_u8SignalQuality;
};
struct dia_tGNSSSatellitesSignalQuality
{
public:
   //! default constructor
   dia_tGNSSSatellitesSignalQuality() :
      m_u16SatellitesId(0),
      m_u8SignalQuality(0)
   {}

   //! class constructor
   dia_tGNSSSatellitesSignalQuality(
      tU16 m_u16SatellitesId_,
      tU8 m_u8SignalQuality_
   ) :
      m_u16SatellitesId(m_u16SatellitesId_),
      m_u8SignalQuality(m_u8SignalQuality_)
   {}
   tU16 m_u16SatellitesId;
   tU8 m_u8SignalQuality;
};
class dia_IGNSS
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_GNSS; }
public:
   virtual tDiaResult getGNSSData ( ) = 0;
   virtual tDiaResult setGNSSSystem (tU8 param ) = 0;
   virtual tDiaResult setDiagGNSSSystem (tU8 param ) = 0;
   virtual tDiaResult getGNSSSystem ( ) = 0;
   virtual tDiaResult getDiagGNSSSystem ( ) = 0;
   virtual tDiaResult getGNSSConfigData ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IGNSS( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_GNSS__ */
