/*****************************************************************************************
*
* \file    dia_IErrorLogListener.h
*
* \brief   listener of dia_IErrorLogListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IErrorLog.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ERROR_LOG_LISTENER__
#define __INCLUDED_DIA_INTERFACE_ERROR_LOG_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_ERROR_LOG__
#include "dia_IErrorLog.h"
#endif

#define IID_ERROR_LOG_LISTENER ((dia::IID) 0x9c11c94d)
/**
 *
 *  \class dia_IErrorLogListener
 *
 */

class dia_IErrorLogListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_ERROR_LOG_LISTENER; }
public:
   //! detailed information on error
   virtual void vOnError (const dia_ErrorInfoInterface& errInfo ) = 0;
   //! detailed information about the list of given ITCs
   virtual void vOnITCInfo (const std::vector<dia_tITCInfo>& itcInfos ) = 0;
   //! acknowledgement that the list of reported ITCs was accepted by VD_DiagLog
   virtual void vOnTestResultAccepted ( ) = 0;
   //! positive response on writing one or more reports
   virtual void vOnDiaglogWriteTestResult ( ) = 0;
   //! negative response on writing one or more reports
   virtual void vOnDiaglogWriteTestError (const tU32 errCode ) = 0;
   //! response on successfully clearing DTCs
   virtual void vOnClearResult ( ) = 0;
   //! response on clearing DTCs with errors
   virtual void vOnClearError (tU32 u32Error ) = 0;
   //! response about setting various aspects of DiagLog
   virtual void vOnControlResult ( ) = 0;
   //! response on reading a given DTC (according status mask)
   virtual void vOnReadDTCbyStatusMaskResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList ) = 0;
   //! returns status of a given DTC's
   virtual void vOnReadStatusByDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList ) = 0;
   //! returns status of a given ITC's
   virtual void vOnReadStatusByITCResult (std::list<tdia_IErrorLogResult>& ErrorLogList ) = 0;
   //! returns the number of DTC's matched with StatusMask
   virtual void vOnReadNumberOfDTCByStatusMaskResult (const tU8 u8DTCStatusAvailabilityMask, const tU32 u32NumberOfDTC ) = 0;
   //! returns supported DTC List
   virtual void vOnReadSupportedDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList ) = 0;
   //! returns the last confirmed DTC
   virtual void vOnReadLastConfirmedDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList ) = 0;
   //! returns extended data of a given DTC's
   virtual void vOnDiaglogGetExtendedDataByDTC (const IErrorLogExtendedDataResult& result ) = 0;
   //! returns snapshot data of a given DTC's
   virtual void vOnDiaglogGetSnapShotDataByDTC (const tU32 dtc, const tU8 status, std::list<IErrorLogSnapshotDataResult>& SnapShotData ) = 0;
   //! returns snapshot ID
   virtual void vOnDiaglogGetSnapShotId (std::list<IErrorLogSnapshotIdResult>& SnapShotId ) = 0;
   //! returns failed DTCs
   virtual void vOnFailedDTCList (std::list<tU32>& failedDTCs ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLogListener( void ) {}
};
/**
 *
 *  \class dia_IErrorLogListenerImpl
 *
 */

class dia_IErrorLogListenerImpl
   : public dia_IErrorLogListener
{
public:
   //! detailed information on error
   virtual void vOnError (const dia_ErrorInfoInterface& /*errInfo*/ ) {}
   //! detailed information about the list of given ITCs
   virtual void vOnITCInfo (const std::vector<dia_tITCInfo>& /*itcInfos*/ ) {}
   //! acknowledgement that the list of reported ITCs was accepted by VD_DiagLog
   virtual void vOnTestResultAccepted ( ) {}
   //! positive response on writing one or more reports
   virtual void vOnDiaglogWriteTestResult ( ) {}
   //! negative response on writing one or more reports
   virtual void vOnDiaglogWriteTestError (const tU32 /*errCode*/ ) {}
   //! response on successfully clearing DTCs
   virtual void vOnClearResult ( ) {}
   //! response on clearing DTCs with errors
   virtual void vOnClearError (tU32 /*u32Error*/ ) {}
   //! response about setting various aspects of DiagLog
   virtual void vOnControlResult ( ) {}
   //! response on reading a given DTC (according status mask)
   virtual void vOnReadDTCbyStatusMaskResult (const tU8 /*u8DTCStatusAvailabilityMask*/, std::list<tdia_IErrorLogResult>& /*ErrorLogList*/ ) {}
   //! returns status of a given DTC's
   virtual void vOnReadStatusByDTCResult (const tU8 /*u8DTCStatusAvailabilityMask*/, std::list<tdia_IErrorLogResult>& /*ErrorLogList*/ ) {}
   //! returns status of a given ITC's
   virtual void vOnReadStatusByITCResult (std::list<tdia_IErrorLogResult>& /*ErrorLogList*/ ) {}
   //! returns the number of DTC's matched with StatusMask
   virtual void vOnReadNumberOfDTCByStatusMaskResult (const tU8 /*u8DTCStatusAvailabilityMask*/, const tU32 /*u32NumberOfDTC*/ ) {}
   //! returns supported DTC List
   virtual void vOnReadSupportedDTCResult (const tU8 /*u8DTCStatusAvailabilityMask*/, std::list<tdia_IErrorLogResult>& /*ErrorLogList*/ ) {}
   //! returns the last confirmed DTC
   virtual void vOnReadLastConfirmedDTCResult (const tU8 /*u8DTCStatusAvailabilityMask*/, std::list<tdia_IErrorLogResult>& /*ErrorLogList*/ ) {}
   //! returns extended data of a given DTC's
   virtual void vOnDiaglogGetExtendedDataByDTC (const IErrorLogExtendedDataResult& /*result*/ ) {}
   //! returns snapshot data of a given DTC's
   virtual void vOnDiaglogGetSnapShotDataByDTC (const tU32 /*dtc*/, const tU8 /*status*/, std::list<IErrorLogSnapshotDataResult>& /*SnapShotData*/ ) {}
   //! returns snapshot ID
   virtual void vOnDiaglogGetSnapShotId (std::list<IErrorLogSnapshotIdResult>& /*SnapShotId*/ ) {}
   //! returns failed DTCs
   virtual void vOnFailedDTCList (std::list<tU32>& /*failedDTCs*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLogListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IErrorLogNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IErrorLogNotifier
   : public dia_IErrorLogListener,
     public dia_Notifier<dia_IErrorLogListener>
{
public:
   //! detailed information on error
   virtual void vOnError (const dia_ErrorInfoInterface& errInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnError(errInfo);
      }
   }
   //! detailed information about the list of given ITCs
   virtual void vOnITCInfo (const std::vector<dia_tITCInfo>& itcInfos)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnITCInfo(itcInfos);
      }
   }
   //! acknowledgement that the list of reported ITCs was accepted by VD_DiagLog
   virtual void vOnTestResultAccepted ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTestResultAccepted();
      }
   }
   //! positive response on writing one or more reports
   virtual void vOnDiaglogWriteTestResult ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDiaglogWriteTestResult();
      }
   }
   //! negative response on writing one or more reports
   virtual void vOnDiaglogWriteTestError (const tU32 errCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDiaglogWriteTestError(errCode);
      }
   }
   //! response on successfully clearing DTCs
   virtual void vOnClearResult ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnClearResult();
      }
   }
   //! response on clearing DTCs with errors
   virtual void vOnClearError (tU32 u32Error)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnClearError(u32Error);
      }
   }
   //! response about setting various aspects of DiagLog
   virtual void vOnControlResult ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnControlResult();
      }
   }
   //! response on reading a given DTC (according status mask)
   virtual void vOnReadDTCbyStatusMaskResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReadDTCbyStatusMaskResult(u8DTCStatusAvailabilityMask, ErrorLogList);
      }
   }
   //! returns status of a given DTC's
   virtual void vOnReadStatusByDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReadStatusByDTCResult(u8DTCStatusAvailabilityMask, ErrorLogList);
      }
   }
   //! returns status of a given ITC's
   virtual void vOnReadStatusByITCResult (std::list<tdia_IErrorLogResult>& ErrorLogList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReadStatusByITCResult(ErrorLogList);
      }
   }
   //! returns the number of DTC's matched with StatusMask
   virtual void vOnReadNumberOfDTCByStatusMaskResult (const tU8 u8DTCStatusAvailabilityMask, const tU32 u32NumberOfDTC)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReadNumberOfDTCByStatusMaskResult(u8DTCStatusAvailabilityMask, u32NumberOfDTC);
      }
   }
   //! returns supported DTC List
   virtual void vOnReadSupportedDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReadSupportedDTCResult(u8DTCStatusAvailabilityMask, ErrorLogList);
      }
   }
   //! returns the last confirmed DTC
   virtual void vOnReadLastConfirmedDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReadLastConfirmedDTCResult(u8DTCStatusAvailabilityMask, ErrorLogList);
      }
   }
   //! returns extended data of a given DTC's
   virtual void vOnDiaglogGetExtendedDataByDTC (const IErrorLogExtendedDataResult& result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDiaglogGetExtendedDataByDTC(result);
      }
   }
   //! returns snapshot data of a given DTC's
   virtual void vOnDiaglogGetSnapShotDataByDTC (const tU32 dtc, const tU8 status, std::list<IErrorLogSnapshotDataResult>& SnapShotData)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDiaglogGetSnapShotDataByDTC(dtc, status, SnapShotData);
      }
   }
   //! returns snapshot ID
   virtual void vOnDiaglogGetSnapShotId (std::list<IErrorLogSnapshotIdResult>& SnapShotId)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDiaglogGetSnapShotId(SnapShotId);
      }
   }
   //! returns failed DTCs
   virtual void vOnFailedDTCList (std::list<tU32>& failedDTCs)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnFailedDTCList(failedDTCs);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_ERROR_LOG_LISTENER__ */
