/*****************************************************************************************
*
* \file    dia_IDimmingControlListener.h
*
* \brief   listener of dia_IDimmingControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDimmingControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL__
#include "dia_IDimmingControl.h"
#endif

#define IID_DIMMING_CONTROL_LISTENER ((dia::IID) 0xbf64b2a7)
/**
 *
 *  \class dia_IDimmingControlListener
 *
 */

class dia_IDimmingControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DIMMING_CONTROL_LISTENER; }
public:
   //! Signal to inform requester about success of the key illumination brightness change request
   virtual void vOnKeyBrightnessChangeResult (tU16 brightness ) = 0;
   virtual void vOnKeyBrightnessFreeze (tBool bFreeze ) = 0;
   //! Signal to inform requester about success of the key illumination pwm change request
   virtual void vOnKeyPWMChangeResult (tU16 pwm ) = 0;
   virtual void vOnKeyPWMFreeze (tBool bFreeze ) = 0;
   /**
   * \brief response to setDisplayBrightness (signal to inform requester about the current display brightness status)
    * \param u16PWMValue Current display brightness
   */
   virtual void vOnDispBrightnessAck (tU16 u16Brightness ) = 0;
   virtual void vOnDispBrightnessFreeze (tBool bFreeze ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDimmingControlListener( void ) {}
};
/**
 *
 *  \class dia_IDimmingControlListenerImpl
 *
 */

class dia_IDimmingControlListenerImpl
   : public dia_IDimmingControlListener
{
public:
   //! Signal to inform requester about success of the key illumination brightness change request
   virtual void vOnKeyBrightnessChangeResult (tU16 /*brightness*/ ) {}
   virtual void vOnKeyBrightnessFreeze (tBool /*bFreeze*/ ) {}
   //! Signal to inform requester about success of the key illumination pwm change request
   virtual void vOnKeyPWMChangeResult (tU16 /*pwm*/ ) {}
   virtual void vOnKeyPWMFreeze (tBool /*bFreeze*/ ) {}
   /**
   * \brief response to setDisplayBrightness (signal to inform requester about the current display brightness status)
    * \param u16PWMValue Current display brightness
   */
   virtual void vOnDispBrightnessAck (tU16 /*u16Brightness*/ ) {}
   virtual void vOnDispBrightnessFreeze (tBool /*bFreeze*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IDimmingControlListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IDimmingControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IDimmingControlNotifier
   : public dia_IDimmingControlListener,
     public dia_Notifier<dia_IDimmingControlListener>
{
public:
   //! Signal to inform requester about success of the key illumination brightness change request
   virtual void vOnKeyBrightnessChangeResult (tU16 brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyBrightnessChangeResult(brightness);
      }
   }
   virtual void vOnKeyBrightnessFreeze (tBool bFreeze)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyBrightnessFreeze(bFreeze);
      }
   }
   //! Signal to inform requester about success of the key illumination pwm change request
   virtual void vOnKeyPWMChangeResult (tU16 pwm)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyPWMChangeResult(pwm);
      }
   }
   virtual void vOnKeyPWMFreeze (tBool bFreeze)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyPWMFreeze(bFreeze);
      }
   }
   /**
   * \brief response to setDisplayBrightness (signal to inform requester about the current display brightness status)
    * \param u16PWMValue Current display brightness
   */
   virtual void vOnDispBrightnessAck (tU16 u16Brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDispBrightnessAck(u16Brightness);
      }
   }
   virtual void vOnDispBrightnessFreeze (tBool bFreeze)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDispBrightnessFreeze(bFreeze);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL_LISTENER__ */
