/*****************************************************************************************
*
* \file    dia_IDimmingControl.h
*
* \brief   interface of dia_IDimmingControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDimmingControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL__
#define __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_DIMMING_CONTROL ((dia::IID) 0x8b7b4541)
class dia_IDimmingControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DIMMING_CONTROL; }
public:
   /**
   * \brief Asynchronous request to set key illumination brightness
    * \param u16Brightness key illumination brightness to set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult setKeyIlluminationBrightness (const tU16 brightness ) = 0;
   virtual tDiaResult freezeKeyIlluminationBrightness (tBool bFreeze ) = 0;
   /**
   * \brief Asynchronous request to set key illumination brightness pwm
    * \param u16Brightness key illumination brightness to set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult setKeyIlluminationPWM (const tU16 brightness ) = 0;
   virtual tDiaResult freezeKeyIlluminationPWM (tBool bFreeze ) = 0;
   /**
   * \brief Asynchronous request to set display brightness
    * \param u16pwmValue display brightness to set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult setDisplayBrightness (tU16 pwmValue ) = 0;
   virtual tDiaResult freezeDisplayBrightness (tBool bFreeze ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDimmingControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL__ */
