/*****************************************************************************************
*
* \file    dia_IDimming.h
*
* \brief   interface of dia_IDimming
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDimming.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING__
#define __INCLUDED_DIA_INTERFACE_DIMMING__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define HALF_CLASS_A_ID 0
#define HALF_CLASS_B_ID 1
#define IID_DIMMING ((dia::IID) 0xbb0605e0)
//------------------------------------------------------------------------------
enum dia_eDimmingStatus
{
   DIA_EN_DIMMING_STATUS_UNKNOWN = 0,
   DIA_EN_DIMMING_STATUS_ON,
   DIA_EN_DIMMING_STATUS_OFF,
   DIA_EN_DIMMING_STATUS_AUTOMATIC,
   DIA_EN_DIMMING_STATUS_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eDimEmulationMode
{
   DIA_EN_DIM_EMULATION_MODE_UNKNOWN = 0,
   DIA_EN_DIM_EMULATION_MODE_OFF,
   DIA_EN_DIM_EMULATION_MODE_KEYBFREEZE,
   DIA_EN_DIM_EMULATION_MODE_DISPFREEZE,
   DIA_EN_DIM_EMULATION_MODE_SETUP,
   DIA_EN_DIM_EMULATION_MODE_VERIFY,
   DIA_EN_DIM_EMULATION_MODE_COUNT = 6
};
class dia_IDimming
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DIMMING; }
public:
   //! get the current active brightness as signalled by the car through PWM input
   virtual tDiaResult getWireDimmingInformation ( ) = 0;
   //! current status of the dimming mode (evaluated and received from car)
   virtual tDiaResult getDimmingMode ( ) = 0;
   //! Provides the current brightness as signalled by the car through PWM input
   virtual tDiaResult getDimmingPWM ( ) = 0;
   //! get the current active keyboard brightness
   virtual tDiaResult getKeyBBrightnessInformation ( ) = 0;
   //! get the current active display brightness
   virtual tDiaResult getDispBrightnessInformation ( ) = 0;
   //! get the current active display panel temperature
   virtual tDiaResult getDispPanelTempInformation ( ) = 0;
   //! get the current display illumination mode
   virtual tDiaResult getDisplIlluminationMode ( ) = 0;
   //! get the current halfclass information
   virtual tDiaResult getDimmingHalfClassInformation ( ) = 0;
   //! get the current dimming status
   virtual tDiaResult getDimmingStatus ( ) = 0;
   //! Provides the current status of the car's illumination switch and illumination value
   virtual tDiaResult getIlluminationStatus ( ) = 0;
   //! get the current light sensor status
   virtual tDiaResult getLightSensorStatus ( ) = 0;
   //! set day and night mode
   virtual tDiaResult setDayAndNightMode (tU8 mode ) = 0;
   //! get the current active keyboard illumination pwm
   virtual tDiaResult getKeyBPwmInformation ( ) = 0;
   /**
   * \brief Asynchronous request to set key illumination brightness
    * \param u16Brightness key illumination brightness to set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult dia_setKeyIlluminationBrightness (const tU16 brightness ) = 0;
   /**
   * \brief Asynchronous request to set key illumination brightness pwm
    * \param u16Brightness key illumination brightness to set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult dia_setKeyIlluminationPWM (const tU16 brightness ) = 0;
   //! get day and night mode
   virtual tDiaResult getDayAndNightMode ( ) = 0;
   /**
   * \brief Asynchronous request to set display brightness
    * \param u16pwmValue display brightness to set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult setDisplayBrightness (tU16 pwmValue ) = 0;
   /**
   * \brief Asynchronous request to set Emulation Mode
    * \param u8Mode Emulation Mode to be set
    * return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully
   */
   virtual tDiaResult setEmulationMode (tU8 u8Mode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDimming( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_DIMMING__ */
