/*****************************************************************************************
*
* \file    dia_IDeviceMGRUSB.h
*
* \brief   interface of dia_IDeviceMGRUSB
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDeviceMGRUSB.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGRUSB__
#define __INCLUDED_DIA_INTERFACE_DEVICEMGRUSB__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_DEVMGR_USB ((dia::IID) 0xa4529fb)
//------------------------------------------------------------------------------
enum dia_eUsbPowerStatus
{
   USB_POWER_UNKNOWN = 0,
   USB_POWER_OFF,
   USB_POWER_ON,
   USB_POWER_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eUsbDevice
{
   USB_DEVICE_UNKNOWN = 0,
   USB_DEVICE_1,
   USB_DEVICE_2,
   USB_DEVICE_3,
   USB_DEVICE_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eUsbPort
{
   USB_PORT_UNKNOWN = 0,
   USB_PORT_1,
   USB_PORT_2,
   USB_PORT_3,
   USB_PORT_COUNT = 4
};
struct dia_tUsbPortCurrent
{
public:
//! Valid numbers of USB port are 1, 2, 3
   //! default constructor
   dia_tUsbPortCurrent() :
      PortNo(USB_PORT_UNKNOWN),
      CurrentInMilliAmpere(0)
   {}

   //! class constructor
   dia_tUsbPortCurrent(
      dia_eUsbPort PortNo_,
      tU16 CurrentInMilliAmpere_
   ) :
      PortNo(PortNo_),
      CurrentInMilliAmpere(CurrentInMilliAmpere_)
   {}
   dia_eUsbPort PortNo;
   tU16 CurrentInMilliAmpere;
};
class dia_IDeviceMGRUSB
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DEVMGR_USB; }
public:
   //! IOControl USB_PowerStatus Set
   virtual tDiaResult setUSBPowerStatus (dia_eUsbDevice powerDevice, dia_eUsbPowerStatus powerStatus ) = 0;
   /**
    * ReadDataByIdentifier USB_PowerSupplyInfoPort Read
    * Get current in units of milliampere for all USB ports (Port 1, Port2, Port3)
   */
   virtual tDiaResult getUSBPortCurrentResult ( ) = 0;
   //! ReadDataByIdentifier USB_PowerStatus Read
   virtual tDiaResult getUSBPowerStatusResult (dia_eUsbDevice powerDevice ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDeviceMGRUSB( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_DEVICEMGRUSB__ */
