/*****************************************************************************************
*
* \file    dia_IDeviceMGRListener.h
*
* \brief   listener of dia_IDeviceMGRListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author fgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDeviceMGR.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGR_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DEVICEMGR_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGR__
#include "dia_IDeviceMGR.h"
#endif

#define SIZE_CID_REGISTER 16
#define IID_DEVMGR_LISTENER ((dia::IID) 0xf44f8077)
/**
 *
 *  \class dia_IDeviceMGRListener
 *
 */

class dia_IDeviceMGRListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DEVMGR_LISTENER; }
public:
   //! information about register content of the SD Card(s)
   virtual void vOnSDCIDRegister (const std::vector<dia_tSdcCIDs>& SdcCidList ) = 0;
   //! information about the SD Card(s) slot state
   virtual void vOnSDStates (const std::vector<dia_tSdcStates>& SdcStatesList ) = 0;
   //! information about USB devices
   virtual void vOnUSBDeviceInfo (const std::vector<dia_tDeviceInfo>& deviceInfo ) = 0;
   //! information about USB port states
   virtual void vOnUSBPortStates (const std::vector<dia_tUsbPortStates>& PortStatesList ) = 0;
   //! information about the CD mode change result
   virtual void vOnCDModeChangeResultDVM (tDiaResult eDiaResult ) = 0;
   //! information about the Optic Disk Connection Status
   virtual void vOnOpticDiskConnectionStatus  (const dia_eOpticalDiscSlotState u8OpticDiskConnectionStatus ) = 0;
   //! information about number of inserted CDs
   virtual void vOnGetCDInsertCount (const tU8 cdCnt ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDeviceMGRListener( void ) {}
};
/**
 *
 *  \class dia_IDeviceMGRListenerImpl
 *
 */

class dia_IDeviceMGRListenerImpl
   : public dia_IDeviceMGRListener
{
public:
   //! information about register content of the SD Card(s)
   virtual void vOnSDCIDRegister (const std::vector<dia_tSdcCIDs>& /*SdcCidList*/ ) {}
   //! information about the SD Card(s) slot state
   virtual void vOnSDStates (const std::vector<dia_tSdcStates>& /*SdcStatesList*/ ) {}
   //! information about USB devices
   virtual void vOnUSBDeviceInfo (const std::vector<dia_tDeviceInfo>& /*deviceInfo*/ ) {}
   //! information about USB port states
   virtual void vOnUSBPortStates (const std::vector<dia_tUsbPortStates>& /*PortStatesList*/ ) {}
   //! information about the CD mode change result
   virtual void vOnCDModeChangeResultDVM (tDiaResult /*eDiaResult*/ ) {}
   //! information about the Optic Disk Connection Status
   virtual void vOnOpticDiskConnectionStatus  (const dia_eOpticalDiscSlotState /*u8OpticDiskConnectionStatus*/ ) {}
   //! information about number of inserted CDs
   virtual void vOnGetCDInsertCount (const tU8 /*cdCnt*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IDeviceMGRListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IDeviceMGRNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IDeviceMGRNotifier
   : public dia_IDeviceMGRListener,
     public dia_Notifier<dia_IDeviceMGRListener>
{
public:
   //! information about register content of the SD Card(s)
   virtual void vOnSDCIDRegister (const std::vector<dia_tSdcCIDs>& SdcCidList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSDCIDRegister(SdcCidList);
      }
   }
   //! information about the SD Card(s) slot state
   virtual void vOnSDStates (const std::vector<dia_tSdcStates>& SdcStatesList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSDStates(SdcStatesList);
      }
   }
   //! information about USB devices
   virtual void vOnUSBDeviceInfo (const std::vector<dia_tDeviceInfo>& deviceInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnUSBDeviceInfo(deviceInfo);
      }
   }
   //! information about USB port states
   virtual void vOnUSBPortStates (const std::vector<dia_tUsbPortStates>& PortStatesList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnUSBPortStates(PortStatesList);
      }
   }
   //! information about the CD mode change result
   virtual void vOnCDModeChangeResultDVM (tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnCDModeChangeResultDVM(eDiaResult);
      }
   }
   //! information about the Optic Disk Connection Status
   virtual void vOnOpticDiskConnectionStatus  (const dia_eOpticalDiscSlotState u8OpticDiskConnectionStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnOpticDiskConnectionStatus (u8OpticDiskConnectionStatus);
      }
   }
   //! information about number of inserted CDs
   virtual void vOnGetCDInsertCount (const tU8 cdCnt)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetCDInsertCount(cdCnt);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_DEVICEMGR_LISTENER__ */
