/*****************************************************************************************
*
* \file    dia_IBluetoothListener.h
*
* \brief   listener of dia_IBluetoothListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IBluetooth.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#define __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH__
#include "dia_IBluetooth.h"
#endif

#define IID_SYSADAPTER_BLUETOOTH_LISTENER ((dia::IID) 0x31760437)
/**
 *
 *  \class dia_IBluetoothListener
 *
 */

class dia_IBluetoothListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_BLUETOOTH_LISTENER; }
public:
   //! notification of the current BT mode
   virtual void vOnBTModeStatus (dia_eBTMode mode ) = 0;
   //! notification of the current BT mode
   virtual void vOnBTTestActionStatus (dia_eBTAction action ) = 0;
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTModeRequestACK (tBool result ) = 0;
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTTestActionRequestACK (tBool result ) = 0;
   //! delivers the Bluetooth signal strength info
   virtual void vOnBTLinkInfoStatus (tU8 linkQuality, tS8 RSSI ) = 0;
   //! status of the mute indication pin
   virtual void vOnMuteIndicationStatus (dia_eDiaBTMuteIndication status ) = 0;
   //! acknowledge status for the connect request
   virtual void vOnConnectACK (tBool status ) = 0;
   //! acknowledge status for the disconnect request
   virtual void vOnDisconnectACK (tBool status ) = 0;
   //! connection status
   virtual void vOnConnectionStatus (tBool status ) = 0;
   //! acknowledge status for the disconnect request
   virtual void vOnDisconnectionStatus (tBool status ) = 0;
   //! reply on faciaID request
   virtual void vOnFaciaIDResponse (char* btDeviceAddr, tU32 btDeviceAddr_size ) = 0;
   //! reply on BTMACAddress request
   virtual void vOnBTMACAddressResponse (char* btDeviceAddr, tU32 btDeviceAddr_size ) = 0;
   //! delivers the Bluetooth signal strength info
   virtual void vOnBTLinkQuality (tU8 linkQuality, tS8 RSSI, tBool isValid ) = 0;
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevicesInfo (const std::vector<dia_BTDeviceInfo*>& devInfo ) = 0;
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevices (tU8 countConnectedDevices, const std::vector<dia_BTServiceDevice*>& connectedDeviceName ) = 0;
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevicesList (const std::vector<dia_BTServiceDevice*>& connectedDeviceName, const std::vector<dia_eBTDevType>& connectedDeviceType ) = 0;
   //! delivers information about the connected devices
   virtual void vOnBTLinkInfoFullStatus (tU8 linkQualityHandsfree, tS8 rssiHandsfree, tU8 linkQualityBtAudio, tS8 rssiBtAudio ) = 0;
   //! delivers the list about the current paired devices with variable type dia_BTPairedDevice
   virtual void vOnBTPairedDevicesList (const std::vector<dia_BTPairedDevice*>& devList ) = 0;
   //! delivers the number of currently paired BT devices
   virtual void vOnBTPairedDevices (const std::vector<dia_BTServiceDevice*>& devList ) = 0;
   //! delivers information about the bluetooth power status
   virtual void vOnBTStatusOnOff (dia_eBTPower currPower ) = 0;
   //! delivers information about the current accessible mode
   virtual void vOnBTAccessibleMode (dia_eBTState currMode ) = 0;
   //! delivers the number of currently located BT devices
   virtual void vOnBTLocatedDevices (tU8 countLocated ) = 0;
   //! delivers the number of currently paired BT devices
   virtual void vOnBTPairedDevices (tU8 countPaired ) = 0;
   //! delivers the number of currently linked BT devices
   virtual void vOnBTLinkedDevices (tU8 countLinked ) = 0;
   //! Information about success of starting bluetooth device search
   virtual void vOnBTSearchDevice (tDiaResult success ) = 0;
   //! Signal to inform requester about success of the "search bluetooth device" request
   virtual void vOnBTSearchDevice (tDiaResult success, dia_eBTSearchMode searchMode ) = 0;
   //! Signal to inform requester about success of the "search bluetooth device" request
   virtual void vOnBTConnectDevice (tDiaResult success ) = 0;
   //! Signal to inform requester about success of the "delete linkkeys" request
   virtual void vOnBTLinkkeysDeleteResult (tDiaResult result ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothListener( void ) {}
};
/**
 *
 *  \class dia_IBluetoothListenerImpl
 *
 */

class dia_IBluetoothListenerImpl
   : public dia_IBluetoothListener
{
public:
   //! notification of the current BT mode
   virtual void vOnBTModeStatus (dia_eBTMode /*mode*/ ) {}
   //! notification of the current BT mode
   virtual void vOnBTTestActionStatus (dia_eBTAction /*action*/ ) {}
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTModeRequestACK (tBool /*result*/ ) {}
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTTestActionRequestACK (tBool /*result*/ ) {}
   //! delivers the Bluetooth signal strength info
   virtual void vOnBTLinkInfoStatus (tU8 /*linkQuality*/, tS8 /*RSSI*/ ) {}
   //! status of the mute indication pin
   virtual void vOnMuteIndicationStatus (dia_eDiaBTMuteIndication /*status*/ ) {}
   //! acknowledge status for the connect request
   virtual void vOnConnectACK (tBool /*status*/ ) {}
   //! acknowledge status for the disconnect request
   virtual void vOnDisconnectACK (tBool /*status*/ ) {}
   //! connection status
   virtual void vOnConnectionStatus (tBool /*status*/ ) {}
   //! acknowledge status for the disconnect request
   virtual void vOnDisconnectionStatus (tBool /*status*/ ) {}
   //! reply on faciaID request
   virtual void vOnFaciaIDResponse (char* /*btDeviceAddr*/, tU32 /*btDeviceAddr_size*/ ) {}
   //! reply on BTMACAddress request
   virtual void vOnBTMACAddressResponse (char* /*btDeviceAddr*/, tU32 /*btDeviceAddr_size*/ ) {}
   //! delivers the Bluetooth signal strength info
   virtual void vOnBTLinkQuality (tU8 /*linkQuality*/, tS8 /*RSSI*/, tBool /*isValid*/ ) {}
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevicesInfo (const std::vector<dia_BTDeviceInfo*>& /*devInfo*/ ) {}
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevices (tU8 /*countConnectedDevices*/, const std::vector<dia_BTServiceDevice*>& /*connectedDeviceName*/ ) {}
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevicesList (const std::vector<dia_BTServiceDevice*>& /*connectedDeviceName*/, const std::vector<dia_eBTDevType>& /*connectedDeviceType*/ ) {}
   //! delivers information about the connected devices
   virtual void vOnBTLinkInfoFullStatus (tU8 /*linkQualityHandsfree*/, tS8 /*rssiHandsfree*/, tU8 /*linkQualityBtAudio*/, tS8 /*rssiBtAudio*/ ) {}
   //! delivers the list about the current paired devices with variable type dia_BTPairedDevice
   virtual void vOnBTPairedDevicesList (const std::vector<dia_BTPairedDevice*>& /*devList*/ ) {}
   //! delivers the number of currently paired BT devices
   virtual void vOnBTPairedDevices (const std::vector<dia_BTServiceDevice*>& /*devList*/ ) {}
   //! delivers information about the bluetooth power status
   virtual void vOnBTStatusOnOff (dia_eBTPower /*currPower*/ ) {}
   //! delivers information about the current accessible mode
   virtual void vOnBTAccessibleMode (dia_eBTState /*currMode*/ ) {}
   //! delivers the number of currently located BT devices
   virtual void vOnBTLocatedDevices (tU8 /*countLocated*/ ) {}
   //! delivers the number of currently paired BT devices
   virtual void vOnBTPairedDevices (tU8 /*countPaired*/ ) {}
   //! delivers the number of currently linked BT devices
   virtual void vOnBTLinkedDevices (tU8 /*countLinked*/ ) {}
   //! Information about success of starting bluetooth device search
   virtual void vOnBTSearchDevice (tDiaResult /*success*/ ) {}
   //! Signal to inform requester about success of the "search bluetooth device" request
   virtual void vOnBTSearchDevice (tDiaResult /*success*/, dia_eBTSearchMode /*searchMode*/ ) {}
   //! Signal to inform requester about success of the "search bluetooth device" request
   virtual void vOnBTConnectDevice (tDiaResult /*success*/ ) {}
   //! Signal to inform requester about success of the "delete linkkeys" request
   virtual void vOnBTLinkkeysDeleteResult (tDiaResult /*result*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IBluetoothListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IBluetoothNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IBluetoothNotifier
   : public dia_IBluetoothListener,
     public dia_Notifier<dia_IBluetoothListener>
{
public:
   //! notification of the current BT mode
   virtual void vOnBTModeStatus (dia_eBTMode mode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTModeStatus(mode);
      }
   }
   //! notification of the current BT mode
   virtual void vOnBTTestActionStatus (dia_eBTAction action)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTTestActionStatus(action);
      }
   }
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTModeRequestACK (tBool result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTModeRequestACK(result);
      }
   }
   //! ACK to indicate if the request was accepted or rejected
   virtual void vOnBTTestActionRequestACK (tBool result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTTestActionRequestACK(result);
      }
   }
   //! delivers the Bluetooth signal strength info
   virtual void vOnBTLinkInfoStatus (tU8 linkQuality, tS8 RSSI)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTLinkInfoStatus(linkQuality, RSSI);
      }
   }
   //! status of the mute indication pin
   virtual void vOnMuteIndicationStatus (dia_eDiaBTMuteIndication status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMuteIndicationStatus(status);
      }
   }
   //! acknowledge status for the connect request
   virtual void vOnConnectACK (tBool status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnConnectACK(status);
      }
   }
   //! acknowledge status for the disconnect request
   virtual void vOnDisconnectACK (tBool status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDisconnectACK(status);
      }
   }
   //! connection status
   virtual void vOnConnectionStatus (tBool status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnConnectionStatus(status);
      }
   }
   //! acknowledge status for the disconnect request
   virtual void vOnDisconnectionStatus (tBool status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDisconnectionStatus(status);
      }
   }
   //! reply on faciaID request
   virtual void vOnFaciaIDResponse (char* btDeviceAddr, tU32 btDeviceAddr_size)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnFaciaIDResponse(btDeviceAddr, btDeviceAddr_size);
      }
   }
   //! reply on BTMACAddress request
   virtual void vOnBTMACAddressResponse (char* btDeviceAddr, tU32 btDeviceAddr_size)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTMACAddressResponse(btDeviceAddr, btDeviceAddr_size);
      }
   }
   //! delivers the Bluetooth signal strength info
   virtual void vOnBTLinkQuality (tU8 linkQuality, tS8 RSSI, tBool isValid)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTLinkQuality(linkQuality, RSSI, isValid);
      }
   }
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevicesInfo (const std::vector<dia_BTDeviceInfo*>& devInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTConnectedDevicesInfo(devInfo);
      }
   }
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevices (tU8 countConnectedDevices, const std::vector<dia_BTServiceDevice*>& connectedDeviceName)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTConnectedDevices(countConnectedDevices, connectedDeviceName);
      }
   }
   //! delivers information about the connected devices
   virtual void vOnBTConnectedDevicesList (const std::vector<dia_BTServiceDevice*>& connectedDeviceName, const std::vector<dia_eBTDevType>& connectedDeviceType)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTConnectedDevicesList(connectedDeviceName, connectedDeviceType);
      }
   }
   //! delivers information about the connected devices
   virtual void vOnBTLinkInfoFullStatus (tU8 linkQualityHandsfree, tS8 rssiHandsfree, tU8 linkQualityBtAudio, tS8 rssiBtAudio)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTLinkInfoFullStatus(linkQualityHandsfree, rssiHandsfree, linkQualityBtAudio, rssiBtAudio);
      }
   }
   //! delivers the list about the current paired devices with variable type dia_BTPairedDevice
   virtual void vOnBTPairedDevicesList (const std::vector<dia_BTPairedDevice*>& devList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTPairedDevicesList(devList);
      }
   }
   //! delivers the number of currently paired BT devices
   virtual void vOnBTPairedDevices (const std::vector<dia_BTServiceDevice*>& devList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTPairedDevices(devList);
      }
   }
   //! delivers information about the bluetooth power status
   virtual void vOnBTStatusOnOff (dia_eBTPower currPower)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTStatusOnOff(currPower);
      }
   }
   //! delivers information about the current accessible mode
   virtual void vOnBTAccessibleMode (dia_eBTState currMode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTAccessibleMode(currMode);
      }
   }
   //! delivers the number of currently located BT devices
   virtual void vOnBTLocatedDevices (tU8 countLocated)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTLocatedDevices(countLocated);
      }
   }
   //! delivers the number of currently paired BT devices
   virtual void vOnBTPairedDevices (tU8 countPaired)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTPairedDevices(countPaired);
      }
   }
   //! delivers the number of currently linked BT devices
   virtual void vOnBTLinkedDevices (tU8 countLinked)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTLinkedDevices(countLinked);
      }
   }
   //! Information about success of starting bluetooth device search
   virtual void vOnBTSearchDevice (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTSearchDevice(success);
      }
   }
   //! Signal to inform requester about success of the "search bluetooth device" request
   virtual void vOnBTSearchDevice (tDiaResult success, dia_eBTSearchMode searchMode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTSearchDevice(success, searchMode);
      }
   }
   //! Signal to inform requester about success of the "search bluetooth device" request
   virtual void vOnBTConnectDevice (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTConnectDevice(success);
      }
   }
   //! Signal to inform requester about success of the "delete linkkeys" request
   virtual void vOnBTLinkkeysDeleteResult (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTLinkkeysDeleteResult(result);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__ */
