/*****************************************************************************************
*
* \file    dia_IBluetooth.h
*
* \brief   interface of dia_IBluetooth
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IBluetooth.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH__
#define __INCLUDED_DIA_INTERFACE_BLUETOOTH__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define DIA_BT_SERVICE_NOT_SUPPORTED 0xFFFF
#define IID_SYSADAPTER_BLUETOOTH ((dia::IID) 0xc65c06d1)
//------------------------------------------------------------------------------
enum dia_eBTPower
{
   DIA_EN_BT_POWER_UNKNOWN = 0,
   DIA_EN_BT_POWER_ON,
   DIA_EN_BT_POWER_OFF,
   DIA_EN_BT_POWER_ERROR,
   DIA_EN_BT_POWER_NOT_MOUNTED,
   DIA_EN_BT_POWER_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eBTMode
{
   DIA_EN_BT_MODE_UNKNOWN = 0,
   DIA_EN_BT_MODE_NORMAL,
   DIA_EN_BT_MODE_PRODUCTION,
   DIA_EN_BT_MODE_DUT,
   DIA_EN_BT_MODE_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eBTSearchMode
{
   DIA_EN_BT_SEARCH_MODE_UNKNOWN = 0,
   DIA_EN_BT_SEARCH_MODE_RUNNING,
   DIA_EN_BT_SEARCH_MODE_FINISH,
   DIA_EN_BT_SEARCH_MODE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eBTAction
{
   DIA_EN_BT_ACTION_UNKNOWN = 0,
   DIA_EN_BT_ACTION_TESTTONESTART,
   DIA_EN_BT_ACTION_TESTTONESTOP,
   DIA_EN_BT_ACTION_LOCALLOOPBACKSTART,
   DIA_EN_BT_ACTION_LOCALLOOPBACKSTOP,
   DIA_EN_BT_ACTION_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eBTNotification
{
   DIA_EN_BT_NOTIFICATION_UNKNOWN = 0,
   DIA_EN_BT_NOTIFICATION_TESTMODE,
   DIA_EN_BT_NOTIFICATION_TESTACTION,
   DIA_EN_BT_NOTIFICATION_CONNECTIONSTATUS,
   DIA_EN_BT_NOTIFICATION_LINKQUALITYSTATUS,
   DIA_EN_BT_NOTIFICATION_DISCONNECTIONSTATUS,
   DIA_EN_BT_NOTIFICATION_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_eDiaBTMuteIndication
{
   DIA_EN_BT_MUTE_PIN_STATE_UNKNOWN = 0,
   DIA_EN_BT_MUTE_PIN_STATE_OPEN,
   DIA_EN_BT_MUTE_PIN_STATE_GROUND,
   DIA_EN_BT_MUTE_PIN_STATE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eBTDevType
{
   DIA_EN_BT_DEV_TYPE_UNKNOWN = 0,
   DIA_EN_BT_DEV_TYPE_HANDSFREE,
   DIA_EN_BT_DEV_TYPE_AUDIO,
   DIA_EN_BT_DEV_TYPE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eBTState
{
   DIA_EN_BT_STATE_UNKNOWN = 0,
   DIA_EN_BT_STATE_NOT_ACCESSIBLE,
   DIA_EN_BT_STATE_DISCOVERABLE_ONLY,
   DIA_EN_BT_STATE_CONNECTABLE_ONLY,
   DIA_EN_BT_STATE_GENERAL_ACCESSIBLE,
   DIA_EN_BT_STATE_AUTO_DISCOVERABLE_FULL_ACCESSIBLE,
   DIA_EN_BT_STATE_LIMITED_DISCOVERABLE,
   DIA_EN_BT_STATE_COUNT = 7
};
//------------------------------------------------------------------------------
/**
 * Mixture between possible services from component and requested services by customer
   */
enum dia_eBTService
{
   DIA_EN_BT_SERVICE_UNKNOWN = 0,
   DIA_EN_BT_SERVICE_SDAP,
   DIA_EN_BT_SERVICE_SPP,
   DIA_EN_BT_SERVICE_HSP,
   DIA_EN_BT_SERVICE_HFP,
   DIA_EN_BT_SERVICE_RSAP,
   DIA_EN_BT_SERVICE_AVP_A2DP,
   DIA_EN_BT_SERVICE_AVP_AVRCP,
   DIA_EN_BT_SERVICE_PAN,
   DIA_EN_BT_SERVICE_DUN,
   DIA_EN_BT_SERVICE_HIDP,
   DIA_EN_BT_SERVICE_SMS_MAP,
   DIA_EN_BT_SERVICE_SMS_HFP,
   DIA_EN_BT_SERVICE_SMS_SPP,
   DIA_EN_BT_SERVICE_OBEX,
   DIA_EN_BT_SERVICE_IRMC,
   DIA_EN_BT_SERVICE_PIM_SYNCML,
   DIA_EN_BT_SERVICE_PIM_OPP,
   DIA_EN_BT_SERVICE_PIM_SPP,
   DIA_EN_BT_SERVICE_PIM_HFP,
   DIA_EN_BT_SERVICE_PIM_PBAP,
   DIA_EN_BT_SERVICE_FTP,
   DIA_EN_BT_SERVICE_SAP,
   DIA_EN_BT_SERVICE_OPPC,
   DIA_EN_BT_SERVICE_ACTIVESYNCML,
   DIA_EN_BT_SERVICE_AT,
   DIA_EN_BT_SERVICE_COUNT = 26
};
//------------------------------------------------------------------------------
/**
 * Mixture between possible services from component and requested services by customer
   */
enum dia_eBTDeleteType
{
   DIA_EN_BT_DELETE_TYPE_UNKNOWN = 0,
   DIA_EN_BT_DELETE_TYPE_ALL_EXCEPT_HANDSET,
   DIA_EN_BT_DELETE_TYPE_ALL,
   DIA_EN_BT_DELETE_TYPE_HANDSET,
   DIA_EN_BT_DELETE_TYPE_REMOTE_CONTROL,
   DIA_EN_BT_DELETE_TYPE_EAR_PHONE,
   DIA_EN_BT_DELETE_TYPE_COUNT = 6
};
struct dia_BTDeviceInfo
{
public:
   //! default constructor
   dia_BTDeviceInfo() :
      btStr(0),
      btStrLen(0)
   {}

   //! class constructor
   dia_BTDeviceInfo(
      tString btStr_,
      tU16 btStrLen_
   ) :
      btStr(btStr_),
      btStrLen(btStrLen_)
   {}
   tString btStr;
   tU16 btStrLen;
};
struct dia_BTPairedDevice
{
public:
   //! default constructor
   dia_BTPairedDevice() :
      btManufacturer(),
      btModel(),
      btSWVersion(),
      btSDAP(0),
      btSPP(0),
      btHSP(0),
      btHFP(0),
      btRSAP(0),
      btA2DP(0),
      btAVRCP(0),
      btPAN(0),
      btDUN(0),
      btHIDP(0),
      btMAP(0),
      btOBEX(0),
      btIRMC(0),
      btSYNCML(0),
      btOPP(0),
      btFTP(0),
      btPBAP(0),
      btACTIVESYNCML(0),
      btAT(0),
      btDeviceAddr(),
      btDeviceName()
   {}

   //! class constructor
   dia_BTPairedDevice(
      dia_BTDeviceInfo btManufacturer_,
      dia_BTDeviceInfo btModel_,
      dia_BTDeviceInfo btSWVersion_,
      tU16 btSDAP_,
      tU16 btSPP_,
      tU16 btHSP_,
      tU16 btHFP_,
      tU16 btRSAP_,
      tU16 btA2DP_,
      tU16 btAVRCP_,
      tU16 btPAN_,
      tU16 btDUN_,
      tU16 btHIDP_,
      tU16 btMAP_,
      tU16 btOBEX_,
      tU16 btIRMC_,
      tU16 btSYNCML_,
      tU16 btOPP_,
      tU16 btFTP_,
      tU16 btPBAP_,
      tU16 btACTIVESYNCML_,
      tU16 btAT_,
      dia_BTDeviceInfo btDeviceAddr_,
      dia_BTDeviceInfo btDeviceName_
   ) :
      btManufacturer(btManufacturer_),
      btModel(btModel_),
      btSWVersion(btSWVersion_),
      btSDAP(btSDAP_),
      btSPP(btSPP_),
      btHSP(btHSP_),
      btHFP(btHFP_),
      btRSAP(btRSAP_),
      btA2DP(btA2DP_),
      btAVRCP(btAVRCP_),
      btPAN(btPAN_),
      btDUN(btDUN_),
      btHIDP(btHIDP_),
      btMAP(btMAP_),
      btOBEX(btOBEX_),
      btIRMC(btIRMC_),
      btSYNCML(btSYNCML_),
      btOPP(btOPP_),
      btFTP(btFTP_),
      btPBAP(btPBAP_),
      btACTIVESYNCML(btACTIVESYNCML_),
      btAT(btAT_),
      btDeviceAddr(btDeviceAddr_),
      btDeviceName(btDeviceName_)
   {}
   dia_BTDeviceInfo btManufacturer;
   dia_BTDeviceInfo btModel;
   dia_BTDeviceInfo btSWVersion;
   tU16 btSDAP;
   tU16 btSPP;
   tU16 btHSP;
   tU16 btHFP;
   tU16 btRSAP;
   tU16 btA2DP;
   tU16 btAVRCP;
   tU16 btPAN;
   tU16 btDUN;
   tU16 btHIDP;
   tU16 btMAP;
   tU16 btOBEX;
   tU16 btIRMC;
   tU16 btSYNCML;
   tU16 btOPP;
   tU16 btFTP;
   tU16 btPBAP;
   tU16 btACTIVESYNCML;
   tU16 btAT;
   dia_BTDeviceInfo btDeviceAddr;
   dia_BTDeviceInfo btDeviceName;
};
struct dia_BTServiceDevice
{
public:
   //! default constructor
   dia_BTServiceDevice() :
      btPService(DIA_EN_BT_SERVICE_UNKNOWN),
      btPDevice()
   {}

   //! class constructor
   dia_BTServiceDevice(
      dia_eBTService btPService_,
      dia_BTDeviceInfo btPDevice_
   ) :
      btPService(btPService_),
      btPDevice(btPDevice_)
   {}
   dia_eBTService btPService;
   dia_BTDeviceInfo btPDevice;
};
class dia_IBluetooth
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_BLUETOOTH; }
public:
   //! register for status notifications
   virtual tDiaResult attachNotification (dia_eBTNotification id ) = 0;
   //! unregister for status notifications
   virtual tDiaResult detachNotification (dia_eBTNotification id ) = 0;
   //! set mode of BT module
   virtual tDiaResult setMode (dia_eBTMode mode ) = 0;
   //! request the given action to be executed in the BT module
   virtual tDiaResult executeAction (dia_eBTAction actionID ) = 0;
   //! connect to BT device
   virtual tDiaResult connectBTDevice (tCString address ) = 0;
   //! disconnect  BT device
   virtual tDiaResult disconnectBTDevice ( ) = 0;
   //! start deletion of linkkeys from paired devices so the phone is unlinked to the HU
   virtual tDiaResult deletePairedDevices (dia_eBTDeleteType type ) = 0;
   //! start the Bluetooth Link Quality Request
   virtual tDiaResult measureLinkQuality ( ) = 0;
   //! request the Bluetooth RSSI and Link Quality
   virtual tDiaResult getLinkInfo ( ) = 0;
   //! get the state of the telephone mute indication pin
   virtual tDiaResult getMuteIndicationStatus ( ) = 0;
   //! get the id of the Bluetooth facia
   virtual tDiaResult getFaciaID ( ) = 0;
   //! get the Bluetooth MAC-Address
   virtual tDiaResult getBTMACAddress ( ) = 0;
   //! get information about the located devices
   virtual tDiaResult getLocatedBTDevices ( ) = 0;
   //! get information about the located devices
   virtual tDiaResult getLocatedBTDevicesReg (tBool reg ) = 0;
   //! get information about the paired devices
   virtual tDiaResult getPairedBTDevices ( ) = 0;
   //! get information about the connected devices
   virtual tDiaResult getConnectBTDevices ( ) = 0;
   //! reads on Phone if bluetooth is activated (ON) or deactivated (OFF)
   virtual tDiaResult getBTStatusOnOff ( ) = 0;
   //! gets the current information about the accessibleMode
   virtual tDiaResult getBTAccessibleMode ( ) = 0;
   //! reset BT module (required to be in production mode)
   virtual tDiaResult resetBTDevice ( ) = 0;
   //! start/stop of BT device search
   virtual tDiaResult setBTDeviceSearch (tBool mode ) = 0;
   //! connect a certain BT device
   virtual tDiaResult connectBTDevice (dia_BTDeviceInfo address, dia_eBTDevType devType ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IBluetooth( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_BLUETOOTH__ */
