/*****************************************************************************************
*
* \file    dia_IBTDeviceListListener.h
*
* \brief   listener of dia_IBTDeviceListListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author Bharath Kumar Yellikanti (RBEI/ECA4) (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IBTDeviceList.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST_LISTENER__
#define __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST__
#include "dia_IBTDeviceList.h"
#endif

#define IID_SYSADAPTER_BLUETOOTH_DEVICE_LIST_LISTENER ((dia::IID) 0xac951ea3)
/**
 *
 *  \class dia_IBTDeviceListListener
 *
 */

class dia_IBTDeviceListListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_BLUETOOTH_DEVICE_LIST_LISTENER; }
public:
   //! response for deviceList request.
   virtual void vOnBTDeviceListResponse (tU8 numOfPairedDevices, const std::vector<dia_tBTDeviceList>& btDeviceList, const dia_tBTDeviceListChange btDeviceListChange ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IBTDeviceListListener( void ) {}
};
/**
 *
 *  \class dia_IBTDeviceListListenerImpl
 *
 */

class dia_IBTDeviceListListenerImpl
   : public dia_IBTDeviceListListener
{
public:
   //! response for deviceList request.
   virtual void vOnBTDeviceListResponse (tU8 /*numOfPairedDevices*/, const std::vector<dia_tBTDeviceList>& /*btDeviceList*/, const dia_tBTDeviceListChange /*btDeviceListChange*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IBTDeviceListListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IBTDeviceListNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IBTDeviceListNotifier
   : public dia_IBTDeviceListListener,
     public dia_Notifier<dia_IBTDeviceListListener>
{
public:
   //! response for deviceList request.
   virtual void vOnBTDeviceListResponse (tU8 numOfPairedDevices, const std::vector<dia_tBTDeviceList>& btDeviceList, const dia_tBTDeviceListChange btDeviceListChange)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBTDeviceListResponse(numOfPairedDevices, btDeviceList, btDeviceListChange);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST_LISTENER__ */
