/*****************************************************************************************
*
* \file    dia_IAudioSourceListener.h
*
* \brief   listener of dia_IAudioSourceListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudioSource.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE__
#include "dia_IAudioSource.h"
#endif

#define IID_AUDIO_SOURCE_LISTENER ((dia::IID) 0x9fc65384)
/**
 *
 *  \class dia_IAudioSourceListener
 *
 */

class dia_IAudioSourceListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO_SOURCE_LISTENER; }
public:
   //! response to setAudioSource/getAudioSource
   virtual void vOnAudioMainSourceConnection (const tU8 audioSrcId ) = 0;
   //! response to getAudioSourceList
   virtual void vOnAudioSourceList (const std::vector<dia_tAudioSourceType>& audioSrcList ) = 0;
   //! response to getAudioSinkList
   virtual void vOnAudioSinkList (const std::vector<dia_tAudioSinkType>& audioSinkList ) = 0;
   //! response to getAudioConnections
   virtual void vOnAudioConnectionList (const std::vector<dia_tAudioConnectionType>& audioConnectionList ) = 0;
   //! response to getAudioConnections
   virtual void vOnAudioConnectionStateChanged (const dia_tAudioConnectionType& audioConnection ) = 0;
   //! response to getAudioConnections
   virtual void vOnAudioConnectionFailure (tDiaResult errInfo ) = 0;
   virtual void vOnAudioSourceConnectionDone (tDiaResult res ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioSourceListener( void ) {}
};
/**
 *
 *  \class dia_IAudioSourceListenerImpl
 *
 */

class dia_IAudioSourceListenerImpl
   : public dia_IAudioSourceListener
{
public:
   //! response to setAudioSource/getAudioSource
   virtual void vOnAudioMainSourceConnection (const tU8 /*audioSrcId*/ ) {}
   //! response to getAudioSourceList
   virtual void vOnAudioSourceList (const std::vector<dia_tAudioSourceType>& /*audioSrcList*/ ) {}
   //! response to getAudioSinkList
   virtual void vOnAudioSinkList (const std::vector<dia_tAudioSinkType>& /*audioSinkList*/ ) {}
   //! response to getAudioConnections
   virtual void vOnAudioConnectionList (const std::vector<dia_tAudioConnectionType>& /*audioConnectionList*/ ) {}
   //! response to getAudioConnections
   virtual void vOnAudioConnectionStateChanged (const dia_tAudioConnectionType& /*audioConnection*/ ) {}
   //! response to getAudioConnections
   virtual void vOnAudioConnectionFailure (tDiaResult /*errInfo*/ ) {}
   virtual void vOnAudioSourceConnectionDone (tDiaResult /*res*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioSourceListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IAudioSourceNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IAudioSourceNotifier
   : public dia_IAudioSourceListener,
     public dia_Notifier<dia_IAudioSourceListener>
{
public:
   //! response to setAudioSource/getAudioSource
   virtual void vOnAudioMainSourceConnection (const tU8 audioSrcId)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioMainSourceConnection(audioSrcId);
      }
   }
   //! response to getAudioSourceList
   virtual void vOnAudioSourceList (const std::vector<dia_tAudioSourceType>& audioSrcList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioSourceList(audioSrcList);
      }
   }
   //! response to getAudioSinkList
   virtual void vOnAudioSinkList (const std::vector<dia_tAudioSinkType>& audioSinkList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioSinkList(audioSinkList);
      }
   }
   //! response to getAudioConnections
   virtual void vOnAudioConnectionList (const std::vector<dia_tAudioConnectionType>& audioConnectionList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioConnectionList(audioConnectionList);
      }
   }
   //! response to getAudioConnections
   virtual void vOnAudioConnectionStateChanged (const dia_tAudioConnectionType& audioConnection)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioConnectionStateChanged(audioConnection);
      }
   }
   //! response to getAudioConnections
   virtual void vOnAudioConnectionFailure (tDiaResult errInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioConnectionFailure(errInfo);
      }
   }
   virtual void vOnAudioSourceConnectionDone (tDiaResult res)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioSourceConnectionDone(res);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE_LISTENER__ */
