/*****************************************************************************************
*
* \file    dia_IAudioSource.h
*
* \brief   interface of dia_IAudioSource
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudioSource.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE__
#define __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
typedef dia::UID dia_eAudioSource;
#define DIA_EN_AUDIO_SOURCE_UNKNOWN ((dia_eAudioSource)  0x8be88415)
#define DIA_EN_AUDIO_SOURCE_AUX_1 ((dia_eAudioSource)  0x71eb3a83)
#define DIA_EN_AUDIO_SOURCE_AUX_2 ((dia_eAudioSource)  0x71eb3a84)
#define DIA_EN_AUDIO_SOURCE_TUNER_AM ((dia_eAudioSource)  0x3ded3e40)
#define DIA_EN_AUDIO_SOURCE_TUNER_DAB ((dia_eAudioSource)  0xfb9511b9)
#define DIA_EN_AUDIO_SOURCE_TUNER_FM ((dia_eAudioSource)  0x3ded3ee5)
#define DIA_EN_AUDIO_SOURCE_TUNER_TA_DAB ((dia_eAudioSource)  0xfe907e0d)
#define DIA_EN_AUDIO_SOURCE_TUNER_TA_FM ((dia_eAudioSource)  0x364270b9)
#define DIA_EN_AUDIO_SOURCE_TUNER_XM ((dia_eAudioSource)  0x3ded4137)
#define DIA_EN_AUDIO_SOURCE_MEDIA_CDDA ((dia_eAudioSource)  0xdbd4b150)
#define DIA_EN_AUDIO_SOURCE_MEDIA_PLAYER ((dia_eAudioSource)  0x42a8e3b1)
#define DIA_EN_AUDIO_SOURCE_NAVI_SPEECH ((dia_eAudioSource)  0xe69e44ea)
#define DIA_EN_AUDIO_SOURCE_PHONE ((dia_eAudioSource)  0x72f360bf)
#define DIA_EN_AUDIO_SOURCE_PHONE_BTAUDIO ((dia_eAudioSource)  0x96d6adc6)
#define DIA_EN_AUDIO_SOURCE_PHONE_ECALL ((dia_eAudioSource)  0xc54f3e7f)
#define DIA_EN_AUDIO_SOURCE_PHONE_EXTERNAL_1 ((dia_eAudioSource)  0x46acedd1)
#define DIA_EN_AUDIO_SOURCE_PHONE_OUTBAND_RING ((dia_eAudioSource)  0xf987511a)
#define DIA_EN_AUDIO_SOURCE_PHONE_INBAND_RING ((dia_eAudioSource)  0xde71d299)
#define DIA_EN_AUDIO_SOURCE_PHONE_SPEECHRECOGNITION ((dia_eAudioSource)  0x6f754877)
#define DIA_EN_AUDIO_SOURCE_SDS_SPEECHRECOGNITION ((dia_eAudioSource)  0x39361b67)
#define DIA_EN_AUDIO_SOURCE_SMS_SPEECH ((dia_eAudioSource)  0x3642da8f)
#define DIA_EN_AUDIO_SOURCE_SPI_ENTERTAIN ((dia_eAudioSource)  0xc884e19a)
#define DIA_EN_AUDIO_SOURCE_SPI_INFO ((dia_eAudioSource)  0xc6efb47c)
#define DIA_EN_AUDIO_SOURCE_SPI_PHONE ((dia_eAudioSource)  0xa561cbaa)
#define DIA_EN_AUDIO_SOURCE_SPI_SPEECHRECOGNITION ((dia_eAudioSource)  0xe2844969)
#define DIA_EN_AUDIO_SOURCE_MICROPHONE ((dia_eAudioSource)  0x95ec7a79)
#define DIA_EN_AUDIO_SOURCE_INTERNET_APPS ((dia_eAudioSource)  0x2a577781)
#define DIA_EN_AUDIO_SOURCE_TUNER_DRM ((dia_eAudioSource)  0xfb9513f5)
#define DIA_EN_AUDIO_SOURCE_DCM ((dia_eAudioSource)  0x631297b9)
#define DIA_EN_AUDIO_SOURCE_MICROPHONE2 ((dia_eAudioSource)  0x537bc9cb)
#define DIA_EN_AUDIO_SOURCE_ENTERTAIN_EXT_CD ((dia_eAudioSource)  0xfa318685)
#define DIA_EN_AUDIO_SOURCE_ENTERTAIN_SPARE_CD ((dia_eAudioSource)  0xa3394c0f)
#define DIA_EN_AUDIO_SOURCE_ENTERTAIN_DTV ((dia_eAudioSource)  0xffd55621)
#define DIA_EN_AUDIO_SOURCE_COUNT ((dia_eAudioSource)  0x720c126e)
#define IID_AUDIO_SOURCE ((dia::IID) 0x9f0c591e)
//------------------------------------------------------------------------------
enum dia_eAudioSink
{
   DIA_EN_AUDIO_SINK_UNKNOWN = 0,
   DIA_EN_AUDIO_SINK_AMPLIFIER_MAINFIELD,
   DIA_EN_AUDIO_SINK_AMPLIFIER_INTERNAL,
   DIA_EN_AUDIO_SINK_AMPLIFIER_EXTERNAL,
   DIA_EN_AUDIO_SINK_SPEAKER,
   DIA_EN_AUDIO_SINK_AMP_A,
   DIA_EN_AUDIO_SINK_AMP_B,
   DIA_EN_AUDIO_SINK_COUNT = 7
};
//------------------------------------------------------------------------------
enum dia_eAudioSoundSystem
{
   DIA_EN_AUDIO_SOUNDSYSTEM_UNKNOWN = 0,
   DIA_EN_AUDIO_SOUNDSYSTEM_EXTERNAL_AMPLIFIER,
   DIA_EN_AUDIO_SOUNDSYSTEM_SPEAKER,
   DIA_EN_AUDIO_SOUNDSYSTEM_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eAudioConnectionState
{
   DIA_EN_AUDIO_CONNECTION_STATE_UNKNOWN = 0,
   DIA_EN_AUDIO_CONNECTION_STATE_CONNECTING,
   DIA_EN_AUDIO_CONNECTION_STATE_CONNECTED,
   DIA_EN_AUDIO_CONNECTION_STATE_DISCONNECTING,
   DIA_EN_AUDIO_CONNECTION_STATE_DISCONNECTED,
   DIA_EN_AUDIO_CONNECTION_STATE_SUSPENDED,
   DIA_EN_AUDIO_CONNECTION_STATE_COUNT = 6
};
struct dia_tAudioSourceType
{
public:
//! description of audio source type
   //! default constructor
   dia_tAudioSourceType() :
      mSourceEnum(DIA_EN_AUDIO_SOURCE_UNKNOWN),
      mSourceID(0),
      mDevID(0)
   {}

   //! class constructor
   dia_tAudioSourceType(
      dia_eAudioSource mSourceEnum_,
      tU8 mSourceID_,
      tU8 mDevID_
   ) :
      mSourceEnum(mSourceEnum_),
      mSourceID(mSourceID_),
      mDevID(mDevID_)
   {}
   
   //! class equal
   bool operator==( const dia_tAudioSourceType &rhs) const {
      return
      (mSourceEnum ==  rhs.mSourceEnum) &&
      (mSourceID ==  rhs.mSourceID) &&
      (mDevID ==  rhs.mDevID);
   }

   void reset (void) {
      *this = dia_tAudioSourceType();
   }

   dia_eAudioSource mSourceEnum;
   tU8 mSourceID;
   tU8 mDevID;
};
struct dia_tAudioSinkType
{
public:
   //! default constructor
   dia_tAudioSinkType() :
      mSinkEnum(DIA_EN_AUDIO_SINK_UNKNOWN),
      mSinkID(0),
      mDevID(0)
   {}

   //! class constructor
   dia_tAudioSinkType(
      dia_eAudioSink mSinkEnum_,
      tU8 mSinkID_,
      tU8 mDevID_
   ) :
      mSinkEnum(mSinkEnum_),
      mSinkID(mSinkID_),
      mDevID(mDevID_)
   {}
   
   //! class equal
   bool operator==( const dia_tAudioSinkType &rhs) const {
      return
      (mSinkEnum ==  rhs.mSinkEnum) &&
      (mSinkID ==  rhs.mSinkID) &&
      (mDevID ==  rhs.mDevID);
   }

   void reset (void) {
      *this = dia_tAudioSinkType();
   }

   dia_eAudioSink mSinkEnum;
   tU8 mSinkID;
   tU8 mDevID;
};
struct dia_tAudioConnectionType
{
public:
   //! default constructor
   dia_tAudioConnectionType() :
      mID(0),
      mSource(),
      mSink(),
      mState(DIA_EN_AUDIO_CONNECTION_STATE_UNKNOWN)
   {}

   //! class constructor
   dia_tAudioConnectionType(
      tU32 mID_,
      dia_tAudioSourceType mSource_,
      dia_tAudioSinkType mSink_,
      dia_eAudioConnectionState mState_
   ) :
      mID(mID_),
      mSource(mSource_),
      mSink(mSink_),
      mState(mState_)
   {}
   
   //! class equal
   bool operator==( const dia_tAudioConnectionType &rhs) const {
      return
      (mID ==  rhs.mID) &&
      (mSource ==  rhs.mSource) &&
      (mSink ==  rhs.mSink) &&
      (mState ==  rhs.mState);
   }

   void reset (void) {
      *this = dia_tAudioConnectionType();
   }

   tU32 mID;
   dia_tAudioSourceType mSource;
   dia_tAudioSinkType mSink;
   dia_eAudioConnectionState mState;
};
class dia_IAudioSource
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO_SOURCE; }
public:
   //! set the audio source
   virtual tDiaResult setAudioSource (dia_eAudioSource src ) = 0;
   //! set the audio source
   virtual tDiaResult setAudioSource (tU8 sourceID, tU8 sinkID ) = 0;
   //! retrieve the currently activated audio source
   virtual tDiaResult getAudioSource ( ) = 0;
   //! retrieve the list of existing audio connections
   virtual tDiaResult getAudioConnections ( ) { return DIA_E_NOT_SUPPORTED; }
   //! retrieve list of all possible sources with their dynamic ID
   virtual tDiaResult getAudioSourceList ( ) = 0;
   //! retrieve list of all possible sinks with their dynamic ID
   virtual tDiaResult getAudioSinkList ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioSource( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_AUDIO_SOURCE__ */
