/*****************************************************************************************
*
* \file    IAudioModeControl.h
*
* \brief   interface of IAudioModeControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudioModeControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_MODE_CONTROL__
#define __INCLUDED_DIA_INTERFACE_AUDIO_MODE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_AUDIO_MODE_CONTROL ((dia::IID) 0xc196ad86)
namespace dia {
//------------------------------------------------------------------------------
enum enAudioMode
{
   DIA_EN_AUDIO_MODE_UNKNOWN = 0,
   DIA_EN_AUDIO_MODE_BEEP/* Beep. Different beeps can be started with this */,
   DIA_EN_AUDIO_MODE_FADER_STATUS_ACTIVE/* Fader status active */,
   DIA_EN_AUDIO_MODE_VOLMODE_STREAM_MAIN_1/* Volume mode for main1 stream */,
   DIA_EN_AUDIO_MODE_VOLMODE_STREAM_MIX_1/* Volume mode for Mix1 stream */,
   DIA_EN_AUDIO_MODE_DIAG_REMOTE_CONTROL/* Diagnosis remote control */,
   DIA_EN_AUDIO_MODE_AM_SRV_STS/* System property for service availability status of GAM */,
   DIA_EN_AUDIO_MODE_HMISTARTUP_MUTE/* System Property to report that HMI is ready and remove MUTE_HMISTARTUP */,
   DIA_EN_AUDIO_MODE_COUNT = 8
};
struct AudioMode
{
public:
   //! default constructor
   AudioMode() :
      mMode(DIA_EN_AUDIO_MODE_UNKNOWN),
      mState(false)
   {}

   //! class constructor
   AudioMode(
      enAudioMode mMode_,
      bool mState_
   ) :
      mMode(mMode_),
      mState(mState_)
   {}
   enAudioMode getMode ( void ) const { return mMode; }
   bool getState ( void ) const { return mState; }
         

   
   //! class equal
   bool operator==( const AudioMode &rhs) const {
      return
      (mMode ==  rhs.mMode) &&
      (mState ==  rhs.mState);
   }

   enAudioMode mMode;
   bool mState;
};
class IAudioModeControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO_MODE_CONTROL; }
public:
   //! switch audio component to obsolete function - don't use anymore. Activates the test tone with a certain frequency and volume. Still available for old projects.
   virtual tDiaResult setAudioMode (AudioMode& mode ) = 0;
   //! activates the test tone with a certain frequency and volume for certain channel with DBV
   virtual tDiaResult getAudioMode (AudioMode& mode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~IAudioModeControl( void ) {}
};
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_AUDIO_MODE_CONTROL__ */
