/*****************************************************************************************
*
* \file    dia_IAudioListener.h
*
* \brief   listener of dia_IAudioListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author bma9kor (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudio.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__
#define __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO__
#include "dia_IAudio.h"
#endif

#define IID_AUDIO_LISTENER ((dia::IID) 0x4b580633)
/**
 *
 *  \class dia_IAudioListener
 *
 */

class dia_IAudioListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO_LISTENER; }
public:
   //! response to dia_setAudioTestTone
   virtual void vOnTestTone (tDiaResult success ) = 0;
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * response to mic1PowerSuppyInfo_Get
   */
   virtual void vOnMic1PowerSupplyInfo_Get (tU8 eConnectionStatus, tU16 antennaCurrent ) = 0;
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * response to mic2PowerSuppyInfo_Get
   */
   virtual void vOnMic2PowerSupplyInfo_Get (tU8 eConnectionStatus, tU16 antennaCurrent ) = 0;
   //! contain Info all the Microphone
   virtual void vOnMicrophonePowersupplyInfo (const dia_tMicrophoneStatus& mic_status ) = 0;
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * contain Info all the Microphone
   */
   virtual void vOnMicrophonePowersupplyInfo (const std::vector<dia_tMicrophoneStatus>& mic_status ) = 0;
   //! response to dia_setAudioTestTone for customer loudspeaker test
   virtual void vOnLoudspeakerTestTone (tDiaResult success ) = 0;
   //! response to regToANCSWVersion
   virtual void onANCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo info ) = 0;
   //! response to regToASCSWVersion
   virtual void onASCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo info ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioListener( void ) {}
};
/**
 *
 *  \class dia_IAudioListenerImpl
 *
 */

class dia_IAudioListenerImpl
   : public dia_IAudioListener
{
public:
   //! response to dia_setAudioTestTone
   virtual void vOnTestTone (tDiaResult /*success*/ ) {}
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * response to mic1PowerSuppyInfo_Get
   */
   virtual void vOnMic1PowerSupplyInfo_Get (tU8 /*eConnectionStatus*/, tU16 /*antennaCurrent*/ ) {}
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * response to mic2PowerSuppyInfo_Get
   */
   virtual void vOnMic2PowerSupplyInfo_Get (tU8 /*eConnectionStatus*/, tU16 /*antennaCurrent*/ ) {}
   //! contain Info all the Microphone
   virtual void vOnMicrophonePowersupplyInfo (const dia_tMicrophoneStatus& /*mic_status*/ ) {}
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * contain Info all the Microphone
   */
   virtual void vOnMicrophonePowersupplyInfo (const std::vector<dia_tMicrophoneStatus>& /*mic_status*/ ) {}
   //! response to dia_setAudioTestTone for customer loudspeaker test
   virtual void vOnLoudspeakerTestTone (tDiaResult /*success*/ ) {}
   //! response to regToANCSWVersion
   virtual void onANCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo /*info*/ ) {}
   //! response to regToASCSWVersion
   virtual void onASCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo /*info*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IAudioNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IAudioNotifier
   : public dia_IAudioListener,
     public dia_Notifier<dia_IAudioListener>
{
public:
   //! response to dia_setAudioTestTone
   virtual void vOnTestTone (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTestTone(success);
      }
   }
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * response to mic1PowerSuppyInfo_Get
   */
   virtual void vOnMic1PowerSupplyInfo_Get (tU8 eConnectionStatus, tU16 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMic1PowerSupplyInfo_Get(eConnectionStatus, antennaCurrent);
      }
   }
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * response to mic2PowerSuppyInfo_Get
   */
   virtual void vOnMic2PowerSupplyInfo_Get (tU8 eConnectionStatus, tU16 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMic2PowerSupplyInfo_Get(eConnectionStatus, antennaCurrent);
      }
   }
   //! contain Info all the Microphone
   virtual void vOnMicrophonePowersupplyInfo (const dia_tMicrophoneStatus& mic_status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMicrophonePowersupplyInfo(mic_status);
      }
   }
   /**
    * DEPRECATED! PLEASE USE vOnMicrophonePowersupplyInfo WITHOUT VECTOR
    * contain Info all the Microphone
   */
   virtual void vOnMicrophonePowersupplyInfo (const std::vector<dia_tMicrophoneStatus>& mic_status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMicrophonePowersupplyInfo(mic_status);
      }
   }
   //! response to dia_setAudioTestTone for customer loudspeaker test
   virtual void vOnLoudspeakerTestTone (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLoudspeakerTestTone(success);
      }
   }
   //! response to regToANCSWVersion
   virtual void onANCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onANCSWVersionUpdate(info);
      }
   }
   //! response to regToASCSWVersion
   virtual void onASCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onASCSWVersionUpdate(info);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__ */
