/*****************************************************************************************
*
* \file    IApplicationStateControl.h
*
* \brief   interface of IApplicationStateControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IApplicationStateControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL__
#define __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
namespace dia {
typedef tU32 ApplicationStateID;
} /* namespace dia */

#define IID_APPLICATION_STATE_CONTROL ((dia::IID) 0x8389f124)
namespace dia {
class IApplicationStateControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_APPLICATION_STATE_CONTROL; }
public:
   //! request a change of the application state.
   virtual tDiaResult changeApplicationState (const std::string& /*sourceStateName*/, const std::string& /*destinationStateName*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request a change of the application state.
   virtual tDiaResult changeApplicationState (ApplicationStateID sourceStateID, ApplicationStateID destinationStateID ) = 0;
   virtual bool isApplicationStateChangeInProgress ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~IApplicationStateControl( void ) {}
};
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL__ */
