/*****************************************************************************************
*
* \file    dia_IAppStateListener.h
*
* \brief   listener of dia_IAppStateListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAppState.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_APP_STATE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_APP_STATE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_APP_STATE__
#include "dia_IAppState.h"
#endif

#define IID_APP_STATE_LISTENER ((dia::IID) 0x7d8665a3)
/**
 *
 *  \class dia_IAppStateListener
 *
 */

class dia_IAppStateListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_APP_STATE_LISTENER; }
public:
   virtual void onApplicationStateChangePrepare (dia::ApplicationStateID /*srcStateID*/, dia::ApplicationStateID /*destStateID*/ ) {}
   virtual void onApplicationStateChange (dia::ApplicationStateID srcStateID, dia::ApplicationStateID destStateID ) = 0;
   virtual void onApplicationStateChangeFinalize (dia::ApplicationStateID /*destStateID*/ ) {}
   virtual void onChangeAppState (tU32 /*currentState*/, tU32 /*nextState*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IAppStateListener( void ) {}
};
/**
 *
 *  \class dia_IAppStateListenerImpl
 *
 */

class dia_IAppStateListenerImpl
   : public dia_IAppStateListener
{
public:
   virtual void onApplicationStateChangePrepare (dia::ApplicationStateID /*srcStateID*/, dia::ApplicationStateID /*destStateID*/ ) {}
   virtual void onApplicationStateChange (dia::ApplicationStateID srcStateID, dia::ApplicationStateID destStateID ) { onChangeAppState((tU32) srcStateID, (tU32) destStateID); }
   virtual void onApplicationStateChangeFinalize (dia::ApplicationStateID /*destStateID*/ ) {}
   virtual void onChangeAppState (tU32 /*currentState*/, tU32 /*nextState*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IAppStateListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IAppStateNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IAppStateNotifier
   : public dia_IAppStateListener,
     public dia_Notifier<dia_IAppStateListener>
{
public:
   virtual void onApplicationStateChangePrepare (dia::ApplicationStateID srcStateID, dia::ApplicationStateID destStateID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onApplicationStateChangePrepare(srcStateID, destStateID);
      }
   }
   virtual void onApplicationStateChange (dia::ApplicationStateID srcStateID, dia::ApplicationStateID destStateID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onApplicationStateChange(srcStateID, destStateID);
      }
   }
   virtual void onApplicationStateChangeFinalize (dia::ApplicationStateID destStateID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onApplicationStateChangeFinalize(destStateID);
      }
   }
   virtual void onChangeAppState (tU32 currentState, tU32 nextState)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onChangeAppState(currentState, nextState);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_APP_STATE_LISTENER__ */
