
///////////////////////////////////////////////////////////////////////////////
//
// special version including MOST compatible types
//
// implementation omitted intentionally for 
// bool, U8, U16, U24, U32, S8, S16, S24, S32, list and multilanguage string
//
///////////////////////////////////////////////////////////////////////////////

#ifdef OSAL_CONF
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>
#else
#include <myosal.h>
#endif

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "conn_most_fi_if.h"
#include "allvisitor.h"

// #define FIDEBUG 
#ifdef FIDEBUG
// #include <iostream>
#endif

/* deleted, since it is now in the fitypes.h to avoid unneccessary dependencies for the common_fi.lib
tVoid figroup_fi_tclTypeBase::vTakeVisitor(figroup_fi_tclVisitorBase& oVisitor) {
   oVisitor.vInvalidate();
}
*/

// --Implementierungen der Methoden der Besucher-Basisklasse
// --Alle Besuchmethoden setzen den Status des Objektes auf ungueltig.

tVoid most_fi_tclVisitorBase::vVisitU8(most_fi_tclU8& /*oU8*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitU8 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclU8::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitU8(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitS8(most_fi_tclS8& /*oS8*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitS8 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclS8::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitS8(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitU16(most_fi_tclU16& /*oU16*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitU16 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclU16::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitU16(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitS16(most_fi_tclS16& /*oS16*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitS16 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclS16::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitS16(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitU32(most_fi_tclU32& /*oU32*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitU32 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclU32::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitU32(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitS32(most_fi_tclS32& /*oS32*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitS32 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclS32::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitS32(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitBool(most_fi_tclBool& /*oBool*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitBool not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclBool::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitBool(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_String(most_fi_tcl_String& /*oString*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_String::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_String(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_TrailingStream(most_fi_tcl_TrailingStream& /*oContainer*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_TrailingStream::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_TrailingStream(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_ShortStream(most_fi_tcl_ShortStream& /*oContainer*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_ShortStream::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_ShortStream(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_ClassifiedStream(most_fi_tcl_ClassifiedStream& /*oContainer*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_ClassifiedStream::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_ClassifiedStream(*this);
}

//------------------------------------------------------------------------------------

most_fi_tclOutput::most_fi_tclOutput()
{
}

tVoid most_fi_tclFileOutput::vPrintLine(tCString coszLine)
{
   if (coszLine)
   {
      (void)OSALUTIL_s32FPrintf(fd,"%s",coszLine);
   }
}

most_fi_tclMemOutput::most_fi_tclMemOutput(tU32 u32MemSize)
{
   s8BufPos = 0;
   szEndBuf = 0;
   szBuf = new tChar[u32MemSize];
   if (szBuf)
   {
      s8BufPos = szBuf;
      szEndBuf = szBuf + u32MemSize;
   }
}

most_fi_tclMemOutput::~most_fi_tclMemOutput()
{
   if (szBuf != 0)
   {
      delete[] szBuf;
      szBuf = 0;
   }
   s8BufPos = 0;
   szEndBuf = 0;
}

tString most_fi_tclMemOutput::szGetBuffer()
{
   return szBuf;
}

tVoid most_fi_tclMemOutput::vPrintLine(tCString coszLine)
{
   if ((coszLine) && (szBuf))
   {
      tU32 u32LineLength = OSAL_u32StringLength(coszLine);
      if (s8BufPos && szEndBuf && (s8BufPos + u32LineLength) < szEndBuf)
      {
         (void)OSAL_szStringCopy(s8BufPos,coszLine);
         s8BufPos += u32LineLength;
      }
   }
}
tVoid most_fi_tclVisitorBase::vVisit_e8_ErrorCode(most_fi_tcl_e8_ErrorCode& /*oe8_ErrorCode*/)
{
}
tVoid most_fi_tcl_e8_ErrorCode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ErrorCode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetPairingType(most_fi_tcl_e8_BTSetPairingType& /*oe8_BTSetPairingType*/)
{
}
tVoid most_fi_tcl_e8_BTSetPairingType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetPairingType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetPairingResponseType(most_fi_tcl_e8_BTSetPairingResponseType& /*oe8_BTSetPairingResponseType*/)
{
}
tVoid most_fi_tcl_e8_BTSetPairingResponseType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetPairingResponseType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetPairingStatusType(most_fi_tcl_e8_BTSetPairingStatusType& /*oe8_BTSetPairingStatusType*/)
{
}
tVoid most_fi_tcl_e8_BTSetPairingStatusType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetPairingStatusType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetDeviceStatus(most_fi_tcl_e8_BTSetDeviceStatus& /*oe8_BTSetDeviceStatus*/)
{
}
tVoid most_fi_tcl_e8_BTSetDeviceStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetDeviceStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDateStamp(most_fi_tcl_BTSetDateStamp& /*oBTSetDateStamp*/)
{
}
tVoid most_fi_tcl_BTSetDateStamp::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDateStamp(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetTimeStamp(most_fi_tcl_BTSetTimeStamp& /*oBTSetTimeStamp*/)
{
}
tVoid most_fi_tcl_BTSetTimeStamp::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetTimeStamp(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDateTimeStamp(most_fi_tcl_BTSetDateTimeStamp& /*oBTSetDateTimeStamp*/)
{
}
tVoid most_fi_tcl_BTSetDateTimeStamp::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDateTimeStamp(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetChangeDeviceStateAction(most_fi_tcl_e8_BTSetChangeDeviceStateAction& /*oe8_BTSetChangeDeviceStateAction*/)
{
}
tVoid most_fi_tcl_e8_BTSetChangeDeviceStateAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetChangeDeviceStateAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetConnectionResult(most_fi_tcl_e8_BTSetConnectionResult& /*oe8_BTSetConnectionResult*/)
{
}
tVoid most_fi_tcl_e8_BTSetConnectionResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetConnectionResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceRingtoneListResultItem(most_fi_tcl_BTSetDeviceRingtoneListResultItem& /*oBTSetDeviceRingtoneListResultItem*/)
{
}
tVoid most_fi_tcl_BTSetDeviceRingtoneListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceRingtoneListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceRingtoneListResult(most_fi_tcl_BTSetDeviceRingtoneListResult& /*oBTSetDeviceRingtoneListResult*/)
{
}
tVoid most_fi_tcl_BTSetDeviceRingtoneListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceRingtoneListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetRingtoneListItem(most_fi_tcl_BTSetRingtoneListItem& /*oBTSetRingtoneListItem*/)
{
}
tVoid most_fi_tcl_BTSetRingtoneListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetRingtoneListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetRingtoneList(most_fi_tcl_BTSetRingtoneList& /*oBTSetRingtoneList*/)
{
}
tVoid most_fi_tcl_BTSetRingtoneList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetRingtoneList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceControlSupport(most_fi_tcl_BTSetDeviceControlSupport& /*oBTSetDeviceControlSupport*/)
{
}
tVoid most_fi_tcl_BTSetDeviceControlSupport::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceControlSupport(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetAudioStreamingSupportType(most_fi_tcl_e8_BTSetAudioStreamingSupportType& /*oe8_BTSetAudioStreamingSupportType*/)
{
}
tVoid most_fi_tcl_e8_BTSetAudioStreamingSupportType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetAudioStreamingSupportType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetInternetAccessSupportType(most_fi_tcl_e8_BTSetInternetAccessSupportType& /*oe8_BTSetInternetAccessSupportType*/)
{
}
tVoid most_fi_tcl_e8_BTSetInternetAccessSupportType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetInternetAccessSupportType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetMajorDeviceClass(most_fi_tcl_e8_BTSetMajorDeviceClass& /*oe8_BTSetMajorDeviceClass*/)
{
}
tVoid most_fi_tcl_e8_BTSetMajorDeviceClass::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetMajorDeviceClass(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetBluetoothFeatureSupport(most_fi_tcl_BTSetBluetoothFeatureSupport& /*oBTSetBluetoothFeatureSupport*/)
{
}
tVoid most_fi_tcl_BTSetBluetoothFeatureSupport::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetBluetoothFeatureSupport(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetSupportedProfiles(most_fi_tcl_BTSetSupportedProfiles& /*oBTSetSupportedProfiles*/)
{
}
tVoid most_fi_tcl_BTSetSupportedProfiles::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetSupportedProfiles(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceIdentification(most_fi_tcl_BTSetDeviceIdentification& /*oBTSetDeviceIdentification*/)
{
}
tVoid most_fi_tcl_BTSetDeviceIdentification::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceIdentification(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetOrigin(most_fi_tcl_e8_BTSetOrigin& /*oe8_BTSetOrigin*/)
{
}
tVoid most_fi_tcl_e8_BTSetOrigin::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetOrigin(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetScanningState(most_fi_tcl_e8_BTSetScanningState& /*oe8_BTSetScanningState*/)
{
}
tVoid most_fi_tcl_e8_BTSetScanningState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetScanningState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTServiceType(most_fi_tcl_BTServiceType& /*oBTServiceType*/)
{
}
tVoid most_fi_tcl_BTServiceType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTServiceType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTConnectionStatus(most_fi_tcl_e8_BTConnectionStatus& /*oe8_BTConnectionStatus*/)
{
}
tVoid most_fi_tcl_e8_BTConnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTConnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetDeviceDisconnectedReason(most_fi_tcl_e8_BTSetDeviceDisconnectedReason& /*oe8_BTSetDeviceDisconnectedReason*/)
{
}
tVoid most_fi_tcl_e8_BTSetDeviceDisconnectedReason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetDeviceDisconnectedReason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTProfileDisconnectedReason(most_fi_tcl_BTProfileDisconnectedReason& /*oBTProfileDisconnectedReason*/)
{
}
tVoid most_fi_tcl_BTProfileDisconnectedReason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTProfileDisconnectedReason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTDisconnectionReason(most_fi_tcl_e8_BTDisconnectionReason& /*oe8_BTDisconnectionReason*/)
{
}
tVoid most_fi_tcl_e8_BTDisconnectionReason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTDisconnectionReason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSPPServiceConnectionStatusListItem(most_fi_tcl_BTSPPServiceConnectionStatusListItem& /*oBTSPPServiceConnectionStatusListItem*/)
{
}
tVoid most_fi_tcl_BTSPPServiceConnectionStatusListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSPPServiceConnectionStatusListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTProfileConnectionStatus(most_fi_tcl_BTProfileConnectionStatus& /*oBTProfileConnectionStatus*/)
{
}
tVoid most_fi_tcl_BTProfileConnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTProfileConnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSPPServiceConnectionStatusList(most_fi_tcl_BTSPPServiceConnectionStatusList& /*oBTSPPServiceConnectionStatusList*/)
{
}
tVoid most_fi_tcl_BTSPPServiceConnectionStatusList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSPPServiceConnectionStatusList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTUsagePreference(most_fi_tcl_e8_BTUsagePreference& /*oe8_BTUsagePreference*/)
{
}
tVoid most_fi_tcl_e8_BTUsagePreference::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTUsagePreference(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTProfileFavoriteIndex(most_fi_tcl_BTProfileFavoriteIndex& /*oBTProfileFavoriteIndex*/)
{
}
tVoid most_fi_tcl_BTProfileFavoriteIndex::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTProfileFavoriteIndex(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetVisibleDeviceConnectionStatus(most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus& /*oe8_BTSetVisibleDeviceConnectionStatus*/)
{
}
tVoid most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetVisibleDeviceConnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetVisibleDeviceItem(most_fi_tcl_BTSetVisibleDeviceItem& /*oBTSetVisibleDeviceItem*/)
{
}
tVoid most_fi_tcl_BTSetVisibleDeviceItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetVisibleDeviceItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetSignalStrengthItem(most_fi_tcl_BTSetSignalStrengthItem& /*oBTSetSignalStrengthItem*/)
{
}
tVoid most_fi_tcl_BTSetSignalStrengthItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetSignalStrengthItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetSignalStrengthList(most_fi_tcl_BTSetSignalStrengthList& /*oBTSetSignalStrengthList*/)
{
}
tVoid most_fi_tcl_BTSetSignalStrengthList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetSignalStrengthList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetVisibleDevicesList(most_fi_tcl_BTSetVisibleDevicesList& /*oBTSetVisibleDevicesList*/)
{
}
tVoid most_fi_tcl_BTSetVisibleDevicesList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetVisibleDevicesList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceListChangeExtended(most_fi_tcl_BTSetDeviceListChangeExtended& /*oBTSetDeviceListChangeExtended*/)
{
}
tVoid most_fi_tcl_BTSetDeviceListChangeExtended::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceListChangeExtended(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceListExtendedResultItem(most_fi_tcl_BTSetDeviceListExtendedResultItem& /*oBTSetDeviceListExtendedResultItem*/)
{
}
tVoid most_fi_tcl_BTSetDeviceListExtendedResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceListExtendedResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetPairingResult(most_fi_tcl_e8_BTSetPairingResult& /*oe8_BTSetPairingResult*/)
{
}
tVoid most_fi_tcl_e8_BTSetPairingResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetPairingResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetPairableModeType(most_fi_tcl_BTSetPairableModeType& /*oBTSetPairableModeType*/)
{
}
tVoid most_fi_tcl_BTSetPairableModeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetPairableModeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTLocalModeType(most_fi_tcl_BTLocalModeType& /*oBTLocalModeType*/)
{
}
tVoid most_fi_tcl_BTLocalModeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTLocalModeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTTechnology(most_fi_tcl_e8_BTTechnology& /*oe8_BTTechnology*/)
{
}
tVoid most_fi_tcl_e8_BTTechnology::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTTechnology(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTCommunicationChannel(most_fi_tcl_e8_BTCommunicationChannel& /*oe8_BTCommunicationChannel*/)
{
}
tVoid most_fi_tcl_e8_BTCommunicationChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTCommunicationChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTLimitationAction(most_fi_tcl_e8_BTLimitationAction& /*oe8_BTLimitationAction*/)
{
}
tVoid most_fi_tcl_e8_BTLimitationAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTLimitationAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTLimitationActionState(most_fi_tcl_e8_BTLimitationActionState& /*oe8_BTLimitationActionState*/)
{
}
tVoid most_fi_tcl_e8_BTLimitationActionState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTLimitationActionState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTLimitationModeListItem(most_fi_tcl_BTLimitationModeListItem& /*oBTLimitationModeListItem*/)
{
}
tVoid most_fi_tcl_BTLimitationModeListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTLimitationModeListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTLimitationModeList(most_fi_tcl_BTLimitationModeList& /*oBTLimitationModeList*/)
{
}
tVoid most_fi_tcl_BTLimitationModeList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTLimitationModeList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTLimitationMode(most_fi_tcl_BTLimitationMode& /*oBTLimitationMode*/)
{
}
tVoid most_fi_tcl_BTLimitationMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTLimitationMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTOobType(most_fi_tcl_e8_BTOobType& /*oe8_BTOobType*/)
{
}
tVoid most_fi_tcl_e8_BTOobType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTOobType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTFavoriteType(most_fi_tcl_e8_BTFavoriteType& /*oe8_BTFavoriteType*/)
{
}
tVoid most_fi_tcl_e8_BTFavoriteType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTFavoriteType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTSetDeviceListExtendedResult(most_fi_tcl_BTSetDeviceListExtendedResult& /*oBTSetDeviceListExtendedResult*/)
{
}
tVoid most_fi_tcl_BTSetDeviceListExtendedResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTSetDeviceListExtendedResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSwitchStatus(most_fi_tcl_e8_BTSwitchStatus& /*oe8_BTSwitchStatus*/)
{
}
tVoid most_fi_tcl_e8_BTSwitchStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSwitchStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTProfile(most_fi_tcl_e8_BTProfile& /*oe8_BTProfile*/)
{
}
tVoid most_fi_tcl_e8_BTProfile::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTProfile(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTProfileUsageType(most_fi_tcl_e8_BTProfileUsageType& /*oe8_BTProfileUsageType*/)
{
}
tVoid most_fi_tcl_e8_BTProfileUsageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTProfileUsageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTProfilesUsageInfo(most_fi_tcl_BTProfilesUsageInfo& /*oBTProfilesUsageInfo*/)
{
}
tVoid most_fi_tcl_BTProfilesUsageInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTProfilesUsageInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTProfilesUsageInfoList(most_fi_tcl_BTProfilesUsageInfoList& /*oBTProfilesUsageInfoList*/)
{
}
tVoid most_fi_tcl_BTProfilesUsageInfoList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTProfilesUsageInfoList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTProfilesUsageList(most_fi_tcl_BTProfilesUsageList& /*oBTProfilesUsageList*/)
{
}
tVoid most_fi_tcl_BTProfilesUsageList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTProfilesUsageList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTResolutionType(most_fi_tcl_e8_BTResolutionType& /*oe8_BTResolutionType*/)
{
}
tVoid most_fi_tcl_e8_BTResolutionType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTResolutionType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTConflictTrigger(most_fi_tcl_e8_BTConflictTrigger& /*oe8_BTConflictTrigger*/)
{
}
tVoid most_fi_tcl_e8_BTConflictTrigger::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTConflictTrigger(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTConflictType(most_fi_tcl_e8_BTConflictType& /*oe8_BTConflictType*/)
{
}
tVoid most_fi_tcl_e8_BTConflictType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTConflictType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTConflictState(most_fi_tcl_e8_BTConflictState& /*oe8_BTConflictState*/)
{
}
tVoid most_fi_tcl_e8_BTConflictState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTConflictState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTConflictInfo(most_fi_tcl_BTConflictInfo& /*oBTConflictInfo*/)
{
}
tVoid most_fi_tcl_BTConflictInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTConflictInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_BTConflictInfoList(most_fi_tcl_BTConflictInfoList& /*oBTConflictInfoList*/)
{
}
tVoid most_fi_tcl_BTConflictInfoList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_BTConflictInfoList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTSetUsagePreference(most_fi_tcl_e8_BTSetUsagePreference& /*oe8_BTSetUsagePreference*/)
{
}
tVoid most_fi_tcl_e8_BTSetUsagePreference::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTSetUsagePreference(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTAutoconnectionStatus(most_fi_tcl_e8_BTAutoconnectionStatus& /*oe8_BTAutoconnectionStatus*/)
{
}
tVoid most_fi_tcl_e8_BTAutoconnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTAutoconnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTUserAvailable(most_fi_tcl_e8_BTUserAvailable& /*oe8_BTUserAvailable*/)
{
}
tVoid most_fi_tcl_e8_BTUserAvailable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTUserAvailable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BTServiceAvailable(most_fi_tcl_e8_BTServiceAvailable& /*oe8_BTServiceAvailable*/)
{
}
tVoid most_fi_tcl_e8_BTServiceAvailable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BTServiceAvailable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgFolderType(most_fi_tcl_e8_MsgFolderType& /*oe8_MsgFolderType*/)
{
}
tVoid most_fi_tcl_e8_MsgFolderType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgFolderType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgMessageListFilterType(most_fi_tcl_e8_MsgMessageListFilterType& /*oe8_MsgMessageListFilterType*/)
{
}
tVoid most_fi_tcl_e8_MsgMessageListFilterType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgMessageListFilterType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgMessageListSortType(most_fi_tcl_e8_MsgMessageListSortType& /*oe8_MsgMessageListSortType*/)
{
}
tVoid most_fi_tcl_e8_MsgMessageListSortType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgMessageListSortType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgMessageListType(most_fi_tcl_e8_MsgMessageListType& /*oe8_MsgMessageListType*/)
{
}
tVoid most_fi_tcl_e8_MsgMessageListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgMessageListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgMessageType(most_fi_tcl_e8_MsgMessageType& /*oe8_MsgMessageType*/)
{
}
tVoid most_fi_tcl_e8_MsgMessageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgMessageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgSendMessageResultType(most_fi_tcl_e8_MsgSendMessageResultType& /*oe8_MsgSendMessageResultType*/)
{
}
tVoid most_fi_tcl_e8_MsgSendMessageResultType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgSendMessageResultType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgPlaybackState(most_fi_tcl_e8_MsgPlaybackState& /*oe8_MsgPlaybackState*/)
{
}
tVoid most_fi_tcl_e8_MsgPlaybackState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgPlaybackState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageHandle(most_fi_tcl_MsgMessageHandle& /*oMsgMessageHandle*/)
{
}
tVoid most_fi_tcl_MsgMessageHandle::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageHandle(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageDate(most_fi_tcl_MsgMessageDate& /*oMsgMessageDate*/)
{
}
tVoid most_fi_tcl_MsgMessageDate::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageDate(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageTime(most_fi_tcl_MsgMessageTime& /*oMsgMessageTime*/)
{
}
tVoid most_fi_tcl_MsgMessageTime::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageTime(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageDateTime(most_fi_tcl_MsgMessageDateTime& /*oMsgMessageDateTime*/)
{
}
tVoid most_fi_tcl_MsgMessageDateTime::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageDateTime(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageListSliceResultItem(most_fi_tcl_MsgMessageListSliceResultItem& /*oMsgMessageListSliceResultItem*/)
{
}
tVoid most_fi_tcl_MsgMessageListSliceResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageListSliceResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageListSliceResult(most_fi_tcl_MsgMessageListSliceResult& /*oMsgMessageListSliceResult*/)
{
}
tVoid most_fi_tcl_MsgMessageListSliceResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageListSliceResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgListChangeType(most_fi_tcl_e8_MsgListChangeType& /*oe8_MsgListChangeType*/)
{
}
tVoid most_fi_tcl_e8_MsgListChangeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgListChangeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgChangeItems(most_fi_tcl_MsgChangeItems& /*oMsgChangeItems*/)
{
}
tVoid most_fi_tcl_MsgChangeItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgChangeItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgFolderListResultItem(most_fi_tcl_MsgFolderListResultItem& /*oMsgFolderListResultItem*/)
{
}
tVoid most_fi_tcl_MsgFolderListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgFolderListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgFolderListResult(most_fi_tcl_MsgFolderListResult& /*oMsgFolderListResult*/)
{
}
tVoid most_fi_tcl_MsgFolderListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgFolderListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgDeletionStatus(most_fi_tcl_e8_MsgDeletionStatus& /*oe8_MsgDeletionStatus*/)
{
}
tVoid most_fi_tcl_e8_MsgDeletionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgDeletionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgDeleteMessageHandles(most_fi_tcl_MsgDeleteMessageHandles& /*oMsgDeleteMessageHandles*/)
{
}
tVoid most_fi_tcl_MsgDeleteMessageHandles::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgDeleteMessageHandles(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgRecoveryStatus(most_fi_tcl_e8_MsgRecoveryStatus& /*oe8_MsgRecoveryStatus*/)
{
}
tVoid most_fi_tcl_e8_MsgRecoveryStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgRecoveryStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAccountListResultItem(most_fi_tcl_MsgAccountListResultItem& /*oMsgAccountListResultItem*/)
{
}
tVoid most_fi_tcl_MsgAccountListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAccountListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAccountListResult(most_fi_tcl_MsgAccountListResult& /*oMsgAccountListResult*/)
{
}
tVoid most_fi_tcl_MsgAccountListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAccountListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgActiveAccount(most_fi_tcl_MsgActiveAccount& /*oMsgActiveAccount*/)
{
}
tVoid most_fi_tcl_MsgActiveAccount::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgActiveAccount(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgAddressFieldType(most_fi_tcl_e8_MsgAddressFieldType& /*oe8_MsgAddressFieldType*/)
{
}
tVoid most_fi_tcl_e8_MsgAddressFieldType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgAddressFieldType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMsgBodyActionElementTags(most_fi_tcl_MsgMsgBodyActionElementTags& /*oMsgMsgBodyActionElementTags*/)
{
}
tVoid most_fi_tcl_MsgMsgBodyActionElementTags::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMsgBodyActionElementTags(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAddressFieldItem(most_fi_tcl_MsgAddressFieldItem& /*oMsgAddressFieldItem*/)
{
}
tVoid most_fi_tcl_MsgAddressFieldItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAddressFieldItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAddressField(most_fi_tcl_MsgAddressField& /*oMsgAddressField*/)
{
}
tVoid most_fi_tcl_MsgAddressField::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAddressField(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageDetailsResult(most_fi_tcl_MsgMessageDetailsResult& /*oMsgMessageDetailsResult*/)
{
}
tVoid most_fi_tcl_MsgMessageDetailsResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageDetailsResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgAttachmentType(most_fi_tcl_e8_MsgAttachmentType& /*oe8_MsgAttachmentType*/)
{
}
tVoid most_fi_tcl_e8_MsgAttachmentType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgAttachmentType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAttachmentListItem(most_fi_tcl_MsgAttachmentListItem& /*oMsgAttachmentListItem*/)
{
}
tVoid most_fi_tcl_MsgAttachmentListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAttachmentListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAttachmentList(most_fi_tcl_MsgAttachmentList& /*oMsgAttachmentList*/)
{
}
tVoid most_fi_tcl_MsgAttachmentList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAttachmentList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgPlaybackAction(most_fi_tcl_e8_MsgPlaybackAction& /*oe8_MsgPlaybackAction*/)
{
}
tVoid most_fi_tcl_e8_MsgPlaybackAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgPlaybackAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgBodyPartListItem(most_fi_tcl_MsgBodyPartListItem& /*oMsgBodyPartListItem*/)
{
}
tVoid most_fi_tcl_MsgBodyPartListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgBodyPartListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgBodyPartList(most_fi_tcl_MsgBodyPartList& /*oMsgBodyPartList*/)
{
}
tVoid most_fi_tcl_MsgBodyPartList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgBodyPartList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgTTSLanguage(most_fi_tcl_e8_MsgTTSLanguage& /*oe8_MsgTTSLanguage*/)
{
}
tVoid most_fi_tcl_e8_MsgTTSLanguage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgTTSLanguage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgRecordMessageAction(most_fi_tcl_e8_MsgRecordMessageAction& /*oe8_MsgRecordMessageAction*/)
{
}
tVoid most_fi_tcl_e8_MsgRecordMessageAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgRecordMessageAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgRecordMessageState(most_fi_tcl_e8_MsgRecordMessageState& /*oe8_MsgRecordMessageState*/)
{
}
tVoid most_fi_tcl_e8_MsgRecordMessageState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgRecordMessageState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgPredefinedMessageType(most_fi_tcl_e8_MsgPredefinedMessageType& /*oe8_MsgPredefinedMessageType*/)
{
}
tVoid most_fi_tcl_e8_MsgPredefinedMessageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgPredefinedMessageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgPredefinedMessageListResultItem(most_fi_tcl_MsgPredefinedMessageListResultItem& /*oMsgPredefinedMessageListResultItem*/)
{
}
tVoid most_fi_tcl_MsgPredefinedMessageListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgPredefinedMessageListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgPredefinedMessageListResult(most_fi_tcl_MsgPredefinedMessageListResult& /*oMsgPredefinedMessageListResult*/)
{
}
tVoid most_fi_tcl_MsgPredefinedMessageListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgPredefinedMessageListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgConversationMessages(most_fi_tcl_MsgConversationMessages& /*oMsgConversationMessages*/)
{
}
tVoid most_fi_tcl_MsgConversationMessages::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgConversationMessages(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgSentMessageStatus(most_fi_tcl_e8_MsgSentMessageStatus& /*oe8_MsgSentMessageStatus*/)
{
}
tVoid most_fi_tcl_e8_MsgSentMessageStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgSentMessageStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgAttachmentHandleStream(most_fi_tcl_MsgAttachmentHandleStream& /*oMsgAttachmentHandleStream*/)
{
}
tVoid most_fi_tcl_MsgAttachmentHandleStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgAttachmentHandleStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgMessageBodyText(most_fi_tcl_MsgMessageBodyText& /*oMsgMessageBodyText*/)
{
}
tVoid most_fi_tcl_MsgMessageBodyText::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgMessageBodyText(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgActionElementType(most_fi_tcl_e8_MsgActionElementType& /*oe8_MsgActionElementType*/)
{
}
tVoid most_fi_tcl_e8_MsgActionElementType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgActionElementType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgCreateMessageType(most_fi_tcl_e8_MsgCreateMessageType& /*oe8_MsgCreateMessageType*/)
{
}
tVoid most_fi_tcl_e8_MsgCreateMessageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgCreateMessageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgNotificationType(most_fi_tcl_e8_MsgNotificationType& /*oe8_MsgNotificationType*/)
{
}
tVoid most_fi_tcl_e8_MsgNotificationType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgNotificationType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MapConnectionStatus(most_fi_tcl_e8_MapConnectionStatus& /*oe8_MapConnectionStatus*/)
{
}
tVoid most_fi_tcl_e8_MapConnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MapConnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgPredefinedMessageSubCategory(most_fi_tcl_e8_MsgPredefinedMessageSubCategory& /*oe8_MsgPredefinedMessageSubCategory*/)
{
}
tVoid most_fi_tcl_e8_MsgPredefinedMessageSubCategory::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgPredefinedMessageSubCategory(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgPredefinedMessageCategory(most_fi_tcl_e8_MsgPredefinedMessageCategory& /*oe8_MsgPredefinedMessageCategory*/)
{
}
tVoid most_fi_tcl_e8_MsgPredefinedMessageCategory::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgPredefinedMessageCategory(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgPredefinedMessageListExtendedResultItem(most_fi_tcl_MsgPredefinedMessageListExtendedResultItem& /*oMsgPredefinedMessageListExtendedResultItem*/)
{
}
tVoid most_fi_tcl_MsgPredefinedMessageListExtendedResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgPredefinedMessageListExtendedResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgPredefinedMessageListExtendedResult(most_fi_tcl_MsgPredefinedMessageListExtendedResult& /*oMsgPredefinedMessageListExtendedResult*/)
{
}
tVoid most_fi_tcl_MsgPredefinedMessageListExtendedResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgPredefinedMessageListExtendedResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgLanguageSet(most_fi_tcl_e8_MsgLanguageSet& /*oe8_MsgLanguageSet*/)
{
}
tVoid most_fi_tcl_e8_MsgLanguageSet::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgLanguageSet(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SignatureTextStreamItem(most_fi_tcl_SignatureTextStreamItem& /*oSignatureTextStreamItem*/)
{
}
tVoid most_fi_tcl_SignatureTextStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SignatureTextStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SignatureTextStream(most_fi_tcl_SignatureTextStream& /*oSignatureTextStream*/)
{
}
tVoid most_fi_tcl_SignatureTextStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SignatureTextStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgConversationHandle(most_fi_tcl_MsgConversationHandle& /*oMsgConversationHandle*/)
{
}
tVoid most_fi_tcl_MsgConversationHandle::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgConversationHandle(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgConversationListSliceResultItem(most_fi_tcl_MsgConversationListSliceResultItem& /*oMsgConversationListSliceResultItem*/)
{
}
tVoid most_fi_tcl_MsgConversationListSliceResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgConversationListSliceResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MsgMessageStatus(most_fi_tcl_e8_MsgMessageStatus& /*oe8_MsgMessageStatus*/)
{
}
tVoid most_fi_tcl_e8_MsgMessageStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MsgMessageStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgConversationDetailListItem(most_fi_tcl_MsgConversationDetailListItem& /*oMsgConversationDetailListItem*/)
{
}
tVoid most_fi_tcl_MsgConversationDetailListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgConversationDetailListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgConversationListSliceResult(most_fi_tcl_MsgConversationListSliceResult& /*oMsgConversationListSliceResult*/)
{
}
tVoid most_fi_tcl_MsgConversationListSliceResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgConversationListSliceResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MsgConversationDetailList(most_fi_tcl_MsgConversationDetailList& /*oMsgConversationDetailList*/)
{
}
tVoid most_fi_tcl_MsgConversationDetailList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MsgConversationDetailList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnOffListItem(most_fi_tcl_OnOffListItem& /*oOnOffListItem*/)
{
}
tVoid most_fi_tcl_OnOffListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnOffListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnOffList(most_fi_tcl_OnOffList& /*oOnOffList*/)
{
}
tVoid most_fi_tcl_OnOffList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnOffList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AutoReplyTextListItem(most_fi_tcl_AutoReplyTextListItem& /*oAutoReplyTextListItem*/)
{
}
tVoid most_fi_tcl_AutoReplyTextListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AutoReplyTextListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AutoReplyTextList(most_fi_tcl_AutoReplyTextList& /*oAutoReplyTextList*/)
{
}
tVoid most_fi_tcl_AutoReplyTextList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AutoReplyTextList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MapDeviceCapabilitiesListItem(most_fi_tcl_MapDeviceCapabilitiesListItem& /*oMapDeviceCapabilitiesListItem*/)
{
}
tVoid most_fi_tcl_MapDeviceCapabilitiesListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MapDeviceCapabilitiesListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MapDeviceCapabilitiesList(most_fi_tcl_MapDeviceCapabilitiesList& /*oMapDeviceCapabilitiesList*/)
{
}
tVoid most_fi_tcl_MapDeviceCapabilitiesList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MapDeviceCapabilitiesList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkPhoneBookSortType(most_fi_tcl_e8_PhonBkPhoneBookSortType& /*oe8_PhonBkPhoneBookSortType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkPhoneBookSortType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkPhoneBookSortType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkSearchKeyboardListItem(most_fi_tcl_PhonBkSearchKeyboardListItem& /*oPhonBkSearchKeyboardListItem*/)
{
}
tVoid most_fi_tcl_PhonBkSearchKeyboardListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkSearchKeyboardListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkSearchKeyboardList(most_fi_tcl_PhonBkSearchKeyboardList& /*oPhonBkSearchKeyboardList*/)
{
}
tVoid most_fi_tcl_PhonBkSearchKeyboardList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkSearchKeyboardList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactDetailFilter(most_fi_tcl_e8_PhonBkContactDetailFilter& /*oe8_PhonBkContactDetailFilter*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactDetailFilter::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactDetailFilter(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkHomeAddressLatLong(most_fi_tcl_PhonBkHomeAddressLatLong& /*oPhonBkHomeAddressLatLong*/)
{
}
tVoid most_fi_tcl_PhonBkHomeAddressLatLong::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkHomeAddressLatLong(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkWorkAddressLatLong(most_fi_tcl_PhonBkWorkAddressLatLong& /*oPhonBkWorkAddressLatLong*/)
{
}
tVoid most_fi_tcl_PhonBkWorkAddressLatLong::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkWorkAddressLatLong(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkOtherAddressLatLong(most_fi_tcl_PhonBkOtherAddressLatLong& /*oPhonBkOtherAddressLatLong*/)
{
}
tVoid most_fi_tcl_PhonBkOtherAddressLatLong::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkOtherAddressLatLong(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkContactDetails(most_fi_tcl_PhonBkContactDetails& /*oPhonBkContactDetails*/)
{
}
tVoid most_fi_tcl_PhonBkContactDetails::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkContactDetails(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkContactPhoto(most_fi_tcl_PhonBkContactPhoto& /*oPhonBkContactPhoto*/)
{
}
tVoid most_fi_tcl_PhonBkContactPhoto::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkContactPhoto(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkListChangeType(most_fi_tcl_e8_PhonBkListChangeType& /*oe8_PhonBkListChangeType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkListChangeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkListChangeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkListType(most_fi_tcl_e8_PhonBkListType& /*oe8_PhonBkListType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkChangeItems(most_fi_tcl_PhonBkChangeItems& /*oPhonBkChangeItems*/)
{
}
tVoid most_fi_tcl_PhonBkChangeItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkChangeItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactAddStatus(most_fi_tcl_e8_PhonBkContactAddStatus& /*oe8_PhonBkContactAddStatus*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactAddStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactAddStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactDeleteStatus(most_fi_tcl_e8_PhonBkContactDeleteStatus& /*oe8_PhonBkContactDeleteStatus*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactDeleteStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactDeleteStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactEditStatus(most_fi_tcl_e8_PhonBkContactEditStatus& /*oe8_PhonBkContactEditStatus*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactEditStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactEditStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkCallHistorySortType(most_fi_tcl_e8_PhonBkCallHistorySortType& /*oe8_PhonBkCallHistorySortType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkCallHistorySortType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkCallHistorySortType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkCallHistoryType(most_fi_tcl_e8_PhonBkCallHistoryType& /*oe8_PhonBkCallHistoryType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkCallHistoryType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkCallHistoryType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkCallPhoneType(most_fi_tcl_e8_PhonBkCallPhoneType& /*oe8_PhonBkCallPhoneType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkCallPhoneType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkCallPhoneType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallDate(most_fi_tcl_PhonBkCallDate& /*oPhonBkCallDate*/)
{
}
tVoid most_fi_tcl_PhonBkCallDate::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallDate(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallTime(most_fi_tcl_PhonBkCallTime& /*oPhonBkCallTime*/)
{
}
tVoid most_fi_tcl_PhonBkCallTime::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallTime(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallDateTime(most_fi_tcl_PhonBkCallDateTime& /*oPhonBkCallDateTime*/)
{
}
tVoid most_fi_tcl_PhonBkCallDateTime::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallDateTime(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallHistoryListSliceResultItem(most_fi_tcl_PhonBkCallHistoryListSliceResultItem& /*oPhonBkCallHistoryListSliceResultItem*/)
{
}
tVoid most_fi_tcl_PhonBkCallHistoryListSliceResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallHistoryListSliceResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallHistoryListSliceResult(most_fi_tcl_PhonBkCallHistoryListSliceResult& /*oPhonBkCallHistoryListSliceResult*/)
{
}
tVoid most_fi_tcl_PhonBkCallHistoryListSliceResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallHistoryListSliceResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactDetailType(most_fi_tcl_e8_PhonBkContactDetailType& /*oe8_PhonBkContactDetailType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactDetailType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactDetailType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallHistoryTypeSupport(most_fi_tcl_PhonBkCallHistoryTypeSupport& /*oPhonBkCallHistoryTypeSupport*/)
{
}
tVoid most_fi_tcl_PhonBkCallHistoryTypeSupport::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallHistoryTypeSupport(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkAutocompleteMultipleMatchListItem(most_fi_tcl_PhonBkAutocompleteMultipleMatchListItem& /*oPhonBkAutocompleteMultipleMatchListItem*/)
{
}
tVoid most_fi_tcl_PhonBkAutocompleteMultipleMatchListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkAutocompleteMultipleMatchListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkAutocompleteMultipleMatchList(most_fi_tcl_PhonBkAutocompleteMultipleMatchList& /*oPhonBkAutocompleteMultipleMatchList*/)
{
}
tVoid most_fi_tcl_PhonBkAutocompleteMultipleMatchList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkAutocompleteMultipleMatchList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPhoneBookListSliceResultItem(most_fi_tcl_PhonBkPhoneBookListSliceResultItem& /*oPhonBkPhoneBookListSliceResultItem*/)
{
}
tVoid most_fi_tcl_PhonBkPhoneBookListSliceResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPhoneBookListSliceResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPhoneBookListSliceResult(most_fi_tcl_PhonBkPhoneBookListSliceResult& /*oPhonBkPhoneBookListSliceResult*/)
{
}
tVoid most_fi_tcl_PhonBkPhoneBookListSliceResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPhoneBookListSliceResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkPreferredPhoneBookSortOrder(most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder& /*oe8_PhonBkPreferredPhoneBookSortOrder*/)
{
}
tVoid most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkPreferredPhoneBookSortOrder(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkRecentCallListDownloadState(most_fi_tcl_e8_PhonBkRecentCallListDownloadState& /*oe8_PhonBkRecentCallListDownloadState*/)
{
}
tVoid most_fi_tcl_e8_PhonBkRecentCallListDownloadState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkRecentCallListDownloadState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkPhoneBookDownloadState(most_fi_tcl_e8_PhonBkPhoneBookDownloadState& /*oe8_PhonBkPhoneBookDownloadState*/)
{
}
tVoid most_fi_tcl_e8_PhonBkPhoneBookDownloadState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkPhoneBookDownloadState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadStateStreamItem(most_fi_tcl_PhonBkDownloadStateStreamItem& /*oPhonBkDownloadStateStreamItem*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadStateStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadStateStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadStateStream(most_fi_tcl_PhonBkDownloadStateStream& /*oPhonBkDownloadStateStream*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadStateStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadStateStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkNumberType(most_fi_tcl_e8_PhonBkNumberType& /*oe8_PhonBkNumberType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkNumberType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkNumberType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallHistoryListSliceResultExtenedItem(most_fi_tcl_PhonBkCallHistoryListSliceResultExtenedItem& /*oPhonBkCallHistoryListSliceResultExtenedItem*/)
{
}
tVoid most_fi_tcl_PhonBkCallHistoryListSliceResultExtenedItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallHistoryListSliceResultExtenedItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPhoneNumberItem(most_fi_tcl_PhonBkPhoneNumberItem& /*oPhonBkPhoneNumberItem*/)
{
}
tVoid most_fi_tcl_PhonBkPhoneNumberItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPhoneNumberItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactType(most_fi_tcl_e8_PhonBkContactType& /*oe8_PhonBkContactType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPhoneBookListSliceResultExtendedItem(most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem& /*oPhonBkPhoneBookListSliceResultExtendedItem*/)
{
}
tVoid most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPhoneBookListSliceResultExtendedItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPhoneBookListSliceResultExtended(most_fi_tcl_PhonBkPhoneBookListSliceResultExtended& /*oPhonBkPhoneBookListSliceResultExtended*/)
{
}
tVoid most_fi_tcl_PhonBkPhoneBookListSliceResultExtended::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPhoneBookListSliceResultExtended(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkCallHistoryListSliceResultExtened(most_fi_tcl_PhonBkCallHistoryListSliceResultExtened& /*oPhonBkCallHistoryListSliceResultExtened*/)
{
}
tVoid most_fi_tcl_PhonBkCallHistoryListSliceResultExtened::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkCallHistoryListSliceResultExtened(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkRecentCallListDownloadStateExtended(most_fi_tcl_e8_PhonBkRecentCallListDownloadStateExtended& /*oe8_PhonBkRecentCallListDownloadStateExtended*/)
{
}
tVoid most_fi_tcl_e8_PhonBkRecentCallListDownloadStateExtended::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkRecentCallListDownloadStateExtended(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkPhoneBookDownloadStateExtended(most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended& /*oe8_PhonBkPhoneBookDownloadStateExtended*/)
{
}
tVoid most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkPhoneBookDownloadStateExtended(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadStateExtendedStreamItem(most_fi_tcl_PhonBkDownloadStateExtendedStreamItem& /*oPhonBkDownloadStateExtendedStreamItem*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadStateExtendedStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadStateExtendedStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadStateExtendedStream(most_fi_tcl_PhonBkDownloadStateExtendedStream& /*oPhonBkDownloadStateExtendedStream*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadStateExtendedStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadStateExtendedStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDeviceHandleList(most_fi_tcl_PhonBkDeviceHandleList& /*oPhonBkDeviceHandleList*/)
{
}
tVoid most_fi_tcl_PhonBkDeviceHandleList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDeviceHandleList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkSearchSortType(most_fi_tcl_e8_PhonBkSearchSortType& /*oe8_PhonBkSearchSortType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkSearchSortType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkSearchSortType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkContactMatchListItem(most_fi_tcl_PhonBkContactMatchListItem& /*oPhonBkContactMatchListItem*/)
{
}
tVoid most_fi_tcl_PhonBkContactMatchListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkContactMatchListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkContactMatchList(most_fi_tcl_PhonBkContactMatchList& /*oPhonBkContactMatchList*/)
{
}
tVoid most_fi_tcl_PhonBkContactMatchList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkContactMatchList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkSwitchDownloadOnOffState(most_fi_tcl_e8_PhonBkSwitchDownloadOnOffState& /*oe8_PhonBkSwitchDownloadOnOffState*/)
{
}
tVoid most_fi_tcl_e8_PhonBkSwitchDownloadOnOffState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkSwitchDownloadOnOffState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadOnOffStateListItem(most_fi_tcl_PhonBkDownloadOnOffStateListItem& /*oPhonBkDownloadOnOffStateListItem*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadOnOffStateListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadOnOffStateListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadOnOffStateList(most_fi_tcl_PhonBkDownloadOnOffStateList& /*oPhonBkDownloadOnOffStateList*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadOnOffStateList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadOnOffStateList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactSortType(most_fi_tcl_e8_PhonBkContactSortType& /*oe8_PhonBkContactSortType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactSortType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactSortType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PhonBkContactListType(most_fi_tcl_e8_PhonBkContactListType& /*oe8_PhonBkContactListType*/)
{
}
tVoid most_fi_tcl_e8_PhonBkContactListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PhonBkContactListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkContactDetailsExtended(most_fi_tcl_PhonBkContactDetailsExtended& /*oPhonBkContactDetailsExtended*/)
{
}
tVoid most_fi_tcl_PhonBkContactDetailsExtended::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkContactDetailsExtended(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AutomaticContactDownloadListItem(most_fi_tcl_AutomaticContactDownloadListItem& /*oAutomaticContactDownloadListItem*/)
{
}
tVoid most_fi_tcl_AutomaticContactDownloadListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AutomaticContactDownloadListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AutomaticContactDownloadList(most_fi_tcl_AutomaticContactDownloadList& /*oAutomaticContactDownloadList*/)
{
}
tVoid most_fi_tcl_AutomaticContactDownloadList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AutomaticContactDownloadList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevicePhoneBookFeatureSupportListItem(most_fi_tcl_DevicePhoneBookFeatureSupportListItem& /*oDevicePhoneBookFeatureSupportListItem*/)
{
}
tVoid most_fi_tcl_DevicePhoneBookFeatureSupportListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevicePhoneBookFeatureSupportListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevicePhoneBookFeatureSupportList(most_fi_tcl_DevicePhoneBookFeatureSupportList& /*oDevicePhoneBookFeatureSupportList*/)
{
}
tVoid most_fi_tcl_DevicePhoneBookFeatureSupportList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevicePhoneBookFeatureSupportList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadProgressListItem(most_fi_tcl_PhonBkDownloadProgressListItem& /*oPhonBkDownloadProgressListItem*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadProgressListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadProgressListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkDownloadProgressList(most_fi_tcl_PhonBkDownloadProgressList& /*oPhonBkDownloadProgressList*/)
{
}
tVoid most_fi_tcl_PhonBkDownloadProgressList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkDownloadProgressList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkMissedCallIndicatorListItem(most_fi_tcl_PhonBkMissedCallIndicatorListItem& /*oPhonBkMissedCallIndicatorListItem*/)
{
}
tVoid most_fi_tcl_PhonBkMissedCallIndicatorListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkMissedCallIndicatorListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkMissedCallIndicatorList(most_fi_tcl_PhonBkMissedCallIndicatorList& /*oPhonBkMissedCallIndicatorList*/)
{
}
tVoid most_fi_tcl_PhonBkMissedCallIndicatorList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkMissedCallIndicatorList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPreferredSortOrderListItem(most_fi_tcl_PhonBkPreferredSortOrderListItem& /*oPhonBkPreferredSortOrderListItem*/)
{
}
tVoid most_fi_tcl_PhonBkPreferredSortOrderListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPreferredSortOrderListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PhonBkPreferredSortOrderList(most_fi_tcl_PhonBkPreferredSortOrderList& /*oPhonBkPreferredSortOrderList*/)
{
}
tVoid most_fi_tcl_PhonBkPreferredSortOrderList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PhonBkPreferredSortOrderList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PbkLanguage(most_fi_tcl_e8_PbkLanguage& /*oe8_PbkLanguage*/)
{
}
tVoid most_fi_tcl_e8_PbkLanguage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PbkLanguage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel& /*oe8_FavPrvAudioChannel*/)
{
}
tVoid most_fi_tcl_e8_FavPrvAudioChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvAudioChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvVideoChannel(most_fi_tcl_e8_FavPrvVideoChannel& /*oe8_FavPrvVideoChannel*/)
{
}
tVoid most_fi_tcl_e8_FavPrvVideoChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvVideoChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvFavoriteType(most_fi_tcl_e8_FavPrvFavoriteType& /*oe8_FavPrvFavoriteType*/)
{
}
tVoid most_fi_tcl_e8_FavPrvFavoriteType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvFavoriteType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavPrvFavoriteInfoItem(most_fi_tcl_FavPrvFavoriteInfoItem& /*oFavPrvFavoriteInfoItem*/)
{
}
tVoid most_fi_tcl_FavPrvFavoriteInfoItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavPrvFavoriteInfoItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavPrvFavoriteInfo(most_fi_tcl_FavPrvFavoriteInfo& /*oFavPrvFavoriteInfo*/)
{
}
tVoid most_fi_tcl_FavPrvFavoriteInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavPrvFavoriteInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvListChangeType(most_fi_tcl_e8_FavPrvListChangeType& /*oe8_FavPrvListChangeType*/)
{
}
tVoid most_fi_tcl_e8_FavPrvListChangeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvListChangeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavPrvChangedFavorites(most_fi_tcl_FavPrvChangedFavorites& /*oFavPrvChangedFavorites*/)
{
}
tVoid most_fi_tcl_FavPrvChangedFavorites::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavPrvChangedFavorites(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcAudioChannelName(most_fi_tcl_e8_SrcAudioChannelName& /*oe8_SrcAudioChannelName*/)
{
}
tVoid most_fi_tcl_e8_SrcAudioChannelName::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcAudioChannelName(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcContentProtection(most_fi_tcl_e8_SrcContentProtection& /*oe8_SrcContentProtection*/)
{
}
tVoid most_fi_tcl_e8_SrcContentProtection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcContentProtection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcContentType(most_fi_tcl_e8_SrcContentType& /*oe8_SrcContentType*/)
{
}
tVoid most_fi_tcl_e8_SrcContentType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcContentType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcTransmissionClass(most_fi_tcl_e8_SrcTransmissionClass& /*oe8_SrcTransmissionClass*/)
{
}
tVoid most_fi_tcl_e8_SrcTransmissionClass::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcTransmissionClass(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannels_Resolution(most_fi_tcl_SrcAudioChannels_Resolution& /*oSrcAudioChannels_Resolution*/)
{
}
tVoid most_fi_tcl_SrcAudioChannels_Resolution::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannels_Resolution(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannelListItem(most_fi_tcl_SrcAudioChannelListItem& /*oSrcAudioChannelListItem*/)
{
}
tVoid most_fi_tcl_SrcAudioChannelListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannelListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannelList(most_fi_tcl_SrcAudioChannelList& /*oSrcAudioChannelList*/)
{
}
tVoid most_fi_tcl_SrcAudioChannelList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannelList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannels_AudioChannelList(most_fi_tcl_SrcAudioChannels_AudioChannelList& /*oSrcAudioChannels_AudioChannelList*/)
{
}
tVoid most_fi_tcl_SrcAudioChannels_AudioChannelList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannels_AudioChannelList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcContentDescription(most_fi_tcl_SrcContentDescription& /*oSrcContentDescription*/)
{
}
tVoid most_fi_tcl_SrcContentDescription::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcContentDescription(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcActivity(most_fi_tcl_e8_SrcActivity& /*oe8_SrcActivity*/)
{
}
tVoid most_fi_tcl_e8_SrcActivity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcActivity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelCallStatus(most_fi_tcl_e8_TelCallStatus& /*oe8_TelCallStatus*/)
{
}
tVoid most_fi_tcl_e8_TelCallStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelCallStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelHandsetState(most_fi_tcl_e8_TelHandsetState& /*oe8_TelHandsetState*/)
{
}
tVoid most_fi_tcl_e8_TelHandsetState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelHandsetState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelActiveCallinHandsetStreamItem(most_fi_tcl_TelActiveCallinHandsetStreamItem& /*oTelActiveCallinHandsetStreamItem*/)
{
}
tVoid most_fi_tcl_TelActiveCallinHandsetStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelActiveCallinHandsetStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelActiveCallinHandsetStream(most_fi_tcl_TelActiveCallinHandsetStream& /*oTelActiveCallinHandsetStream*/)
{
}
tVoid most_fi_tcl_TelActiveCallinHandsetStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelActiveCallinHandsetStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelCallStatusNoticeStreamItem(most_fi_tcl_TelCallStatusNoticeStreamItem& /*oTelCallStatusNoticeStreamItem*/)
{
}
tVoid most_fi_tcl_TelCallStatusNoticeStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelCallStatusNoticeStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelCallStatusNoticeStream(most_fi_tcl_TelCallStatusNoticeStream& /*oTelCallStatusNoticeStream*/)
{
}
tVoid most_fi_tcl_TelCallStatusNoticeStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelCallStatusNoticeStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelCellService(most_fi_tcl_e8_TelCellService& /*oe8_TelCellService*/)
{
}
tVoid most_fi_tcl_e8_TelCellService::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelCellService(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelStreamOfCallInstances(most_fi_tcl_TelStreamOfCallInstances& /*oTelStreamOfCallInstances*/)
{
}
tVoid most_fi_tcl_TelStreamOfCallInstances::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelStreamOfCallInstances(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelIncomingCallEventEnum(most_fi_tcl_e8_TelIncomingCallEventEnum& /*oe8_TelIncomingCallEventEnum*/)
{
}
tVoid most_fi_tcl_e8_TelIncomingCallEventEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelIncomingCallEventEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelEchoCancellationNoiseReductionSetting(most_fi_tcl_e8_TelEchoCancellationNoiseReductionSetting& /*oe8_TelEchoCancellationNoiseReductionSetting*/)
{
}
tVoid most_fi_tcl_e8_TelEchoCancellationNoiseReductionSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelEchoCancellationNoiseReductionSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelHFEnhancedCallControlStreamItem(most_fi_tcl_TelHFEnhancedCallControlStreamItem& /*oTelHFEnhancedCallControlStreamItem*/)
{
}
tVoid most_fi_tcl_TelHFEnhancedCallControlStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelHFEnhancedCallControlStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelHFEnhancedCallControlStream(most_fi_tcl_TelHFEnhancedCallControlStream& /*oTelHFEnhancedCallControlStream*/)
{
}
tVoid most_fi_tcl_TelHFEnhancedCallControlStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelHFEnhancedCallControlStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelInbandRingingSupport(most_fi_tcl_e8_TelInbandRingingSupport& /*oe8_TelInbandRingingSupport*/)
{
}
tVoid most_fi_tcl_e8_TelInbandRingingSupport::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelInbandRingingSupport(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelDeviceRingtoneListResultItem(most_fi_tcl_TelDeviceRingtoneListResultItem& /*oTelDeviceRingtoneListResultItem*/)
{
}
tVoid most_fi_tcl_TelDeviceRingtoneListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelDeviceRingtoneListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelDeviceRingtoneListResult(most_fi_tcl_TelDeviceRingtoneListResult& /*oTelDeviceRingtoneListResult*/)
{
}
tVoid most_fi_tcl_TelDeviceRingtoneListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelDeviceRingtoneListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelSystemWideRingtonesListResultItem(most_fi_tcl_TelSystemWideRingtonesListResultItem& /*oTelSystemWideRingtonesListResultItem*/)
{
}
tVoid most_fi_tcl_TelSystemWideRingtonesListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelSystemWideRingtonesListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelSystemWideRingtonesListResult(most_fi_tcl_TelSystemWideRingtonesListResult& /*oTelSystemWideRingtonesListResult*/)
{
}
tVoid most_fi_tcl_TelSystemWideRingtonesListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelSystemWideRingtonesListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelSuppressRingtoneOnOffListResultItem(most_fi_tcl_TelSuppressRingtoneOnOffListResultItem& /*oTelSuppressRingtoneOnOffListResultItem*/)
{
}
tVoid most_fi_tcl_TelSuppressRingtoneOnOffListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelSuppressRingtoneOnOffListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelSuppressRingtoneOnOffListResult(most_fi_tcl_TelSuppressRingtoneOnOffListResult& /*oTelSuppressRingtoneOnOffListResult*/)
{
}
tVoid most_fi_tcl_TelSuppressRingtoneOnOffListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelSuppressRingtoneOnOffListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelAutoWaitingModeOnOffListResultItem(most_fi_tcl_TelAutoWaitingModeOnOffListResultItem& /*oTelAutoWaitingModeOnOffListResultItem*/)
{
}
tVoid most_fi_tcl_TelAutoWaitingModeOnOffListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelAutoWaitingModeOnOffListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelAutoWaitingModeOnOffListResult(most_fi_tcl_TelAutoWaitingModeOnOffListResult& /*oTelAutoWaitingModeOnOffListResult*/)
{
}
tVoid most_fi_tcl_TelAutoWaitingModeOnOffListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelAutoWaitingModeOnOffListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelWaitingModeAction(most_fi_tcl_e8_TelWaitingModeAction& /*oe8_TelWaitingModeAction*/)
{
}
tVoid most_fi_tcl_e8_TelWaitingModeAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelWaitingModeAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelWaitingModeStatus(most_fi_tcl_e8_TelWaitingModeStatus& /*oe8_TelWaitingModeStatus*/)
{
}
tVoid most_fi_tcl_e8_TelWaitingModeStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelWaitingModeStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelSiriAvailabilityState(most_fi_tcl_e8_TelSiriAvailabilityState& /*oe8_TelSiriAvailabilityState*/)
{
}
tVoid most_fi_tcl_e8_TelSiriAvailabilityState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelSiriAvailabilityState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelCallStatusNoticeExtendedStreamItem(most_fi_tcl_TelCallStatusNoticeExtendedStreamItem& /*oTelCallStatusNoticeExtendedStreamItem*/)
{
}
tVoid most_fi_tcl_TelCallStatusNoticeExtendedStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelCallStatusNoticeExtendedStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelCallStatusNoticeExtendedStream(most_fi_tcl_TelCallStatusNoticeExtendedStream& /*oTelCallStatusNoticeExtendedStream*/)
{
}
tVoid most_fi_tcl_TelCallStatusNoticeExtendedStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelCallStatusNoticeExtendedStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelOutgoingCall_Failed(most_fi_tcl_TelOutgoingCall_Failed& /*oTelOutgoingCall_Failed*/)
{
}
tVoid most_fi_tcl_TelOutgoingCall_Failed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelOutgoingCall_Failed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TelIncomingCall_Rejected(most_fi_tcl_TelIncomingCall_Rejected& /*oTelIncomingCall_Rejected*/)
{
}
tVoid most_fi_tcl_TelIncomingCall_Rejected::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TelIncomingCall_Rejected(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_WaitingModeState(most_fi_tcl_e8_WaitingModeState& /*oe8_WaitingModeState*/)
{
}
tVoid most_fi_tcl_e8_WaitingModeState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_WaitingModeState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ExternalVRState(most_fi_tcl_e8_ExternalVRState& /*oe8_ExternalVRState*/)
{
}
tVoid most_fi_tcl_e8_ExternalVRState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ExternalVRState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_VRErrorCode(most_fi_tcl_e8_VRErrorCode& /*oe8_VRErrorCode*/)
{
}
tVoid most_fi_tcl_e8_VRErrorCode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_VRErrorCode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_ListOfCallInstanceStreamItem(most_fi_tcl_ListOfCallInstanceStreamItem& /*oListOfCallInstanceStreamItem*/)
{
}
tVoid most_fi_tcl_ListOfCallInstanceStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_ListOfCallInstanceStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_ListOfCallInstanceStream(most_fi_tcl_ListOfCallInstanceStream& /*oListOfCallInstanceStream*/)
{
}
tVoid most_fi_tcl_ListOfCallInstanceStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_ListOfCallInstanceStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudioTransferDirection(most_fi_tcl_e8_AudioTransferDirection& /*oe8_AudioTransferDirection*/)
{
}
tVoid most_fi_tcl_e8_AudioTransferDirection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudioTransferDirection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TelPlaybackState(most_fi_tcl_e8_TelPlaybackState& /*oe8_TelPlaybackState*/)
{
}
tVoid most_fi_tcl_e8_TelPlaybackState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TelPlaybackState(*this);
}

