#ifndef MOST_FIVISITOR_HEADER
#define MOST_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class most_fi_tclOutput {
public:
   most_fi_tclOutput();
   virtual ~most_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class most_fi_tclFileOutput : public most_fi_tclOutput 
{
public:
   most_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   most_fi_tclFileOutput(); //lint !e1704
   most_fi_tclFileOutput& operator=(const most_fi_tclFileOutput& coRef);
   most_fi_tclFileOutput(const most_fi_tclFileOutput& coRef); //lint !e1704
};

class most_fi_tclMemOutput : public most_fi_tclOutput
{
public:
   most_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~most_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   most_fi_tclMemOutput(); //lint !e1704
   most_fi_tclMemOutput(const most_fi_tclMemOutput& coRef); //lint !e1704
   most_fi_tclMemOutput& operator=(const most_fi_tclMemOutput& coRef); //lint !e1704
};

///////////////////////////////////////////////////////////////////////////////
//
// special version including MOST compatible types
//
// implementation omitted intentionally for 
// bool, U8, U16, U24, U32, S8, S16, S24, S32, list and multilanguage string
//
///////////////////////////////////////////////////////////////////////////////

class MY_DECL most_fi_tclVisitorBase {
public:

   // --Konstruktor
   most_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~most_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(most_fi_tclU8& oU8);
   virtual tVoid vVisitS8(most_fi_tclS8& oS8);
   virtual tVoid vVisitU16(most_fi_tclU16& oU16);
   virtual tVoid vVisitS16(most_fi_tclS16& oS16);
   virtual tVoid vVisitU32(most_fi_tclU32& oU32);
   virtual tVoid vVisitS32(most_fi_tclS32& oS32);
   virtual tVoid vVisitBool(most_fi_tclBool& oBool);

   virtual tVoid vVisit_String(most_fi_tcl_String& oString);  // MOST-compatible String
   virtual tVoid vVisit_TrailingStream(most_fi_tcl_TrailingStream& oContainer);
   virtual tVoid vVisit_ShortStream(most_fi_tcl_ShortStream& oContainer);
   virtual tVoid vVisit_ClassifiedStream(most_fi_tcl_ClassifiedStream& oContainer);
   virtual tVoid vVisit_e8_ErrorCode(most_fi_tcl_e8_ErrorCode& oe8_ErrorCode);

   virtual tVoid vVisit_e8_BTSetPairingType(most_fi_tcl_e8_BTSetPairingType& oe8_BTSetPairingType);

   virtual tVoid vVisit_e8_BTSetPairingResponseType(most_fi_tcl_e8_BTSetPairingResponseType& oe8_BTSetPairingResponseType);

   virtual tVoid vVisit_e8_BTSetPairingStatusType(most_fi_tcl_e8_BTSetPairingStatusType& oe8_BTSetPairingStatusType);

   virtual tVoid vVisit_e8_BTSetDeviceStatus(most_fi_tcl_e8_BTSetDeviceStatus& oe8_BTSetDeviceStatus);

   virtual tVoid vVisit_BTSetDateStamp(most_fi_tcl_BTSetDateStamp& oBTSetDateStamp);

   virtual tVoid vVisit_BTSetTimeStamp(most_fi_tcl_BTSetTimeStamp& oBTSetTimeStamp);

   virtual tVoid vVisit_BTSetDateTimeStamp(most_fi_tcl_BTSetDateTimeStamp& oBTSetDateTimeStamp);

   virtual tVoid vVisit_e8_BTSetChangeDeviceStateAction(most_fi_tcl_e8_BTSetChangeDeviceStateAction& oe8_BTSetChangeDeviceStateAction);

   virtual tVoid vVisit_e8_BTSetConnectionResult(most_fi_tcl_e8_BTSetConnectionResult& oe8_BTSetConnectionResult);

   virtual tVoid vVisit_BTSetDeviceRingtoneListResultItem(most_fi_tcl_BTSetDeviceRingtoneListResultItem& oBTSetDeviceRingtoneListResultItem);

   virtual tVoid vVisit_BTSetDeviceRingtoneListResult(most_fi_tcl_BTSetDeviceRingtoneListResult& oBTSetDeviceRingtoneListResult);

   virtual tVoid vVisit_BTSetRingtoneListItem(most_fi_tcl_BTSetRingtoneListItem& oBTSetRingtoneListItem);

   virtual tVoid vVisit_BTSetRingtoneList(most_fi_tcl_BTSetRingtoneList& oBTSetRingtoneList);

   virtual tVoid vVisit_BTSetDeviceControlSupport(most_fi_tcl_BTSetDeviceControlSupport& oBTSetDeviceControlSupport);

   virtual tVoid vVisit_e8_BTSetAudioStreamingSupportType(most_fi_tcl_e8_BTSetAudioStreamingSupportType& oe8_BTSetAudioStreamingSupportType);

   virtual tVoid vVisit_e8_BTSetInternetAccessSupportType(most_fi_tcl_e8_BTSetInternetAccessSupportType& oe8_BTSetInternetAccessSupportType);

   virtual tVoid vVisit_e8_BTSetMajorDeviceClass(most_fi_tcl_e8_BTSetMajorDeviceClass& oe8_BTSetMajorDeviceClass);

   virtual tVoid vVisit_BTSetBluetoothFeatureSupport(most_fi_tcl_BTSetBluetoothFeatureSupport& oBTSetBluetoothFeatureSupport);

   virtual tVoid vVisit_BTSetSupportedProfiles(most_fi_tcl_BTSetSupportedProfiles& oBTSetSupportedProfiles);

   virtual tVoid vVisit_BTSetDeviceIdentification(most_fi_tcl_BTSetDeviceIdentification& oBTSetDeviceIdentification);

   virtual tVoid vVisit_e8_BTSetOrigin(most_fi_tcl_e8_BTSetOrigin& oe8_BTSetOrigin);

   virtual tVoid vVisit_e8_BTSetScanningState(most_fi_tcl_e8_BTSetScanningState& oe8_BTSetScanningState);

   virtual tVoid vVisit_BTServiceType(most_fi_tcl_BTServiceType& oBTServiceType);

   virtual tVoid vVisit_e8_BTConnectionStatus(most_fi_tcl_e8_BTConnectionStatus& oe8_BTConnectionStatus);

   virtual tVoid vVisit_e8_BTSetDeviceDisconnectedReason(most_fi_tcl_e8_BTSetDeviceDisconnectedReason& oe8_BTSetDeviceDisconnectedReason);

   virtual tVoid vVisit_BTProfileDisconnectedReason(most_fi_tcl_BTProfileDisconnectedReason& oBTProfileDisconnectedReason);

   virtual tVoid vVisit_e8_BTDisconnectionReason(most_fi_tcl_e8_BTDisconnectionReason& oe8_BTDisconnectionReason);

   virtual tVoid vVisit_BTSPPServiceConnectionStatusListItem(most_fi_tcl_BTSPPServiceConnectionStatusListItem& oBTSPPServiceConnectionStatusListItem);

   virtual tVoid vVisit_BTProfileConnectionStatus(most_fi_tcl_BTProfileConnectionStatus& oBTProfileConnectionStatus);

   virtual tVoid vVisit_BTSPPServiceConnectionStatusList(most_fi_tcl_BTSPPServiceConnectionStatusList& oBTSPPServiceConnectionStatusList);

   virtual tVoid vVisit_e8_BTUsagePreference(most_fi_tcl_e8_BTUsagePreference& oe8_BTUsagePreference);

   virtual tVoid vVisit_BTProfileFavoriteIndex(most_fi_tcl_BTProfileFavoriteIndex& oBTProfileFavoriteIndex);

   virtual tVoid vVisit_e8_BTSetVisibleDeviceConnectionStatus(most_fi_tcl_e8_BTSetVisibleDeviceConnectionStatus& oe8_BTSetVisibleDeviceConnectionStatus);

   virtual tVoid vVisit_BTSetVisibleDeviceItem(most_fi_tcl_BTSetVisibleDeviceItem& oBTSetVisibleDeviceItem);

   virtual tVoid vVisit_BTSetSignalStrengthItem(most_fi_tcl_BTSetSignalStrengthItem& oBTSetSignalStrengthItem);

   virtual tVoid vVisit_BTSetSignalStrengthList(most_fi_tcl_BTSetSignalStrengthList& oBTSetSignalStrengthList);

   virtual tVoid vVisit_BTSetVisibleDevicesList(most_fi_tcl_BTSetVisibleDevicesList& oBTSetVisibleDevicesList);

   virtual tVoid vVisit_BTSetDeviceListChangeExtended(most_fi_tcl_BTSetDeviceListChangeExtended& oBTSetDeviceListChangeExtended);

   virtual tVoid vVisit_BTSetDeviceListExtendedResultItem(most_fi_tcl_BTSetDeviceListExtendedResultItem& oBTSetDeviceListExtendedResultItem);

   virtual tVoid vVisit_e8_BTSetPairingResult(most_fi_tcl_e8_BTSetPairingResult& oe8_BTSetPairingResult);

   virtual tVoid vVisit_BTSetPairableModeType(most_fi_tcl_BTSetPairableModeType& oBTSetPairableModeType);

   virtual tVoid vVisit_BTLocalModeType(most_fi_tcl_BTLocalModeType& oBTLocalModeType);

   virtual tVoid vVisit_e8_BTTechnology(most_fi_tcl_e8_BTTechnology& oe8_BTTechnology);

   virtual tVoid vVisit_e8_BTCommunicationChannel(most_fi_tcl_e8_BTCommunicationChannel& oe8_BTCommunicationChannel);

   virtual tVoid vVisit_e8_BTLimitationAction(most_fi_tcl_e8_BTLimitationAction& oe8_BTLimitationAction);

   virtual tVoid vVisit_e8_BTLimitationActionState(most_fi_tcl_e8_BTLimitationActionState& oe8_BTLimitationActionState);

   virtual tVoid vVisit_BTLimitationModeListItem(most_fi_tcl_BTLimitationModeListItem& oBTLimitationModeListItem);

   virtual tVoid vVisit_BTLimitationModeList(most_fi_tcl_BTLimitationModeList& oBTLimitationModeList);

   virtual tVoid vVisit_BTLimitationMode(most_fi_tcl_BTLimitationMode& oBTLimitationMode);

   virtual tVoid vVisit_e8_BTOobType(most_fi_tcl_e8_BTOobType& oe8_BTOobType);

   virtual tVoid vVisit_e8_BTFavoriteType(most_fi_tcl_e8_BTFavoriteType& oe8_BTFavoriteType);

   virtual tVoid vVisit_BTSetDeviceListExtendedResult(most_fi_tcl_BTSetDeviceListExtendedResult& oBTSetDeviceListExtendedResult);

   virtual tVoid vVisit_e8_BTSwitchStatus(most_fi_tcl_e8_BTSwitchStatus& oe8_BTSwitchStatus);

   virtual tVoid vVisit_e8_BTProfile(most_fi_tcl_e8_BTProfile& oe8_BTProfile);

   virtual tVoid vVisit_e8_BTProfileUsageType(most_fi_tcl_e8_BTProfileUsageType& oe8_BTProfileUsageType);

   virtual tVoid vVisit_BTProfilesUsageInfo(most_fi_tcl_BTProfilesUsageInfo& oBTProfilesUsageInfo);

   virtual tVoid vVisit_BTProfilesUsageInfoList(most_fi_tcl_BTProfilesUsageInfoList& oBTProfilesUsageInfoList);

   virtual tVoid vVisit_BTProfilesUsageList(most_fi_tcl_BTProfilesUsageList& oBTProfilesUsageList);

   virtual tVoid vVisit_e8_BTResolutionType(most_fi_tcl_e8_BTResolutionType& oe8_BTResolutionType);

   virtual tVoid vVisit_e8_BTConflictTrigger(most_fi_tcl_e8_BTConflictTrigger& oe8_BTConflictTrigger);

   virtual tVoid vVisit_e8_BTConflictType(most_fi_tcl_e8_BTConflictType& oe8_BTConflictType);

   virtual tVoid vVisit_e8_BTConflictState(most_fi_tcl_e8_BTConflictState& oe8_BTConflictState);

   virtual tVoid vVisit_BTConflictInfo(most_fi_tcl_BTConflictInfo& oBTConflictInfo);

   virtual tVoid vVisit_BTConflictInfoList(most_fi_tcl_BTConflictInfoList& oBTConflictInfoList);

   virtual tVoid vVisit_e8_BTSetUsagePreference(most_fi_tcl_e8_BTSetUsagePreference& oe8_BTSetUsagePreference);

   virtual tVoid vVisit_e8_BTAutoconnectionStatus(most_fi_tcl_e8_BTAutoconnectionStatus& oe8_BTAutoconnectionStatus);

   virtual tVoid vVisit_e8_BTUserAvailable(most_fi_tcl_e8_BTUserAvailable& oe8_BTUserAvailable);

   virtual tVoid vVisit_e8_BTServiceAvailable(most_fi_tcl_e8_BTServiceAvailable& oe8_BTServiceAvailable);

   virtual tVoid vVisit_e8_MsgFolderType(most_fi_tcl_e8_MsgFolderType& oe8_MsgFolderType);

   virtual tVoid vVisit_e8_MsgMessageListFilterType(most_fi_tcl_e8_MsgMessageListFilterType& oe8_MsgMessageListFilterType);

   virtual tVoid vVisit_e8_MsgMessageListSortType(most_fi_tcl_e8_MsgMessageListSortType& oe8_MsgMessageListSortType);

   virtual tVoid vVisit_e8_MsgMessageListType(most_fi_tcl_e8_MsgMessageListType& oe8_MsgMessageListType);

   virtual tVoid vVisit_e8_MsgMessageType(most_fi_tcl_e8_MsgMessageType& oe8_MsgMessageType);

   virtual tVoid vVisit_e8_MsgSendMessageResultType(most_fi_tcl_e8_MsgSendMessageResultType& oe8_MsgSendMessageResultType);

   virtual tVoid vVisit_e8_MsgPlaybackState(most_fi_tcl_e8_MsgPlaybackState& oe8_MsgPlaybackState);

   virtual tVoid vVisit_MsgMessageHandle(most_fi_tcl_MsgMessageHandle& oMsgMessageHandle);

   virtual tVoid vVisit_MsgMessageDate(most_fi_tcl_MsgMessageDate& oMsgMessageDate);

   virtual tVoid vVisit_MsgMessageTime(most_fi_tcl_MsgMessageTime& oMsgMessageTime);

   virtual tVoid vVisit_MsgMessageDateTime(most_fi_tcl_MsgMessageDateTime& oMsgMessageDateTime);

   virtual tVoid vVisit_MsgMessageListSliceResultItem(most_fi_tcl_MsgMessageListSliceResultItem& oMsgMessageListSliceResultItem);

   virtual tVoid vVisit_MsgMessageListSliceResult(most_fi_tcl_MsgMessageListSliceResult& oMsgMessageListSliceResult);

   virtual tVoid vVisit_e8_MsgListChangeType(most_fi_tcl_e8_MsgListChangeType& oe8_MsgListChangeType);

   virtual tVoid vVisit_MsgChangeItems(most_fi_tcl_MsgChangeItems& oMsgChangeItems);

   virtual tVoid vVisit_MsgFolderListResultItem(most_fi_tcl_MsgFolderListResultItem& oMsgFolderListResultItem);

   virtual tVoid vVisit_MsgFolderListResult(most_fi_tcl_MsgFolderListResult& oMsgFolderListResult);

   virtual tVoid vVisit_e8_MsgDeletionStatus(most_fi_tcl_e8_MsgDeletionStatus& oe8_MsgDeletionStatus);

   virtual tVoid vVisit_MsgDeleteMessageHandles(most_fi_tcl_MsgDeleteMessageHandles& oMsgDeleteMessageHandles);

   virtual tVoid vVisit_e8_MsgRecoveryStatus(most_fi_tcl_e8_MsgRecoveryStatus& oe8_MsgRecoveryStatus);

   virtual tVoid vVisit_MsgAccountListResultItem(most_fi_tcl_MsgAccountListResultItem& oMsgAccountListResultItem);

   virtual tVoid vVisit_MsgAccountListResult(most_fi_tcl_MsgAccountListResult& oMsgAccountListResult);

   virtual tVoid vVisit_MsgActiveAccount(most_fi_tcl_MsgActiveAccount& oMsgActiveAccount);

   virtual tVoid vVisit_e8_MsgAddressFieldType(most_fi_tcl_e8_MsgAddressFieldType& oe8_MsgAddressFieldType);

   virtual tVoid vVisit_MsgMsgBodyActionElementTags(most_fi_tcl_MsgMsgBodyActionElementTags& oMsgMsgBodyActionElementTags);

   virtual tVoid vVisit_MsgAddressFieldItem(most_fi_tcl_MsgAddressFieldItem& oMsgAddressFieldItem);

   virtual tVoid vVisit_MsgAddressField(most_fi_tcl_MsgAddressField& oMsgAddressField);

   virtual tVoid vVisit_MsgMessageDetailsResult(most_fi_tcl_MsgMessageDetailsResult& oMsgMessageDetailsResult);

   virtual tVoid vVisit_e8_MsgAttachmentType(most_fi_tcl_e8_MsgAttachmentType& oe8_MsgAttachmentType);

   virtual tVoid vVisit_MsgAttachmentListItem(most_fi_tcl_MsgAttachmentListItem& oMsgAttachmentListItem);

   virtual tVoid vVisit_MsgAttachmentList(most_fi_tcl_MsgAttachmentList& oMsgAttachmentList);

   virtual tVoid vVisit_e8_MsgPlaybackAction(most_fi_tcl_e8_MsgPlaybackAction& oe8_MsgPlaybackAction);

   virtual tVoid vVisit_MsgBodyPartListItem(most_fi_tcl_MsgBodyPartListItem& oMsgBodyPartListItem);

   virtual tVoid vVisit_MsgBodyPartList(most_fi_tcl_MsgBodyPartList& oMsgBodyPartList);

   virtual tVoid vVisit_e8_MsgTTSLanguage(most_fi_tcl_e8_MsgTTSLanguage& oe8_MsgTTSLanguage);

   virtual tVoid vVisit_e8_MsgRecordMessageAction(most_fi_tcl_e8_MsgRecordMessageAction& oe8_MsgRecordMessageAction);

   virtual tVoid vVisit_e8_MsgRecordMessageState(most_fi_tcl_e8_MsgRecordMessageState& oe8_MsgRecordMessageState);

   virtual tVoid vVisit_e8_MsgPredefinedMessageType(most_fi_tcl_e8_MsgPredefinedMessageType& oe8_MsgPredefinedMessageType);

   virtual tVoid vVisit_MsgPredefinedMessageListResultItem(most_fi_tcl_MsgPredefinedMessageListResultItem& oMsgPredefinedMessageListResultItem);

   virtual tVoid vVisit_MsgPredefinedMessageListResult(most_fi_tcl_MsgPredefinedMessageListResult& oMsgPredefinedMessageListResult);

   virtual tVoid vVisit_MsgConversationMessages(most_fi_tcl_MsgConversationMessages& oMsgConversationMessages);

   virtual tVoid vVisit_e8_MsgSentMessageStatus(most_fi_tcl_e8_MsgSentMessageStatus& oe8_MsgSentMessageStatus);

   virtual tVoid vVisit_MsgAttachmentHandleStream(most_fi_tcl_MsgAttachmentHandleStream& oMsgAttachmentHandleStream);

   virtual tVoid vVisit_MsgMessageBodyText(most_fi_tcl_MsgMessageBodyText& oMsgMessageBodyText);

   virtual tVoid vVisit_e8_MsgActionElementType(most_fi_tcl_e8_MsgActionElementType& oe8_MsgActionElementType);

   virtual tVoid vVisit_e8_MsgCreateMessageType(most_fi_tcl_e8_MsgCreateMessageType& oe8_MsgCreateMessageType);

   virtual tVoid vVisit_e8_MsgNotificationType(most_fi_tcl_e8_MsgNotificationType& oe8_MsgNotificationType);

   virtual tVoid vVisit_e8_MapConnectionStatus(most_fi_tcl_e8_MapConnectionStatus& oe8_MapConnectionStatus);

   virtual tVoid vVisit_e8_MsgPredefinedMessageSubCategory(most_fi_tcl_e8_MsgPredefinedMessageSubCategory& oe8_MsgPredefinedMessageSubCategory);

   virtual tVoid vVisit_e8_MsgPredefinedMessageCategory(most_fi_tcl_e8_MsgPredefinedMessageCategory& oe8_MsgPredefinedMessageCategory);

   virtual tVoid vVisit_MsgPredefinedMessageListExtendedResultItem(most_fi_tcl_MsgPredefinedMessageListExtendedResultItem& oMsgPredefinedMessageListExtendedResultItem);

   virtual tVoid vVisit_MsgPredefinedMessageListExtendedResult(most_fi_tcl_MsgPredefinedMessageListExtendedResult& oMsgPredefinedMessageListExtendedResult);

   virtual tVoid vVisit_e8_MsgLanguageSet(most_fi_tcl_e8_MsgLanguageSet& oe8_MsgLanguageSet);

   virtual tVoid vVisit_SignatureTextStreamItem(most_fi_tcl_SignatureTextStreamItem& oSignatureTextStreamItem);

   virtual tVoid vVisit_SignatureTextStream(most_fi_tcl_SignatureTextStream& oSignatureTextStream);

   virtual tVoid vVisit_MsgConversationHandle(most_fi_tcl_MsgConversationHandle& oMsgConversationHandle);

   virtual tVoid vVisit_MsgConversationListSliceResultItem(most_fi_tcl_MsgConversationListSliceResultItem& oMsgConversationListSliceResultItem);

   virtual tVoid vVisit_e8_MsgMessageStatus(most_fi_tcl_e8_MsgMessageStatus& oe8_MsgMessageStatus);

   virtual tVoid vVisit_MsgConversationDetailListItem(most_fi_tcl_MsgConversationDetailListItem& oMsgConversationDetailListItem);

   virtual tVoid vVisit_MsgConversationListSliceResult(most_fi_tcl_MsgConversationListSliceResult& oMsgConversationListSliceResult);

   virtual tVoid vVisit_MsgConversationDetailList(most_fi_tcl_MsgConversationDetailList& oMsgConversationDetailList);

   virtual tVoid vVisit_OnOffListItem(most_fi_tcl_OnOffListItem& oOnOffListItem);

   virtual tVoid vVisit_OnOffList(most_fi_tcl_OnOffList& oOnOffList);

   virtual tVoid vVisit_AutoReplyTextListItem(most_fi_tcl_AutoReplyTextListItem& oAutoReplyTextListItem);

   virtual tVoid vVisit_AutoReplyTextList(most_fi_tcl_AutoReplyTextList& oAutoReplyTextList);

   virtual tVoid vVisit_MapDeviceCapabilitiesListItem(most_fi_tcl_MapDeviceCapabilitiesListItem& oMapDeviceCapabilitiesListItem);

   virtual tVoid vVisit_MapDeviceCapabilitiesList(most_fi_tcl_MapDeviceCapabilitiesList& oMapDeviceCapabilitiesList);

   virtual tVoid vVisit_e8_PhonBkPhoneBookSortType(most_fi_tcl_e8_PhonBkPhoneBookSortType& oe8_PhonBkPhoneBookSortType);

   virtual tVoid vVisit_PhonBkSearchKeyboardListItem(most_fi_tcl_PhonBkSearchKeyboardListItem& oPhonBkSearchKeyboardListItem);

   virtual tVoid vVisit_PhonBkSearchKeyboardList(most_fi_tcl_PhonBkSearchKeyboardList& oPhonBkSearchKeyboardList);

   virtual tVoid vVisit_e8_PhonBkContactDetailFilter(most_fi_tcl_e8_PhonBkContactDetailFilter& oe8_PhonBkContactDetailFilter);

   virtual tVoid vVisit_PhonBkHomeAddressLatLong(most_fi_tcl_PhonBkHomeAddressLatLong& oPhonBkHomeAddressLatLong);

   virtual tVoid vVisit_PhonBkWorkAddressLatLong(most_fi_tcl_PhonBkWorkAddressLatLong& oPhonBkWorkAddressLatLong);

   virtual tVoid vVisit_PhonBkOtherAddressLatLong(most_fi_tcl_PhonBkOtherAddressLatLong& oPhonBkOtherAddressLatLong);

   virtual tVoid vVisit_PhonBkContactDetails(most_fi_tcl_PhonBkContactDetails& oPhonBkContactDetails);

   virtual tVoid vVisit_PhonBkContactPhoto(most_fi_tcl_PhonBkContactPhoto& oPhonBkContactPhoto);

   virtual tVoid vVisit_e8_PhonBkListChangeType(most_fi_tcl_e8_PhonBkListChangeType& oe8_PhonBkListChangeType);

   virtual tVoid vVisit_e8_PhonBkListType(most_fi_tcl_e8_PhonBkListType& oe8_PhonBkListType);

   virtual tVoid vVisit_PhonBkChangeItems(most_fi_tcl_PhonBkChangeItems& oPhonBkChangeItems);

   virtual tVoid vVisit_e8_PhonBkContactAddStatus(most_fi_tcl_e8_PhonBkContactAddStatus& oe8_PhonBkContactAddStatus);

   virtual tVoid vVisit_e8_PhonBkContactDeleteStatus(most_fi_tcl_e8_PhonBkContactDeleteStatus& oe8_PhonBkContactDeleteStatus);

   virtual tVoid vVisit_e8_PhonBkContactEditStatus(most_fi_tcl_e8_PhonBkContactEditStatus& oe8_PhonBkContactEditStatus);

   virtual tVoid vVisit_e8_PhonBkCallHistorySortType(most_fi_tcl_e8_PhonBkCallHistorySortType& oe8_PhonBkCallHistorySortType);

   virtual tVoid vVisit_e8_PhonBkCallHistoryType(most_fi_tcl_e8_PhonBkCallHistoryType& oe8_PhonBkCallHistoryType);

   virtual tVoid vVisit_e8_PhonBkCallPhoneType(most_fi_tcl_e8_PhonBkCallPhoneType& oe8_PhonBkCallPhoneType);

   virtual tVoid vVisit_PhonBkCallDate(most_fi_tcl_PhonBkCallDate& oPhonBkCallDate);

   virtual tVoid vVisit_PhonBkCallTime(most_fi_tcl_PhonBkCallTime& oPhonBkCallTime);

   virtual tVoid vVisit_PhonBkCallDateTime(most_fi_tcl_PhonBkCallDateTime& oPhonBkCallDateTime);

   virtual tVoid vVisit_PhonBkCallHistoryListSliceResultItem(most_fi_tcl_PhonBkCallHistoryListSliceResultItem& oPhonBkCallHistoryListSliceResultItem);

   virtual tVoid vVisit_PhonBkCallHistoryListSliceResult(most_fi_tcl_PhonBkCallHistoryListSliceResult& oPhonBkCallHistoryListSliceResult);

   virtual tVoid vVisit_e8_PhonBkContactDetailType(most_fi_tcl_e8_PhonBkContactDetailType& oe8_PhonBkContactDetailType);

   virtual tVoid vVisit_PhonBkCallHistoryTypeSupport(most_fi_tcl_PhonBkCallHistoryTypeSupport& oPhonBkCallHistoryTypeSupport);

   virtual tVoid vVisit_PhonBkAutocompleteMultipleMatchListItem(most_fi_tcl_PhonBkAutocompleteMultipleMatchListItem& oPhonBkAutocompleteMultipleMatchListItem);

   virtual tVoid vVisit_PhonBkAutocompleteMultipleMatchList(most_fi_tcl_PhonBkAutocompleteMultipleMatchList& oPhonBkAutocompleteMultipleMatchList);

   virtual tVoid vVisit_PhonBkPhoneBookListSliceResultItem(most_fi_tcl_PhonBkPhoneBookListSliceResultItem& oPhonBkPhoneBookListSliceResultItem);

   virtual tVoid vVisit_PhonBkPhoneBookListSliceResult(most_fi_tcl_PhonBkPhoneBookListSliceResult& oPhonBkPhoneBookListSliceResult);

   virtual tVoid vVisit_e8_PhonBkPreferredPhoneBookSortOrder(most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder& oe8_PhonBkPreferredPhoneBookSortOrder);

   virtual tVoid vVisit_e8_PhonBkRecentCallListDownloadState(most_fi_tcl_e8_PhonBkRecentCallListDownloadState& oe8_PhonBkRecentCallListDownloadState);

   virtual tVoid vVisit_e8_PhonBkPhoneBookDownloadState(most_fi_tcl_e8_PhonBkPhoneBookDownloadState& oe8_PhonBkPhoneBookDownloadState);

   virtual tVoid vVisit_PhonBkDownloadStateStreamItem(most_fi_tcl_PhonBkDownloadStateStreamItem& oPhonBkDownloadStateStreamItem);

   virtual tVoid vVisit_PhonBkDownloadStateStream(most_fi_tcl_PhonBkDownloadStateStream& oPhonBkDownloadStateStream);

   virtual tVoid vVisit_e8_PhonBkNumberType(most_fi_tcl_e8_PhonBkNumberType& oe8_PhonBkNumberType);

   virtual tVoid vVisit_PhonBkCallHistoryListSliceResultExtenedItem(most_fi_tcl_PhonBkCallHistoryListSliceResultExtenedItem& oPhonBkCallHistoryListSliceResultExtenedItem);

   virtual tVoid vVisit_PhonBkPhoneNumberItem(most_fi_tcl_PhonBkPhoneNumberItem& oPhonBkPhoneNumberItem);

   virtual tVoid vVisit_e8_PhonBkContactType(most_fi_tcl_e8_PhonBkContactType& oe8_PhonBkContactType);

   virtual tVoid vVisit_PhonBkPhoneBookListSliceResultExtendedItem(most_fi_tcl_PhonBkPhoneBookListSliceResultExtendedItem& oPhonBkPhoneBookListSliceResultExtendedItem);

   virtual tVoid vVisit_PhonBkPhoneBookListSliceResultExtended(most_fi_tcl_PhonBkPhoneBookListSliceResultExtended& oPhonBkPhoneBookListSliceResultExtended);

   virtual tVoid vVisit_PhonBkCallHistoryListSliceResultExtened(most_fi_tcl_PhonBkCallHistoryListSliceResultExtened& oPhonBkCallHistoryListSliceResultExtened);

   virtual tVoid vVisit_e8_PhonBkRecentCallListDownloadStateExtended(most_fi_tcl_e8_PhonBkRecentCallListDownloadStateExtended& oe8_PhonBkRecentCallListDownloadStateExtended);

   virtual tVoid vVisit_e8_PhonBkPhoneBookDownloadStateExtended(most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended& oe8_PhonBkPhoneBookDownloadStateExtended);

   virtual tVoid vVisit_PhonBkDownloadStateExtendedStreamItem(most_fi_tcl_PhonBkDownloadStateExtendedStreamItem& oPhonBkDownloadStateExtendedStreamItem);

   virtual tVoid vVisit_PhonBkDownloadStateExtendedStream(most_fi_tcl_PhonBkDownloadStateExtendedStream& oPhonBkDownloadStateExtendedStream);

   virtual tVoid vVisit_PhonBkDeviceHandleList(most_fi_tcl_PhonBkDeviceHandleList& oPhonBkDeviceHandleList);

   virtual tVoid vVisit_e8_PhonBkSearchSortType(most_fi_tcl_e8_PhonBkSearchSortType& oe8_PhonBkSearchSortType);

   virtual tVoid vVisit_PhonBkContactMatchListItem(most_fi_tcl_PhonBkContactMatchListItem& oPhonBkContactMatchListItem);

   virtual tVoid vVisit_PhonBkContactMatchList(most_fi_tcl_PhonBkContactMatchList& oPhonBkContactMatchList);

   virtual tVoid vVisit_e8_PhonBkSwitchDownloadOnOffState(most_fi_tcl_e8_PhonBkSwitchDownloadOnOffState& oe8_PhonBkSwitchDownloadOnOffState);

   virtual tVoid vVisit_PhonBkDownloadOnOffStateListItem(most_fi_tcl_PhonBkDownloadOnOffStateListItem& oPhonBkDownloadOnOffStateListItem);

   virtual tVoid vVisit_PhonBkDownloadOnOffStateList(most_fi_tcl_PhonBkDownloadOnOffStateList& oPhonBkDownloadOnOffStateList);

   virtual tVoid vVisit_e8_PhonBkContactSortType(most_fi_tcl_e8_PhonBkContactSortType& oe8_PhonBkContactSortType);

   virtual tVoid vVisit_e8_PhonBkContactListType(most_fi_tcl_e8_PhonBkContactListType& oe8_PhonBkContactListType);

   virtual tVoid vVisit_PhonBkContactDetailsExtended(most_fi_tcl_PhonBkContactDetailsExtended& oPhonBkContactDetailsExtended);

   virtual tVoid vVisit_AutomaticContactDownloadListItem(most_fi_tcl_AutomaticContactDownloadListItem& oAutomaticContactDownloadListItem);

   virtual tVoid vVisit_AutomaticContactDownloadList(most_fi_tcl_AutomaticContactDownloadList& oAutomaticContactDownloadList);

   virtual tVoid vVisit_DevicePhoneBookFeatureSupportListItem(most_fi_tcl_DevicePhoneBookFeatureSupportListItem& oDevicePhoneBookFeatureSupportListItem);

   virtual tVoid vVisit_DevicePhoneBookFeatureSupportList(most_fi_tcl_DevicePhoneBookFeatureSupportList& oDevicePhoneBookFeatureSupportList);

   virtual tVoid vVisit_PhonBkDownloadProgressListItem(most_fi_tcl_PhonBkDownloadProgressListItem& oPhonBkDownloadProgressListItem);

   virtual tVoid vVisit_PhonBkDownloadProgressList(most_fi_tcl_PhonBkDownloadProgressList& oPhonBkDownloadProgressList);

   virtual tVoid vVisit_PhonBkMissedCallIndicatorListItem(most_fi_tcl_PhonBkMissedCallIndicatorListItem& oPhonBkMissedCallIndicatorListItem);

   virtual tVoid vVisit_PhonBkMissedCallIndicatorList(most_fi_tcl_PhonBkMissedCallIndicatorList& oPhonBkMissedCallIndicatorList);

   virtual tVoid vVisit_PhonBkPreferredSortOrderListItem(most_fi_tcl_PhonBkPreferredSortOrderListItem& oPhonBkPreferredSortOrderListItem);

   virtual tVoid vVisit_PhonBkPreferredSortOrderList(most_fi_tcl_PhonBkPreferredSortOrderList& oPhonBkPreferredSortOrderList);

   virtual tVoid vVisit_e8_PbkLanguage(most_fi_tcl_e8_PbkLanguage& oe8_PbkLanguage);

   virtual tVoid vVisit_e8_FavPrvAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel& oe8_FavPrvAudioChannel);

   virtual tVoid vVisit_e8_FavPrvVideoChannel(most_fi_tcl_e8_FavPrvVideoChannel& oe8_FavPrvVideoChannel);

   virtual tVoid vVisit_e8_FavPrvFavoriteType(most_fi_tcl_e8_FavPrvFavoriteType& oe8_FavPrvFavoriteType);

   virtual tVoid vVisit_FavPrvFavoriteInfoItem(most_fi_tcl_FavPrvFavoriteInfoItem& oFavPrvFavoriteInfoItem);

   virtual tVoid vVisit_FavPrvFavoriteInfo(most_fi_tcl_FavPrvFavoriteInfo& oFavPrvFavoriteInfo);

   virtual tVoid vVisit_e8_FavPrvListChangeType(most_fi_tcl_e8_FavPrvListChangeType& oe8_FavPrvListChangeType);

   virtual tVoid vVisit_FavPrvChangedFavorites(most_fi_tcl_FavPrvChangedFavorites& oFavPrvChangedFavorites);

   virtual tVoid vVisit_e8_SrcAudioChannelName(most_fi_tcl_e8_SrcAudioChannelName& oe8_SrcAudioChannelName);

   virtual tVoid vVisit_e8_SrcContentProtection(most_fi_tcl_e8_SrcContentProtection& oe8_SrcContentProtection);

   virtual tVoid vVisit_e8_SrcContentType(most_fi_tcl_e8_SrcContentType& oe8_SrcContentType);

   virtual tVoid vVisit_e8_SrcTransmissionClass(most_fi_tcl_e8_SrcTransmissionClass& oe8_SrcTransmissionClass);

   virtual tVoid vVisit_SrcAudioChannels_Resolution(most_fi_tcl_SrcAudioChannels_Resolution& oSrcAudioChannels_Resolution);

   virtual tVoid vVisit_SrcAudioChannelListItem(most_fi_tcl_SrcAudioChannelListItem& oSrcAudioChannelListItem);

   virtual tVoid vVisit_SrcAudioChannelList(most_fi_tcl_SrcAudioChannelList& oSrcAudioChannelList);

   virtual tVoid vVisit_SrcAudioChannels_AudioChannelList(most_fi_tcl_SrcAudioChannels_AudioChannelList& oSrcAudioChannels_AudioChannelList);

   virtual tVoid vVisit_SrcContentDescription(most_fi_tcl_SrcContentDescription& oSrcContentDescription);

   virtual tVoid vVisit_e8_SrcActivity(most_fi_tcl_e8_SrcActivity& oe8_SrcActivity);

   virtual tVoid vVisit_e8_TelCallStatus(most_fi_tcl_e8_TelCallStatus& oe8_TelCallStatus);

   virtual tVoid vVisit_e8_TelHandsetState(most_fi_tcl_e8_TelHandsetState& oe8_TelHandsetState);

   virtual tVoid vVisit_TelActiveCallinHandsetStreamItem(most_fi_tcl_TelActiveCallinHandsetStreamItem& oTelActiveCallinHandsetStreamItem);

   virtual tVoid vVisit_TelActiveCallinHandsetStream(most_fi_tcl_TelActiveCallinHandsetStream& oTelActiveCallinHandsetStream);

   virtual tVoid vVisit_TelCallStatusNoticeStreamItem(most_fi_tcl_TelCallStatusNoticeStreamItem& oTelCallStatusNoticeStreamItem);

   virtual tVoid vVisit_TelCallStatusNoticeStream(most_fi_tcl_TelCallStatusNoticeStream& oTelCallStatusNoticeStream);

   virtual tVoid vVisit_e8_TelCellService(most_fi_tcl_e8_TelCellService& oe8_TelCellService);

   virtual tVoid vVisit_TelStreamOfCallInstances(most_fi_tcl_TelStreamOfCallInstances& oTelStreamOfCallInstances);

   virtual tVoid vVisit_e8_TelIncomingCallEventEnum(most_fi_tcl_e8_TelIncomingCallEventEnum& oe8_TelIncomingCallEventEnum);

   virtual tVoid vVisit_e8_TelEchoCancellationNoiseReductionSetting(most_fi_tcl_e8_TelEchoCancellationNoiseReductionSetting& oe8_TelEchoCancellationNoiseReductionSetting);

   virtual tVoid vVisit_TelHFEnhancedCallControlStreamItem(most_fi_tcl_TelHFEnhancedCallControlStreamItem& oTelHFEnhancedCallControlStreamItem);

   virtual tVoid vVisit_TelHFEnhancedCallControlStream(most_fi_tcl_TelHFEnhancedCallControlStream& oTelHFEnhancedCallControlStream);

   virtual tVoid vVisit_e8_TelInbandRingingSupport(most_fi_tcl_e8_TelInbandRingingSupport& oe8_TelInbandRingingSupport);

   virtual tVoid vVisit_TelDeviceRingtoneListResultItem(most_fi_tcl_TelDeviceRingtoneListResultItem& oTelDeviceRingtoneListResultItem);

   virtual tVoid vVisit_TelDeviceRingtoneListResult(most_fi_tcl_TelDeviceRingtoneListResult& oTelDeviceRingtoneListResult);

   virtual tVoid vVisit_TelSystemWideRingtonesListResultItem(most_fi_tcl_TelSystemWideRingtonesListResultItem& oTelSystemWideRingtonesListResultItem);

   virtual tVoid vVisit_TelSystemWideRingtonesListResult(most_fi_tcl_TelSystemWideRingtonesListResult& oTelSystemWideRingtonesListResult);

   virtual tVoid vVisit_TelSuppressRingtoneOnOffListResultItem(most_fi_tcl_TelSuppressRingtoneOnOffListResultItem& oTelSuppressRingtoneOnOffListResultItem);

   virtual tVoid vVisit_TelSuppressRingtoneOnOffListResult(most_fi_tcl_TelSuppressRingtoneOnOffListResult& oTelSuppressRingtoneOnOffListResult);

   virtual tVoid vVisit_TelAutoWaitingModeOnOffListResultItem(most_fi_tcl_TelAutoWaitingModeOnOffListResultItem& oTelAutoWaitingModeOnOffListResultItem);

   virtual tVoid vVisit_TelAutoWaitingModeOnOffListResult(most_fi_tcl_TelAutoWaitingModeOnOffListResult& oTelAutoWaitingModeOnOffListResult);

   virtual tVoid vVisit_e8_TelWaitingModeAction(most_fi_tcl_e8_TelWaitingModeAction& oe8_TelWaitingModeAction);

   virtual tVoid vVisit_e8_TelWaitingModeStatus(most_fi_tcl_e8_TelWaitingModeStatus& oe8_TelWaitingModeStatus);

   virtual tVoid vVisit_e8_TelSiriAvailabilityState(most_fi_tcl_e8_TelSiriAvailabilityState& oe8_TelSiriAvailabilityState);

   virtual tVoid vVisit_TelCallStatusNoticeExtendedStreamItem(most_fi_tcl_TelCallStatusNoticeExtendedStreamItem& oTelCallStatusNoticeExtendedStreamItem);

   virtual tVoid vVisit_TelCallStatusNoticeExtendedStream(most_fi_tcl_TelCallStatusNoticeExtendedStream& oTelCallStatusNoticeExtendedStream);

   virtual tVoid vVisit_TelOutgoingCall_Failed(most_fi_tcl_TelOutgoingCall_Failed& oTelOutgoingCall_Failed);

   virtual tVoid vVisit_TelIncomingCall_Rejected(most_fi_tcl_TelIncomingCall_Rejected& oTelIncomingCall_Rejected);

   virtual tVoid vVisit_e8_WaitingModeState(most_fi_tcl_e8_WaitingModeState& oe8_WaitingModeState);

   virtual tVoid vVisit_e8_ExternalVRState(most_fi_tcl_e8_ExternalVRState& oe8_ExternalVRState);

   virtual tVoid vVisit_e8_VRErrorCode(most_fi_tcl_e8_VRErrorCode& oe8_VRErrorCode);

   virtual tVoid vVisit_ListOfCallInstanceStreamItem(most_fi_tcl_ListOfCallInstanceStreamItem& oListOfCallInstanceStreamItem);

   virtual tVoid vVisit_ListOfCallInstanceStream(most_fi_tcl_ListOfCallInstanceStream& oListOfCallInstanceStream);

   virtual tVoid vVisit_e8_AudioTransferDirection(most_fi_tcl_e8_AudioTransferDirection& oe8_AudioTransferDirection);

   virtual tVoid vVisit_e8_TelPlaybackState(most_fi_tcl_e8_TelPlaybackState& oe8_TelPlaybackState);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
