/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO
#include "conn_most_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MOST_Tel_FI message types

fi_tclMessageBase* most_telfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case most_telfi_tclToken::EN_MSG_AllocateMethodStart:
         return OSAL_NEW most_telfi_tclMsgAllocateMethodStart;

      case most_telfi_tclToken::EN_MSG_AllocateMethodResult:
         return OSAL_NEW most_telfi_tclMsgAllocateMethodResult;

      case most_telfi_tclToken::EN_MSG_DeAllocateMethodStart:
         return OSAL_NEW most_telfi_tclMsgDeAllocateMethodStart;

      case most_telfi_tclToken::EN_MSG_DeAllocateMethodResult:
         return OSAL_NEW most_telfi_tclMsgDeAllocateMethodResult;

      case most_telfi_tclToken::EN_MSG_SourceActivityMethodStart:
         return OSAL_NEW most_telfi_tclMsgSourceActivityMethodStart;

      case most_telfi_tclToken::EN_MSG_SourceActivityMethodResult:
         return OSAL_NEW most_telfi_tclMsgSourceActivityMethodResult;

      case most_telfi_tclToken::EN_MSG_AcceptCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgAcceptCallMethodStart;

      case most_telfi_tclToken::EN_MSG_AcceptCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgAcceptCallMethodResult;

      case most_telfi_tclToken::EN_MSG_CancelOutgoingCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgCancelOutgoingCallMethodStart;

      case most_telfi_tclToken::EN_MSG_CancelOutgoingCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgCancelOutgoingCallMethodResult;

      case most_telfi_tclToken::EN_MSG_ConferenceInMethodStart:
         return OSAL_NEW most_telfi_tclMsgConferenceInMethodStart;

      case most_telfi_tclToken::EN_MSG_ConferenceInMethodResult:
         return OSAL_NEW most_telfi_tclMsgConferenceInMethodResult;

      case most_telfi_tclToken::EN_MSG_HangUpCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgHangUpCallMethodStart;

      case most_telfi_tclToken::EN_MSG_HangUpCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgHangUpCallMethodResult;

      case most_telfi_tclToken::EN_MSG_HoldCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgHoldCallMethodStart;

      case most_telfi_tclToken::EN_MSG_HoldCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgHoldCallMethodResult;

      case most_telfi_tclToken::EN_MSG_IgnoreCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgIgnoreCallMethodStart;

      case most_telfi_tclToken::EN_MSG_IgnoreCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgIgnoreCallMethodResult;

      case most_telfi_tclToken::EN_MSG_RejectCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgRejectCallMethodStart;

      case most_telfi_tclToken::EN_MSG_RejectCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgRejectCallMethodResult;

      case most_telfi_tclToken::EN_MSG_ResumeCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgResumeCallMethodStart;

      case most_telfi_tclToken::EN_MSG_ResumeCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgResumeCallMethodResult;

      case most_telfi_tclToken::EN_MSG_SendDTMFMethodStart:
         return OSAL_NEW most_telfi_tclMsgSendDTMFMethodStart;

      case most_telfi_tclToken::EN_MSG_SendDTMFMethodResult:
         return OSAL_NEW most_telfi_tclMsgSendDTMFMethodResult;

      case most_telfi_tclToken::EN_MSG_SpeedDialMethodStart:
         return OSAL_NEW most_telfi_tclMsgSpeedDialMethodStart;

      case most_telfi_tclToken::EN_MSG_SpeedDialMethodResult:
         return OSAL_NEW most_telfi_tclMsgSpeedDialMethodResult;

      case most_telfi_tclToken::EN_MSG_SplitCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgSplitCallMethodStart;

      case most_telfi_tclToken::EN_MSG_SplitCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgSplitCallMethodResult;

      case most_telfi_tclToken::EN_MSG_SwapCallMethodStart:
         return OSAL_NEW most_telfi_tclMsgSwapCallMethodStart;

      case most_telfi_tclToken::EN_MSG_SwapCallMethodResult:
         return OSAL_NEW most_telfi_tclMsgSwapCallMethodResult;

      case most_telfi_tclToken::EN_MSG_TransferCallToHandsetMethodStart:
         return OSAL_NEW most_telfi_tclMsgTransferCallToHandsetMethodStart;

      case most_telfi_tclToken::EN_MSG_TransferCallToHandsetMethodResult:
         return OSAL_NEW most_telfi_tclMsgTransferCallToHandsetMethodResult;

      case most_telfi_tclToken::EN_MSG_TransferCallToVehicleMethodStart:
         return OSAL_NEW most_telfi_tclMsgTransferCallToVehicleMethodStart;

      case most_telfi_tclToken::EN_MSG_TransferCallToVehicleMethodResult:
         return OSAL_NEW most_telfi_tclMsgTransferCallToVehicleMethodResult;

      case most_telfi_tclToken::EN_MSG_VoiceMailMethodStart:
         return OSAL_NEW most_telfi_tclMsgVoiceMailMethodStart;

      case most_telfi_tclToken::EN_MSG_VoiceMailMethodResult:
         return OSAL_NEW most_telfi_tclMsgVoiceMailMethodResult;

      case most_telfi_tclToken::EN_MSG_DialMethodStart:
         return OSAL_NEW most_telfi_tclMsgDialMethodStart;

      case most_telfi_tclToken::EN_MSG_DialMethodResult:
         return OSAL_NEW most_telfi_tclMsgDialMethodResult;

      case most_telfi_tclToken::EN_MSG_QueryTelephoneNumberMethodStart:
         return OSAL_NEW most_telfi_tclMsgQueryTelephoneNumberMethodStart;

      case most_telfi_tclToken::EN_MSG_QueryTelephoneNumberMethodResult:
         return OSAL_NEW most_telfi_tclMsgQueryTelephoneNumberMethodResult;

      case most_telfi_tclToken::EN_MSG_AcquireTelephoneNumberMethodStart:
         return OSAL_NEW most_telfi_tclMsgAcquireTelephoneNumberMethodStart;

      case most_telfi_tclToken::EN_MSG_AcquireTelephoneNumberMethodResult:
         return OSAL_NEW most_telfi_tclMsgAcquireTelephoneNumberMethodResult;

      case most_telfi_tclToken::EN_MSG_RedialMethodStart:
         return OSAL_NEW most_telfi_tclMsgRedialMethodStart;

      case most_telfi_tclToken::EN_MSG_RedialMethodResult:
         return OSAL_NEW most_telfi_tclMsgRedialMethodResult;

      case most_telfi_tclToken::EN_MSG_SetRingtoneMethodStart:
         return OSAL_NEW most_telfi_tclMsgSetRingtoneMethodStart;

      case most_telfi_tclToken::EN_MSG_SetRingtoneMethodResult:
         return OSAL_NEW most_telfi_tclMsgSetRingtoneMethodResult;

      case most_telfi_tclToken::EN_MSG_PlayRingtoneMethodStart:
         return OSAL_NEW most_telfi_tclMsgPlayRingtoneMethodStart;

      case most_telfi_tclToken::EN_MSG_PlayRingtoneMethodResult:
         return OSAL_NEW most_telfi_tclMsgPlayRingtoneMethodResult;

      case most_telfi_tclToken::EN_MSG_StopRingtoneMethodStart:
         return OSAL_NEW most_telfi_tclMsgStopRingtoneMethodStart;

      case most_telfi_tclToken::EN_MSG_StopRingtoneMethodResult:
         return OSAL_NEW most_telfi_tclMsgStopRingtoneMethodResult;

      case most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffMethodStart:
         return OSAL_NEW most_telfi_tclMsgSuppressRingtoneOnOffMethodStart;

      case most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffMethodResult:
         return OSAL_NEW most_telfi_tclMsgSuppressRingtoneOnOffMethodResult;

      case most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffMethodStart:
         return OSAL_NEW most_telfi_tclMsgAutoWaitingModeOnOffMethodStart;

      case most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffMethodResult:
         return OSAL_NEW most_telfi_tclMsgAutoWaitingModeOnOffMethodResult;

      case most_telfi_tclToken::EN_MSG_StartStopWaitingModeMethodStart:
         return OSAL_NEW most_telfi_tclMsgStartStopWaitingModeMethodStart;

      case most_telfi_tclToken::EN_MSG_StartStopWaitingModeMethodResult:
         return OSAL_NEW most_telfi_tclMsgStartStopWaitingModeMethodResult;

      case most_telfi_tclToken::EN_MSG_DialExtendedMethodStart:
         return OSAL_NEW most_telfi_tclMsgDialExtendedMethodStart;

      case most_telfi_tclToken::EN_MSG_DialExtendedMethodResult:
         return OSAL_NEW most_telfi_tclMsgDialExtendedMethodResult;

      case most_telfi_tclToken::EN_MSG_SetActivePhoneMethodStart:
         return OSAL_NEW most_telfi_tclMsgSetActivePhoneMethodStart;

      case most_telfi_tclToken::EN_MSG_SetActivePhoneMethodResult:
         return OSAL_NEW most_telfi_tclMsgSetActivePhoneMethodResult;

      case most_telfi_tclToken::EN_MSG_ActivateExternalVRMethodStart:
         return OSAL_NEW most_telfi_tclMsgActivateExternalVRMethodStart;

      case most_telfi_tclToken::EN_MSG_ActivateExternalVRMethodResult:
         return OSAL_NEW most_telfi_tclMsgActivateExternalVRMethodResult;

      case most_telfi_tclToken::EN_MSG_DeActivateExternalVRMethodStart:
         return OSAL_NEW most_telfi_tclMsgDeActivateExternalVRMethodStart;

      case most_telfi_tclToken::EN_MSG_DeActivateExternalVRMethodResult:
         return OSAL_NEW most_telfi_tclMsgDeActivateExternalVRMethodResult;

      case most_telfi_tclToken::EN_MSG_SourceInfoGet:
         return OSAL_NEW most_telfi_tclMsgSourceInfoGet;

      case most_telfi_tclToken::EN_MSG_SourceInfoStatus:
         return OSAL_NEW most_telfi_tclMsgSourceInfoStatus;

      case most_telfi_tclToken::EN_MSG_SourceAvailableUpReg:
         return OSAL_NEW most_telfi_tclMsgSourceAvailableUpReg;

      case most_telfi_tclToken::EN_MSG_SourceAvailableRelUpReg:
         return OSAL_NEW most_telfi_tclMsgSourceAvailableRelUpReg;

      case most_telfi_tclToken::EN_MSG_SourceAvailableGet:
         return OSAL_NEW most_telfi_tclMsgSourceAvailableGet;

      case most_telfi_tclToken::EN_MSG_SourceAvailableStatus:
         return OSAL_NEW most_telfi_tclMsgSourceAvailableStatus;

      case most_telfi_tclToken::EN_MSG_ActiveCallinHandsetUpReg:
         return OSAL_NEW most_telfi_tclMsgActiveCallinHandsetUpReg;

      case most_telfi_tclToken::EN_MSG_ActiveCallinHandsetRelUpReg:
         return OSAL_NEW most_telfi_tclMsgActiveCallinHandsetRelUpReg;

      case most_telfi_tclToken::EN_MSG_ActiveCallinHandsetGet:
         return OSAL_NEW most_telfi_tclMsgActiveCallinHandsetGet;

      case most_telfi_tclToken::EN_MSG_ActiveCallinHandsetStatus:
         return OSAL_NEW most_telfi_tclMsgActiveCallinHandsetStatus;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeUpReg:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeUpReg;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeRelUpReg;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeGet:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeGet;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeStatus:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeStatus;

      case most_telfi_tclToken::EN_MSG_CellDeviceNameUpReg:
         return OSAL_NEW most_telfi_tclMsgCellDeviceNameUpReg;

      case most_telfi_tclToken::EN_MSG_CellDeviceNameRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCellDeviceNameRelUpReg;

      case most_telfi_tclToken::EN_MSG_CellDeviceNameGet:
         return OSAL_NEW most_telfi_tclMsgCellDeviceNameGet;

      case most_telfi_tclToken::EN_MSG_CellDeviceNameStatus:
         return OSAL_NEW most_telfi_tclMsgCellDeviceNameStatus;

      case most_telfi_tclToken::EN_MSG_CellNetworkStatusUpReg:
         return OSAL_NEW most_telfi_tclMsgCellNetworkStatusUpReg;

      case most_telfi_tclToken::EN_MSG_CellNetworkStatusRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCellNetworkStatusRelUpReg;

      case most_telfi_tclToken::EN_MSG_CellNetworkStatusGet:
         return OSAL_NEW most_telfi_tclMsgCellNetworkStatusGet;

      case most_telfi_tclToken::EN_MSG_CellNetworkStatusStatus:
         return OSAL_NEW most_telfi_tclMsgCellNetworkStatusStatus;

      case most_telfi_tclToken::EN_MSG_CellSignalStrengthUpReg:
         return OSAL_NEW most_telfi_tclMsgCellSignalStrengthUpReg;

      case most_telfi_tclToken::EN_MSG_CellSignalStrengthRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCellSignalStrengthRelUpReg;

      case most_telfi_tclToken::EN_MSG_CellSignalStrengthGet:
         return OSAL_NEW most_telfi_tclMsgCellSignalStrengthGet;

      case most_telfi_tclToken::EN_MSG_CellSignalStrengthStatus:
         return OSAL_NEW most_telfi_tclMsgCellSignalStrengthStatus;

      case most_telfi_tclToken::EN_MSG_CellStateofChargeUpReg:
         return OSAL_NEW most_telfi_tclMsgCellStateofChargeUpReg;

      case most_telfi_tclToken::EN_MSG_CellStateofChargeRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCellStateofChargeRelUpReg;

      case most_telfi_tclToken::EN_MSG_CellStateofChargeGet:
         return OSAL_NEW most_telfi_tclMsgCellStateofChargeGet;

      case most_telfi_tclToken::EN_MSG_CellStateofChargeStatus:
         return OSAL_NEW most_telfi_tclMsgCellStateofChargeStatus;

      case most_telfi_tclToken::EN_MSG_InComingCallEventUpReg:
         return OSAL_NEW most_telfi_tclMsgInComingCallEventUpReg;

      case most_telfi_tclToken::EN_MSG_InComingCallEventRelUpReg:
         return OSAL_NEW most_telfi_tclMsgInComingCallEventRelUpReg;

      case most_telfi_tclToken::EN_MSG_InComingCallEventGet:
         return OSAL_NEW most_telfi_tclMsgInComingCallEventGet;

      case most_telfi_tclToken::EN_MSG_InComingCallEventStatus:
         return OSAL_NEW most_telfi_tclMsgInComingCallEventStatus;

      case most_telfi_tclToken::EN_MSG_NetworkOperatorUpReg:
         return OSAL_NEW most_telfi_tclMsgNetworkOperatorUpReg;

      case most_telfi_tclToken::EN_MSG_NetworkOperatorRelUpReg:
         return OSAL_NEW most_telfi_tclMsgNetworkOperatorRelUpReg;

      case most_telfi_tclToken::EN_MSG_NetworkOperatorGet:
         return OSAL_NEW most_telfi_tclMsgNetworkOperatorGet;

      case most_telfi_tclToken::EN_MSG_NetworkOperatorStatus:
         return OSAL_NEW most_telfi_tclMsgNetworkOperatorStatus;

      case most_telfi_tclToken::EN_MSG_SLCStatusUpReg:
         return OSAL_NEW most_telfi_tclMsgSLCStatusUpReg;

      case most_telfi_tclToken::EN_MSG_SLCStatusRelUpReg:
         return OSAL_NEW most_telfi_tclMsgSLCStatusRelUpReg;

      case most_telfi_tclToken::EN_MSG_SLCStatusGet:
         return OSAL_NEW most_telfi_tclMsgSLCStatusGet;

      case most_telfi_tclToken::EN_MSG_SLCStatusStatus:
         return OSAL_NEW most_telfi_tclMsgSLCStatusStatus;

      case most_telfi_tclToken::EN_MSG_VehicleAudioUpReg:
         return OSAL_NEW most_telfi_tclMsgVehicleAudioUpReg;

      case most_telfi_tclToken::EN_MSG_VehicleAudioRelUpReg:
         return OSAL_NEW most_telfi_tclMsgVehicleAudioRelUpReg;

      case most_telfi_tclToken::EN_MSG_VehicleAudioGet:
         return OSAL_NEW most_telfi_tclMsgVehicleAudioGet;

      case most_telfi_tclToken::EN_MSG_VehicleAudioStatus:
         return OSAL_NEW most_telfi_tclMsgVehicleAudioStatus;

      case most_telfi_tclToken::EN_MSG_MicrophoneMuteStateUpReg:
         return OSAL_NEW most_telfi_tclMsgMicrophoneMuteStateUpReg;

      case most_telfi_tclToken::EN_MSG_MicrophoneMuteStateRelUpReg:
         return OSAL_NEW most_telfi_tclMsgMicrophoneMuteStateRelUpReg;

      case most_telfi_tclToken::EN_MSG_MicrophoneMuteStateGet:
         return OSAL_NEW most_telfi_tclMsgMicrophoneMuteStateGet;

      case most_telfi_tclToken::EN_MSG_MicrophoneMuteStatePureSet:
         return OSAL_NEW most_telfi_tclMsgMicrophoneMuteStatePureSet;

      case most_telfi_tclToken::EN_MSG_MicrophoneMuteStateStatus:
         return OSAL_NEW most_telfi_tclMsgMicrophoneMuteStateStatus;

      case most_telfi_tclToken::EN_MSG_RingtoneMuteStateUpReg:
         return OSAL_NEW most_telfi_tclMsgRingtoneMuteStateUpReg;

      case most_telfi_tclToken::EN_MSG_RingtoneMuteStateRelUpReg:
         return OSAL_NEW most_telfi_tclMsgRingtoneMuteStateRelUpReg;

      case most_telfi_tclToken::EN_MSG_RingtoneMuteStateGet:
         return OSAL_NEW most_telfi_tclMsgRingtoneMuteStateGet;

      case most_telfi_tclToken::EN_MSG_RingtoneMuteStatePureSet:
         return OSAL_NEW most_telfi_tclMsgRingtoneMuteStatePureSet;

      case most_telfi_tclToken::EN_MSG_RingtoneMuteStateStatus:
         return OSAL_NEW most_telfi_tclMsgRingtoneMuteStateStatus;

      case most_telfi_tclToken::EN_MSG_HFServiceUpReg:
         return OSAL_NEW most_telfi_tclMsgHFServiceUpReg;

      case most_telfi_tclToken::EN_MSG_HFServiceRelUpReg:
         return OSAL_NEW most_telfi_tclMsgHFServiceRelUpReg;

      case most_telfi_tclToken::EN_MSG_HFServiceGet:
         return OSAL_NEW most_telfi_tclMsgHFServiceGet;

      case most_telfi_tclToken::EN_MSG_HFServiceStatus:
         return OSAL_NEW most_telfi_tclMsgHFServiceStatus;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionUpReg:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionRelUpReg:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionGet:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionGet;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionPureSet:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionStatus:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionStatus;

      case most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlUpReg:
         return OSAL_NEW most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg;

      case most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlRelUpReg:
         return OSAL_NEW most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg;

      case most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlGet:
         return OSAL_NEW most_telfi_tclMsgHandsFreeEnhancedCallControlGet;

      case most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlStatus:
         return OSAL_NEW most_telfi_tclMsgHandsFreeEnhancedCallControlStatus;

      case most_telfi_tclToken::EN_MSG_SystemWideRingtonesListUpReg:
         return OSAL_NEW most_telfi_tclMsgSystemWideRingtonesListUpReg;

      case most_telfi_tclToken::EN_MSG_SystemWideRingtonesListRelUpReg:
         return OSAL_NEW most_telfi_tclMsgSystemWideRingtonesListRelUpReg;

      case most_telfi_tclToken::EN_MSG_SystemWideRingtonesListGet:
         return OSAL_NEW most_telfi_tclMsgSystemWideRingtonesListGet;

      case most_telfi_tclToken::EN_MSG_SystemWideRingtonesListStatus:
         return OSAL_NEW most_telfi_tclMsgSystemWideRingtonesListStatus;

      case most_telfi_tclToken::EN_MSG_DeviceRingtoneListUpReg:
         return OSAL_NEW most_telfi_tclMsgDeviceRingtoneListUpReg;

      case most_telfi_tclToken::EN_MSG_DeviceRingtoneListRelUpReg:
         return OSAL_NEW most_telfi_tclMsgDeviceRingtoneListRelUpReg;

      case most_telfi_tclToken::EN_MSG_DeviceRingtoneListGet:
         return OSAL_NEW most_telfi_tclMsgDeviceRingtoneListGet;

      case most_telfi_tclToken::EN_MSG_DeviceRingtoneListStatus:
         return OSAL_NEW most_telfi_tclMsgDeviceRingtoneListStatus;

      case most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListUpReg:
         return OSAL_NEW most_telfi_tclMsgSuppressRingtoneOnOffListUpReg;

      case most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListRelUpReg:
         return OSAL_NEW most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg;

      case most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListGet:
         return OSAL_NEW most_telfi_tclMsgSuppressRingtoneOnOffListGet;

      case most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListStatus:
         return OSAL_NEW most_telfi_tclMsgSuppressRingtoneOnOffListStatus;

      case most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListUpReg:
         return OSAL_NEW most_telfi_tclMsgAutoWaitingModeOnOffListUpReg;

      case most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListRelUpReg:
         return OSAL_NEW most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg;

      case most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListGet:
         return OSAL_NEW most_telfi_tclMsgAutoWaitingModeOnOffListGet;

      case most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListStatus:
         return OSAL_NEW most_telfi_tclMsgAutoWaitingModeOnOffListStatus;

      case most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusUpReg:
         return OSAL_NEW most_telfi_tclMsgRingtonePlaybackStatusUpReg;

      case most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusRelUpReg:
         return OSAL_NEW most_telfi_tclMsgRingtonePlaybackStatusRelUpReg;

      case most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusGet:
         return OSAL_NEW most_telfi_tclMsgRingtonePlaybackStatusGet;

      case most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusStatus:
         return OSAL_NEW most_telfi_tclMsgRingtonePlaybackStatusStatus;

      case most_telfi_tclToken::EN_MSG_WaitingModeFilePathUpReg:
         return OSAL_NEW most_telfi_tclMsgWaitingModeFilePathUpReg;

      case most_telfi_tclToken::EN_MSG_WaitingModeFilePathRelUpReg:
         return OSAL_NEW most_telfi_tclMsgWaitingModeFilePathRelUpReg;

      case most_telfi_tclToken::EN_MSG_WaitingModeFilePathGet:
         return OSAL_NEW most_telfi_tclMsgWaitingModeFilePathGet;

      case most_telfi_tclToken::EN_MSG_WaitingModeFilePathPureSet:
         return OSAL_NEW most_telfi_tclMsgWaitingModeFilePathPureSet;

      case most_telfi_tclToken::EN_MSG_WaitingModeFilePathStatus:
         return OSAL_NEW most_telfi_tclMsgWaitingModeFilePathStatus;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedUpReg:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedRelUpReg:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedGet:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedPureSet:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet;

      case most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedStatus:
         return OSAL_NEW most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedUpReg:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeExtendedUpReg;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedGet:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeExtendedGet;

      case most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedStatus:
         return OSAL_NEW most_telfi_tclMsgCallStatusNoticeExtendedStatus;

      case most_telfi_tclToken::EN_MSG_ActivePhoneDeviceUpReg:
         return OSAL_NEW most_telfi_tclMsgActivePhoneDeviceUpReg;

      case most_telfi_tclToken::EN_MSG_ActivePhoneDeviceRelUpReg:
         return OSAL_NEW most_telfi_tclMsgActivePhoneDeviceRelUpReg;

      case most_telfi_tclToken::EN_MSG_ActivePhoneDeviceGet:
         return OSAL_NEW most_telfi_tclMsgActivePhoneDeviceGet;

      case most_telfi_tclToken::EN_MSG_ActivePhoneDeviceStatus:
         return OSAL_NEW most_telfi_tclMsgActivePhoneDeviceStatus;

      case most_telfi_tclToken::EN_MSG_OutgoingCallFailedEventUpReg:
         return OSAL_NEW most_telfi_tclMsgOutgoingCallFailedEventUpReg;

      case most_telfi_tclToken::EN_MSG_OutgoingCallFailedEventRelUpReg:
         return OSAL_NEW most_telfi_tclMsgOutgoingCallFailedEventRelUpReg;

      case most_telfi_tclToken::EN_MSG_OutgoingCallFailedEventStatus:
         return OSAL_NEW most_telfi_tclMsgOutgoingCallFailedEventStatus;

      case most_telfi_tclToken::EN_MSG_IncomingCallRejectedEventUpReg:
         return OSAL_NEW most_telfi_tclMsgIncomingCallRejectedEventUpReg;

      case most_telfi_tclToken::EN_MSG_IncomingCallRejectedEventRelUpReg:
         return OSAL_NEW most_telfi_tclMsgIncomingCallRejectedEventRelUpReg;

      case most_telfi_tclToken::EN_MSG_IncomingCallRejectedEventStatus:
         return OSAL_NEW most_telfi_tclMsgIncomingCallRejectedEventStatus;

      case most_telfi_tclToken::EN_MSG_WaitingModeStateUpReg:
         return OSAL_NEW most_telfi_tclMsgWaitingModeStateUpReg;

      case most_telfi_tclToken::EN_MSG_WaitingModeStateRelUpReg:
         return OSAL_NEW most_telfi_tclMsgWaitingModeStateRelUpReg;

      case most_telfi_tclToken::EN_MSG_WaitingModeStateGet:
         return OSAL_NEW most_telfi_tclMsgWaitingModeStateGet;

      case most_telfi_tclToken::EN_MSG_WaitingModeStateStatus:
         return OSAL_NEW most_telfi_tclMsgWaitingModeStateStatus;

      case most_telfi_tclToken::EN_MSG_ExternalVRStateUpReg:
         return OSAL_NEW most_telfi_tclMsgExternalVRStateUpReg;

      case most_telfi_tclToken::EN_MSG_ExternalVRStateRelUpReg:
         return OSAL_NEW most_telfi_tclMsgExternalVRStateRelUpReg;

      case most_telfi_tclToken::EN_MSG_ExternalVRStateGet:
         return OSAL_NEW most_telfi_tclMsgExternalVRStateGet;

      case most_telfi_tclToken::EN_MSG_ExternalVRStateStatus:
         return OSAL_NEW most_telfi_tclMsgExternalVRStateStatus;

      case most_telfi_tclToken::EN_MSG_CallOperationFailedEventUpReg:
         return OSAL_NEW most_telfi_tclMsgCallOperationFailedEventUpReg;

      case most_telfi_tclToken::EN_MSG_CallOperationFailedEventRelUpReg:
         return OSAL_NEW most_telfi_tclMsgCallOperationFailedEventRelUpReg;

      case most_telfi_tclToken::EN_MSG_CallOperationFailedEventStatus:
         return OSAL_NEW most_telfi_tclMsgCallOperationFailedEventStatus;

      case most_telfi_tclToken::EN_MSG_SendDTMFFailedEventUpReg:
         return OSAL_NEW most_telfi_tclMsgSendDTMFFailedEventUpReg;

      case most_telfi_tclToken::EN_MSG_SendDTMFFailedEventRelUpReg:
         return OSAL_NEW most_telfi_tclMsgSendDTMFFailedEventRelUpReg;

      case most_telfi_tclToken::EN_MSG_SendDTMFFailedEventStatus:
         return OSAL_NEW most_telfi_tclMsgSendDTMFFailedEventStatus;

      case most_telfi_tclToken::EN_MSG_AudioTransferFailedEventUpReg:
         return OSAL_NEW most_telfi_tclMsgAudioTransferFailedEventUpReg;

      case most_telfi_tclToken::EN_MSG_AudioTransferFailedEventRelUpReg:
         return OSAL_NEW most_telfi_tclMsgAudioTransferFailedEventRelUpReg;

      case most_telfi_tclToken::EN_MSG_AudioTransferFailedEventStatus:
         return OSAL_NEW most_telfi_tclMsgAudioTransferFailedEventStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all most_telfifi messages

// common functions

tU16 most_telfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MOST_TELFI_C_U16_SERVICE_ID;
}

tU16 most_telfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 most_telfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& most_telfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& most_telfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 most_telfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& most_telfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& most_telfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

// base class for all most_telfi standard error messages

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDefaultError::most_telfi_tclMsgDefaultError(const most_telfi_tclMsgDefaultError& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   *this = coRef;
}
most_telfi_tclMsgDefaultError& most_telfi_tclMsgDefaultError::operator=(const most_telfi_tclMsgDefaultError& coRef)
{
   if (this != &coRef)
   {
      e8ErrorCode = coRef.e8ErrorCode;
      oErrorInfo = coRef.oErrorInfo;
   }

   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgDefaultError::vDestroy()
{
   oErrorInfo.vDestroy();
}

tU32 most_telfi_tclMsgDefaultError::u32GetSize(tU16 u16MajorVersion) const
{
   return 3 + oErrorInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& most_telfi_tclMsgDefaultError::oRead(fi_tclInContext& oIn)
{
   tU16 u16CCA_Error = CCA_C_U16_ERROR_UNSPECIFIED;
   (tVoid) (oIn >> u16CCA_Error);
   (tVoid) (oIn >> e8ErrorCode);
   (tVoid) (oIn >> oErrorInfo);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDefaultError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU16)CCA_C_U16_ERROR_UNSPECIFIED);
   (tVoid) (oOut << e8ErrorCode);
   (tVoid) (oOut << oErrorInfo);
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAllocateMethodStart::most_telfi_tclMsgAllocateMethodStart(const most_telfi_tclMsgAllocateMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_telfi_tclMsgAllocateMethodStart& most_telfi_tclMsgAllocateMethodStart::operator=(const most_telfi_tclMsgAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgAllocateMethodStart::most_telfi_tclMsgAllocateMethodStart()
:u8SourceNr(0)
 {}

tS32 most_telfi_tclMsgAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AllocateMethodStart;
}


most_telfi_tclMsgAllocateMethodStart::~most_telfi_tclMsgAllocateMethodStart()
{}

tU32 most_telfi_tclMsgAllocateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_telfi_tclMsgAllocateMethodStart::operator==(const most_telfi_tclMsgAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAllocateError::most_telfi_tclMsgAllocateError(const most_telfi_tclMsgAllocateError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgAllocateError& most_telfi_tclMsgAllocateError::operator=(const most_telfi_tclMsgAllocateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgAllocateError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AllocateError;
}


most_telfi_tclMsgAllocateError::~most_telfi_tclMsgAllocateError()
{}

tBool most_telfi_tclMsgAllocateError::operator==(const most_telfi_tclMsgAllocateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAllocateMethodResult::most_telfi_tclMsgAllocateMethodResult(const most_telfi_tclMsgAllocateMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
}
most_telfi_tclMsgAllocateMethodResult& most_telfi_tclMsgAllocateMethodResult::operator=(const most_telfi_tclMsgAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgAllocateMethodResult::most_telfi_tclMsgAllocateMethodResult()
:u8SourceNr(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
 {}

tS32 most_telfi_tclMsgAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AllocateMethodResult;
}


most_telfi_tclMsgAllocateMethodResult::~most_telfi_tclMsgAllocateMethodResult()
{}

tU32 most_telfi_tclMsgAllocateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_telfi_tclMsgAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   return oOut;
}

tBool most_telfi_tclMsgAllocateMethodResult::operator==(const most_telfi_tclMsgAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDeAllocateMethodStart::most_telfi_tclMsgDeAllocateMethodStart(const most_telfi_tclMsgDeAllocateMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_telfi_tclMsgDeAllocateMethodStart& most_telfi_tclMsgDeAllocateMethodStart::operator=(const most_telfi_tclMsgDeAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgDeAllocateMethodStart::most_telfi_tclMsgDeAllocateMethodStart()
:u8SourceNr(0)
 {}

tS32 most_telfi_tclMsgDeAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeAllocateMethodStart;
}


most_telfi_tclMsgDeAllocateMethodStart::~most_telfi_tclMsgDeAllocateMethodStart()
{}

tU32 most_telfi_tclMsgDeAllocateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgDeAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDeAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_telfi_tclMsgDeAllocateMethodStart::operator==(const most_telfi_tclMsgDeAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDeAllocateError::most_telfi_tclMsgDeAllocateError(const most_telfi_tclMsgDeAllocateError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgDeAllocateError& most_telfi_tclMsgDeAllocateError::operator=(const most_telfi_tclMsgDeAllocateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgDeAllocateError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeAllocateError;
}


most_telfi_tclMsgDeAllocateError::~most_telfi_tclMsgDeAllocateError()
{}

tBool most_telfi_tclMsgDeAllocateError::operator==(const most_telfi_tclMsgDeAllocateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDeAllocateMethodResult::most_telfi_tclMsgDeAllocateMethodResult(const most_telfi_tclMsgDeAllocateMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_telfi_tclMsgDeAllocateMethodResult& most_telfi_tclMsgDeAllocateMethodResult::operator=(const most_telfi_tclMsgDeAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgDeAllocateMethodResult::most_telfi_tclMsgDeAllocateMethodResult()
:u8SourceNr(0)
 {}

tS32 most_telfi_tclMsgDeAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeAllocateMethodResult;
}


most_telfi_tclMsgDeAllocateMethodResult::~most_telfi_tclMsgDeAllocateMethodResult()
{}

tU32 most_telfi_tclMsgDeAllocateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgDeAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDeAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_telfi_tclMsgDeAllocateMethodResult::operator==(const most_telfi_tclMsgDeAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceActivityMethodStart::most_telfi_tclMsgSourceActivityMethodStart(const most_telfi_tclMsgSourceActivityMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
}
most_telfi_tclMsgSourceActivityMethodStart& most_telfi_tclMsgSourceActivityMethodStart::operator=(const most_telfi_tclMsgSourceActivityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSourceActivityMethodStart::most_telfi_tclMsgSourceActivityMethodStart()
:u8SourceNr(0)
,e8Activity()
 {}

tS32 most_telfi_tclMsgSourceActivityMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceActivityMethodStart;
}


most_telfi_tclMsgSourceActivityMethodStart::~most_telfi_tclMsgSourceActivityMethodStart()
{}

tU32 most_telfi_tclMsgSourceActivityMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgSourceActivityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSourceActivityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool most_telfi_tclMsgSourceActivityMethodStart::operator==(const most_telfi_tclMsgSourceActivityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceActivityError::most_telfi_tclMsgSourceActivityError(const most_telfi_tclMsgSourceActivityError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSourceActivityError& most_telfi_tclMsgSourceActivityError::operator=(const most_telfi_tclMsgSourceActivityError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSourceActivityError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceActivityError;
}


most_telfi_tclMsgSourceActivityError::~most_telfi_tclMsgSourceActivityError()
{}

tBool most_telfi_tclMsgSourceActivityError::operator==(const most_telfi_tclMsgSourceActivityError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceActivityMethodResult::most_telfi_tclMsgSourceActivityMethodResult(const most_telfi_tclMsgSourceActivityMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
}
most_telfi_tclMsgSourceActivityMethodResult& most_telfi_tclMsgSourceActivityMethodResult::operator=(const most_telfi_tclMsgSourceActivityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSourceActivityMethodResult::most_telfi_tclMsgSourceActivityMethodResult()
:u8SourceNr(0)
,e8Activity()
 {}

tS32 most_telfi_tclMsgSourceActivityMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceActivityMethodResult;
}


most_telfi_tclMsgSourceActivityMethodResult::~most_telfi_tclMsgSourceActivityMethodResult()
{}

tU32 most_telfi_tclMsgSourceActivityMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgSourceActivityMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSourceActivityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool most_telfi_tclMsgSourceActivityMethodResult::operator==(const most_telfi_tclMsgSourceActivityMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAcceptCallMethodStart::most_telfi_tclMsgAcceptCallMethodStart(const most_telfi_tclMsgAcceptCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgAcceptCallMethodStart& most_telfi_tclMsgAcceptCallMethodStart::operator=(const most_telfi_tclMsgAcceptCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgAcceptCallMethodStart::most_telfi_tclMsgAcceptCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgAcceptCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AcceptCallMethodStart;
}


most_telfi_tclMsgAcceptCallMethodStart::~most_telfi_tclMsgAcceptCallMethodStart()
{}

tU32 most_telfi_tclMsgAcceptCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgAcceptCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAcceptCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgAcceptCallMethodStart::operator==(const most_telfi_tclMsgAcceptCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAcceptCallError::most_telfi_tclMsgAcceptCallError(const most_telfi_tclMsgAcceptCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgAcceptCallError& most_telfi_tclMsgAcceptCallError::operator=(const most_telfi_tclMsgAcceptCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgAcceptCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AcceptCallError;
}


most_telfi_tclMsgAcceptCallError::~most_telfi_tclMsgAcceptCallError()
{}

tBool most_telfi_tclMsgAcceptCallError::operator==(const most_telfi_tclMsgAcceptCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAcceptCallMethodResult::most_telfi_tclMsgAcceptCallMethodResult(const most_telfi_tclMsgAcceptCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgAcceptCallMethodResult& most_telfi_tclMsgAcceptCallMethodResult::operator=(const most_telfi_tclMsgAcceptCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgAcceptCallMethodResult::most_telfi_tclMsgAcceptCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgAcceptCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AcceptCallMethodResult;
}


most_telfi_tclMsgAcceptCallMethodResult::~most_telfi_tclMsgAcceptCallMethodResult()
{}

tU32 most_telfi_tclMsgAcceptCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgAcceptCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAcceptCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgAcceptCallMethodResult::operator==(const most_telfi_tclMsgAcceptCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCancelOutgoingCallMethodStart::most_telfi_tclMsgCancelOutgoingCallMethodStart(const most_telfi_tclMsgCancelOutgoingCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgCancelOutgoingCallMethodStart& most_telfi_tclMsgCancelOutgoingCallMethodStart::operator=(const most_telfi_tclMsgCancelOutgoingCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgCancelOutgoingCallMethodStart::most_telfi_tclMsgCancelOutgoingCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgCancelOutgoingCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CancelOutgoingCallMethodStart;
}


most_telfi_tclMsgCancelOutgoingCallMethodStart::~most_telfi_tclMsgCancelOutgoingCallMethodStart()
{}

tU32 most_telfi_tclMsgCancelOutgoingCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgCancelOutgoingCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCancelOutgoingCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgCancelOutgoingCallMethodStart::operator==(const most_telfi_tclMsgCancelOutgoingCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCancelOutgoingCallError::most_telfi_tclMsgCancelOutgoingCallError(const most_telfi_tclMsgCancelOutgoingCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCancelOutgoingCallError& most_telfi_tclMsgCancelOutgoingCallError::operator=(const most_telfi_tclMsgCancelOutgoingCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCancelOutgoingCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CancelOutgoingCallError;
}


most_telfi_tclMsgCancelOutgoingCallError::~most_telfi_tclMsgCancelOutgoingCallError()
{}

tBool most_telfi_tclMsgCancelOutgoingCallError::operator==(const most_telfi_tclMsgCancelOutgoingCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCancelOutgoingCallMethodResult::most_telfi_tclMsgCancelOutgoingCallMethodResult(const most_telfi_tclMsgCancelOutgoingCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgCancelOutgoingCallMethodResult& most_telfi_tclMsgCancelOutgoingCallMethodResult::operator=(const most_telfi_tclMsgCancelOutgoingCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgCancelOutgoingCallMethodResult::most_telfi_tclMsgCancelOutgoingCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgCancelOutgoingCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CancelOutgoingCallMethodResult;
}


most_telfi_tclMsgCancelOutgoingCallMethodResult::~most_telfi_tclMsgCancelOutgoingCallMethodResult()
{}

tU32 most_telfi_tclMsgCancelOutgoingCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgCancelOutgoingCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCancelOutgoingCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgCancelOutgoingCallMethodResult::operator==(const most_telfi_tclMsgCancelOutgoingCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgConferenceInMethodStart::most_telfi_tclMsgConferenceInMethodStart(const most_telfi_tclMsgConferenceInMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oStreamOfCallInstances = coRef.oStreamOfCallInstances;
}
most_telfi_tclMsgConferenceInMethodStart& most_telfi_tclMsgConferenceInMethodStart::operator=(const most_telfi_tclMsgConferenceInMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oStreamOfCallInstances = coRef.oStreamOfCallInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgConferenceInMethodStart::most_telfi_tclMsgConferenceInMethodStart()
:oStreamOfCallInstances()
 {}

tS32 most_telfi_tclMsgConferenceInMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ConferenceInMethodStart;
}


most_telfi_tclMsgConferenceInMethodStart::~most_telfi_tclMsgConferenceInMethodStart()
{}

tU32 most_telfi_tclMsgConferenceInMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oStreamOfCallInstances.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgConferenceInMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oStreamOfCallInstances);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgConferenceInMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oStreamOfCallInstances);
   return oOut;
}

tBool most_telfi_tclMsgConferenceInMethodStart::operator==(const most_telfi_tclMsgConferenceInMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oStreamOfCallInstances == roRef.oStreamOfCallInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgConferenceInError::most_telfi_tclMsgConferenceInError(const most_telfi_tclMsgConferenceInError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgConferenceInError& most_telfi_tclMsgConferenceInError::operator=(const most_telfi_tclMsgConferenceInError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgConferenceInError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ConferenceInError;
}


most_telfi_tclMsgConferenceInError::~most_telfi_tclMsgConferenceInError()
{}

tBool most_telfi_tclMsgConferenceInError::operator==(const most_telfi_tclMsgConferenceInError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgConferenceInMethodResult::most_telfi_tclMsgConferenceInMethodResult(const most_telfi_tclMsgConferenceInMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oStreamOfCallInstances = coRef.oStreamOfCallInstances;
}
most_telfi_tclMsgConferenceInMethodResult& most_telfi_tclMsgConferenceInMethodResult::operator=(const most_telfi_tclMsgConferenceInMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oStreamOfCallInstances = coRef.oStreamOfCallInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgConferenceInMethodResult::most_telfi_tclMsgConferenceInMethodResult()
:oStreamOfCallInstances()
 {}

tS32 most_telfi_tclMsgConferenceInMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ConferenceInMethodResult;
}


most_telfi_tclMsgConferenceInMethodResult::~most_telfi_tclMsgConferenceInMethodResult()
{}

tU32 most_telfi_tclMsgConferenceInMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oStreamOfCallInstances.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgConferenceInMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oStreamOfCallInstances);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgConferenceInMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oStreamOfCallInstances);
   return oOut;
}

tBool most_telfi_tclMsgConferenceInMethodResult::operator==(const most_telfi_tclMsgConferenceInMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oStreamOfCallInstances == roRef.oStreamOfCallInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHangUpCallMethodStart::most_telfi_tclMsgHangUpCallMethodStart(const most_telfi_tclMsgHangUpCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgHangUpCallMethodStart& most_telfi_tclMsgHangUpCallMethodStart::operator=(const most_telfi_tclMsgHangUpCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgHangUpCallMethodStart::most_telfi_tclMsgHangUpCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgHangUpCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HangUpCallMethodStart;
}


most_telfi_tclMsgHangUpCallMethodStart::~most_telfi_tclMsgHangUpCallMethodStart()
{}

tU32 most_telfi_tclMsgHangUpCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgHangUpCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgHangUpCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgHangUpCallMethodStart::operator==(const most_telfi_tclMsgHangUpCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHangUpCallError::most_telfi_tclMsgHangUpCallError(const most_telfi_tclMsgHangUpCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgHangUpCallError& most_telfi_tclMsgHangUpCallError::operator=(const most_telfi_tclMsgHangUpCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgHangUpCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HangUpCallError;
}


most_telfi_tclMsgHangUpCallError::~most_telfi_tclMsgHangUpCallError()
{}

tBool most_telfi_tclMsgHangUpCallError::operator==(const most_telfi_tclMsgHangUpCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHangUpCallMethodResult::most_telfi_tclMsgHangUpCallMethodResult(const most_telfi_tclMsgHangUpCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgHangUpCallMethodResult& most_telfi_tclMsgHangUpCallMethodResult::operator=(const most_telfi_tclMsgHangUpCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgHangUpCallMethodResult::most_telfi_tclMsgHangUpCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgHangUpCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HangUpCallMethodResult;
}


most_telfi_tclMsgHangUpCallMethodResult::~most_telfi_tclMsgHangUpCallMethodResult()
{}

tU32 most_telfi_tclMsgHangUpCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgHangUpCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgHangUpCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgHangUpCallMethodResult::operator==(const most_telfi_tclMsgHangUpCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHoldCallMethodStart::most_telfi_tclMsgHoldCallMethodStart(const most_telfi_tclMsgHoldCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgHoldCallMethodStart& most_telfi_tclMsgHoldCallMethodStart::operator=(const most_telfi_tclMsgHoldCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgHoldCallMethodStart::most_telfi_tclMsgHoldCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgHoldCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HoldCallMethodStart;
}


most_telfi_tclMsgHoldCallMethodStart::~most_telfi_tclMsgHoldCallMethodStart()
{}

tU32 most_telfi_tclMsgHoldCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgHoldCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgHoldCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgHoldCallMethodStart::operator==(const most_telfi_tclMsgHoldCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHoldCallError::most_telfi_tclMsgHoldCallError(const most_telfi_tclMsgHoldCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgHoldCallError& most_telfi_tclMsgHoldCallError::operator=(const most_telfi_tclMsgHoldCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgHoldCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HoldCallError;
}


most_telfi_tclMsgHoldCallError::~most_telfi_tclMsgHoldCallError()
{}

tBool most_telfi_tclMsgHoldCallError::operator==(const most_telfi_tclMsgHoldCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHoldCallMethodResult::most_telfi_tclMsgHoldCallMethodResult(const most_telfi_tclMsgHoldCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgHoldCallMethodResult& most_telfi_tclMsgHoldCallMethodResult::operator=(const most_telfi_tclMsgHoldCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgHoldCallMethodResult::most_telfi_tclMsgHoldCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgHoldCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HoldCallMethodResult;
}


most_telfi_tclMsgHoldCallMethodResult::~most_telfi_tclMsgHoldCallMethodResult()
{}

tU32 most_telfi_tclMsgHoldCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgHoldCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgHoldCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgHoldCallMethodResult::operator==(const most_telfi_tclMsgHoldCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgIgnoreCallMethodStart::most_telfi_tclMsgIgnoreCallMethodStart(const most_telfi_tclMsgIgnoreCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgIgnoreCallMethodStart& most_telfi_tclMsgIgnoreCallMethodStart::operator=(const most_telfi_tclMsgIgnoreCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgIgnoreCallMethodStart::most_telfi_tclMsgIgnoreCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgIgnoreCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_IgnoreCallMethodStart;
}


most_telfi_tclMsgIgnoreCallMethodStart::~most_telfi_tclMsgIgnoreCallMethodStart()
{}

tU32 most_telfi_tclMsgIgnoreCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgIgnoreCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgIgnoreCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgIgnoreCallMethodStart::operator==(const most_telfi_tclMsgIgnoreCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgIgnoreCallError::most_telfi_tclMsgIgnoreCallError(const most_telfi_tclMsgIgnoreCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgIgnoreCallError& most_telfi_tclMsgIgnoreCallError::operator=(const most_telfi_tclMsgIgnoreCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgIgnoreCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_IgnoreCallError;
}


most_telfi_tclMsgIgnoreCallError::~most_telfi_tclMsgIgnoreCallError()
{}

tBool most_telfi_tclMsgIgnoreCallError::operator==(const most_telfi_tclMsgIgnoreCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgIgnoreCallMethodResult::most_telfi_tclMsgIgnoreCallMethodResult(const most_telfi_tclMsgIgnoreCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgIgnoreCallMethodResult& most_telfi_tclMsgIgnoreCallMethodResult::operator=(const most_telfi_tclMsgIgnoreCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgIgnoreCallMethodResult::most_telfi_tclMsgIgnoreCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgIgnoreCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_IgnoreCallMethodResult;
}


most_telfi_tclMsgIgnoreCallMethodResult::~most_telfi_tclMsgIgnoreCallMethodResult()
{}

tU32 most_telfi_tclMsgIgnoreCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgIgnoreCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgIgnoreCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgIgnoreCallMethodResult::operator==(const most_telfi_tclMsgIgnoreCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRejectCallMethodStart::most_telfi_tclMsgRejectCallMethodStart(const most_telfi_tclMsgRejectCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgRejectCallMethodStart& most_telfi_tclMsgRejectCallMethodStart::operator=(const most_telfi_tclMsgRejectCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRejectCallMethodStart::most_telfi_tclMsgRejectCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgRejectCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RejectCallMethodStart;
}


most_telfi_tclMsgRejectCallMethodStart::~most_telfi_tclMsgRejectCallMethodStart()
{}

tU32 most_telfi_tclMsgRejectCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgRejectCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRejectCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgRejectCallMethodStart::operator==(const most_telfi_tclMsgRejectCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRejectCallError::most_telfi_tclMsgRejectCallError(const most_telfi_tclMsgRejectCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgRejectCallError& most_telfi_tclMsgRejectCallError::operator=(const most_telfi_tclMsgRejectCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgRejectCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RejectCallError;
}


most_telfi_tclMsgRejectCallError::~most_telfi_tclMsgRejectCallError()
{}

tBool most_telfi_tclMsgRejectCallError::operator==(const most_telfi_tclMsgRejectCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRejectCallMethodResult::most_telfi_tclMsgRejectCallMethodResult(const most_telfi_tclMsgRejectCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgRejectCallMethodResult& most_telfi_tclMsgRejectCallMethodResult::operator=(const most_telfi_tclMsgRejectCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRejectCallMethodResult::most_telfi_tclMsgRejectCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgRejectCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RejectCallMethodResult;
}


most_telfi_tclMsgRejectCallMethodResult::~most_telfi_tclMsgRejectCallMethodResult()
{}

tU32 most_telfi_tclMsgRejectCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgRejectCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRejectCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgRejectCallMethodResult::operator==(const most_telfi_tclMsgRejectCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgResumeCallMethodStart::most_telfi_tclMsgResumeCallMethodStart(const most_telfi_tclMsgResumeCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgResumeCallMethodStart& most_telfi_tclMsgResumeCallMethodStart::operator=(const most_telfi_tclMsgResumeCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgResumeCallMethodStart::most_telfi_tclMsgResumeCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgResumeCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ResumeCallMethodStart;
}


most_telfi_tclMsgResumeCallMethodStart::~most_telfi_tclMsgResumeCallMethodStart()
{}

tU32 most_telfi_tclMsgResumeCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgResumeCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgResumeCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgResumeCallMethodStart::operator==(const most_telfi_tclMsgResumeCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgResumeCallError::most_telfi_tclMsgResumeCallError(const most_telfi_tclMsgResumeCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgResumeCallError& most_telfi_tclMsgResumeCallError::operator=(const most_telfi_tclMsgResumeCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgResumeCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ResumeCallError;
}


most_telfi_tclMsgResumeCallError::~most_telfi_tclMsgResumeCallError()
{}

tBool most_telfi_tclMsgResumeCallError::operator==(const most_telfi_tclMsgResumeCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgResumeCallMethodResult::most_telfi_tclMsgResumeCallMethodResult(const most_telfi_tclMsgResumeCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgResumeCallMethodResult& most_telfi_tclMsgResumeCallMethodResult::operator=(const most_telfi_tclMsgResumeCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgResumeCallMethodResult::most_telfi_tclMsgResumeCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgResumeCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ResumeCallMethodResult;
}


most_telfi_tclMsgResumeCallMethodResult::~most_telfi_tclMsgResumeCallMethodResult()
{}

tU32 most_telfi_tclMsgResumeCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgResumeCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgResumeCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgResumeCallMethodResult::operator==(const most_telfi_tclMsgResumeCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSendDTMFMethodStart::most_telfi_tclMsgSendDTMFMethodStart(const most_telfi_tclMsgSendDTMFMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   sDTMFChar = coRef.sDTMFChar;
}
most_telfi_tclMsgSendDTMFMethodStart& most_telfi_tclMsgSendDTMFMethodStart::operator=(const most_telfi_tclMsgSendDTMFMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   sDTMFChar = coRef.sDTMFChar;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgSendDTMFMethodStart::vDestroy()
{
   sDTMFChar.vDestroy(); 
}

most_telfi_tclMsgSendDTMFMethodStart::most_telfi_tclMsgSendDTMFMethodStart()
:u16CallInstance(0)
,sDTMFChar()
 {}

tS32 most_telfi_tclMsgSendDTMFMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SendDTMFMethodStart;
}


most_telfi_tclMsgSendDTMFMethodStart::~most_telfi_tclMsgSendDTMFMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgSendDTMFMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDTMFChar.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSendDTMFMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> sDTMFChar);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSendDTMFMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << sDTMFChar);
   return oOut;
}

tBool most_telfi_tclMsgSendDTMFMethodStart::operator==(const most_telfi_tclMsgSendDTMFMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (sDTMFChar == roRef.sDTMFChar);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSendDTMFError::most_telfi_tclMsgSendDTMFError(const most_telfi_tclMsgSendDTMFError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSendDTMFError& most_telfi_tclMsgSendDTMFError::operator=(const most_telfi_tclMsgSendDTMFError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSendDTMFError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SendDTMFError;
}


most_telfi_tclMsgSendDTMFError::~most_telfi_tclMsgSendDTMFError()
{}

tBool most_telfi_tclMsgSendDTMFError::operator==(const most_telfi_tclMsgSendDTMFError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSendDTMFMethodResult::most_telfi_tclMsgSendDTMFMethodResult(const most_telfi_tclMsgSendDTMFMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   bCommandStatus = coRef.bCommandStatus;
}
most_telfi_tclMsgSendDTMFMethodResult& most_telfi_tclMsgSendDTMFMethodResult::operator=(const most_telfi_tclMsgSendDTMFMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   bCommandStatus = coRef.bCommandStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSendDTMFMethodResult::most_telfi_tclMsgSendDTMFMethodResult()
:u16CallInstance(0)
,bCommandStatus(0)
 {}

tS32 most_telfi_tclMsgSendDTMFMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SendDTMFMethodResult;
}


most_telfi_tclMsgSendDTMFMethodResult::~most_telfi_tclMsgSendDTMFMethodResult()
{}

tU32 most_telfi_tclMsgSendDTMFMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_telfi_tclMsgSendDTMFMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> bCommandStatus);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSendDTMFMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << bCommandStatus);
   return oOut;
}

tBool most_telfi_tclMsgSendDTMFMethodResult::operator==(const most_telfi_tclMsgSendDTMFMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (bCommandStatus == roRef.bCommandStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSpeedDialMethodStart::most_telfi_tclMsgSpeedDialMethodStart(const most_telfi_tclMsgSpeedDialMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   s8MemoryDialParam = coRef.s8MemoryDialParam;
}
most_telfi_tclMsgSpeedDialMethodStart& most_telfi_tclMsgSpeedDialMethodStart::operator=(const most_telfi_tclMsgSpeedDialMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s8MemoryDialParam = coRef.s8MemoryDialParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSpeedDialMethodStart::most_telfi_tclMsgSpeedDialMethodStart()
:s8MemoryDialParam(0)
 {}

tS32 most_telfi_tclMsgSpeedDialMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SpeedDialMethodStart;
}


most_telfi_tclMsgSpeedDialMethodStart::~most_telfi_tclMsgSpeedDialMethodStart()
{}

tU32 most_telfi_tclMsgSpeedDialMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgSpeedDialMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s8MemoryDialParam);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSpeedDialMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s8MemoryDialParam);
   return oOut;
}

tBool most_telfi_tclMsgSpeedDialMethodStart::operator==(const most_telfi_tclMsgSpeedDialMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s8MemoryDialParam == roRef.s8MemoryDialParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSpeedDialError::most_telfi_tclMsgSpeedDialError(const most_telfi_tclMsgSpeedDialError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSpeedDialError& most_telfi_tclMsgSpeedDialError::operator=(const most_telfi_tclMsgSpeedDialError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSpeedDialError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SpeedDialError;
}


most_telfi_tclMsgSpeedDialError::~most_telfi_tclMsgSpeedDialError()
{}

tBool most_telfi_tclMsgSpeedDialError::operator==(const most_telfi_tclMsgSpeedDialError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSpeedDialMethodResult::most_telfi_tclMsgSpeedDialMethodResult(const most_telfi_tclMsgSpeedDialMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgSpeedDialMethodResult& most_telfi_tclMsgSpeedDialMethodResult::operator=(const most_telfi_tclMsgSpeedDialMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSpeedDialMethodResult::most_telfi_tclMsgSpeedDialMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgSpeedDialMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SpeedDialMethodResult;
}


most_telfi_tclMsgSpeedDialMethodResult::~most_telfi_tclMsgSpeedDialMethodResult()
{}

tU32 most_telfi_tclMsgSpeedDialMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgSpeedDialMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSpeedDialMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgSpeedDialMethodResult::operator==(const most_telfi_tclMsgSpeedDialMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSplitCallMethodStart::most_telfi_tclMsgSplitCallMethodStart(const most_telfi_tclMsgSplitCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgSplitCallMethodStart& most_telfi_tclMsgSplitCallMethodStart::operator=(const most_telfi_tclMsgSplitCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSplitCallMethodStart::most_telfi_tclMsgSplitCallMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgSplitCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SplitCallMethodStart;
}


most_telfi_tclMsgSplitCallMethodStart::~most_telfi_tclMsgSplitCallMethodStart()
{}

tU32 most_telfi_tclMsgSplitCallMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgSplitCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSplitCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgSplitCallMethodStart::operator==(const most_telfi_tclMsgSplitCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSplitCallError::most_telfi_tclMsgSplitCallError(const most_telfi_tclMsgSplitCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSplitCallError& most_telfi_tclMsgSplitCallError::operator=(const most_telfi_tclMsgSplitCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSplitCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SplitCallError;
}


most_telfi_tclMsgSplitCallError::~most_telfi_tclMsgSplitCallError()
{}

tBool most_telfi_tclMsgSplitCallError::operator==(const most_telfi_tclMsgSplitCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSplitCallMethodResult::most_telfi_tclMsgSplitCallMethodResult(const most_telfi_tclMsgSplitCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgSplitCallMethodResult& most_telfi_tclMsgSplitCallMethodResult::operator=(const most_telfi_tclMsgSplitCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSplitCallMethodResult::most_telfi_tclMsgSplitCallMethodResult()
:e8CallStatus()
,bUsingVehicleAudio(0)
,u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgSplitCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SplitCallMethodResult;
}


most_telfi_tclMsgSplitCallMethodResult::~most_telfi_tclMsgSplitCallMethodResult()
{}

tU32 most_telfi_tclMsgSplitCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgSplitCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSplitCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgSplitCallMethodResult::operator==(const most_telfi_tclMsgSplitCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSwapCallMethodStart::most_telfi_tclMsgSwapCallMethodStart(const most_telfi_tclMsgSwapCallMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oStreamOfCallInstances = coRef.oStreamOfCallInstances;
}
most_telfi_tclMsgSwapCallMethodStart& most_telfi_tclMsgSwapCallMethodStart::operator=(const most_telfi_tclMsgSwapCallMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oStreamOfCallInstances = coRef.oStreamOfCallInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSwapCallMethodStart::most_telfi_tclMsgSwapCallMethodStart()
:oStreamOfCallInstances()
 {}

tS32 most_telfi_tclMsgSwapCallMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SwapCallMethodStart;
}


most_telfi_tclMsgSwapCallMethodStart::~most_telfi_tclMsgSwapCallMethodStart()
{}

tU32 most_telfi_tclMsgSwapCallMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oStreamOfCallInstances.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSwapCallMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oStreamOfCallInstances);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSwapCallMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oStreamOfCallInstances);
   return oOut;
}

tBool most_telfi_tclMsgSwapCallMethodStart::operator==(const most_telfi_tclMsgSwapCallMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oStreamOfCallInstances == roRef.oStreamOfCallInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSwapCallError::most_telfi_tclMsgSwapCallError(const most_telfi_tclMsgSwapCallError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSwapCallError& most_telfi_tclMsgSwapCallError::operator=(const most_telfi_tclMsgSwapCallError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSwapCallError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SwapCallError;
}


most_telfi_tclMsgSwapCallError::~most_telfi_tclMsgSwapCallError()
{}

tBool most_telfi_tclMsgSwapCallError::operator==(const most_telfi_tclMsgSwapCallError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSwapCallMethodResult::most_telfi_tclMsgSwapCallMethodResult(const most_telfi_tclMsgSwapCallMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
}
most_telfi_tclMsgSwapCallMethodResult& most_telfi_tclMsgSwapCallMethodResult::operator=(const most_telfi_tclMsgSwapCallMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSwapCallMethodResult::most_telfi_tclMsgSwapCallMethodResult()
:u16CallInstance(0)
,e8CallStatus()
 {}

tS32 most_telfi_tclMsgSwapCallMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SwapCallMethodResult;
}


most_telfi_tclMsgSwapCallMethodResult::~most_telfi_tclMsgSwapCallMethodResult()
{}

tU32 most_telfi_tclMsgSwapCallMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_telfi_tclMsgSwapCallMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSwapCallMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   return oOut;
}

tBool most_telfi_tclMsgSwapCallMethodResult::operator==(const most_telfi_tclMsgSwapCallMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgTransferCallToHandsetMethodStart::most_telfi_tclMsgTransferCallToHandsetMethodStart()
 {}

tS32 most_telfi_tclMsgTransferCallToHandsetMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_TransferCallToHandsetMethodStart;
}


most_telfi_tclMsgTransferCallToHandsetMethodStart::~most_telfi_tclMsgTransferCallToHandsetMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgTransferCallToHandsetError::most_telfi_tclMsgTransferCallToHandsetError(const most_telfi_tclMsgTransferCallToHandsetError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgTransferCallToHandsetError& most_telfi_tclMsgTransferCallToHandsetError::operator=(const most_telfi_tclMsgTransferCallToHandsetError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgTransferCallToHandsetError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_TransferCallToHandsetError;
}


most_telfi_tclMsgTransferCallToHandsetError::~most_telfi_tclMsgTransferCallToHandsetError()
{}

tBool most_telfi_tclMsgTransferCallToHandsetError::operator==(const most_telfi_tclMsgTransferCallToHandsetError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgTransferCallToHandsetMethodResult::most_telfi_tclMsgTransferCallToHandsetMethodResult()
 {}

tS32 most_telfi_tclMsgTransferCallToHandsetMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_TransferCallToHandsetMethodResult;
}


most_telfi_tclMsgTransferCallToHandsetMethodResult::~most_telfi_tclMsgTransferCallToHandsetMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgTransferCallToVehicleMethodStart::most_telfi_tclMsgTransferCallToVehicleMethodStart(const most_telfi_tclMsgTransferCallToVehicleMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgTransferCallToVehicleMethodStart& most_telfi_tclMsgTransferCallToVehicleMethodStart::operator=(const most_telfi_tclMsgTransferCallToVehicleMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgTransferCallToVehicleMethodStart::most_telfi_tclMsgTransferCallToVehicleMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgTransferCallToVehicleMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_TransferCallToVehicleMethodStart;
}


most_telfi_tclMsgTransferCallToVehicleMethodStart::~most_telfi_tclMsgTransferCallToVehicleMethodStart()
{}

tU32 most_telfi_tclMsgTransferCallToVehicleMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgTransferCallToVehicleMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgTransferCallToVehicleMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgTransferCallToVehicleMethodStart::operator==(const most_telfi_tclMsgTransferCallToVehicleMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgTransferCallToVehicleError::most_telfi_tclMsgTransferCallToVehicleError(const most_telfi_tclMsgTransferCallToVehicleError& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
}
most_telfi_tclMsgTransferCallToVehicleError& most_telfi_tclMsgTransferCallToVehicleError::operator=(const most_telfi_tclMsgTransferCallToVehicleError& coRef)
{
   if (this == &coRef) return *this;
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgTransferCallToVehicleError::most_telfi_tclMsgTransferCallToVehicleError()
:oErrorInfo()
,e8ErrorCode()
 {}

tS32 most_telfi_tclMsgTransferCallToVehicleError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_TransferCallToVehicleError;
}


most_telfi_tclMsgTransferCallToVehicleError::~most_telfi_tclMsgTransferCallToVehicleError()
{}

tU32 most_telfi_tclMsgTransferCallToVehicleError::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgTransferCallToVehicleError::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oErrorInfo);
   (tVoid) (oIn >> e8ErrorCode);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgTransferCallToVehicleError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oErrorInfo);
   (tVoid) (oOut << e8ErrorCode);
   return oOut;
}

tBool most_telfi_tclMsgTransferCallToVehicleError::operator==(const most_telfi_tclMsgTransferCallToVehicleError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgTransferCallToVehicleMethodResult::most_telfi_tclMsgTransferCallToVehicleMethodResult(const most_telfi_tclMsgTransferCallToVehicleMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgTransferCallToVehicleMethodResult& most_telfi_tclMsgTransferCallToVehicleMethodResult::operator=(const most_telfi_tclMsgTransferCallToVehicleMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgTransferCallToVehicleMethodResult::most_telfi_tclMsgTransferCallToVehicleMethodResult()
:bUsingVehicleAudio(0)
,u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgTransferCallToVehicleMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_TransferCallToVehicleMethodResult;
}


most_telfi_tclMsgTransferCallToVehicleMethodResult::~most_telfi_tclMsgTransferCallToVehicleMethodResult()
{}

tU32 most_telfi_tclMsgTransferCallToVehicleMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgTransferCallToVehicleMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bUsingVehicleAudio);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgTransferCallToVehicleMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bUsingVehicleAudio);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgTransferCallToVehicleMethodResult::operator==(const most_telfi_tclMsgTransferCallToVehicleMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgVoiceMailMethodStart::most_telfi_tclMsgVoiceMailMethodStart(const most_telfi_tclMsgVoiceMailMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sDeviceName = coRef.sDeviceName;
}
most_telfi_tclMsgVoiceMailMethodStart& most_telfi_tclMsgVoiceMailMethodStart::operator=(const most_telfi_tclMsgVoiceMailMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sDeviceName = coRef.sDeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgVoiceMailMethodStart::vDestroy()
{
   sDeviceName.vDestroy(); 
}

most_telfi_tclMsgVoiceMailMethodStart::most_telfi_tclMsgVoiceMailMethodStart()
:sDeviceName()
 {}

tS32 most_telfi_tclMsgVoiceMailMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VoiceMailMethodStart;
}


most_telfi_tclMsgVoiceMailMethodStart::~most_telfi_tclMsgVoiceMailMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgVoiceMailMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgVoiceMailMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceName);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgVoiceMailMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceName);
   return oOut;
}

tBool most_telfi_tclMsgVoiceMailMethodStart::operator==(const most_telfi_tclMsgVoiceMailMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgVoiceMailError::most_telfi_tclMsgVoiceMailError(const most_telfi_tclMsgVoiceMailError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgVoiceMailError& most_telfi_tclMsgVoiceMailError::operator=(const most_telfi_tclMsgVoiceMailError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgVoiceMailError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VoiceMailError;
}


most_telfi_tclMsgVoiceMailError::~most_telfi_tclMsgVoiceMailError()
{}

tBool most_telfi_tclMsgVoiceMailError::operator==(const most_telfi_tclMsgVoiceMailError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgVoiceMailMethodResult::most_telfi_tclMsgVoiceMailMethodResult(const most_telfi_tclMsgVoiceMailMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sVoiceMailNumber = coRef.sVoiceMailNumber;
}
most_telfi_tclMsgVoiceMailMethodResult& most_telfi_tclMsgVoiceMailMethodResult::operator=(const most_telfi_tclMsgVoiceMailMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sVoiceMailNumber = coRef.sVoiceMailNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgVoiceMailMethodResult::vDestroy()
{
   sVoiceMailNumber.vDestroy(); 
}

most_telfi_tclMsgVoiceMailMethodResult::most_telfi_tclMsgVoiceMailMethodResult()
:sVoiceMailNumber()
 {}

tS32 most_telfi_tclMsgVoiceMailMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VoiceMailMethodResult;
}


most_telfi_tclMsgVoiceMailMethodResult::~most_telfi_tclMsgVoiceMailMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgVoiceMailMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sVoiceMailNumber.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgVoiceMailMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVoiceMailNumber);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgVoiceMailMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVoiceMailNumber);
   return oOut;
}

tBool most_telfi_tclMsgVoiceMailMethodResult::operator==(const most_telfi_tclMsgVoiceMailMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVoiceMailNumber == roRef.sVoiceMailNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDialMethodStart::most_telfi_tclMsgDialMethodStart(const most_telfi_tclMsgDialMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sTelephoneNumber = coRef.sTelephoneNumber;
   e8EchoCancellationNoiseReductionSetting = coRef.e8EchoCancellationNoiseReductionSetting;
}
most_telfi_tclMsgDialMethodStart& most_telfi_tclMsgDialMethodStart::operator=(const most_telfi_tclMsgDialMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sTelephoneNumber = coRef.sTelephoneNumber;
   e8EchoCancellationNoiseReductionSetting = coRef.e8EchoCancellationNoiseReductionSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgDialMethodStart::vDestroy()
{
   sTelephoneNumber.vDestroy(); 
}

most_telfi_tclMsgDialMethodStart::most_telfi_tclMsgDialMethodStart()
:sTelephoneNumber()
,e8EchoCancellationNoiseReductionSetting()
 {}

tS32 most_telfi_tclMsgDialMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DialMethodStart;
}


most_telfi_tclMsgDialMethodStart::~most_telfi_tclMsgDialMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgDialMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sTelephoneNumber.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgDialMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sTelephoneNumber);
   (tVoid) (oIn >> e8EchoCancellationNoiseReductionSetting);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDialMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sTelephoneNumber);
   (tVoid) (oOut << e8EchoCancellationNoiseReductionSetting);
   return oOut;
}

tBool most_telfi_tclMsgDialMethodStart::operator==(const most_telfi_tclMsgDialMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sTelephoneNumber == roRef.sTelephoneNumber);
   bResult = bResult && (e8EchoCancellationNoiseReductionSetting == roRef.e8EchoCancellationNoiseReductionSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDialError::most_telfi_tclMsgDialError(const most_telfi_tclMsgDialError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgDialError& most_telfi_tclMsgDialError::operator=(const most_telfi_tclMsgDialError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgDialError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DialError;
}


most_telfi_tclMsgDialError::~most_telfi_tclMsgDialError()
{}

tBool most_telfi_tclMsgDialError::operator==(const most_telfi_tclMsgDialError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDialMethodResult::most_telfi_tclMsgDialMethodResult(const most_telfi_tclMsgDialMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgDialMethodResult& most_telfi_tclMsgDialMethodResult::operator=(const most_telfi_tclMsgDialMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgDialMethodResult::most_telfi_tclMsgDialMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgDialMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DialMethodResult;
}


most_telfi_tclMsgDialMethodResult::~most_telfi_tclMsgDialMethodResult()
{}

tU32 most_telfi_tclMsgDialMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgDialMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDialMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgDialMethodResult::operator==(const most_telfi_tclMsgDialMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgQueryTelephoneNumberMethodStart::most_telfi_tclMsgQueryTelephoneNumberMethodStart(const most_telfi_tclMsgQueryTelephoneNumberMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
}
most_telfi_tclMsgQueryTelephoneNumberMethodStart& most_telfi_tclMsgQueryTelephoneNumberMethodStart::operator=(const most_telfi_tclMsgQueryTelephoneNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgQueryTelephoneNumberMethodStart::most_telfi_tclMsgQueryTelephoneNumberMethodStart()
:u16CallInstance(0)
 {}

tS32 most_telfi_tclMsgQueryTelephoneNumberMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_QueryTelephoneNumberMethodStart;
}


most_telfi_tclMsgQueryTelephoneNumberMethodStart::~most_telfi_tclMsgQueryTelephoneNumberMethodStart()
{}

tU32 most_telfi_tclMsgQueryTelephoneNumberMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgQueryTelephoneNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgQueryTelephoneNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   return oOut;
}

tBool most_telfi_tclMsgQueryTelephoneNumberMethodStart::operator==(const most_telfi_tclMsgQueryTelephoneNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgQueryTelephoneNumberError::most_telfi_tclMsgQueryTelephoneNumberError(const most_telfi_tclMsgQueryTelephoneNumberError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgQueryTelephoneNumberError& most_telfi_tclMsgQueryTelephoneNumberError::operator=(const most_telfi_tclMsgQueryTelephoneNumberError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgQueryTelephoneNumberError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_QueryTelephoneNumberError;
}


most_telfi_tclMsgQueryTelephoneNumberError::~most_telfi_tclMsgQueryTelephoneNumberError()
{}

tBool most_telfi_tclMsgQueryTelephoneNumberError::operator==(const most_telfi_tclMsgQueryTelephoneNumberError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgQueryTelephoneNumberMethodResult::most_telfi_tclMsgQueryTelephoneNumberMethodResult(const most_telfi_tclMsgQueryTelephoneNumberMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   sTelephoneNumber = coRef.sTelephoneNumber;
}
most_telfi_tclMsgQueryTelephoneNumberMethodResult& most_telfi_tclMsgQueryTelephoneNumberMethodResult::operator=(const most_telfi_tclMsgQueryTelephoneNumberMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   sTelephoneNumber = coRef.sTelephoneNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgQueryTelephoneNumberMethodResult::vDestroy()
{
   sTelephoneNumber.vDestroy(); 
}

most_telfi_tclMsgQueryTelephoneNumberMethodResult::most_telfi_tclMsgQueryTelephoneNumberMethodResult()
:u16CallInstance(0)
,sTelephoneNumber()
 {}

tS32 most_telfi_tclMsgQueryTelephoneNumberMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_QueryTelephoneNumberMethodResult;
}


most_telfi_tclMsgQueryTelephoneNumberMethodResult::~most_telfi_tclMsgQueryTelephoneNumberMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgQueryTelephoneNumberMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sTelephoneNumber.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgQueryTelephoneNumberMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> sTelephoneNumber);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgQueryTelephoneNumberMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << sTelephoneNumber);
   return oOut;
}

tBool most_telfi_tclMsgQueryTelephoneNumberMethodResult::operator==(const most_telfi_tclMsgQueryTelephoneNumberMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (sTelephoneNumber == roRef.sTelephoneNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAcquireTelephoneNumberMethodStart::most_telfi_tclMsgAcquireTelephoneNumberMethodStart(const most_telfi_tclMsgAcquireTelephoneNumberMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgAcquireTelephoneNumberMethodStart& most_telfi_tclMsgAcquireTelephoneNumberMethodStart::operator=(const most_telfi_tclMsgAcquireTelephoneNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgAcquireTelephoneNumberMethodStart::most_telfi_tclMsgAcquireTelephoneNumberMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgAcquireTelephoneNumberMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AcquireTelephoneNumberMethodStart;
}


most_telfi_tclMsgAcquireTelephoneNumberMethodStart::~most_telfi_tclMsgAcquireTelephoneNumberMethodStart()
{}

tU32 most_telfi_tclMsgAcquireTelephoneNumberMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgAcquireTelephoneNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAcquireTelephoneNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgAcquireTelephoneNumberMethodStart::operator==(const most_telfi_tclMsgAcquireTelephoneNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAcquireTelephoneNumberError::most_telfi_tclMsgAcquireTelephoneNumberError(const most_telfi_tclMsgAcquireTelephoneNumberError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgAcquireTelephoneNumberError& most_telfi_tclMsgAcquireTelephoneNumberError::operator=(const most_telfi_tclMsgAcquireTelephoneNumberError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgAcquireTelephoneNumberError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AcquireTelephoneNumberError;
}


most_telfi_tclMsgAcquireTelephoneNumberError::~most_telfi_tclMsgAcquireTelephoneNumberError()
{}

tBool most_telfi_tclMsgAcquireTelephoneNumberError::operator==(const most_telfi_tclMsgAcquireTelephoneNumberError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAcquireTelephoneNumberMethodResult::most_telfi_tclMsgAcquireTelephoneNumberMethodResult(const most_telfi_tclMsgAcquireTelephoneNumberMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sTelephoneNumber = coRef.sTelephoneNumber;
}
most_telfi_tclMsgAcquireTelephoneNumberMethodResult& most_telfi_tclMsgAcquireTelephoneNumberMethodResult::operator=(const most_telfi_tclMsgAcquireTelephoneNumberMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sTelephoneNumber = coRef.sTelephoneNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgAcquireTelephoneNumberMethodResult::vDestroy()
{
   sTelephoneNumber.vDestroy(); 
}

most_telfi_tclMsgAcquireTelephoneNumberMethodResult::most_telfi_tclMsgAcquireTelephoneNumberMethodResult()
:sTelephoneNumber()
 {}

tS32 most_telfi_tclMsgAcquireTelephoneNumberMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AcquireTelephoneNumberMethodResult;
}


most_telfi_tclMsgAcquireTelephoneNumberMethodResult::~most_telfi_tclMsgAcquireTelephoneNumberMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgAcquireTelephoneNumberMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sTelephoneNumber.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgAcquireTelephoneNumberMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sTelephoneNumber);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAcquireTelephoneNumberMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sTelephoneNumber);
   return oOut;
}

tBool most_telfi_tclMsgAcquireTelephoneNumberMethodResult::operator==(const most_telfi_tclMsgAcquireTelephoneNumberMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sTelephoneNumber == roRef.sTelephoneNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRedialMethodStart::most_telfi_tclMsgRedialMethodStart(const most_telfi_tclMsgRedialMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8EchoCancellationNoiseReductionSetting = coRef.e8EchoCancellationNoiseReductionSetting;
}
most_telfi_tclMsgRedialMethodStart& most_telfi_tclMsgRedialMethodStart::operator=(const most_telfi_tclMsgRedialMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8EchoCancellationNoiseReductionSetting = coRef.e8EchoCancellationNoiseReductionSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRedialMethodStart::most_telfi_tclMsgRedialMethodStart()
:e8EchoCancellationNoiseReductionSetting()
 {}

tS32 most_telfi_tclMsgRedialMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RedialMethodStart;
}


most_telfi_tclMsgRedialMethodStart::~most_telfi_tclMsgRedialMethodStart()
{}

tU32 most_telfi_tclMsgRedialMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgRedialMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8EchoCancellationNoiseReductionSetting);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRedialMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8EchoCancellationNoiseReductionSetting);
   return oOut;
}

tBool most_telfi_tclMsgRedialMethodStart::operator==(const most_telfi_tclMsgRedialMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8EchoCancellationNoiseReductionSetting == roRef.e8EchoCancellationNoiseReductionSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRedialError::most_telfi_tclMsgRedialError(const most_telfi_tclMsgRedialError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgRedialError& most_telfi_tclMsgRedialError::operator=(const most_telfi_tclMsgRedialError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgRedialError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RedialError;
}


most_telfi_tclMsgRedialError::~most_telfi_tclMsgRedialError()
{}

tBool most_telfi_tclMsgRedialError::operator==(const most_telfi_tclMsgRedialError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRedialMethodResult::most_telfi_tclMsgRedialMethodResult(const most_telfi_tclMsgRedialMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgRedialMethodResult& most_telfi_tclMsgRedialMethodResult::operator=(const most_telfi_tclMsgRedialMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRedialMethodResult::most_telfi_tclMsgRedialMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgRedialMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RedialMethodResult;
}


most_telfi_tclMsgRedialMethodResult::~most_telfi_tclMsgRedialMethodResult()
{}

tU32 most_telfi_tclMsgRedialMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgRedialMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRedialMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgRedialMethodResult::operator==(const most_telfi_tclMsgRedialMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSetRingtoneMethodStart::most_telfi_tclMsgSetRingtoneMethodStart(const most_telfi_tclMsgSetRingtoneMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   u8RingtoneID = coRef.u8RingtoneID;
}
most_telfi_tclMsgSetRingtoneMethodStart& most_telfi_tclMsgSetRingtoneMethodStart::operator=(const most_telfi_tclMsgSetRingtoneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   u8RingtoneID = coRef.u8RingtoneID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgSetRingtoneMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgSetRingtoneMethodStart::most_telfi_tclMsgSetRingtoneMethodStart()
:sBdAddress()
,u8RingtoneID(0)
 {}

tS32 most_telfi_tclMsgSetRingtoneMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SetRingtoneMethodStart;
}


most_telfi_tclMsgSetRingtoneMethodStart::~most_telfi_tclMsgSetRingtoneMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgSetRingtoneMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSetRingtoneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> u8RingtoneID);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSetRingtoneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << u8RingtoneID);
   return oOut;
}

tBool most_telfi_tclMsgSetRingtoneMethodStart::operator==(const most_telfi_tclMsgSetRingtoneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (u8RingtoneID == roRef.u8RingtoneID);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSetRingtoneMethodResult::most_telfi_tclMsgSetRingtoneMethodResult()
 {}

tS32 most_telfi_tclMsgSetRingtoneMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SetRingtoneMethodResult;
}


most_telfi_tclMsgSetRingtoneMethodResult::~most_telfi_tclMsgSetRingtoneMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSetRingtoneError::most_telfi_tclMsgSetRingtoneError(const most_telfi_tclMsgSetRingtoneError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSetRingtoneError& most_telfi_tclMsgSetRingtoneError::operator=(const most_telfi_tclMsgSetRingtoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSetRingtoneError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SetRingtoneError;
}


most_telfi_tclMsgSetRingtoneError::~most_telfi_tclMsgSetRingtoneError()
{}

tBool most_telfi_tclMsgSetRingtoneError::operator==(const most_telfi_tclMsgSetRingtoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgPlayRingtoneMethodStart::most_telfi_tclMsgPlayRingtoneMethodStart(const most_telfi_tclMsgPlayRingtoneMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8RingtoneID = coRef.u8RingtoneID;
   u8PlayCount = coRef.u8PlayCount;
}
most_telfi_tclMsgPlayRingtoneMethodStart& most_telfi_tclMsgPlayRingtoneMethodStart::operator=(const most_telfi_tclMsgPlayRingtoneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8RingtoneID = coRef.u8RingtoneID;
   u8PlayCount = coRef.u8PlayCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgPlayRingtoneMethodStart::most_telfi_tclMsgPlayRingtoneMethodStart()
:u8RingtoneID(0)
,u8PlayCount(0)
 {}

tS32 most_telfi_tclMsgPlayRingtoneMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_PlayRingtoneMethodStart;
}


most_telfi_tclMsgPlayRingtoneMethodStart::~most_telfi_tclMsgPlayRingtoneMethodStart()
{}

tU32 most_telfi_tclMsgPlayRingtoneMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgPlayRingtoneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8RingtoneID);
   (tVoid) (oIn >> u8PlayCount);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgPlayRingtoneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8RingtoneID);
   (tVoid) (oOut << u8PlayCount);
   return oOut;
}

tBool most_telfi_tclMsgPlayRingtoneMethodStart::operator==(const most_telfi_tclMsgPlayRingtoneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8RingtoneID == roRef.u8RingtoneID);
   bResult = bResult && (u8PlayCount == roRef.u8PlayCount);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgPlayRingtoneMethodResult::most_telfi_tclMsgPlayRingtoneMethodResult()
 {}

tS32 most_telfi_tclMsgPlayRingtoneMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_PlayRingtoneMethodResult;
}


most_telfi_tclMsgPlayRingtoneMethodResult::~most_telfi_tclMsgPlayRingtoneMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgPlayRingtoneError::most_telfi_tclMsgPlayRingtoneError(const most_telfi_tclMsgPlayRingtoneError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgPlayRingtoneError& most_telfi_tclMsgPlayRingtoneError::operator=(const most_telfi_tclMsgPlayRingtoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgPlayRingtoneError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_PlayRingtoneError;
}


most_telfi_tclMsgPlayRingtoneError::~most_telfi_tclMsgPlayRingtoneError()
{}

tBool most_telfi_tclMsgPlayRingtoneError::operator==(const most_telfi_tclMsgPlayRingtoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgStopRingtoneMethodStart::most_telfi_tclMsgStopRingtoneMethodStart()
 {}

tS32 most_telfi_tclMsgStopRingtoneMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_StopRingtoneMethodStart;
}


most_telfi_tclMsgStopRingtoneMethodStart::~most_telfi_tclMsgStopRingtoneMethodStart()
{}

//=============================================================================

most_telfi_tclMsgStopRingtoneMethodResult::most_telfi_tclMsgStopRingtoneMethodResult()
 {}

tS32 most_telfi_tclMsgStopRingtoneMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_StopRingtoneMethodResult;
}


most_telfi_tclMsgStopRingtoneMethodResult::~most_telfi_tclMsgStopRingtoneMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgStopRingtoneError::most_telfi_tclMsgStopRingtoneError(const most_telfi_tclMsgStopRingtoneError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgStopRingtoneError& most_telfi_tclMsgStopRingtoneError::operator=(const most_telfi_tclMsgStopRingtoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgStopRingtoneError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_StopRingtoneError;
}


most_telfi_tclMsgStopRingtoneError::~most_telfi_tclMsgStopRingtoneError()
{}

tBool most_telfi_tclMsgStopRingtoneError::operator==(const most_telfi_tclMsgStopRingtoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::most_telfi_tclMsgSuppressRingtoneOnOffMethodStart(const most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   bSuppressRingtoneState = coRef.bSuppressRingtoneState;
}
most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::operator=(const most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   bSuppressRingtoneState = coRef.bSuppressRingtoneState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::most_telfi_tclMsgSuppressRingtoneOnOffMethodStart()
:sBdAddress()
,bSuppressRingtoneState(0)
 {}

tS32 most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffMethodStart;
}


most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::~most_telfi_tclMsgSuppressRingtoneOnOffMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> bSuppressRingtoneState);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << bSuppressRingtoneState);
   return oOut;
}

tBool most_telfi_tclMsgSuppressRingtoneOnOffMethodStart::operator==(const most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (bSuppressRingtoneState == roRef.bSuppressRingtoneState);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSuppressRingtoneOnOffMethodResult::most_telfi_tclMsgSuppressRingtoneOnOffMethodResult()
 {}

tS32 most_telfi_tclMsgSuppressRingtoneOnOffMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffMethodResult;
}


most_telfi_tclMsgSuppressRingtoneOnOffMethodResult::~most_telfi_tclMsgSuppressRingtoneOnOffMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSuppressRingtoneOnOffError::most_telfi_tclMsgSuppressRingtoneOnOffError(const most_telfi_tclMsgSuppressRingtoneOnOffError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSuppressRingtoneOnOffError& most_telfi_tclMsgSuppressRingtoneOnOffError::operator=(const most_telfi_tclMsgSuppressRingtoneOnOffError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSuppressRingtoneOnOffError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffError;
}


most_telfi_tclMsgSuppressRingtoneOnOffError::~most_telfi_tclMsgSuppressRingtoneOnOffError()
{}

tBool most_telfi_tclMsgSuppressRingtoneOnOffError::operator==(const most_telfi_tclMsgSuppressRingtoneOnOffError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::most_telfi_tclMsgAutoWaitingModeOnOffMethodStart(const most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   bAutoWaitingModeState = coRef.bAutoWaitingModeState;
}
most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::operator=(const most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   bAutoWaitingModeState = coRef.bAutoWaitingModeState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::most_telfi_tclMsgAutoWaitingModeOnOffMethodStart()
:sBdAddress()
,bAutoWaitingModeState(0)
 {}

tS32 most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffMethodStart;
}


most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::~most_telfi_tclMsgAutoWaitingModeOnOffMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> bAutoWaitingModeState);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << bAutoWaitingModeState);
   return oOut;
}

tBool most_telfi_tclMsgAutoWaitingModeOnOffMethodStart::operator==(const most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (bAutoWaitingModeState == roRef.bAutoWaitingModeState);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgAutoWaitingModeOnOffMethodResult::most_telfi_tclMsgAutoWaitingModeOnOffMethodResult()
 {}

tS32 most_telfi_tclMsgAutoWaitingModeOnOffMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffMethodResult;
}


most_telfi_tclMsgAutoWaitingModeOnOffMethodResult::~most_telfi_tclMsgAutoWaitingModeOnOffMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAutoWaitingModeOnOffError::most_telfi_tclMsgAutoWaitingModeOnOffError(const most_telfi_tclMsgAutoWaitingModeOnOffError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgAutoWaitingModeOnOffError& most_telfi_tclMsgAutoWaitingModeOnOffError::operator=(const most_telfi_tclMsgAutoWaitingModeOnOffError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgAutoWaitingModeOnOffError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffError;
}


most_telfi_tclMsgAutoWaitingModeOnOffError::~most_telfi_tclMsgAutoWaitingModeOnOffError()
{}

tBool most_telfi_tclMsgAutoWaitingModeOnOffError::operator==(const most_telfi_tclMsgAutoWaitingModeOnOffError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgStartStopWaitingModeMethodStart::most_telfi_tclMsgStartStopWaitingModeMethodStart(const most_telfi_tclMsgStartStopWaitingModeMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8WaitingModeAction = coRef.e8WaitingModeAction;
}
most_telfi_tclMsgStartStopWaitingModeMethodStart& most_telfi_tclMsgStartStopWaitingModeMethodStart::operator=(const most_telfi_tclMsgStartStopWaitingModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8WaitingModeAction = coRef.e8WaitingModeAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgStartStopWaitingModeMethodStart::most_telfi_tclMsgStartStopWaitingModeMethodStart()
:e8WaitingModeAction()
 {}

tS32 most_telfi_tclMsgStartStopWaitingModeMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_StartStopWaitingModeMethodStart;
}


most_telfi_tclMsgStartStopWaitingModeMethodStart::~most_telfi_tclMsgStartStopWaitingModeMethodStart()
{}

tU32 most_telfi_tclMsgStartStopWaitingModeMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgStartStopWaitingModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8WaitingModeAction);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgStartStopWaitingModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8WaitingModeAction);
   return oOut;
}

tBool most_telfi_tclMsgStartStopWaitingModeMethodStart::operator==(const most_telfi_tclMsgStartStopWaitingModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8WaitingModeAction == roRef.e8WaitingModeAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgStartStopWaitingModeError::most_telfi_tclMsgStartStopWaitingModeError(const most_telfi_tclMsgStartStopWaitingModeError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgStartStopWaitingModeError& most_telfi_tclMsgStartStopWaitingModeError::operator=(const most_telfi_tclMsgStartStopWaitingModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgStartStopWaitingModeError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_StartStopWaitingModeError;
}


most_telfi_tclMsgStartStopWaitingModeError::~most_telfi_tclMsgStartStopWaitingModeError()
{}

tBool most_telfi_tclMsgStartStopWaitingModeError::operator==(const most_telfi_tclMsgStartStopWaitingModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgStartStopWaitingModeMethodResult::most_telfi_tclMsgStartStopWaitingModeMethodResult(const most_telfi_tclMsgStartStopWaitingModeMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8WaitingModeStatus = coRef.e8WaitingModeStatus;
}
most_telfi_tclMsgStartStopWaitingModeMethodResult& most_telfi_tclMsgStartStopWaitingModeMethodResult::operator=(const most_telfi_tclMsgStartStopWaitingModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8WaitingModeStatus = coRef.e8WaitingModeStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgStartStopWaitingModeMethodResult::most_telfi_tclMsgStartStopWaitingModeMethodResult()
:e8WaitingModeStatus()
 {}

tS32 most_telfi_tclMsgStartStopWaitingModeMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_StartStopWaitingModeMethodResult;
}


most_telfi_tclMsgStartStopWaitingModeMethodResult::~most_telfi_tclMsgStartStopWaitingModeMethodResult()
{}

tU32 most_telfi_tclMsgStartStopWaitingModeMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgStartStopWaitingModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8WaitingModeStatus);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgStartStopWaitingModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8WaitingModeStatus);
   return oOut;
}

tBool most_telfi_tclMsgStartStopWaitingModeMethodResult::operator==(const most_telfi_tclMsgStartStopWaitingModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8WaitingModeStatus == roRef.e8WaitingModeStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDialExtendedMethodStart::most_telfi_tclMsgDialExtendedMethodStart(const most_telfi_tclMsgDialExtendedMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sTelephoneNumber = coRef.sTelephoneNumber;
   sName = coRef.sName;
   e8EchoCancellationNoiseReductionSetting = coRef.e8EchoCancellationNoiseReductionSetting;
}
most_telfi_tclMsgDialExtendedMethodStart& most_telfi_tclMsgDialExtendedMethodStart::operator=(const most_telfi_tclMsgDialExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sTelephoneNumber = coRef.sTelephoneNumber;
   sName = coRef.sName;
   e8EchoCancellationNoiseReductionSetting = coRef.e8EchoCancellationNoiseReductionSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgDialExtendedMethodStart::vDestroy()
{
   sTelephoneNumber.vDestroy(); 
   sName.vDestroy(); 
}

most_telfi_tclMsgDialExtendedMethodStart::most_telfi_tclMsgDialExtendedMethodStart()
:sTelephoneNumber()
,sName()
,e8EchoCancellationNoiseReductionSetting()
 {}

tS32 most_telfi_tclMsgDialExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DialExtendedMethodStart;
}


most_telfi_tclMsgDialExtendedMethodStart::~most_telfi_tclMsgDialExtendedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgDialExtendedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sTelephoneNumber.u32GetSize(u16MajorVersion);
   u32DynamicSize += sName.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgDialExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sTelephoneNumber);
   (tVoid) (oIn >> sName);
   (tVoid) (oIn >> e8EchoCancellationNoiseReductionSetting);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDialExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sTelephoneNumber);
   (tVoid) (oOut << sName);
   (tVoid) (oOut << e8EchoCancellationNoiseReductionSetting);
   return oOut;
}

tBool most_telfi_tclMsgDialExtendedMethodStart::operator==(const most_telfi_tclMsgDialExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sTelephoneNumber == roRef.sTelephoneNumber);
   bResult = bResult && (sName == roRef.sName);
   bResult = bResult && (e8EchoCancellationNoiseReductionSetting == roRef.e8EchoCancellationNoiseReductionSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDialExtendedError::most_telfi_tclMsgDialExtendedError(const most_telfi_tclMsgDialExtendedError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgDialExtendedError& most_telfi_tclMsgDialExtendedError::operator=(const most_telfi_tclMsgDialExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgDialExtendedError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DialExtendedError;
}


most_telfi_tclMsgDialExtendedError::~most_telfi_tclMsgDialExtendedError()
{}

tBool most_telfi_tclMsgDialExtendedError::operator==(const most_telfi_tclMsgDialExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDialExtendedMethodResult::most_telfi_tclMsgDialExtendedMethodResult(const most_telfi_tclMsgDialExtendedMethodResult& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgDialExtendedMethodResult& most_telfi_tclMsgDialExtendedMethodResult::operator=(const most_telfi_tclMsgDialExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16CallInstance = coRef.u16CallInstance;
   e8CallStatus = coRef.e8CallStatus;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgDialExtendedMethodResult::most_telfi_tclMsgDialExtendedMethodResult()
:u16CallInstance(0)
,e8CallStatus()
,bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgDialExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DialExtendedMethodResult;
}


most_telfi_tclMsgDialExtendedMethodResult::~most_telfi_tclMsgDialExtendedMethodResult()
{}

tU32 most_telfi_tclMsgDialExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgDialExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> e8CallStatus);
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDialExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << e8CallStatus);
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgDialExtendedMethodResult::operator==(const most_telfi_tclMsgDialExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (e8CallStatus == roRef.e8CallStatus);
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSetActivePhoneMethodStart::most_telfi_tclMsgSetActivePhoneMethodStart(const most_telfi_tclMsgSetActivePhoneMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgSetActivePhoneMethodStart& most_telfi_tclMsgSetActivePhoneMethodStart::operator=(const most_telfi_tclMsgSetActivePhoneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSetActivePhoneMethodStart::most_telfi_tclMsgSetActivePhoneMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgSetActivePhoneMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SetActivePhoneMethodStart;
}


most_telfi_tclMsgSetActivePhoneMethodStart::~most_telfi_tclMsgSetActivePhoneMethodStart()
{}

tU32 most_telfi_tclMsgSetActivePhoneMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgSetActivePhoneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSetActivePhoneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgSetActivePhoneMethodStart::operator==(const most_telfi_tclMsgSetActivePhoneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSetActivePhoneError::most_telfi_tclMsgSetActivePhoneError(const most_telfi_tclMsgSetActivePhoneError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSetActivePhoneError& most_telfi_tclMsgSetActivePhoneError::operator=(const most_telfi_tclMsgSetActivePhoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSetActivePhoneError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SetActivePhoneError;
}


most_telfi_tclMsgSetActivePhoneError::~most_telfi_tclMsgSetActivePhoneError()
{}

tBool most_telfi_tclMsgSetActivePhoneError::operator==(const most_telfi_tclMsgSetActivePhoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSetActivePhoneMethodResult::most_telfi_tclMsgSetActivePhoneMethodResult()
 {}

tS32 most_telfi_tclMsgSetActivePhoneMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SetActivePhoneMethodResult;
}


most_telfi_tclMsgSetActivePhoneMethodResult::~most_telfi_tclMsgSetActivePhoneMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgActivateExternalVRMethodStart::most_telfi_tclMsgActivateExternalVRMethodStart(const most_telfi_tclMsgActivateExternalVRMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
}
most_telfi_tclMsgActivateExternalVRMethodStart& most_telfi_tclMsgActivateExternalVRMethodStart::operator=(const most_telfi_tclMsgActivateExternalVRMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgActivateExternalVRMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgActivateExternalVRMethodStart::most_telfi_tclMsgActivateExternalVRMethodStart()
:sBdAddress()
 {}

tS32 most_telfi_tclMsgActivateExternalVRMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivateExternalVRMethodStart;
}


most_telfi_tclMsgActivateExternalVRMethodStart::~most_telfi_tclMsgActivateExternalVRMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgActivateExternalVRMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgActivateExternalVRMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgActivateExternalVRMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   return oOut;
}

tBool most_telfi_tclMsgActivateExternalVRMethodStart::operator==(const most_telfi_tclMsgActivateExternalVRMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgActivateExternalVRError::most_telfi_tclMsgActivateExternalVRError(const most_telfi_tclMsgActivateExternalVRError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgActivateExternalVRError& most_telfi_tclMsgActivateExternalVRError::operator=(const most_telfi_tclMsgActivateExternalVRError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgActivateExternalVRError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivateExternalVRError;
}


most_telfi_tclMsgActivateExternalVRError::~most_telfi_tclMsgActivateExternalVRError()
{}

tBool most_telfi_tclMsgActivateExternalVRError::operator==(const most_telfi_tclMsgActivateExternalVRError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgActivateExternalVRMethodResult::most_telfi_tclMsgActivateExternalVRMethodResult()
 {}

tS32 most_telfi_tclMsgActivateExternalVRMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivateExternalVRMethodResult;
}


most_telfi_tclMsgActivateExternalVRMethodResult::~most_telfi_tclMsgActivateExternalVRMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDeActivateExternalVRMethodStart::most_telfi_tclMsgDeActivateExternalVRMethodStart(const most_telfi_tclMsgDeActivateExternalVRMethodStart& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
}
most_telfi_tclMsgDeActivateExternalVRMethodStart& most_telfi_tclMsgDeActivateExternalVRMethodStart::operator=(const most_telfi_tclMsgDeActivateExternalVRMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgDeActivateExternalVRMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgDeActivateExternalVRMethodStart::most_telfi_tclMsgDeActivateExternalVRMethodStart()
:sBdAddress()
 {}

tS32 most_telfi_tclMsgDeActivateExternalVRMethodStart::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeActivateExternalVRMethodStart;
}


most_telfi_tclMsgDeActivateExternalVRMethodStart::~most_telfi_tclMsgDeActivateExternalVRMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgDeActivateExternalVRMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgDeActivateExternalVRMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDeActivateExternalVRMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   return oOut;
}

tBool most_telfi_tclMsgDeActivateExternalVRMethodStart::operator==(const most_telfi_tclMsgDeActivateExternalVRMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDeActivateExternalVRError::most_telfi_tclMsgDeActivateExternalVRError(const most_telfi_tclMsgDeActivateExternalVRError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgDeActivateExternalVRError& most_telfi_tclMsgDeActivateExternalVRError::operator=(const most_telfi_tclMsgDeActivateExternalVRError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgDeActivateExternalVRError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeActivateExternalVRError;
}


most_telfi_tclMsgDeActivateExternalVRError::~most_telfi_tclMsgDeActivateExternalVRError()
{}

tBool most_telfi_tclMsgDeActivateExternalVRError::operator==(const most_telfi_tclMsgDeActivateExternalVRError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgDeActivateExternalVRMethodResult::most_telfi_tclMsgDeActivateExternalVRMethodResult()
 {}

tS32 most_telfi_tclMsgDeActivateExternalVRMethodResult::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeActivateExternalVRMethodResult;
}


most_telfi_tclMsgDeActivateExternalVRMethodResult::~most_telfi_tclMsgDeActivateExternalVRMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceInfoGet::most_telfi_tclMsgSourceInfoGet(const most_telfi_tclMsgSourceInfoGet& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_telfi_tclMsgSourceInfoGet& most_telfi_tclMsgSourceInfoGet::operator=(const most_telfi_tclMsgSourceInfoGet& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSourceInfoGet::most_telfi_tclMsgSourceInfoGet()
:u8SourceNr(0)
 {}

tS32 most_telfi_tclMsgSourceInfoGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceInfoGet;
}


most_telfi_tclMsgSourceInfoGet::~most_telfi_tclMsgSourceInfoGet()
{}

tU32 most_telfi_tclMsgSourceInfoGet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgSourceInfoGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSourceInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_telfi_tclMsgSourceInfoGet::operator==(const most_telfi_tclMsgSourceInfoGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceInfoError::most_telfi_tclMsgSourceInfoError(const most_telfi_tclMsgSourceInfoError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSourceInfoError& most_telfi_tclMsgSourceInfoError::operator=(const most_telfi_tclMsgSourceInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSourceInfoError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceInfoError;
}


most_telfi_tclMsgSourceInfoError::~most_telfi_tclMsgSourceInfoError()
{}

tBool most_telfi_tclMsgSourceInfoError::operator==(const most_telfi_tclMsgSourceInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceInfoStatus::most_telfi_tclMsgSourceInfoStatus(const most_telfi_tclMsgSourceInfoStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   e8TransmissionClass = coRef.e8TransmissionClass;
   e8ContentProtection = coRef.e8ContentProtection;
   e8ContentType = coRef.e8ContentType;
   oContentDescription = coRef.oContentDescription;
   oTransmissionParameter = coRef.oTransmissionParameter;
}
most_telfi_tclMsgSourceInfoStatus& most_telfi_tclMsgSourceInfoStatus::operator=(const most_telfi_tclMsgSourceInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   e8TransmissionClass = coRef.e8TransmissionClass;
   e8ContentProtection = coRef.e8ContentProtection;
   e8ContentType = coRef.e8ContentType;
   oContentDescription = coRef.oContentDescription;
   oTransmissionParameter = coRef.oTransmissionParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSourceInfoStatus::most_telfi_tclMsgSourceInfoStatus()
:u8SourceNr(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
,e8TransmissionClass()
,e8ContentProtection()
,e8ContentType()
,oContentDescription()
,oTransmissionParameter()
 {}

tS32 most_telfi_tclMsgSourceInfoStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceInfoStatus;
}


most_telfi_tclMsgSourceInfoStatus::~most_telfi_tclMsgSourceInfoStatus()
{}

tU32 most_telfi_tclMsgSourceInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContentDescription.u32GetSize(u16MajorVersion);
   u32DynamicSize += oTransmissionParameter.u32GetSize(u16MajorVersion);
   return 8 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSourceInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   (tVoid) (oIn >> e8TransmissionClass);
   (tVoid) (oIn >> e8ContentProtection);
   (tVoid) (oIn >> e8ContentType);
   (tVoid) (oIn >> oContentDescription);
   (tVoid) (oIn >> oTransmissionParameter);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSourceInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   (tVoid) (oOut << e8TransmissionClass);
   (tVoid) (oOut << e8ContentProtection);
   (tVoid) (oOut << e8ContentType);
   (tVoid) (oOut << oContentDescription);
   (tVoid) (oOut << oTransmissionParameter);
   return oOut;
}

tBool most_telfi_tclMsgSourceInfoStatus::operator==(const most_telfi_tclMsgSourceInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   bResult = bResult && (e8TransmissionClass == roRef.e8TransmissionClass);
   bResult = bResult && (e8ContentProtection == roRef.e8ContentProtection);
   bResult = bResult && (e8ContentType == roRef.e8ContentType);
   bResult = bResult && (oContentDescription == roRef.oContentDescription);
   bResult = bResult && (oTransmissionParameter == roRef.oTransmissionParameter);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSourceAvailableUpReg::most_telfi_tclMsgSourceAvailableUpReg()
 {}

tS32 most_telfi_tclMsgSourceAvailableUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceAvailableUpReg;
}


most_telfi_tclMsgSourceAvailableUpReg::~most_telfi_tclMsgSourceAvailableUpReg()
{}

//=============================================================================

most_telfi_tclMsgSourceAvailableRelUpReg::most_telfi_tclMsgSourceAvailableRelUpReg()
 {}

tS32 most_telfi_tclMsgSourceAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceAvailableRelUpReg;
}


most_telfi_tclMsgSourceAvailableRelUpReg::~most_telfi_tclMsgSourceAvailableRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgSourceAvailableGet::most_telfi_tclMsgSourceAvailableGet()
 {}

tS32 most_telfi_tclMsgSourceAvailableGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceAvailableGet;
}


most_telfi_tclMsgSourceAvailableGet::~most_telfi_tclMsgSourceAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceAvailableError::most_telfi_tclMsgSourceAvailableError(const most_telfi_tclMsgSourceAvailableError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgSourceAvailableError& most_telfi_tclMsgSourceAvailableError::operator=(const most_telfi_tclMsgSourceAvailableError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgSourceAvailableError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceAvailableError;
}


most_telfi_tclMsgSourceAvailableError::~most_telfi_tclMsgSourceAvailableError()
{}

tBool most_telfi_tclMsgSourceAvailableError::operator==(const most_telfi_tclMsgSourceAvailableError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSourceAvailableStatus::most_telfi_tclMsgSourceAvailableStatus(const most_telfi_tclMsgSourceAvailableStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bSourceAvailable = coRef.bSourceAvailable;
}
most_telfi_tclMsgSourceAvailableStatus& most_telfi_tclMsgSourceAvailableStatus::operator=(const most_telfi_tclMsgSourceAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   bSourceAvailable = coRef.bSourceAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSourceAvailableStatus::most_telfi_tclMsgSourceAvailableStatus()
:bSourceAvailable(0)
 {}

tS32 most_telfi_tclMsgSourceAvailableStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SourceAvailableStatus;
}


most_telfi_tclMsgSourceAvailableStatus::~most_telfi_tclMsgSourceAvailableStatus()
{}

tU32 most_telfi_tclMsgSourceAvailableStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgSourceAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSourceAvailable);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSourceAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSourceAvailable);
   return oOut;
}

tBool most_telfi_tclMsgSourceAvailableStatus::operator==(const most_telfi_tclMsgSourceAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSourceAvailable == roRef.bSourceAvailable);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgActiveCallinHandsetUpReg::most_telfi_tclMsgActiveCallinHandsetUpReg()
 {}

tS32 most_telfi_tclMsgActiveCallinHandsetUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActiveCallinHandsetUpReg;
}


most_telfi_tclMsgActiveCallinHandsetUpReg::~most_telfi_tclMsgActiveCallinHandsetUpReg()
{}

//=============================================================================

most_telfi_tclMsgActiveCallinHandsetRelUpReg::most_telfi_tclMsgActiveCallinHandsetRelUpReg()
 {}

tS32 most_telfi_tclMsgActiveCallinHandsetRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActiveCallinHandsetRelUpReg;
}


most_telfi_tclMsgActiveCallinHandsetRelUpReg::~most_telfi_tclMsgActiveCallinHandsetRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgActiveCallinHandsetGet::most_telfi_tclMsgActiveCallinHandsetGet()
 {}

tS32 most_telfi_tclMsgActiveCallinHandsetGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActiveCallinHandsetGet;
}


most_telfi_tclMsgActiveCallinHandsetGet::~most_telfi_tclMsgActiveCallinHandsetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgActiveCallinHandsetError::most_telfi_tclMsgActiveCallinHandsetError(const most_telfi_tclMsgActiveCallinHandsetError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgActiveCallinHandsetError& most_telfi_tclMsgActiveCallinHandsetError::operator=(const most_telfi_tclMsgActiveCallinHandsetError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgActiveCallinHandsetError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActiveCallinHandsetError;
}


most_telfi_tclMsgActiveCallinHandsetError::~most_telfi_tclMsgActiveCallinHandsetError()
{}

tBool most_telfi_tclMsgActiveCallinHandsetError::operator==(const most_telfi_tclMsgActiveCallinHandsetError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgActiveCallinHandsetStatus::most_telfi_tclMsgActiveCallinHandsetStatus(const most_telfi_tclMsgActiveCallinHandsetStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oActiveCallinHandsetStream = coRef.oActiveCallinHandsetStream;
}
most_telfi_tclMsgActiveCallinHandsetStatus& most_telfi_tclMsgActiveCallinHandsetStatus::operator=(const most_telfi_tclMsgActiveCallinHandsetStatus& coRef)
{
   if (this == &coRef) return *this;
   oActiveCallinHandsetStream = coRef.oActiveCallinHandsetStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgActiveCallinHandsetStatus::most_telfi_tclMsgActiveCallinHandsetStatus()
:oActiveCallinHandsetStream()
 {}

tS32 most_telfi_tclMsgActiveCallinHandsetStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActiveCallinHandsetStatus;
}


most_telfi_tclMsgActiveCallinHandsetStatus::~most_telfi_tclMsgActiveCallinHandsetStatus()
{}

tU32 most_telfi_tclMsgActiveCallinHandsetStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oActiveCallinHandsetStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgActiveCallinHandsetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oActiveCallinHandsetStream);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgActiveCallinHandsetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oActiveCallinHandsetStream);
   return oOut;
}

tBool most_telfi_tclMsgActiveCallinHandsetStatus::operator==(const most_telfi_tclMsgActiveCallinHandsetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oActiveCallinHandsetStream == roRef.oActiveCallinHandsetStream);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCallStatusNoticeUpReg::most_telfi_tclMsgCallStatusNoticeUpReg()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeUpReg;
}


most_telfi_tclMsgCallStatusNoticeUpReg::~most_telfi_tclMsgCallStatusNoticeUpReg()
{}

//=============================================================================

most_telfi_tclMsgCallStatusNoticeRelUpReg::most_telfi_tclMsgCallStatusNoticeRelUpReg()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeRelUpReg;
}


most_telfi_tclMsgCallStatusNoticeRelUpReg::~most_telfi_tclMsgCallStatusNoticeRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgCallStatusNoticeGet::most_telfi_tclMsgCallStatusNoticeGet()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeGet;
}


most_telfi_tclMsgCallStatusNoticeGet::~most_telfi_tclMsgCallStatusNoticeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCallStatusNoticeError::most_telfi_tclMsgCallStatusNoticeError(const most_telfi_tclMsgCallStatusNoticeError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCallStatusNoticeError& most_telfi_tclMsgCallStatusNoticeError::operator=(const most_telfi_tclMsgCallStatusNoticeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCallStatusNoticeError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeError;
}


most_telfi_tclMsgCallStatusNoticeError::~most_telfi_tclMsgCallStatusNoticeError()
{}

tBool most_telfi_tclMsgCallStatusNoticeError::operator==(const most_telfi_tclMsgCallStatusNoticeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCallStatusNoticeStatus::most_telfi_tclMsgCallStatusNoticeStatus(const most_telfi_tclMsgCallStatusNoticeStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oCallStatusNoticeStream = coRef.oCallStatusNoticeStream;
}
most_telfi_tclMsgCallStatusNoticeStatus& most_telfi_tclMsgCallStatusNoticeStatus::operator=(const most_telfi_tclMsgCallStatusNoticeStatus& coRef)
{
   if (this == &coRef) return *this;
   oCallStatusNoticeStream = coRef.oCallStatusNoticeStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgCallStatusNoticeStatus::most_telfi_tclMsgCallStatusNoticeStatus()
:oCallStatusNoticeStream()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeStatus;
}


most_telfi_tclMsgCallStatusNoticeStatus::~most_telfi_tclMsgCallStatusNoticeStatus()
{}

tU32 most_telfi_tclMsgCallStatusNoticeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oCallStatusNoticeStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgCallStatusNoticeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oCallStatusNoticeStream);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCallStatusNoticeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oCallStatusNoticeStream);
   return oOut;
}

tBool most_telfi_tclMsgCallStatusNoticeStatus::operator==(const most_telfi_tclMsgCallStatusNoticeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oCallStatusNoticeStream == roRef.oCallStatusNoticeStream);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCellDeviceNameUpReg::most_telfi_tclMsgCellDeviceNameUpReg()
 {}

tS32 most_telfi_tclMsgCellDeviceNameUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellDeviceNameUpReg;
}


most_telfi_tclMsgCellDeviceNameUpReg::~most_telfi_tclMsgCellDeviceNameUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellDeviceNameRelUpReg::most_telfi_tclMsgCellDeviceNameRelUpReg()
 {}

tS32 most_telfi_tclMsgCellDeviceNameRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellDeviceNameRelUpReg;
}


most_telfi_tclMsgCellDeviceNameRelUpReg::~most_telfi_tclMsgCellDeviceNameRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellDeviceNameGet::most_telfi_tclMsgCellDeviceNameGet()
 {}

tS32 most_telfi_tclMsgCellDeviceNameGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellDeviceNameGet;
}


most_telfi_tclMsgCellDeviceNameGet::~most_telfi_tclMsgCellDeviceNameGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellDeviceNameError::most_telfi_tclMsgCellDeviceNameError(const most_telfi_tclMsgCellDeviceNameError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCellDeviceNameError& most_telfi_tclMsgCellDeviceNameError::operator=(const most_telfi_tclMsgCellDeviceNameError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCellDeviceNameError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellDeviceNameError;
}


most_telfi_tclMsgCellDeviceNameError::~most_telfi_tclMsgCellDeviceNameError()
{}

tBool most_telfi_tclMsgCellDeviceNameError::operator==(const most_telfi_tclMsgCellDeviceNameError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellDeviceNameStatus::most_telfi_tclMsgCellDeviceNameStatus(const most_telfi_tclMsgCellDeviceNameStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sDeviceName = coRef.sDeviceName;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgCellDeviceNameStatus& most_telfi_tclMsgCellDeviceNameStatus::operator=(const most_telfi_tclMsgCellDeviceNameStatus& coRef)
{
   if (this == &coRef) return *this;
   sDeviceName = coRef.sDeviceName;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgCellDeviceNameStatus::vDestroy()
{
   sDeviceName.vDestroy(); 
}

most_telfi_tclMsgCellDeviceNameStatus::most_telfi_tclMsgCellDeviceNameStatus()
:sDeviceName()
,u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgCellDeviceNameStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellDeviceNameStatus;
}


most_telfi_tclMsgCellDeviceNameStatus::~most_telfi_tclMsgCellDeviceNameStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgCellDeviceNameStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgCellDeviceNameStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCellDeviceNameStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgCellDeviceNameStatus::operator==(const most_telfi_tclMsgCellDeviceNameStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCellNetworkStatusUpReg::most_telfi_tclMsgCellNetworkStatusUpReg()
 {}

tS32 most_telfi_tclMsgCellNetworkStatusUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellNetworkStatusUpReg;
}


most_telfi_tclMsgCellNetworkStatusUpReg::~most_telfi_tclMsgCellNetworkStatusUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellNetworkStatusRelUpReg::most_telfi_tclMsgCellNetworkStatusRelUpReg()
 {}

tS32 most_telfi_tclMsgCellNetworkStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellNetworkStatusRelUpReg;
}


most_telfi_tclMsgCellNetworkStatusRelUpReg::~most_telfi_tclMsgCellNetworkStatusRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellNetworkStatusGet::most_telfi_tclMsgCellNetworkStatusGet()
 {}

tS32 most_telfi_tclMsgCellNetworkStatusGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellNetworkStatusGet;
}


most_telfi_tclMsgCellNetworkStatusGet::~most_telfi_tclMsgCellNetworkStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellNetworkStatusError::most_telfi_tclMsgCellNetworkStatusError(const most_telfi_tclMsgCellNetworkStatusError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCellNetworkStatusError& most_telfi_tclMsgCellNetworkStatusError::operator=(const most_telfi_tclMsgCellNetworkStatusError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCellNetworkStatusError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellNetworkStatusError;
}


most_telfi_tclMsgCellNetworkStatusError::~most_telfi_tclMsgCellNetworkStatusError()
{}

tBool most_telfi_tclMsgCellNetworkStatusError::operator==(const most_telfi_tclMsgCellNetworkStatusError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellNetworkStatusStatus::most_telfi_tclMsgCellNetworkStatusStatus(const most_telfi_tclMsgCellNetworkStatusStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8CellService = coRef.e8CellService;
   bRoamingStatus = coRef.bRoamingStatus;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgCellNetworkStatusStatus& most_telfi_tclMsgCellNetworkStatusStatus::operator=(const most_telfi_tclMsgCellNetworkStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CellService = coRef.e8CellService;
   bRoamingStatus = coRef.bRoamingStatus;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgCellNetworkStatusStatus::most_telfi_tclMsgCellNetworkStatusStatus()
:e8CellService()
,bRoamingStatus(0)
,u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgCellNetworkStatusStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellNetworkStatusStatus;
}


most_telfi_tclMsgCellNetworkStatusStatus::~most_telfi_tclMsgCellNetworkStatusStatus()
{}

tU32 most_telfi_tclMsgCellNetworkStatusStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_telfi_tclMsgCellNetworkStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CellService);
   (tVoid) (oIn >> bRoamingStatus);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCellNetworkStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CellService);
   (tVoid) (oOut << bRoamingStatus);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgCellNetworkStatusStatus::operator==(const most_telfi_tclMsgCellNetworkStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CellService == roRef.e8CellService);
   bResult = bResult && (bRoamingStatus == roRef.bRoamingStatus);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCellSignalStrengthUpReg::most_telfi_tclMsgCellSignalStrengthUpReg()
 {}

tS32 most_telfi_tclMsgCellSignalStrengthUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellSignalStrengthUpReg;
}


most_telfi_tclMsgCellSignalStrengthUpReg::~most_telfi_tclMsgCellSignalStrengthUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellSignalStrengthRelUpReg::most_telfi_tclMsgCellSignalStrengthRelUpReg()
 {}

tS32 most_telfi_tclMsgCellSignalStrengthRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellSignalStrengthRelUpReg;
}


most_telfi_tclMsgCellSignalStrengthRelUpReg::~most_telfi_tclMsgCellSignalStrengthRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellSignalStrengthGet::most_telfi_tclMsgCellSignalStrengthGet()
 {}

tS32 most_telfi_tclMsgCellSignalStrengthGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellSignalStrengthGet;
}


most_telfi_tclMsgCellSignalStrengthGet::~most_telfi_tclMsgCellSignalStrengthGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellSignalStrengthError::most_telfi_tclMsgCellSignalStrengthError(const most_telfi_tclMsgCellSignalStrengthError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCellSignalStrengthError& most_telfi_tclMsgCellSignalStrengthError::operator=(const most_telfi_tclMsgCellSignalStrengthError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCellSignalStrengthError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellSignalStrengthError;
}


most_telfi_tclMsgCellSignalStrengthError::~most_telfi_tclMsgCellSignalStrengthError()
{}

tBool most_telfi_tclMsgCellSignalStrengthError::operator==(const most_telfi_tclMsgCellSignalStrengthError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellSignalStrengthStatus::most_telfi_tclMsgCellSignalStrengthStatus(const most_telfi_tclMsgCellSignalStrengthStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8SignalSrength = coRef.u8SignalSrength;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgCellSignalStrengthStatus& most_telfi_tclMsgCellSignalStrengthStatus::operator=(const most_telfi_tclMsgCellSignalStrengthStatus& coRef)
{
   if (this == &coRef) return *this;
   u8SignalSrength = coRef.u8SignalSrength;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgCellSignalStrengthStatus::most_telfi_tclMsgCellSignalStrengthStatus()
:u8SignalSrength(0)
,u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgCellSignalStrengthStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellSignalStrengthStatus;
}


most_telfi_tclMsgCellSignalStrengthStatus::~most_telfi_tclMsgCellSignalStrengthStatus()
{}

tU32 most_telfi_tclMsgCellSignalStrengthStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgCellSignalStrengthStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SignalSrength);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCellSignalStrengthStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SignalSrength);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgCellSignalStrengthStatus::operator==(const most_telfi_tclMsgCellSignalStrengthStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SignalSrength == roRef.u8SignalSrength);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCellStateofChargeUpReg::most_telfi_tclMsgCellStateofChargeUpReg()
 {}

tS32 most_telfi_tclMsgCellStateofChargeUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellStateofChargeUpReg;
}


most_telfi_tclMsgCellStateofChargeUpReg::~most_telfi_tclMsgCellStateofChargeUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellStateofChargeRelUpReg::most_telfi_tclMsgCellStateofChargeRelUpReg()
 {}

tS32 most_telfi_tclMsgCellStateofChargeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellStateofChargeRelUpReg;
}


most_telfi_tclMsgCellStateofChargeRelUpReg::~most_telfi_tclMsgCellStateofChargeRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgCellStateofChargeGet::most_telfi_tclMsgCellStateofChargeGet()
 {}

tS32 most_telfi_tclMsgCellStateofChargeGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellStateofChargeGet;
}


most_telfi_tclMsgCellStateofChargeGet::~most_telfi_tclMsgCellStateofChargeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellStateofChargeError::most_telfi_tclMsgCellStateofChargeError(const most_telfi_tclMsgCellStateofChargeError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCellStateofChargeError& most_telfi_tclMsgCellStateofChargeError::operator=(const most_telfi_tclMsgCellStateofChargeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCellStateofChargeError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellStateofChargeError;
}


most_telfi_tclMsgCellStateofChargeError::~most_telfi_tclMsgCellStateofChargeError()
{}

tBool most_telfi_tclMsgCellStateofChargeError::operator==(const most_telfi_tclMsgCellStateofChargeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCellStateofChargeStatus::most_telfi_tclMsgCellStateofChargeStatus(const most_telfi_tclMsgCellStateofChargeStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8StateofCharge = coRef.u8StateofCharge;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgCellStateofChargeStatus& most_telfi_tclMsgCellStateofChargeStatus::operator=(const most_telfi_tclMsgCellStateofChargeStatus& coRef)
{
   if (this == &coRef) return *this;
   u8StateofCharge = coRef.u8StateofCharge;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgCellStateofChargeStatus::most_telfi_tclMsgCellStateofChargeStatus()
:u8StateofCharge(0)
,u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgCellStateofChargeStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CellStateofChargeStatus;
}


most_telfi_tclMsgCellStateofChargeStatus::~most_telfi_tclMsgCellStateofChargeStatus()
{}

tU32 most_telfi_tclMsgCellStateofChargeStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgCellStateofChargeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8StateofCharge);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCellStateofChargeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8StateofCharge);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgCellStateofChargeStatus::operator==(const most_telfi_tclMsgCellStateofChargeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8StateofCharge == roRef.u8StateofCharge);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgInComingCallEventUpReg::most_telfi_tclMsgInComingCallEventUpReg()
 {}

tS32 most_telfi_tclMsgInComingCallEventUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_InComingCallEventUpReg;
}


most_telfi_tclMsgInComingCallEventUpReg::~most_telfi_tclMsgInComingCallEventUpReg()
{}

//=============================================================================

most_telfi_tclMsgInComingCallEventRelUpReg::most_telfi_tclMsgInComingCallEventRelUpReg()
 {}

tS32 most_telfi_tclMsgInComingCallEventRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_InComingCallEventRelUpReg;
}


most_telfi_tclMsgInComingCallEventRelUpReg::~most_telfi_tclMsgInComingCallEventRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgInComingCallEventGet::most_telfi_tclMsgInComingCallEventGet()
 {}

tS32 most_telfi_tclMsgInComingCallEventGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_InComingCallEventGet;
}


most_telfi_tclMsgInComingCallEventGet::~most_telfi_tclMsgInComingCallEventGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgInComingCallEventError::most_telfi_tclMsgInComingCallEventError(const most_telfi_tclMsgInComingCallEventError& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
}
most_telfi_tclMsgInComingCallEventError& most_telfi_tclMsgInComingCallEventError::operator=(const most_telfi_tclMsgInComingCallEventError& coRef)
{
   if (this == &coRef) return *this;
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgInComingCallEventError::most_telfi_tclMsgInComingCallEventError()
:oErrorInfo()
,e8ErrorCode()
 {}

tS32 most_telfi_tclMsgInComingCallEventError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_InComingCallEventError;
}


most_telfi_tclMsgInComingCallEventError::~most_telfi_tclMsgInComingCallEventError()
{}

tU32 most_telfi_tclMsgInComingCallEventError::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgInComingCallEventError::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oErrorInfo);
   (tVoid) (oIn >> e8ErrorCode);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgInComingCallEventError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oErrorInfo);
   (tVoid) (oOut << e8ErrorCode);
   return oOut;
}

tBool most_telfi_tclMsgInComingCallEventError::operator==(const most_telfi_tclMsgInComingCallEventError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgInComingCallEventStatus::most_telfi_tclMsgInComingCallEventStatus(const most_telfi_tclMsgInComingCallEventStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8IncomingCallEventEnum = coRef.e8IncomingCallEventEnum;
   u16CallInstance = coRef.u16CallInstance;
   sTelephoneNumber = coRef.sTelephoneNumber;
   sFirstName = coRef.sFirstName;
   sLastName = coRef.sLastName;
   bCallWait = coRef.bCallWait;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgInComingCallEventStatus& most_telfi_tclMsgInComingCallEventStatus::operator=(const most_telfi_tclMsgInComingCallEventStatus& coRef)
{
   if (this == &coRef) return *this;
   e8IncomingCallEventEnum = coRef.e8IncomingCallEventEnum;
   u16CallInstance = coRef.u16CallInstance;
   sTelephoneNumber = coRef.sTelephoneNumber;
   sFirstName = coRef.sFirstName;
   sLastName = coRef.sLastName;
   bCallWait = coRef.bCallWait;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgInComingCallEventStatus::vDestroy()
{
   sTelephoneNumber.vDestroy(); 
   sFirstName.vDestroy(); 
   sLastName.vDestroy(); 
}

most_telfi_tclMsgInComingCallEventStatus::most_telfi_tclMsgInComingCallEventStatus()
:e8IncomingCallEventEnum()
,u16CallInstance(0)
,sTelephoneNumber()
,sFirstName()
,sLastName()
,bCallWait(0)
,u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgInComingCallEventStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_InComingCallEventStatus;
}


most_telfi_tclMsgInComingCallEventStatus::~most_telfi_tclMsgInComingCallEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgInComingCallEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sTelephoneNumber.u32GetSize(u16MajorVersion);
   u32DynamicSize += sFirstName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sLastName.u32GetSize(u16MajorVersion);
   return 5 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgInComingCallEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8IncomingCallEventEnum);
   (tVoid) (oIn >> u16CallInstance);
   (tVoid) (oIn >> sTelephoneNumber);
   (tVoid) (oIn >> sFirstName);
   (tVoid) (oIn >> sLastName);
   (tVoid) (oIn >> bCallWait);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgInComingCallEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8IncomingCallEventEnum);
   (tVoid) (oOut << u16CallInstance);
   (tVoid) (oOut << sTelephoneNumber);
   (tVoid) (oOut << sFirstName);
   (tVoid) (oOut << sLastName);
   (tVoid) (oOut << bCallWait);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgInComingCallEventStatus::operator==(const most_telfi_tclMsgInComingCallEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8IncomingCallEventEnum == roRef.e8IncomingCallEventEnum);
   bResult = bResult && (u16CallInstance == roRef.u16CallInstance);
   bResult = bResult && (sTelephoneNumber == roRef.sTelephoneNumber);
   bResult = bResult && (sFirstName == roRef.sFirstName);
   bResult = bResult && (sLastName == roRef.sLastName);
   bResult = bResult && (bCallWait == roRef.bCallWait);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgNetworkOperatorUpReg::most_telfi_tclMsgNetworkOperatorUpReg()
 {}

tS32 most_telfi_tclMsgNetworkOperatorUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_NetworkOperatorUpReg;
}


most_telfi_tclMsgNetworkOperatorUpReg::~most_telfi_tclMsgNetworkOperatorUpReg()
{}

//=============================================================================

most_telfi_tclMsgNetworkOperatorRelUpReg::most_telfi_tclMsgNetworkOperatorRelUpReg()
 {}

tS32 most_telfi_tclMsgNetworkOperatorRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_NetworkOperatorRelUpReg;
}


most_telfi_tclMsgNetworkOperatorRelUpReg::~most_telfi_tclMsgNetworkOperatorRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgNetworkOperatorGet::most_telfi_tclMsgNetworkOperatorGet()
 {}

tS32 most_telfi_tclMsgNetworkOperatorGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_NetworkOperatorGet;
}


most_telfi_tclMsgNetworkOperatorGet::~most_telfi_tclMsgNetworkOperatorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgNetworkOperatorError::most_telfi_tclMsgNetworkOperatorError(const most_telfi_tclMsgNetworkOperatorError& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
}
most_telfi_tclMsgNetworkOperatorError& most_telfi_tclMsgNetworkOperatorError::operator=(const most_telfi_tclMsgNetworkOperatorError& coRef)
{
   if (this == &coRef) return *this;
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgNetworkOperatorError::most_telfi_tclMsgNetworkOperatorError()
:oErrorInfo()
,e8ErrorCode()
 {}

tS32 most_telfi_tclMsgNetworkOperatorError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_NetworkOperatorError;
}


most_telfi_tclMsgNetworkOperatorError::~most_telfi_tclMsgNetworkOperatorError()
{}

tU32 most_telfi_tclMsgNetworkOperatorError::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgNetworkOperatorError::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oErrorInfo);
   (tVoid) (oIn >> e8ErrorCode);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgNetworkOperatorError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oErrorInfo);
   (tVoid) (oOut << e8ErrorCode);
   return oOut;
}

tBool most_telfi_tclMsgNetworkOperatorError::operator==(const most_telfi_tclMsgNetworkOperatorError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgNetworkOperatorStatus::most_telfi_tclMsgNetworkOperatorStatus(const most_telfi_tclMsgNetworkOperatorStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sNetworkOperator = coRef.sNetworkOperator;
}
most_telfi_tclMsgNetworkOperatorStatus& most_telfi_tclMsgNetworkOperatorStatus::operator=(const most_telfi_tclMsgNetworkOperatorStatus& coRef)
{
   if (this == &coRef) return *this;
   sNetworkOperator = coRef.sNetworkOperator;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgNetworkOperatorStatus::vDestroy()
{
   sNetworkOperator.vDestroy(); 
}

most_telfi_tclMsgNetworkOperatorStatus::most_telfi_tclMsgNetworkOperatorStatus()
:sNetworkOperator()
 {}

tS32 most_telfi_tclMsgNetworkOperatorStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_NetworkOperatorStatus;
}


most_telfi_tclMsgNetworkOperatorStatus::~most_telfi_tclMsgNetworkOperatorStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgNetworkOperatorStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sNetworkOperator.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgNetworkOperatorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sNetworkOperator);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgNetworkOperatorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sNetworkOperator);
   return oOut;
}

tBool most_telfi_tclMsgNetworkOperatorStatus::operator==(const most_telfi_tclMsgNetworkOperatorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sNetworkOperator == roRef.sNetworkOperator);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSLCStatusUpReg::most_telfi_tclMsgSLCStatusUpReg()
 {}

tS32 most_telfi_tclMsgSLCStatusUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SLCStatusUpReg;
}


most_telfi_tclMsgSLCStatusUpReg::~most_telfi_tclMsgSLCStatusUpReg()
{}

//=============================================================================

most_telfi_tclMsgSLCStatusRelUpReg::most_telfi_tclMsgSLCStatusRelUpReg()
 {}

tS32 most_telfi_tclMsgSLCStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SLCStatusRelUpReg;
}


most_telfi_tclMsgSLCStatusRelUpReg::~most_telfi_tclMsgSLCStatusRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgSLCStatusGet::most_telfi_tclMsgSLCStatusGet()
 {}

tS32 most_telfi_tclMsgSLCStatusGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SLCStatusGet;
}


most_telfi_tclMsgSLCStatusGet::~most_telfi_tclMsgSLCStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSLCStatusError::most_telfi_tclMsgSLCStatusError(const most_telfi_tclMsgSLCStatusError& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
}
most_telfi_tclMsgSLCStatusError& most_telfi_tclMsgSLCStatusError::operator=(const most_telfi_tclMsgSLCStatusError& coRef)
{
   if (this == &coRef) return *this;
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSLCStatusError::most_telfi_tclMsgSLCStatusError()
:oErrorInfo()
,e8ErrorCode()
 {}

tS32 most_telfi_tclMsgSLCStatusError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SLCStatusError;
}


most_telfi_tclMsgSLCStatusError::~most_telfi_tclMsgSLCStatusError()
{}

tU32 most_telfi_tclMsgSLCStatusError::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSLCStatusError::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oErrorInfo);
   (tVoid) (oIn >> e8ErrorCode);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSLCStatusError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oErrorInfo);
   (tVoid) (oOut << e8ErrorCode);
   return oOut;
}

tBool most_telfi_tclMsgSLCStatusError::operator==(const most_telfi_tclMsgSLCStatusError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSLCStatusStatus::most_telfi_tclMsgSLCStatusStatus(const most_telfi_tclMsgSLCStatusStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bCommandStatus = coRef.bCommandStatus;
}
most_telfi_tclMsgSLCStatusStatus& most_telfi_tclMsgSLCStatusStatus::operator=(const most_telfi_tclMsgSLCStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   bCommandStatus = coRef.bCommandStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgSLCStatusStatus::most_telfi_tclMsgSLCStatusStatus()
:bCommandStatus(0)
 {}

tS32 most_telfi_tclMsgSLCStatusStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SLCStatusStatus;
}


most_telfi_tclMsgSLCStatusStatus::~most_telfi_tclMsgSLCStatusStatus()
{}

tU32 most_telfi_tclMsgSLCStatusStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgSLCStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bCommandStatus);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSLCStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bCommandStatus);
   return oOut;
}

tBool most_telfi_tclMsgSLCStatusStatus::operator==(const most_telfi_tclMsgSLCStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bCommandStatus == roRef.bCommandStatus);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgVehicleAudioUpReg::most_telfi_tclMsgVehicleAudioUpReg()
 {}

tS32 most_telfi_tclMsgVehicleAudioUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VehicleAudioUpReg;
}


most_telfi_tclMsgVehicleAudioUpReg::~most_telfi_tclMsgVehicleAudioUpReg()
{}

//=============================================================================

most_telfi_tclMsgVehicleAudioRelUpReg::most_telfi_tclMsgVehicleAudioRelUpReg()
 {}

tS32 most_telfi_tclMsgVehicleAudioRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VehicleAudioRelUpReg;
}


most_telfi_tclMsgVehicleAudioRelUpReg::~most_telfi_tclMsgVehicleAudioRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgVehicleAudioGet::most_telfi_tclMsgVehicleAudioGet()
 {}

tS32 most_telfi_tclMsgVehicleAudioGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VehicleAudioGet;
}


most_telfi_tclMsgVehicleAudioGet::~most_telfi_tclMsgVehicleAudioGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgVehicleAudioError::most_telfi_tclMsgVehicleAudioError(const most_telfi_tclMsgVehicleAudioError& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
}
most_telfi_tclMsgVehicleAudioError& most_telfi_tclMsgVehicleAudioError::operator=(const most_telfi_tclMsgVehicleAudioError& coRef)
{
   if (this == &coRef) return *this;
   oErrorInfo = coRef.oErrorInfo;
   e8ErrorCode = coRef.e8ErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgVehicleAudioError::most_telfi_tclMsgVehicleAudioError()
:oErrorInfo()
,e8ErrorCode()
 {}

tS32 most_telfi_tclMsgVehicleAudioError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VehicleAudioError;
}


most_telfi_tclMsgVehicleAudioError::~most_telfi_tclMsgVehicleAudioError()
{}

tU32 most_telfi_tclMsgVehicleAudioError::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgVehicleAudioError::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oErrorInfo);
   (tVoid) (oIn >> e8ErrorCode);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgVehicleAudioError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oErrorInfo);
   (tVoid) (oOut << e8ErrorCode);
   return oOut;
}

tBool most_telfi_tclMsgVehicleAudioError::operator==(const most_telfi_tclMsgVehicleAudioError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgVehicleAudioStatus::most_telfi_tclMsgVehicleAudioStatus(const most_telfi_tclMsgVehicleAudioStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
}
most_telfi_tclMsgVehicleAudioStatus& most_telfi_tclMsgVehicleAudioStatus::operator=(const most_telfi_tclMsgVehicleAudioStatus& coRef)
{
   if (this == &coRef) return *this;
   bUsingVehicleAudio = coRef.bUsingVehicleAudio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgVehicleAudioStatus::most_telfi_tclMsgVehicleAudioStatus()
:bUsingVehicleAudio(0)
 {}

tS32 most_telfi_tclMsgVehicleAudioStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_VehicleAudioStatus;
}


most_telfi_tclMsgVehicleAudioStatus::~most_telfi_tclMsgVehicleAudioStatus()
{}

tU32 most_telfi_tclMsgVehicleAudioStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgVehicleAudioStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bUsingVehicleAudio);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgVehicleAudioStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bUsingVehicleAudio);
   return oOut;
}

tBool most_telfi_tclMsgVehicleAudioStatus::operator==(const most_telfi_tclMsgVehicleAudioStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bUsingVehicleAudio == roRef.bUsingVehicleAudio);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgMicrophoneMuteStateUpReg::most_telfi_tclMsgMicrophoneMuteStateUpReg()
 {}

tS32 most_telfi_tclMsgMicrophoneMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_MicrophoneMuteStateUpReg;
}


most_telfi_tclMsgMicrophoneMuteStateUpReg::~most_telfi_tclMsgMicrophoneMuteStateUpReg()
{}

//=============================================================================

most_telfi_tclMsgMicrophoneMuteStateRelUpReg::most_telfi_tclMsgMicrophoneMuteStateRelUpReg()
 {}

tS32 most_telfi_tclMsgMicrophoneMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_MicrophoneMuteStateRelUpReg;
}


most_telfi_tclMsgMicrophoneMuteStateRelUpReg::~most_telfi_tclMsgMicrophoneMuteStateRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgMicrophoneMuteStateGet::most_telfi_tclMsgMicrophoneMuteStateGet()
 {}

tS32 most_telfi_tclMsgMicrophoneMuteStateGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_MicrophoneMuteStateGet;
}


most_telfi_tclMsgMicrophoneMuteStateGet::~most_telfi_tclMsgMicrophoneMuteStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgMicrophoneMuteStatePureSet::most_telfi_tclMsgMicrophoneMuteStatePureSet(const most_telfi_tclMsgMicrophoneMuteStatePureSet& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bEnable = coRef.bEnable;
}
most_telfi_tclMsgMicrophoneMuteStatePureSet& most_telfi_tclMsgMicrophoneMuteStatePureSet::operator=(const most_telfi_tclMsgMicrophoneMuteStatePureSet& coRef)
{
   if (this == &coRef) return *this;
   bEnable = coRef.bEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgMicrophoneMuteStatePureSet::most_telfi_tclMsgMicrophoneMuteStatePureSet()
:bEnable(0)
 {}

tS32 most_telfi_tclMsgMicrophoneMuteStatePureSet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_MicrophoneMuteStatePureSet;
}


most_telfi_tclMsgMicrophoneMuteStatePureSet::~most_telfi_tclMsgMicrophoneMuteStatePureSet()
{}

tU32 most_telfi_tclMsgMicrophoneMuteStatePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgMicrophoneMuteStatePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnable);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgMicrophoneMuteStatePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnable);
   return oOut;
}

tBool most_telfi_tclMsgMicrophoneMuteStatePureSet::operator==(const most_telfi_tclMsgMicrophoneMuteStatePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnable == roRef.bEnable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgMicrophoneMuteStateError::most_telfi_tclMsgMicrophoneMuteStateError(const most_telfi_tclMsgMicrophoneMuteStateError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgMicrophoneMuteStateError& most_telfi_tclMsgMicrophoneMuteStateError::operator=(const most_telfi_tclMsgMicrophoneMuteStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgMicrophoneMuteStateError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_MicrophoneMuteStateError;
}


most_telfi_tclMsgMicrophoneMuteStateError::~most_telfi_tclMsgMicrophoneMuteStateError()
{}

tBool most_telfi_tclMsgMicrophoneMuteStateError::operator==(const most_telfi_tclMsgMicrophoneMuteStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgMicrophoneMuteStateStatus::most_telfi_tclMsgMicrophoneMuteStateStatus(const most_telfi_tclMsgMicrophoneMuteStateStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bEnable = coRef.bEnable;
}
most_telfi_tclMsgMicrophoneMuteStateStatus& most_telfi_tclMsgMicrophoneMuteStateStatus::operator=(const most_telfi_tclMsgMicrophoneMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   bEnable = coRef.bEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgMicrophoneMuteStateStatus::most_telfi_tclMsgMicrophoneMuteStateStatus()
:bEnable(0)
 {}

tS32 most_telfi_tclMsgMicrophoneMuteStateStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_MicrophoneMuteStateStatus;
}


most_telfi_tclMsgMicrophoneMuteStateStatus::~most_telfi_tclMsgMicrophoneMuteStateStatus()
{}

tU32 most_telfi_tclMsgMicrophoneMuteStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgMicrophoneMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnable);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgMicrophoneMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnable);
   return oOut;
}

tBool most_telfi_tclMsgMicrophoneMuteStateStatus::operator==(const most_telfi_tclMsgMicrophoneMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnable == roRef.bEnable);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgRingtoneMuteStateUpReg::most_telfi_tclMsgRingtoneMuteStateUpReg()
 {}

tS32 most_telfi_tclMsgRingtoneMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtoneMuteStateUpReg;
}


most_telfi_tclMsgRingtoneMuteStateUpReg::~most_telfi_tclMsgRingtoneMuteStateUpReg()
{}

//=============================================================================

most_telfi_tclMsgRingtoneMuteStateRelUpReg::most_telfi_tclMsgRingtoneMuteStateRelUpReg()
 {}

tS32 most_telfi_tclMsgRingtoneMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtoneMuteStateRelUpReg;
}


most_telfi_tclMsgRingtoneMuteStateRelUpReg::~most_telfi_tclMsgRingtoneMuteStateRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgRingtoneMuteStateGet::most_telfi_tclMsgRingtoneMuteStateGet()
 {}

tS32 most_telfi_tclMsgRingtoneMuteStateGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtoneMuteStateGet;
}


most_telfi_tclMsgRingtoneMuteStateGet::~most_telfi_tclMsgRingtoneMuteStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRingtoneMuteStatePureSet::most_telfi_tclMsgRingtoneMuteStatePureSet(const most_telfi_tclMsgRingtoneMuteStatePureSet& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bEnable = coRef.bEnable;
}
most_telfi_tclMsgRingtoneMuteStatePureSet& most_telfi_tclMsgRingtoneMuteStatePureSet::operator=(const most_telfi_tclMsgRingtoneMuteStatePureSet& coRef)
{
   if (this == &coRef) return *this;
   bEnable = coRef.bEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRingtoneMuteStatePureSet::most_telfi_tclMsgRingtoneMuteStatePureSet()
:bEnable(0)
 {}

tS32 most_telfi_tclMsgRingtoneMuteStatePureSet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtoneMuteStatePureSet;
}


most_telfi_tclMsgRingtoneMuteStatePureSet::~most_telfi_tclMsgRingtoneMuteStatePureSet()
{}

tU32 most_telfi_tclMsgRingtoneMuteStatePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgRingtoneMuteStatePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnable);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRingtoneMuteStatePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnable);
   return oOut;
}

tBool most_telfi_tclMsgRingtoneMuteStatePureSet::operator==(const most_telfi_tclMsgRingtoneMuteStatePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnable == roRef.bEnable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRingtoneMuteStateError::most_telfi_tclMsgRingtoneMuteStateError(const most_telfi_tclMsgRingtoneMuteStateError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgRingtoneMuteStateError& most_telfi_tclMsgRingtoneMuteStateError::operator=(const most_telfi_tclMsgRingtoneMuteStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgRingtoneMuteStateError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtoneMuteStateError;
}


most_telfi_tclMsgRingtoneMuteStateError::~most_telfi_tclMsgRingtoneMuteStateError()
{}

tBool most_telfi_tclMsgRingtoneMuteStateError::operator==(const most_telfi_tclMsgRingtoneMuteStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRingtoneMuteStateStatus::most_telfi_tclMsgRingtoneMuteStateStatus(const most_telfi_tclMsgRingtoneMuteStateStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bEnable = coRef.bEnable;
}
most_telfi_tclMsgRingtoneMuteStateStatus& most_telfi_tclMsgRingtoneMuteStateStatus::operator=(const most_telfi_tclMsgRingtoneMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   bEnable = coRef.bEnable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRingtoneMuteStateStatus::most_telfi_tclMsgRingtoneMuteStateStatus()
:bEnable(0)
 {}

tS32 most_telfi_tclMsgRingtoneMuteStateStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtoneMuteStateStatus;
}


most_telfi_tclMsgRingtoneMuteStateStatus::~most_telfi_tclMsgRingtoneMuteStateStatus()
{}

tU32 most_telfi_tclMsgRingtoneMuteStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgRingtoneMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnable);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRingtoneMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnable);
   return oOut;
}

tBool most_telfi_tclMsgRingtoneMuteStateStatus::operator==(const most_telfi_tclMsgRingtoneMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnable == roRef.bEnable);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgHFServiceUpReg::most_telfi_tclMsgHFServiceUpReg()
 {}

tS32 most_telfi_tclMsgHFServiceUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HFServiceUpReg;
}


most_telfi_tclMsgHFServiceUpReg::~most_telfi_tclMsgHFServiceUpReg()
{}

//=============================================================================

most_telfi_tclMsgHFServiceRelUpReg::most_telfi_tclMsgHFServiceRelUpReg()
 {}

tS32 most_telfi_tclMsgHFServiceRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HFServiceRelUpReg;
}


most_telfi_tclMsgHFServiceRelUpReg::~most_telfi_tclMsgHFServiceRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgHFServiceGet::most_telfi_tclMsgHFServiceGet()
 {}

tS32 most_telfi_tclMsgHFServiceGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HFServiceGet;
}


most_telfi_tclMsgHFServiceGet::~most_telfi_tclMsgHFServiceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHFServiceError::most_telfi_tclMsgHFServiceError(const most_telfi_tclMsgHFServiceError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgHFServiceError& most_telfi_tclMsgHFServiceError::operator=(const most_telfi_tclMsgHFServiceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgHFServiceError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HFServiceError;
}


most_telfi_tclMsgHFServiceError::~most_telfi_tclMsgHFServiceError()
{}

tBool most_telfi_tclMsgHFServiceError::operator==(const most_telfi_tclMsgHFServiceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHFServiceStatus::most_telfi_tclMsgHFServiceStatus(const most_telfi_tclMsgHFServiceStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bCallWaitAvail = coRef.bCallWaitAvail;
   bThreeWayCallAvail = coRef.bThreeWayCallAvail;
}
most_telfi_tclMsgHFServiceStatus& most_telfi_tclMsgHFServiceStatus::operator=(const most_telfi_tclMsgHFServiceStatus& coRef)
{
   if (this == &coRef) return *this;
   bCallWaitAvail = coRef.bCallWaitAvail;
   bThreeWayCallAvail = coRef.bThreeWayCallAvail;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgHFServiceStatus::most_telfi_tclMsgHFServiceStatus()
:bCallWaitAvail(0)
,bThreeWayCallAvail(0)
 {}

tS32 most_telfi_tclMsgHFServiceStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HFServiceStatus;
}


most_telfi_tclMsgHFServiceStatus::~most_telfi_tclMsgHFServiceStatus()
{}

tU32 most_telfi_tclMsgHFServiceStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgHFServiceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bCallWaitAvail);
   (tVoid) (oIn >> bThreeWayCallAvail);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgHFServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bCallWaitAvail);
   (tVoid) (oOut << bThreeWayCallAvail);
   return oOut;
}

tBool most_telfi_tclMsgHFServiceStatus::operator==(const most_telfi_tclMsgHFServiceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bCallWaitAvail == roRef.bCallWaitAvail);
   bResult = bResult && (bThreeWayCallAvail == roRef.bThreeWayCallAvail);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg::most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionUpReg;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg::~most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg()
{}

//=============================================================================

most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg::most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionRelUpReg;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg::~most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgBTDeviceVoiceRecognitionGet::most_telfi_tclMsgBTDeviceVoiceRecognitionGet()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionGet;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionGet::~most_telfi_tclMsgBTDeviceVoiceRecognitionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet(const most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
}
most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& coRef)
{
   if (this == &coRef) return *this;
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet()
:bBTDeviceVoiceRecActive(0)
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionPureSet;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::~most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet()
{}

tU32 most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBTDeviceVoiceRecActive);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBTDeviceVoiceRecActive);
   return oOut;
}

tBool most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet::operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBTDeviceVoiceRecActive == roRef.bBTDeviceVoiceRecActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgBTDeviceVoiceRecognitionError::most_telfi_tclMsgBTDeviceVoiceRecognitionError(const most_telfi_tclMsgBTDeviceVoiceRecognitionError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgBTDeviceVoiceRecognitionError& most_telfi_tclMsgBTDeviceVoiceRecognitionError::operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionError;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionError::~most_telfi_tclMsgBTDeviceVoiceRecognitionError()
{}

tBool most_telfi_tclMsgBTDeviceVoiceRecognitionError::operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::most_telfi_tclMsgBTDeviceVoiceRecognitionStatus(const most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
   bBTDeviceVoiceRecSupported = coRef.bBTDeviceVoiceRecSupported;
}
most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& coRef)
{
   if (this == &coRef) return *this;
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
   bBTDeviceVoiceRecSupported = coRef.bBTDeviceVoiceRecSupported;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::most_telfi_tclMsgBTDeviceVoiceRecognitionStatus()
:bBTDeviceVoiceRecActive(0)
,bBTDeviceVoiceRecSupported(0)
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionStatus;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::~most_telfi_tclMsgBTDeviceVoiceRecognitionStatus()
{}

tU32 most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBTDeviceVoiceRecActive);
   (tVoid) (oIn >> bBTDeviceVoiceRecSupported);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBTDeviceVoiceRecActive);
   (tVoid) (oOut << bBTDeviceVoiceRecSupported);
   return oOut;
}

tBool most_telfi_tclMsgBTDeviceVoiceRecognitionStatus::operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBTDeviceVoiceRecActive == roRef.bBTDeviceVoiceRecActive);
   bResult = bResult && (bBTDeviceVoiceRecSupported == roRef.bBTDeviceVoiceRecSupported);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg::most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg()
 {}

tS32 most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlUpReg;
}


most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg::~most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg()
{}

//=============================================================================

most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg::most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg()
 {}

tS32 most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlRelUpReg;
}


most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg::~most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgHandsFreeEnhancedCallControlGet::most_telfi_tclMsgHandsFreeEnhancedCallControlGet()
 {}

tS32 most_telfi_tclMsgHandsFreeEnhancedCallControlGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlGet;
}


most_telfi_tclMsgHandsFreeEnhancedCallControlGet::~most_telfi_tclMsgHandsFreeEnhancedCallControlGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHandsFreeEnhancedCallControlError::most_telfi_tclMsgHandsFreeEnhancedCallControlError(const most_telfi_tclMsgHandsFreeEnhancedCallControlError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgHandsFreeEnhancedCallControlError& most_telfi_tclMsgHandsFreeEnhancedCallControlError::operator=(const most_telfi_tclMsgHandsFreeEnhancedCallControlError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgHandsFreeEnhancedCallControlError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlError;
}


most_telfi_tclMsgHandsFreeEnhancedCallControlError::~most_telfi_tclMsgHandsFreeEnhancedCallControlError()
{}

tBool most_telfi_tclMsgHandsFreeEnhancedCallControlError::operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::most_telfi_tclMsgHandsFreeEnhancedCallControlStatus(const most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oHFEnhancedCallControlStream = coRef.oHFEnhancedCallControlStream;
}
most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::operator=(const most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& coRef)
{
   if (this == &coRef) return *this;
   oHFEnhancedCallControlStream = coRef.oHFEnhancedCallControlStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::most_telfi_tclMsgHandsFreeEnhancedCallControlStatus()
:oHFEnhancedCallControlStream()
 {}

tS32 most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_HandsFreeEnhancedCallControlStatus;
}


most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::~most_telfi_tclMsgHandsFreeEnhancedCallControlStatus()
{}

tU32 most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oHFEnhancedCallControlStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oHFEnhancedCallControlStream);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oHFEnhancedCallControlStream);
   return oOut;
}

tBool most_telfi_tclMsgHandsFreeEnhancedCallControlStatus::operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oHFEnhancedCallControlStream == roRef.oHFEnhancedCallControlStream);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSystemWideRingtonesListUpReg::most_telfi_tclMsgSystemWideRingtonesListUpReg()
 {}

tS32 most_telfi_tclMsgSystemWideRingtonesListUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SystemWideRingtonesListUpReg;
}


most_telfi_tclMsgSystemWideRingtonesListUpReg::~most_telfi_tclMsgSystemWideRingtonesListUpReg()
{}

//=============================================================================

most_telfi_tclMsgSystemWideRingtonesListRelUpReg::most_telfi_tclMsgSystemWideRingtonesListRelUpReg()
 {}

tS32 most_telfi_tclMsgSystemWideRingtonesListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SystemWideRingtonesListRelUpReg;
}


most_telfi_tclMsgSystemWideRingtonesListRelUpReg::~most_telfi_tclMsgSystemWideRingtonesListRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgSystemWideRingtonesListGet::most_telfi_tclMsgSystemWideRingtonesListGet()
 {}

tS32 most_telfi_tclMsgSystemWideRingtonesListGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SystemWideRingtonesListGet;
}


most_telfi_tclMsgSystemWideRingtonesListGet::~most_telfi_tclMsgSystemWideRingtonesListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSystemWideRingtonesListStatus::most_telfi_tclMsgSystemWideRingtonesListStatus(const most_telfi_tclMsgSystemWideRingtonesListStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8ActiveSystemRingtoneID = coRef.u8ActiveSystemRingtoneID;
   oSystemWideRingtonesListResult = coRef.oSystemWideRingtonesListResult;
}
most_telfi_tclMsgSystemWideRingtonesListStatus& most_telfi_tclMsgSystemWideRingtonesListStatus::operator=(const most_telfi_tclMsgSystemWideRingtonesListStatus& coRef)
{
   if (this == &coRef) return *this;
   u8ActiveSystemRingtoneID = coRef.u8ActiveSystemRingtoneID;
   oSystemWideRingtonesListResult = coRef.oSystemWideRingtonesListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgSystemWideRingtonesListStatus::vDestroy()
{
}

most_telfi_tclMsgSystemWideRingtonesListStatus::most_telfi_tclMsgSystemWideRingtonesListStatus()
:u8ActiveSystemRingtoneID(0)
,oSystemWideRingtonesListResult()
 {}

tS32 most_telfi_tclMsgSystemWideRingtonesListStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SystemWideRingtonesListStatus;
}


most_telfi_tclMsgSystemWideRingtonesListStatus::~most_telfi_tclMsgSystemWideRingtonesListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgSystemWideRingtonesListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSystemWideRingtonesListResult.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSystemWideRingtonesListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ActiveSystemRingtoneID);
   (tVoid) (oIn >> oSystemWideRingtonesListResult);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSystemWideRingtonesListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ActiveSystemRingtoneID);
   (tVoid) (oOut << oSystemWideRingtonesListResult);
   return oOut;
}

tBool most_telfi_tclMsgSystemWideRingtonesListStatus::operator==(const most_telfi_tclMsgSystemWideRingtonesListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ActiveSystemRingtoneID == roRef.u8ActiveSystemRingtoneID);
   bResult = bResult && (oSystemWideRingtonesListResult == roRef.oSystemWideRingtonesListResult);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgDeviceRingtoneListUpReg::most_telfi_tclMsgDeviceRingtoneListUpReg()
 {}

tS32 most_telfi_tclMsgDeviceRingtoneListUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeviceRingtoneListUpReg;
}


most_telfi_tclMsgDeviceRingtoneListUpReg::~most_telfi_tclMsgDeviceRingtoneListUpReg()
{}

//=============================================================================

most_telfi_tclMsgDeviceRingtoneListRelUpReg::most_telfi_tclMsgDeviceRingtoneListRelUpReg()
 {}

tS32 most_telfi_tclMsgDeviceRingtoneListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeviceRingtoneListRelUpReg;
}


most_telfi_tclMsgDeviceRingtoneListRelUpReg::~most_telfi_tclMsgDeviceRingtoneListRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgDeviceRingtoneListGet::most_telfi_tclMsgDeviceRingtoneListGet()
 {}

tS32 most_telfi_tclMsgDeviceRingtoneListGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeviceRingtoneListGet;
}


most_telfi_tclMsgDeviceRingtoneListGet::~most_telfi_tclMsgDeviceRingtoneListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgDeviceRingtoneListStatus::most_telfi_tclMsgDeviceRingtoneListStatus(const most_telfi_tclMsgDeviceRingtoneListStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oDeviceRingtoneListResult = coRef.oDeviceRingtoneListResult;
}
most_telfi_tclMsgDeviceRingtoneListStatus& most_telfi_tclMsgDeviceRingtoneListStatus::operator=(const most_telfi_tclMsgDeviceRingtoneListStatus& coRef)
{
   if (this == &coRef) return *this;
   oDeviceRingtoneListResult = coRef.oDeviceRingtoneListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgDeviceRingtoneListStatus::vDestroy()
{
}

most_telfi_tclMsgDeviceRingtoneListStatus::most_telfi_tclMsgDeviceRingtoneListStatus()
:oDeviceRingtoneListResult()
 {}

tS32 most_telfi_tclMsgDeviceRingtoneListStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_DeviceRingtoneListStatus;
}


most_telfi_tclMsgDeviceRingtoneListStatus::~most_telfi_tclMsgDeviceRingtoneListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgDeviceRingtoneListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeviceRingtoneListResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgDeviceRingtoneListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceRingtoneListResult);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgDeviceRingtoneListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceRingtoneListResult);
   return oOut;
}

tBool most_telfi_tclMsgDeviceRingtoneListStatus::operator==(const most_telfi_tclMsgDeviceRingtoneListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceRingtoneListResult == roRef.oDeviceRingtoneListResult);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSuppressRingtoneOnOffListUpReg::most_telfi_tclMsgSuppressRingtoneOnOffListUpReg()
 {}

tS32 most_telfi_tclMsgSuppressRingtoneOnOffListUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListUpReg;
}


most_telfi_tclMsgSuppressRingtoneOnOffListUpReg::~most_telfi_tclMsgSuppressRingtoneOnOffListUpReg()
{}

//=============================================================================

most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg::most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg()
 {}

tS32 most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListRelUpReg;
}


most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg::~most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgSuppressRingtoneOnOffListGet::most_telfi_tclMsgSuppressRingtoneOnOffListGet()
 {}

tS32 most_telfi_tclMsgSuppressRingtoneOnOffListGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListGet;
}


most_telfi_tclMsgSuppressRingtoneOnOffListGet::~most_telfi_tclMsgSuppressRingtoneOnOffListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSuppressRingtoneOnOffListStatus::most_telfi_tclMsgSuppressRingtoneOnOffListStatus(const most_telfi_tclMsgSuppressRingtoneOnOffListStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oSuppressRingtoneOnOffListResult = coRef.oSuppressRingtoneOnOffListResult;
}
most_telfi_tclMsgSuppressRingtoneOnOffListStatus& most_telfi_tclMsgSuppressRingtoneOnOffListStatus::operator=(const most_telfi_tclMsgSuppressRingtoneOnOffListStatus& coRef)
{
   if (this == &coRef) return *this;
   oSuppressRingtoneOnOffListResult = coRef.oSuppressRingtoneOnOffListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgSuppressRingtoneOnOffListStatus::vDestroy()
{
}

most_telfi_tclMsgSuppressRingtoneOnOffListStatus::most_telfi_tclMsgSuppressRingtoneOnOffListStatus()
:oSuppressRingtoneOnOffListResult()
 {}

tS32 most_telfi_tclMsgSuppressRingtoneOnOffListStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SuppressRingtoneOnOffListStatus;
}


most_telfi_tclMsgSuppressRingtoneOnOffListStatus::~most_telfi_tclMsgSuppressRingtoneOnOffListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgSuppressRingtoneOnOffListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSuppressRingtoneOnOffListResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSuppressRingtoneOnOffListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oSuppressRingtoneOnOffListResult);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSuppressRingtoneOnOffListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oSuppressRingtoneOnOffListResult);
   return oOut;
}

tBool most_telfi_tclMsgSuppressRingtoneOnOffListStatus::operator==(const most_telfi_tclMsgSuppressRingtoneOnOffListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oSuppressRingtoneOnOffListResult == roRef.oSuppressRingtoneOnOffListResult);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgAutoWaitingModeOnOffListUpReg::most_telfi_tclMsgAutoWaitingModeOnOffListUpReg()
 {}

tS32 most_telfi_tclMsgAutoWaitingModeOnOffListUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListUpReg;
}


most_telfi_tclMsgAutoWaitingModeOnOffListUpReg::~most_telfi_tclMsgAutoWaitingModeOnOffListUpReg()
{}

//=============================================================================

most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg::most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg()
 {}

tS32 most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListRelUpReg;
}


most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg::~most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgAutoWaitingModeOnOffListGet::most_telfi_tclMsgAutoWaitingModeOnOffListGet()
 {}

tS32 most_telfi_tclMsgAutoWaitingModeOnOffListGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListGet;
}


most_telfi_tclMsgAutoWaitingModeOnOffListGet::~most_telfi_tclMsgAutoWaitingModeOnOffListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAutoWaitingModeOnOffListStatus::most_telfi_tclMsgAutoWaitingModeOnOffListStatus(const most_telfi_tclMsgAutoWaitingModeOnOffListStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oAutoWaitingModeOnOffListResult = coRef.oAutoWaitingModeOnOffListResult;
}
most_telfi_tclMsgAutoWaitingModeOnOffListStatus& most_telfi_tclMsgAutoWaitingModeOnOffListStatus::operator=(const most_telfi_tclMsgAutoWaitingModeOnOffListStatus& coRef)
{
   if (this == &coRef) return *this;
   oAutoWaitingModeOnOffListResult = coRef.oAutoWaitingModeOnOffListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgAutoWaitingModeOnOffListStatus::vDestroy()
{
}

most_telfi_tclMsgAutoWaitingModeOnOffListStatus::most_telfi_tclMsgAutoWaitingModeOnOffListStatus()
:oAutoWaitingModeOnOffListResult()
 {}

tS32 most_telfi_tclMsgAutoWaitingModeOnOffListStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AutoWaitingModeOnOffListStatus;
}


most_telfi_tclMsgAutoWaitingModeOnOffListStatus::~most_telfi_tclMsgAutoWaitingModeOnOffListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgAutoWaitingModeOnOffListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAutoWaitingModeOnOffListResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgAutoWaitingModeOnOffListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAutoWaitingModeOnOffListResult);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAutoWaitingModeOnOffListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAutoWaitingModeOnOffListResult);
   return oOut;
}

tBool most_telfi_tclMsgAutoWaitingModeOnOffListStatus::operator==(const most_telfi_tclMsgAutoWaitingModeOnOffListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAutoWaitingModeOnOffListResult == roRef.oAutoWaitingModeOnOffListResult);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgRingtonePlaybackStatusUpReg::most_telfi_tclMsgRingtonePlaybackStatusUpReg()
 {}

tS32 most_telfi_tclMsgRingtonePlaybackStatusUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusUpReg;
}


most_telfi_tclMsgRingtonePlaybackStatusUpReg::~most_telfi_tclMsgRingtonePlaybackStatusUpReg()
{}

//=============================================================================

most_telfi_tclMsgRingtonePlaybackStatusRelUpReg::most_telfi_tclMsgRingtonePlaybackStatusRelUpReg()
 {}

tS32 most_telfi_tclMsgRingtonePlaybackStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusRelUpReg;
}


most_telfi_tclMsgRingtonePlaybackStatusRelUpReg::~most_telfi_tclMsgRingtonePlaybackStatusRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgRingtonePlaybackStatusGet::most_telfi_tclMsgRingtonePlaybackStatusGet()
 {}

tS32 most_telfi_tclMsgRingtonePlaybackStatusGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusGet;
}


most_telfi_tclMsgRingtonePlaybackStatusGet::~most_telfi_tclMsgRingtonePlaybackStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgRingtonePlaybackStatusStatus::most_telfi_tclMsgRingtonePlaybackStatusStatus(const most_telfi_tclMsgRingtonePlaybackStatusStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackState = coRef.e8PlaybackState;
}
most_telfi_tclMsgRingtonePlaybackStatusStatus& most_telfi_tclMsgRingtonePlaybackStatusStatus::operator=(const most_telfi_tclMsgRingtonePlaybackStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackState = coRef.e8PlaybackState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgRingtonePlaybackStatusStatus::most_telfi_tclMsgRingtonePlaybackStatusStatus()
:e8PlaybackState()
 {}

tS32 most_telfi_tclMsgRingtonePlaybackStatusStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_RingtonePlaybackStatusStatus;
}


most_telfi_tclMsgRingtonePlaybackStatusStatus::~most_telfi_tclMsgRingtonePlaybackStatusStatus()
{}

tU32 most_telfi_tclMsgRingtonePlaybackStatusStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgRingtonePlaybackStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackState);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgRingtonePlaybackStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackState);
   return oOut;
}

tBool most_telfi_tclMsgRingtonePlaybackStatusStatus::operator==(const most_telfi_tclMsgRingtonePlaybackStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackState == roRef.e8PlaybackState);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgWaitingModeFilePathUpReg::most_telfi_tclMsgWaitingModeFilePathUpReg()
 {}

tS32 most_telfi_tclMsgWaitingModeFilePathUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeFilePathUpReg;
}


most_telfi_tclMsgWaitingModeFilePathUpReg::~most_telfi_tclMsgWaitingModeFilePathUpReg()
{}

//=============================================================================

most_telfi_tclMsgWaitingModeFilePathRelUpReg::most_telfi_tclMsgWaitingModeFilePathRelUpReg()
 {}

tS32 most_telfi_tclMsgWaitingModeFilePathRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeFilePathRelUpReg;
}


most_telfi_tclMsgWaitingModeFilePathRelUpReg::~most_telfi_tclMsgWaitingModeFilePathRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgWaitingModeFilePathGet::most_telfi_tclMsgWaitingModeFilePathGet()
 {}

tS32 most_telfi_tclMsgWaitingModeFilePathGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeFilePathGet;
}


most_telfi_tclMsgWaitingModeFilePathGet::~most_telfi_tclMsgWaitingModeFilePathGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgWaitingModeFilePathPureSet::most_telfi_tclMsgWaitingModeFilePathPureSet(const most_telfi_tclMsgWaitingModeFilePathPureSet& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sFilePathNB = coRef.sFilePathNB;
   sFilePathWB = coRef.sFilePathWB;
}
most_telfi_tclMsgWaitingModeFilePathPureSet& most_telfi_tclMsgWaitingModeFilePathPureSet::operator=(const most_telfi_tclMsgWaitingModeFilePathPureSet& coRef)
{
   if (this == &coRef) return *this;
   sFilePathNB = coRef.sFilePathNB;
   sFilePathWB = coRef.sFilePathWB;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgWaitingModeFilePathPureSet::vDestroy()
{
   sFilePathNB.vDestroy(); 
   sFilePathWB.vDestroy(); 
}

most_telfi_tclMsgWaitingModeFilePathPureSet::most_telfi_tclMsgWaitingModeFilePathPureSet()
:sFilePathNB()
,sFilePathWB()
 {}

tS32 most_telfi_tclMsgWaitingModeFilePathPureSet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeFilePathPureSet;
}


most_telfi_tclMsgWaitingModeFilePathPureSet::~most_telfi_tclMsgWaitingModeFilePathPureSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgWaitingModeFilePathPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sFilePathNB.u32GetSize(u16MajorVersion);
   u32DynamicSize += sFilePathWB.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgWaitingModeFilePathPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilePathNB);
   (tVoid) (oIn >> sFilePathWB);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgWaitingModeFilePathPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilePathNB);
   (tVoid) (oOut << sFilePathWB);
   return oOut;
}

tBool most_telfi_tclMsgWaitingModeFilePathPureSet::operator==(const most_telfi_tclMsgWaitingModeFilePathPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilePathNB == roRef.sFilePathNB);
   bResult = bResult && (sFilePathWB == roRef.sFilePathWB);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgWaitingModeFilePathError::most_telfi_tclMsgWaitingModeFilePathError(const most_telfi_tclMsgWaitingModeFilePathError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgWaitingModeFilePathError& most_telfi_tclMsgWaitingModeFilePathError::operator=(const most_telfi_tclMsgWaitingModeFilePathError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgWaitingModeFilePathError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeFilePathError;
}


most_telfi_tclMsgWaitingModeFilePathError::~most_telfi_tclMsgWaitingModeFilePathError()
{}

tBool most_telfi_tclMsgWaitingModeFilePathError::operator==(const most_telfi_tclMsgWaitingModeFilePathError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgWaitingModeFilePathStatus::most_telfi_tclMsgWaitingModeFilePathStatus(const most_telfi_tclMsgWaitingModeFilePathStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sFilePathNB = coRef.sFilePathNB;
   sFilePathWB = coRef.sFilePathWB;
}
most_telfi_tclMsgWaitingModeFilePathStatus& most_telfi_tclMsgWaitingModeFilePathStatus::operator=(const most_telfi_tclMsgWaitingModeFilePathStatus& coRef)
{
   if (this == &coRef) return *this;
   sFilePathNB = coRef.sFilePathNB;
   sFilePathWB = coRef.sFilePathWB;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgWaitingModeFilePathStatus::vDestroy()
{
   sFilePathNB.vDestroy(); 
   sFilePathWB.vDestroy(); 
}

most_telfi_tclMsgWaitingModeFilePathStatus::most_telfi_tclMsgWaitingModeFilePathStatus()
:sFilePathNB()
,sFilePathWB()
 {}

tS32 most_telfi_tclMsgWaitingModeFilePathStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeFilePathStatus;
}


most_telfi_tclMsgWaitingModeFilePathStatus::~most_telfi_tclMsgWaitingModeFilePathStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgWaitingModeFilePathStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sFilePathNB.u32GetSize(u16MajorVersion);
   u32DynamicSize += sFilePathWB.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgWaitingModeFilePathStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilePathNB);
   (tVoid) (oIn >> sFilePathWB);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgWaitingModeFilePathStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilePathNB);
   (tVoid) (oOut << sFilePathWB);
   return oOut;
}

tBool most_telfi_tclMsgWaitingModeFilePathStatus::operator==(const most_telfi_tclMsgWaitingModeFilePathStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilePathNB == roRef.sFilePathNB);
   bResult = bResult && (sFilePathWB == roRef.sFilePathWB);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedUpReg;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg::~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg()
{}

//=============================================================================

most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedRelUpReg;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg::~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedGet;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet::~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
}
most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet()
:u8DeviceHandle(0)
,bBTDeviceVoiceRecActive(0)
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedPureSet;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet()
{}

tU32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bBTDeviceVoiceRecActive);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bBTDeviceVoiceRecActive);
   return oOut;
}

tBool most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet::operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bBTDeviceVoiceRecActive == roRef.bBTDeviceVoiceRecActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError::operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedError;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError::~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError()
{}

tBool most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError::operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
   bBTDeviceVoiceRecSupported = coRef.bBTDeviceVoiceRecSupported;
   e8SiriAvailabilityState = coRef.e8SiriAvailabilityState;
}
most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bBTDeviceVoiceRecActive = coRef.bBTDeviceVoiceRecActive;
   bBTDeviceVoiceRecSupported = coRef.bBTDeviceVoiceRecSupported;
   e8SiriAvailabilityState = coRef.e8SiriAvailabilityState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus()
:u8DeviceHandle(0)
,bBTDeviceVoiceRecActive(0)
,bBTDeviceVoiceRecSupported(0)
,e8SiriAvailabilityState()
 {}

tS32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_BTDeviceVoiceRecognitionExtendedStatus;
}


most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus()
{}

tU32 most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bBTDeviceVoiceRecActive);
   (tVoid) (oIn >> bBTDeviceVoiceRecSupported);
   (tVoid) (oIn >> e8SiriAvailabilityState);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bBTDeviceVoiceRecActive);
   (tVoid) (oOut << bBTDeviceVoiceRecSupported);
   (tVoid) (oOut << e8SiriAvailabilityState);
   return oOut;
}

tBool most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus::operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bBTDeviceVoiceRecActive == roRef.bBTDeviceVoiceRecActive);
   bResult = bResult && (bBTDeviceVoiceRecSupported == roRef.bBTDeviceVoiceRecSupported);
   bResult = bResult && (e8SiriAvailabilityState == roRef.e8SiriAvailabilityState);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCallStatusNoticeExtendedUpReg::most_telfi_tclMsgCallStatusNoticeExtendedUpReg()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedUpReg;
}


most_telfi_tclMsgCallStatusNoticeExtendedUpReg::~most_telfi_tclMsgCallStatusNoticeExtendedUpReg()
{}

//=============================================================================

most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg::most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedRelUpReg;
}


most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg::~most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgCallStatusNoticeExtendedGet::most_telfi_tclMsgCallStatusNoticeExtendedGet()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeExtendedGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedGet;
}


most_telfi_tclMsgCallStatusNoticeExtendedGet::~most_telfi_tclMsgCallStatusNoticeExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCallStatusNoticeExtendedError::most_telfi_tclMsgCallStatusNoticeExtendedError(const most_telfi_tclMsgCallStatusNoticeExtendedError& coRef)
   : most_telfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_telfi_tclMsgCallStatusNoticeExtendedError& most_telfi_tclMsgCallStatusNoticeExtendedError::operator=(const most_telfi_tclMsgCallStatusNoticeExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_telfi_tclMsgCallStatusNoticeExtendedError::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedError;
}


most_telfi_tclMsgCallStatusNoticeExtendedError::~most_telfi_tclMsgCallStatusNoticeExtendedError()
{}

tBool most_telfi_tclMsgCallStatusNoticeExtendedError::operator==(const most_telfi_tclMsgCallStatusNoticeExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCallStatusNoticeExtendedStatus::most_telfi_tclMsgCallStatusNoticeExtendedStatus(const most_telfi_tclMsgCallStatusNoticeExtendedStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8TotalCallInstances = coRef.u8TotalCallInstances;
   oCallStatusNoticeExtendedStream = coRef.oCallStatusNoticeExtendedStream;
}
most_telfi_tclMsgCallStatusNoticeExtendedStatus& most_telfi_tclMsgCallStatusNoticeExtendedStatus::operator=(const most_telfi_tclMsgCallStatusNoticeExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   u8TotalCallInstances = coRef.u8TotalCallInstances;
   oCallStatusNoticeExtendedStream = coRef.oCallStatusNoticeExtendedStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgCallStatusNoticeExtendedStatus::vDestroy()
{
}

most_telfi_tclMsgCallStatusNoticeExtendedStatus::most_telfi_tclMsgCallStatusNoticeExtendedStatus()
:u8TotalCallInstances(0)
,oCallStatusNoticeExtendedStream()
 {}

tS32 most_telfi_tclMsgCallStatusNoticeExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallStatusNoticeExtendedStatus;
}


most_telfi_tclMsgCallStatusNoticeExtendedStatus::~most_telfi_tclMsgCallStatusNoticeExtendedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgCallStatusNoticeExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oCallStatusNoticeExtendedStream.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgCallStatusNoticeExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8TotalCallInstances);
   (tVoid) (oIn >> oCallStatusNoticeExtendedStream);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCallStatusNoticeExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8TotalCallInstances);
   (tVoid) (oOut << oCallStatusNoticeExtendedStream);
   return oOut;
}

tBool most_telfi_tclMsgCallStatusNoticeExtendedStatus::operator==(const most_telfi_tclMsgCallStatusNoticeExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8TotalCallInstances == roRef.u8TotalCallInstances);
   bResult = bResult && (oCallStatusNoticeExtendedStream == roRef.oCallStatusNoticeExtendedStream);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgActivePhoneDeviceUpReg::most_telfi_tclMsgActivePhoneDeviceUpReg()
 {}

tS32 most_telfi_tclMsgActivePhoneDeviceUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivePhoneDeviceUpReg;
}


most_telfi_tclMsgActivePhoneDeviceUpReg::~most_telfi_tclMsgActivePhoneDeviceUpReg()
{}

//=============================================================================

most_telfi_tclMsgActivePhoneDeviceRelUpReg::most_telfi_tclMsgActivePhoneDeviceRelUpReg()
 {}

tS32 most_telfi_tclMsgActivePhoneDeviceRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivePhoneDeviceRelUpReg;
}


most_telfi_tclMsgActivePhoneDeviceRelUpReg::~most_telfi_tclMsgActivePhoneDeviceRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgActivePhoneDeviceGet::most_telfi_tclMsgActivePhoneDeviceGet()
 {}

tS32 most_telfi_tclMsgActivePhoneDeviceGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivePhoneDeviceGet;
}


most_telfi_tclMsgActivePhoneDeviceGet::~most_telfi_tclMsgActivePhoneDeviceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgActivePhoneDeviceStatus::most_telfi_tclMsgActivePhoneDeviceStatus(const most_telfi_tclMsgActivePhoneDeviceStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_telfi_tclMsgActivePhoneDeviceStatus& most_telfi_tclMsgActivePhoneDeviceStatus::operator=(const most_telfi_tclMsgActivePhoneDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgActivePhoneDeviceStatus::most_telfi_tclMsgActivePhoneDeviceStatus()
:u8DeviceHandle(0)
 {}

tS32 most_telfi_tclMsgActivePhoneDeviceStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ActivePhoneDeviceStatus;
}


most_telfi_tclMsgActivePhoneDeviceStatus::~most_telfi_tclMsgActivePhoneDeviceStatus()
{}

tU32 most_telfi_tclMsgActivePhoneDeviceStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgActivePhoneDeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgActivePhoneDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_telfi_tclMsgActivePhoneDeviceStatus::operator==(const most_telfi_tclMsgActivePhoneDeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgOutgoingCallFailedEventUpReg::most_telfi_tclMsgOutgoingCallFailedEventUpReg()
 {}

tS32 most_telfi_tclMsgOutgoingCallFailedEventUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_OutgoingCallFailedEventUpReg;
}


most_telfi_tclMsgOutgoingCallFailedEventUpReg::~most_telfi_tclMsgOutgoingCallFailedEventUpReg()
{}

//=============================================================================

most_telfi_tclMsgOutgoingCallFailedEventRelUpReg::most_telfi_tclMsgOutgoingCallFailedEventRelUpReg()
 {}

tS32 most_telfi_tclMsgOutgoingCallFailedEventRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_OutgoingCallFailedEventRelUpReg;
}


most_telfi_tclMsgOutgoingCallFailedEventRelUpReg::~most_telfi_tclMsgOutgoingCallFailedEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgOutgoingCallFailedEventStatus::most_telfi_tclMsgOutgoingCallFailedEventStatus(const most_telfi_tclMsgOutgoingCallFailedEventStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oOutgoingFailed = coRef.oOutgoingFailed;
}
most_telfi_tclMsgOutgoingCallFailedEventStatus& most_telfi_tclMsgOutgoingCallFailedEventStatus::operator=(const most_telfi_tclMsgOutgoingCallFailedEventStatus& coRef)
{
   if (this == &coRef) return *this;
   oOutgoingFailed = coRef.oOutgoingFailed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgOutgoingCallFailedEventStatus::vDestroy()
{
   oOutgoingFailed.vDestroy(); 
}

most_telfi_tclMsgOutgoingCallFailedEventStatus::most_telfi_tclMsgOutgoingCallFailedEventStatus()
:oOutgoingFailed()
 {}

tS32 most_telfi_tclMsgOutgoingCallFailedEventStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_OutgoingCallFailedEventStatus;
}


most_telfi_tclMsgOutgoingCallFailedEventStatus::~most_telfi_tclMsgOutgoingCallFailedEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgOutgoingCallFailedEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oOutgoingFailed.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgOutgoingCallFailedEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oOutgoingFailed);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgOutgoingCallFailedEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oOutgoingFailed);
   return oOut;
}

tBool most_telfi_tclMsgOutgoingCallFailedEventStatus::operator==(const most_telfi_tclMsgOutgoingCallFailedEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oOutgoingFailed == roRef.oOutgoingFailed);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgIncomingCallRejectedEventUpReg::most_telfi_tclMsgIncomingCallRejectedEventUpReg()
 {}

tS32 most_telfi_tclMsgIncomingCallRejectedEventUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_IncomingCallRejectedEventUpReg;
}


most_telfi_tclMsgIncomingCallRejectedEventUpReg::~most_telfi_tclMsgIncomingCallRejectedEventUpReg()
{}

//=============================================================================

most_telfi_tclMsgIncomingCallRejectedEventRelUpReg::most_telfi_tclMsgIncomingCallRejectedEventRelUpReg()
 {}

tS32 most_telfi_tclMsgIncomingCallRejectedEventRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_IncomingCallRejectedEventRelUpReg;
}


most_telfi_tclMsgIncomingCallRejectedEventRelUpReg::~most_telfi_tclMsgIncomingCallRejectedEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgIncomingCallRejectedEventStatus::most_telfi_tclMsgIncomingCallRejectedEventStatus(const most_telfi_tclMsgIncomingCallRejectedEventStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   oIncomingRejected = coRef.oIncomingRejected;
}
most_telfi_tclMsgIncomingCallRejectedEventStatus& most_telfi_tclMsgIncomingCallRejectedEventStatus::operator=(const most_telfi_tclMsgIncomingCallRejectedEventStatus& coRef)
{
   if (this == &coRef) return *this;
   oIncomingRejected = coRef.oIncomingRejected;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgIncomingCallRejectedEventStatus::vDestroy()
{
   oIncomingRejected.vDestroy(); 
}

most_telfi_tclMsgIncomingCallRejectedEventStatus::most_telfi_tclMsgIncomingCallRejectedEventStatus()
:oIncomingRejected()
 {}

tS32 most_telfi_tclMsgIncomingCallRejectedEventStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_IncomingCallRejectedEventStatus;
}


most_telfi_tclMsgIncomingCallRejectedEventStatus::~most_telfi_tclMsgIncomingCallRejectedEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgIncomingCallRejectedEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oIncomingRejected.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgIncomingCallRejectedEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oIncomingRejected);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgIncomingCallRejectedEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oIncomingRejected);
   return oOut;
}

tBool most_telfi_tclMsgIncomingCallRejectedEventStatus::operator==(const most_telfi_tclMsgIncomingCallRejectedEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oIncomingRejected == roRef.oIncomingRejected);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgWaitingModeStateUpReg::most_telfi_tclMsgWaitingModeStateUpReg()
 {}

tS32 most_telfi_tclMsgWaitingModeStateUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeStateUpReg;
}


most_telfi_tclMsgWaitingModeStateUpReg::~most_telfi_tclMsgWaitingModeStateUpReg()
{}

//=============================================================================

most_telfi_tclMsgWaitingModeStateRelUpReg::most_telfi_tclMsgWaitingModeStateRelUpReg()
 {}

tS32 most_telfi_tclMsgWaitingModeStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeStateRelUpReg;
}


most_telfi_tclMsgWaitingModeStateRelUpReg::~most_telfi_tclMsgWaitingModeStateRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgWaitingModeStateGet::most_telfi_tclMsgWaitingModeStateGet()
 {}

tS32 most_telfi_tclMsgWaitingModeStateGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeStateGet;
}


most_telfi_tclMsgWaitingModeStateGet::~most_telfi_tclMsgWaitingModeStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgWaitingModeStateStatus::most_telfi_tclMsgWaitingModeStateStatus(const most_telfi_tclMsgWaitingModeStateStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   e8WaitingModeState = coRef.e8WaitingModeState;
}
most_telfi_tclMsgWaitingModeStateStatus& most_telfi_tclMsgWaitingModeStateStatus::operator=(const most_telfi_tclMsgWaitingModeStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8WaitingModeState = coRef.e8WaitingModeState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_telfi_tclMsgWaitingModeStateStatus::most_telfi_tclMsgWaitingModeStateStatus()
:e8WaitingModeState()
 {}

tS32 most_telfi_tclMsgWaitingModeStateStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_WaitingModeStateStatus;
}


most_telfi_tclMsgWaitingModeStateStatus::~most_telfi_tclMsgWaitingModeStateStatus()
{}

tU32 most_telfi_tclMsgWaitingModeStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_telfi_tclMsgWaitingModeStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8WaitingModeState);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgWaitingModeStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8WaitingModeState);
   return oOut;
}

tBool most_telfi_tclMsgWaitingModeStateStatus::operator==(const most_telfi_tclMsgWaitingModeStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8WaitingModeState == roRef.e8WaitingModeState);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgExternalVRStateUpReg::most_telfi_tclMsgExternalVRStateUpReg()
 {}

tS32 most_telfi_tclMsgExternalVRStateUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ExternalVRStateUpReg;
}


most_telfi_tclMsgExternalVRStateUpReg::~most_telfi_tclMsgExternalVRStateUpReg()
{}

//=============================================================================

most_telfi_tclMsgExternalVRStateRelUpReg::most_telfi_tclMsgExternalVRStateRelUpReg()
 {}

tS32 most_telfi_tclMsgExternalVRStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ExternalVRStateRelUpReg;
}


most_telfi_tclMsgExternalVRStateRelUpReg::~most_telfi_tclMsgExternalVRStateRelUpReg()
{}

//=============================================================================

most_telfi_tclMsgExternalVRStateGet::most_telfi_tclMsgExternalVRStateGet()
 {}

tS32 most_telfi_tclMsgExternalVRStateGet::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ExternalVRStateGet;
}


most_telfi_tclMsgExternalVRStateGet::~most_telfi_tclMsgExternalVRStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgExternalVRStateStatus::most_telfi_tclMsgExternalVRStateStatus(const most_telfi_tclMsgExternalVRStateStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   e8ExternalVRState = coRef.e8ExternalVRState;
   e8VRErrorCode = coRef.e8VRErrorCode;
}
most_telfi_tclMsgExternalVRStateStatus& most_telfi_tclMsgExternalVRStateStatus::operator=(const most_telfi_tclMsgExternalVRStateStatus& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   e8ExternalVRState = coRef.e8ExternalVRState;
   e8VRErrorCode = coRef.e8VRErrorCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgExternalVRStateStatus::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgExternalVRStateStatus::most_telfi_tclMsgExternalVRStateStatus()
:sBdAddress()
,e8ExternalVRState()
,e8VRErrorCode()
 {}

tS32 most_telfi_tclMsgExternalVRStateStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_ExternalVRStateStatus;
}


most_telfi_tclMsgExternalVRStateStatus::~most_telfi_tclMsgExternalVRStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgExternalVRStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgExternalVRStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> e8ExternalVRState);
   (tVoid) (oIn >> e8VRErrorCode);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgExternalVRStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << e8ExternalVRState);
   (tVoid) (oOut << e8VRErrorCode);
   return oOut;
}

tBool most_telfi_tclMsgExternalVRStateStatus::operator==(const most_telfi_tclMsgExternalVRStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (e8ExternalVRState == roRef.e8ExternalVRState);
   bResult = bResult && (e8VRErrorCode == roRef.e8VRErrorCode);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgCallOperationFailedEventUpReg::most_telfi_tclMsgCallOperationFailedEventUpReg()
 {}

tS32 most_telfi_tclMsgCallOperationFailedEventUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallOperationFailedEventUpReg;
}


most_telfi_tclMsgCallOperationFailedEventUpReg::~most_telfi_tclMsgCallOperationFailedEventUpReg()
{}

//=============================================================================

most_telfi_tclMsgCallOperationFailedEventRelUpReg::most_telfi_tclMsgCallOperationFailedEventRelUpReg()
 {}

tS32 most_telfi_tclMsgCallOperationFailedEventRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallOperationFailedEventRelUpReg;
}


most_telfi_tclMsgCallOperationFailedEventRelUpReg::~most_telfi_tclMsgCallOperationFailedEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgCallOperationFailedEventStatus::most_telfi_tclMsgCallOperationFailedEventStatus(const most_telfi_tclMsgCallOperationFailedEventStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   sOperation = coRef.sOperation;
   sCallOperationFailedReason = coRef.sCallOperationFailedReason;
   oListOfCallInstanceStream = coRef.oListOfCallInstanceStream;
}
most_telfi_tclMsgCallOperationFailedEventStatus& most_telfi_tclMsgCallOperationFailedEventStatus::operator=(const most_telfi_tclMsgCallOperationFailedEventStatus& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   sOperation = coRef.sOperation;
   sCallOperationFailedReason = coRef.sCallOperationFailedReason;
   oListOfCallInstanceStream = coRef.oListOfCallInstanceStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgCallOperationFailedEventStatus::vDestroy()
{
   sBdAddress.vDestroy(); 
   sOperation.vDestroy(); 
   sCallOperationFailedReason.vDestroy(); 
}

most_telfi_tclMsgCallOperationFailedEventStatus::most_telfi_tclMsgCallOperationFailedEventStatus()
:sBdAddress()
,sOperation()
,sCallOperationFailedReason()
,oListOfCallInstanceStream()
 {}

tS32 most_telfi_tclMsgCallOperationFailedEventStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_CallOperationFailedEventStatus;
}


most_telfi_tclMsgCallOperationFailedEventStatus::~most_telfi_tclMsgCallOperationFailedEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgCallOperationFailedEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += sOperation.u32GetSize(u16MajorVersion);
   u32DynamicSize += sCallOperationFailedReason.u32GetSize(u16MajorVersion);
   u32DynamicSize += oListOfCallInstanceStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgCallOperationFailedEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> sOperation);
   (tVoid) (oIn >> sCallOperationFailedReason);
   (tVoid) (oIn >> oListOfCallInstanceStream);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgCallOperationFailedEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << sOperation);
   (tVoid) (oOut << sCallOperationFailedReason);
   (tVoid) (oOut << oListOfCallInstanceStream);
   return oOut;
}

tBool most_telfi_tclMsgCallOperationFailedEventStatus::operator==(const most_telfi_tclMsgCallOperationFailedEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (sOperation == roRef.sOperation);
   bResult = bResult && (sCallOperationFailedReason == roRef.sCallOperationFailedReason);
   bResult = bResult && (oListOfCallInstanceStream == roRef.oListOfCallInstanceStream);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgSendDTMFFailedEventUpReg::most_telfi_tclMsgSendDTMFFailedEventUpReg()
 {}

tS32 most_telfi_tclMsgSendDTMFFailedEventUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SendDTMFFailedEventUpReg;
}


most_telfi_tclMsgSendDTMFFailedEventUpReg::~most_telfi_tclMsgSendDTMFFailedEventUpReg()
{}

//=============================================================================

most_telfi_tclMsgSendDTMFFailedEventRelUpReg::most_telfi_tclMsgSendDTMFFailedEventRelUpReg()
 {}

tS32 most_telfi_tclMsgSendDTMFFailedEventRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SendDTMFFailedEventRelUpReg;
}


most_telfi_tclMsgSendDTMFFailedEventRelUpReg::~most_telfi_tclMsgSendDTMFFailedEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgSendDTMFFailedEventStatus::most_telfi_tclMsgSendDTMFFailedEventStatus(const most_telfi_tclMsgSendDTMFFailedEventStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   sSendDTMFFailedReason = coRef.sSendDTMFFailedReason;
}
most_telfi_tclMsgSendDTMFFailedEventStatus& most_telfi_tclMsgSendDTMFFailedEventStatus::operator=(const most_telfi_tclMsgSendDTMFFailedEventStatus& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   sSendDTMFFailedReason = coRef.sSendDTMFFailedReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgSendDTMFFailedEventStatus::vDestroy()
{
   sBdAddress.vDestroy(); 
   sSendDTMFFailedReason.vDestroy(); 
}

most_telfi_tclMsgSendDTMFFailedEventStatus::most_telfi_tclMsgSendDTMFFailedEventStatus()
:sBdAddress()
,sSendDTMFFailedReason()
 {}

tS32 most_telfi_tclMsgSendDTMFFailedEventStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_SendDTMFFailedEventStatus;
}


most_telfi_tclMsgSendDTMFFailedEventStatus::~most_telfi_tclMsgSendDTMFFailedEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgSendDTMFFailedEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += sSendDTMFFailedReason.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgSendDTMFFailedEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> sSendDTMFFailedReason);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgSendDTMFFailedEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << sSendDTMFFailedReason);
   return oOut;
}

tBool most_telfi_tclMsgSendDTMFFailedEventStatus::operator==(const most_telfi_tclMsgSendDTMFFailedEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (sSendDTMFFailedReason == roRef.sSendDTMFFailedReason);
   return bResult;
}

//=============================================================================

most_telfi_tclMsgAudioTransferFailedEventUpReg::most_telfi_tclMsgAudioTransferFailedEventUpReg()
 {}

tS32 most_telfi_tclMsgAudioTransferFailedEventUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AudioTransferFailedEventUpReg;
}


most_telfi_tclMsgAudioTransferFailedEventUpReg::~most_telfi_tclMsgAudioTransferFailedEventUpReg()
{}

//=============================================================================

most_telfi_tclMsgAudioTransferFailedEventRelUpReg::most_telfi_tclMsgAudioTransferFailedEventRelUpReg()
 {}

tS32 most_telfi_tclMsgAudioTransferFailedEventRelUpReg::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AudioTransferFailedEventRelUpReg;
}


most_telfi_tclMsgAudioTransferFailedEventRelUpReg::~most_telfi_tclMsgAudioTransferFailedEventRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_telfi_tclMsgAudioTransferFailedEventStatus::most_telfi_tclMsgAudioTransferFailedEventStatus(const most_telfi_tclMsgAudioTransferFailedEventStatus& coRef)
   : most_telfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   e8AudioDirection = coRef.e8AudioDirection;
}
most_telfi_tclMsgAudioTransferFailedEventStatus& most_telfi_tclMsgAudioTransferFailedEventStatus::operator=(const most_telfi_tclMsgAudioTransferFailedEventStatus& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   e8AudioDirection = coRef.e8AudioDirection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_telfi_tclMsgAudioTransferFailedEventStatus::vDestroy()
{
   sBdAddress.vDestroy(); 
}

most_telfi_tclMsgAudioTransferFailedEventStatus::most_telfi_tclMsgAudioTransferFailedEventStatus()
:sBdAddress()
,e8AudioDirection()
 {}

tS32 most_telfi_tclMsgAudioTransferFailedEventStatus::s32GetTypeId() const
{
   return (tS32) most_telfi_tclToken::EN_MSG_AudioTransferFailedEventStatus;
}


most_telfi_tclMsgAudioTransferFailedEventStatus::~most_telfi_tclMsgAudioTransferFailedEventStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_telfi_tclMsgAudioTransferFailedEventStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_telfi_tclMsgAudioTransferFailedEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> e8AudioDirection);
   return oIn;
}

fi_tclOutContext& most_telfi_tclMsgAudioTransferFailedEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << e8AudioDirection);
   return oOut;
}

tBool most_telfi_tclMsgAudioTransferFailedEventStatus::operator==(const most_telfi_tclMsgAudioTransferFailedEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (e8AudioDirection == roRef.e8AudioDirection);
   return bResult;
}

