/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_PHONBKFI_SERVICEINFO
#include "conn_most_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MOST_PhonBk_FI message types

fi_tclMessageBase* most_phonbkfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case most_phonbkfi_tclToken::EN_MSG_StoreFavoriteMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgStoreFavoriteMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_StoreFavoriteMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgStoreFavoriteMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ActivateFavoriteMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgActivateFavoriteMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ActivateFavoriteMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgActivateFavoriteMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_DeleteFavoriteMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgDeleteFavoriteMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_DeleteFavoriteMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgDeleteFavoriteMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetFavoriteInfoMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetFavoriteInfoMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetFavoriteInfoMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetFavoriteInfoMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ResetFavoritesMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgResetFavoritesMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ResetFavoritesMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgResetFavoritesMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_CreatePhoneBookListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgCreatePhoneBookListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_CreatePhoneBookListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgCreatePhoneBookListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SearchKeyboardPhoneBookListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SearchKeyboardPhoneBookListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ReleasePhoneBookListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgReleasePhoneBookListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ReleasePhoneBookListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgReleasePhoneBookListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetContactDetailsMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactDetailsMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetContactDetailsMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactDetailsMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetContactPhotoMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactPhotoMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetContactPhotoMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactPhotoMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_AddContactMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgAddContactMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_AddContactMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgAddContactMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_DeleteContactMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgDeleteContactMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_DeleteContactMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgDeleteContactMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_EditContactMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgEditContactMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_EditContactMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgEditContactMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_CreateCallHistoryListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgCreateCallHistoryListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_CreateCallHistoryListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgCreateCallHistoryListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ClearMissedCallIndicatorMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ClearMissedCallIndicatorMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SearchPhoneBookMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSearchPhoneBookMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SearchPhoneBookMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSearchPhoneBookMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ReleaseCallHistoryListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ReleaseCallHistoryListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetContactPhotoInfoMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetContactPhotoInfoMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetDeviceCallHistorySupportMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetDeviceCallHistorySupportMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_AutocompletePhoneNumberEntryMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_AutocompletePhoneNumberEntryMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ClearPhoneBookDataMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgClearPhoneBookDataMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ClearPhoneBookDataMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgClearPhoneBookDataMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhoneBookMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhoneBookMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListExtendedMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListExtendedMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceExtendedMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceExtendedMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SearchContactsMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSearchContactsMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SearchContactsMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSearchContactsMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_StartPbDownloadMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgStartPbDownloadMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_StartPbDownloadMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgStartPbDownloadMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SwitchDownloadOnOffStateMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SwitchDownloadOnOffStateMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_CreateContactListMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgCreateContactListMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_CreateContactListMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgCreateContactListMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SetContactPhotoMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSetContactPhotoMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SetContactPhotoMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSetContactPhotoMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_CancelPbDownloadMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgCancelPbDownloadMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_CancelPbDownloadMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgCancelPbDownloadMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SetContactPositionMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSetContactPositionMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SetContactPositionMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSetContactPositionMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_AddContactExtendedMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgAddContactExtendedMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_AddContactExtendedMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgAddContactExtendedMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_EditContactExtendedMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgEditContactExtendedMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_EditContactExtendedMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgEditContactExtendedMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetContactDetailsExtendedMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetContactDetailsExtendedMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhonebookExtendedMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhonebookExtendedMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_SetAutomaticContactDownloadMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_SetAutomaticContactDownloadMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_GetPositionForContactHandleMethodStart:
         return OSAL_NEW most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart;

      case most_phonbkfi_tclToken::EN_MSG_GetPositionForContactHandleMethodResult:
         return OSAL_NEW most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult;

      case most_phonbkfi_tclToken::EN_MSG_FavoritesChangedUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgFavoritesChangedUpReg;

      case most_phonbkfi_tclToken::EN_MSG_FavoritesChangedRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgFavoritesChangedRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_FavoritesChangedStatus:
         return OSAL_NEW most_phonbkfi_tclMsgFavoritesChangedStatus;

      case most_phonbkfi_tclToken::EN_MSG_ListChangeUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgListChangeUpReg;

      case most_phonbkfi_tclToken::EN_MSG_ListChangeRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgListChangeRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_ListChangeStatus:
         return OSAL_NEW most_phonbkfi_tclMsgListChangeStatus;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorUpReg;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorStatus:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorStatus;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportGet:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus;

      case most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg;

      case most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderGet:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet;

      case most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderPureSet:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet;

      case most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderStatus:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus;

      case most_phonbkfi_tclToken::EN_MSG_DownloadStateUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadStateUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadStateRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadStateRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadStateStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadStateStatus;

      case most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadStateExtendedUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadStateExtendedStatus;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressGet:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressGet;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressStatus;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressListUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressListUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressListRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressListRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressListGet:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressListGet;

      case most_phonbkfi_tclToken::EN_MSG_DownloadProgressListStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadProgressListStatus;

      case most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadOnOffListUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadOnOffListRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListGet:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadOnOffListGet;

      case most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDownloadOnOffListStatus;

      case most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg;

      case most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListGet:
         return OSAL_NEW most_phonbkfi_tclMsgAutomaticContactDownloadListGet;

      case most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListStatus:
         return OSAL_NEW most_phonbkfi_tclMsgAutomaticContactDownloadListStatus;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedGet:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet;

      case most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedStatus:
         return OSAL_NEW most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus;

      case most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgProbablyLockedDevicesUpReg;

      case most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesGet:
         return OSAL_NEW most_phonbkfi_tclMsgProbablyLockedDevicesGet;

      case most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesStatus:
         return OSAL_NEW most_phonbkfi_tclMsgProbablyLockedDevicesStatus;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorListUpReg;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListGet:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorListGet;

      case most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListStatus:
         return OSAL_NEW most_phonbkfi_tclMsgMissedCallIndicatorListStatus;

      case most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredSortOrderListUpReg;

      case most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListGet:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredSortOrderListGet;

      case most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListPureSet:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredSortOrderListPureSet;

      case most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListStatus:
         return OSAL_NEW most_phonbkfi_tclMsgPreferredSortOrderListStatus;

      case most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgPhonebookLanguageUpReg;

      case most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgPhonebookLanguageRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageGet:
         return OSAL_NEW most_phonbkfi_tclMsgPhonebookLanguageGet;

      case most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageSet:
         return OSAL_NEW most_phonbkfi_tclMsgPhonebookLanguageSet;

      case most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageStatus:
         return OSAL_NEW most_phonbkfi_tclMsgPhonebookLanguageStatus;

      case most_phonbkfi_tclToken::EN_MSG_MaxContactCountUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgMaxContactCountUpReg;

      case most_phonbkfi_tclToken::EN_MSG_MaxContactCountRelUpReg:
         return OSAL_NEW most_phonbkfi_tclMsgMaxContactCountRelUpReg;

      case most_phonbkfi_tclToken::EN_MSG_MaxContactCountGet:
         return OSAL_NEW most_phonbkfi_tclMsgMaxContactCountGet;

      case most_phonbkfi_tclToken::EN_MSG_MaxContactCountStatus:
         return OSAL_NEW most_phonbkfi_tclMsgMaxContactCountStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all most_phonbkfifi messages

// common functions

tU16 most_phonbkfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MOST_PHONBKFI_C_U16_SERVICE_ID;
}

tU16 most_phonbkfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 most_phonbkfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& most_phonbkfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& most_phonbkfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 most_phonbkfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& most_phonbkfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& most_phonbkfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

// base class for all most_phonbkfi standard error messages

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDefaultError::most_phonbkfi_tclMsgDefaultError(const most_phonbkfi_tclMsgDefaultError& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   *this = coRef;
}
most_phonbkfi_tclMsgDefaultError& most_phonbkfi_tclMsgDefaultError::operator=(const most_phonbkfi_tclMsgDefaultError& coRef)
{
   if (this != &coRef)
   {
      e8ErrorCode = coRef.e8ErrorCode;
      oErrorInfo = coRef.oErrorInfo;
   }

   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgDefaultError::vDestroy()
{
   oErrorInfo.vDestroy();
}

tU32 most_phonbkfi_tclMsgDefaultError::u32GetSize(tU16 u16MajorVersion) const
{
   return 3 + oErrorInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& most_phonbkfi_tclMsgDefaultError::oRead(fi_tclInContext& oIn)
{
   tU16 u16CCA_Error = CCA_C_U16_ERROR_UNSPECIFIED;
   (tVoid) (oIn >> u16CCA_Error);
   (tVoid) (oIn >> e8ErrorCode);
   (tVoid) (oIn >> oErrorInfo);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDefaultError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU16)CCA_C_U16_ERROR_UNSPECIFIED);
   (tVoid) (oOut << e8ErrorCode);
   (tVoid) (oOut << oErrorInfo);
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgStoreFavoriteMethodStart::most_phonbkfi_tclMsgStoreFavoriteMethodStart(const most_phonbkfi_tclMsgStoreFavoriteMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ObjectID = coRef.u32ObjectID;
}
most_phonbkfi_tclMsgStoreFavoriteMethodStart& most_phonbkfi_tclMsgStoreFavoriteMethodStart::operator=(const most_phonbkfi_tclMsgStoreFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ObjectID = coRef.u32ObjectID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgStoreFavoriteMethodStart::most_phonbkfi_tclMsgStoreFavoriteMethodStart()
:u32ObjectID(0)
 {}

tS32 most_phonbkfi_tclMsgStoreFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_StoreFavoriteMethodStart;
}


most_phonbkfi_tclMsgStoreFavoriteMethodStart::~most_phonbkfi_tclMsgStoreFavoriteMethodStart()
{}

tU32 most_phonbkfi_tclMsgStoreFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgStoreFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ObjectID);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgStoreFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ObjectID);
   return oOut;
}

tBool most_phonbkfi_tclMsgStoreFavoriteMethodStart::operator==(const most_phonbkfi_tclMsgStoreFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ObjectID == roRef.u32ObjectID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgStoreFavoriteError::most_phonbkfi_tclMsgStoreFavoriteError(const most_phonbkfi_tclMsgStoreFavoriteError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgStoreFavoriteError& most_phonbkfi_tclMsgStoreFavoriteError::operator=(const most_phonbkfi_tclMsgStoreFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgStoreFavoriteError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_StoreFavoriteError;
}


most_phonbkfi_tclMsgStoreFavoriteError::~most_phonbkfi_tclMsgStoreFavoriteError()
{}

tBool most_phonbkfi_tclMsgStoreFavoriteError::operator==(const most_phonbkfi_tclMsgStoreFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgStoreFavoriteMethodResult::most_phonbkfi_tclMsgStoreFavoriteMethodResult(const most_phonbkfi_tclMsgStoreFavoriteMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_phonbkfi_tclMsgStoreFavoriteMethodResult& most_phonbkfi_tclMsgStoreFavoriteMethodResult::operator=(const most_phonbkfi_tclMsgStoreFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgStoreFavoriteMethodResult::most_phonbkfi_tclMsgStoreFavoriteMethodResult()
:u16FavoriteID(0)
 {}

tS32 most_phonbkfi_tclMsgStoreFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_StoreFavoriteMethodResult;
}


most_phonbkfi_tclMsgStoreFavoriteMethodResult::~most_phonbkfi_tclMsgStoreFavoriteMethodResult()
{}

tU32 most_phonbkfi_tclMsgStoreFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgStoreFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgStoreFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_phonbkfi_tclMsgStoreFavoriteMethodResult::operator==(const most_phonbkfi_tclMsgStoreFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgActivateFavoriteMethodStart::most_phonbkfi_tclMsgActivateFavoriteMethodStart(const most_phonbkfi_tclMsgActivateFavoriteMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
   e8AudioChannel = coRef.e8AudioChannel;
   e8VideoChannel = coRef.e8VideoChannel;
}
most_phonbkfi_tclMsgActivateFavoriteMethodStart& most_phonbkfi_tclMsgActivateFavoriteMethodStart::operator=(const most_phonbkfi_tclMsgActivateFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   e8AudioChannel = coRef.e8AudioChannel;
   e8VideoChannel = coRef.e8VideoChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgActivateFavoriteMethodStart::most_phonbkfi_tclMsgActivateFavoriteMethodStart()
:u16FavoriteID(0)
,e8AudioChannel()
,e8VideoChannel()
 {}

tS32 most_phonbkfi_tclMsgActivateFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ActivateFavoriteMethodStart;
}


most_phonbkfi_tclMsgActivateFavoriteMethodStart::~most_phonbkfi_tclMsgActivateFavoriteMethodStart()
{}

tU32 most_phonbkfi_tclMsgActivateFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgActivateFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   (tVoid) (oIn >> e8AudioChannel);
   (tVoid) (oIn >> e8VideoChannel);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgActivateFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   (tVoid) (oOut << e8AudioChannel);
   (tVoid) (oOut << e8VideoChannel);
   return oOut;
}

tBool most_phonbkfi_tclMsgActivateFavoriteMethodStart::operator==(const most_phonbkfi_tclMsgActivateFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   bResult = bResult && (e8AudioChannel == roRef.e8AudioChannel);
   bResult = bResult && (e8VideoChannel == roRef.e8VideoChannel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgActivateFavoriteError::most_phonbkfi_tclMsgActivateFavoriteError(const most_phonbkfi_tclMsgActivateFavoriteError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgActivateFavoriteError& most_phonbkfi_tclMsgActivateFavoriteError::operator=(const most_phonbkfi_tclMsgActivateFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgActivateFavoriteError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ActivateFavoriteError;
}


most_phonbkfi_tclMsgActivateFavoriteError::~most_phonbkfi_tclMsgActivateFavoriteError()
{}

tBool most_phonbkfi_tclMsgActivateFavoriteError::operator==(const most_phonbkfi_tclMsgActivateFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgActivateFavoriteMethodResult::most_phonbkfi_tclMsgActivateFavoriteMethodResult(const most_phonbkfi_tclMsgActivateFavoriteMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
   u32ActivationHandle = coRef.u32ActivationHandle;
}
most_phonbkfi_tclMsgActivateFavoriteMethodResult& most_phonbkfi_tclMsgActivateFavoriteMethodResult::operator=(const most_phonbkfi_tclMsgActivateFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   u32ActivationHandle = coRef.u32ActivationHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgActivateFavoriteMethodResult::most_phonbkfi_tclMsgActivateFavoriteMethodResult()
:u16FavoriteID(0)
,u32ActivationHandle(0)
 {}

tS32 most_phonbkfi_tclMsgActivateFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ActivateFavoriteMethodResult;
}


most_phonbkfi_tclMsgActivateFavoriteMethodResult::~most_phonbkfi_tclMsgActivateFavoriteMethodResult()
{}

tU32 most_phonbkfi_tclMsgActivateFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 6;
}

fi_tclInContext& most_phonbkfi_tclMsgActivateFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   (tVoid) (oIn >> u32ActivationHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgActivateFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   (tVoid) (oOut << u32ActivationHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgActivateFavoriteMethodResult::operator==(const most_phonbkfi_tclMsgActivateFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   bResult = bResult && (u32ActivationHandle == roRef.u32ActivationHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDeleteFavoriteMethodStart::most_phonbkfi_tclMsgDeleteFavoriteMethodStart(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_phonbkfi_tclMsgDeleteFavoriteMethodStart& most_phonbkfi_tclMsgDeleteFavoriteMethodStart::operator=(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDeleteFavoriteMethodStart::most_phonbkfi_tclMsgDeleteFavoriteMethodStart()
:u16FavoriteID(0)
 {}

tS32 most_phonbkfi_tclMsgDeleteFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DeleteFavoriteMethodStart;
}


most_phonbkfi_tclMsgDeleteFavoriteMethodStart::~most_phonbkfi_tclMsgDeleteFavoriteMethodStart()
{}

tU32 most_phonbkfi_tclMsgDeleteFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgDeleteFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDeleteFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_phonbkfi_tclMsgDeleteFavoriteMethodStart::operator==(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDeleteFavoriteError::most_phonbkfi_tclMsgDeleteFavoriteError(const most_phonbkfi_tclMsgDeleteFavoriteError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDeleteFavoriteError& most_phonbkfi_tclMsgDeleteFavoriteError::operator=(const most_phonbkfi_tclMsgDeleteFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDeleteFavoriteError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DeleteFavoriteError;
}


most_phonbkfi_tclMsgDeleteFavoriteError::~most_phonbkfi_tclMsgDeleteFavoriteError()
{}

tBool most_phonbkfi_tclMsgDeleteFavoriteError::operator==(const most_phonbkfi_tclMsgDeleteFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDeleteFavoriteMethodResult::most_phonbkfi_tclMsgDeleteFavoriteMethodResult(const most_phonbkfi_tclMsgDeleteFavoriteMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_phonbkfi_tclMsgDeleteFavoriteMethodResult& most_phonbkfi_tclMsgDeleteFavoriteMethodResult::operator=(const most_phonbkfi_tclMsgDeleteFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDeleteFavoriteMethodResult::most_phonbkfi_tclMsgDeleteFavoriteMethodResult()
:u16FavoriteID(0)
 {}

tS32 most_phonbkfi_tclMsgDeleteFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DeleteFavoriteMethodResult;
}


most_phonbkfi_tclMsgDeleteFavoriteMethodResult::~most_phonbkfi_tclMsgDeleteFavoriteMethodResult()
{}

tU32 most_phonbkfi_tclMsgDeleteFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgDeleteFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDeleteFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_phonbkfi_tclMsgDeleteFavoriteMethodResult::operator==(const most_phonbkfi_tclMsgDeleteFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::most_phonbkfi_tclMsgGetFavoriteInfoMethodStart(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16FavoriteID = coRef.u16FavoriteID;
}
most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::operator=(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16FavoriteID = coRef.u16FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::most_phonbkfi_tclMsgGetFavoriteInfoMethodStart()
:u16FavoriteID(0)
 {}

tS32 most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetFavoriteInfoMethodStart;
}


most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::~most_phonbkfi_tclMsgGetFavoriteInfoMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16FavoriteID);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16FavoriteID);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetFavoriteInfoMethodStart::operator==(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16FavoriteID == roRef.u16FavoriteID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetFavoriteInfoError::most_phonbkfi_tclMsgGetFavoriteInfoError(const most_phonbkfi_tclMsgGetFavoriteInfoError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetFavoriteInfoError& most_phonbkfi_tclMsgGetFavoriteInfoError::operator=(const most_phonbkfi_tclMsgGetFavoriteInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetFavoriteInfoError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetFavoriteInfoError;
}


most_phonbkfi_tclMsgGetFavoriteInfoError::~most_phonbkfi_tclMsgGetFavoriteInfoError()
{}

tBool most_phonbkfi_tclMsgGetFavoriteInfoError::operator==(const most_phonbkfi_tclMsgGetFavoriteInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::most_phonbkfi_tclMsgGetFavoriteInfoMethodResult(const most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32NumItems = coRef.u32NumItems;
   oFavoriteInfo = coRef.oFavoriteInfo;
}
most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::operator=(const most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32NumItems = coRef.u32NumItems;
   oFavoriteInfo = coRef.oFavoriteInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::most_phonbkfi_tclMsgGetFavoriteInfoMethodResult()
:u32NumItems(0)
,oFavoriteInfo()
 {}

tS32 most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetFavoriteInfoMethodResult;
}


most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::~most_phonbkfi_tclMsgGetFavoriteInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oFavoriteInfo.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oFavoriteInfo);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oFavoriteInfo);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetFavoriteInfoMethodResult::operator==(const most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oFavoriteInfo == roRef.oFavoriteInfo);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgResetFavoritesMethodStart::most_phonbkfi_tclMsgResetFavoritesMethodStart()
 {}

tS32 most_phonbkfi_tclMsgResetFavoritesMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ResetFavoritesMethodStart;
}


most_phonbkfi_tclMsgResetFavoritesMethodStart::~most_phonbkfi_tclMsgResetFavoritesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgResetFavoritesError::most_phonbkfi_tclMsgResetFavoritesError(const most_phonbkfi_tclMsgResetFavoritesError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgResetFavoritesError& most_phonbkfi_tclMsgResetFavoritesError::operator=(const most_phonbkfi_tclMsgResetFavoritesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgResetFavoritesError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ResetFavoritesError;
}


most_phonbkfi_tclMsgResetFavoritesError::~most_phonbkfi_tclMsgResetFavoritesError()
{}

tBool most_phonbkfi_tclMsgResetFavoritesError::operator==(const most_phonbkfi_tclMsgResetFavoritesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgResetFavoritesMethodResult::most_phonbkfi_tclMsgResetFavoritesMethodResult()
 {}

tS32 most_phonbkfi_tclMsgResetFavoritesMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ResetFavoritesMethodResult;
}


most_phonbkfi_tclMsgResetFavoritesMethodResult::~most_phonbkfi_tclMsgResetFavoritesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::most_phonbkfi_tclMsgCreatePhoneBookListMethodStart(const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8PhoneBookSortType = coRef.e8PhoneBookSortType;
}
most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::operator=(const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8PhoneBookSortType = coRef.e8PhoneBookSortType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::most_phonbkfi_tclMsgCreatePhoneBookListMethodStart()
:u8DeviceHandle(0)
,e8PhoneBookSortType()
 {}

tS32 most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreatePhoneBookListMethodStart;
}


most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::~most_phonbkfi_tclMsgCreatePhoneBookListMethodStart()
{}

tU32 most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8PhoneBookSortType);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8PhoneBookSortType);
   return oOut;
}

tBool most_phonbkfi_tclMsgCreatePhoneBookListMethodStart::operator==(const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8PhoneBookSortType == roRef.e8PhoneBookSortType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreatePhoneBookListError::most_phonbkfi_tclMsgCreatePhoneBookListError(const most_phonbkfi_tclMsgCreatePhoneBookListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgCreatePhoneBookListError& most_phonbkfi_tclMsgCreatePhoneBookListError::operator=(const most_phonbkfi_tclMsgCreatePhoneBookListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgCreatePhoneBookListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreatePhoneBookListError;
}


most_phonbkfi_tclMsgCreatePhoneBookListError::~most_phonbkfi_tclMsgCreatePhoneBookListError()
{}

tBool most_phonbkfi_tclMsgCreatePhoneBookListError::operator==(const most_phonbkfi_tclMsgCreatePhoneBookListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::most_phonbkfi_tclMsgCreatePhoneBookListMethodResult(const most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
}
most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::operator=(const most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::most_phonbkfi_tclMsgCreatePhoneBookListMethodResult()
:u16ListHandle(0)
,u16ListLength(0)
 {}

tS32 most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreatePhoneBookListMethodResult;
}


most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::~most_phonbkfi_tclMsgCreatePhoneBookListMethodResult()
{}

tU32 most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u16ListLength);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u16ListLength);
   return oOut;
}

tBool most_phonbkfi_tclMsgCreatePhoneBookListMethodResult::operator==(const most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u16ListLength == roRef.u16ListLength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::operator=(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart()
:u16ListHandle(0)
 {}

tS32 most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchKeyboardPhoneBookListMethodStart;
}


most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::~most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart()
{}

tU32 most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart::operator==(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError::most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError::operator=(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchKeyboardPhoneBookListError;
}


most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError::~most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError()
{}

tBool most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError::operator==(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   oSearchKeyboardList = coRef.oSearchKeyboardList;
}
most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::operator=(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   oSearchKeyboardList = coRef.oSearchKeyboardList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult()
:u16ListHandle(0)
,oSearchKeyboardList()
 {}

tS32 most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchKeyboardPhoneBookListMethodResult;
}


most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::~most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSearchKeyboardList.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> oSearchKeyboardList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << oSearchKeyboardList);
   return oOut;
}

tBool most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult::operator==(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (oSearchKeyboardList == roRef.oSearchKeyboardList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::most_phonbkfi_tclMsgReleasePhoneBookListMethodStart(const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::operator=(const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::most_phonbkfi_tclMsgReleasePhoneBookListMethodStart()
:u16ListHandle(0)
 {}

tS32 most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ReleasePhoneBookListMethodStart;
}


most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::~most_phonbkfi_tclMsgReleasePhoneBookListMethodStart()
{}

tU32 most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgReleasePhoneBookListMethodStart::operator==(const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgReleasePhoneBookListError::most_phonbkfi_tclMsgReleasePhoneBookListError(const most_phonbkfi_tclMsgReleasePhoneBookListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgReleasePhoneBookListError& most_phonbkfi_tclMsgReleasePhoneBookListError::operator=(const most_phonbkfi_tclMsgReleasePhoneBookListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgReleasePhoneBookListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ReleasePhoneBookListError;
}


most_phonbkfi_tclMsgReleasePhoneBookListError::~most_phonbkfi_tclMsgReleasePhoneBookListError()
{}

tBool most_phonbkfi_tclMsgReleasePhoneBookListError::operator==(const most_phonbkfi_tclMsgReleasePhoneBookListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::most_phonbkfi_tclMsgReleasePhoneBookListMethodResult(const most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::operator=(const most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::most_phonbkfi_tclMsgReleasePhoneBookListMethodResult()
:u16ListHandle(0)
 {}

tS32 most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ReleasePhoneBookListMethodResult;
}


most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::~most_phonbkfi_tclMsgReleasePhoneBookListMethodResult()
{}

tU32 most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgReleasePhoneBookListMethodResult::operator==(const most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactDetailsMethodStart::most_phonbkfi_tclMsgGetContactDetailsMethodStart(const most_phonbkfi_tclMsgGetContactDetailsMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactDetailFilter = coRef.e8ContactDetailFilter;
}
most_phonbkfi_tclMsgGetContactDetailsMethodStart& most_phonbkfi_tclMsgGetContactDetailsMethodStart::operator=(const most_phonbkfi_tclMsgGetContactDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactDetailFilter = coRef.e8ContactDetailFilter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetContactDetailsMethodStart::most_phonbkfi_tclMsgGetContactDetailsMethodStart()
:u32ContactHandle(0)
,e8ContactDetailFilter()
 {}

tS32 most_phonbkfi_tclMsgGetContactDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactDetailsMethodStart;
}


most_phonbkfi_tclMsgGetContactDetailsMethodStart::~most_phonbkfi_tclMsgGetContactDetailsMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetContactDetailsMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> e8ContactDetailFilter);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << e8ContactDetailFilter);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactDetailsMethodStart::operator==(const most_phonbkfi_tclMsgGetContactDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (e8ContactDetailFilter == roRef.e8ContactDetailFilter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactDetailsError::most_phonbkfi_tclMsgGetContactDetailsError(const most_phonbkfi_tclMsgGetContactDetailsError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetContactDetailsError& most_phonbkfi_tclMsgGetContactDetailsError::operator=(const most_phonbkfi_tclMsgGetContactDetailsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetContactDetailsError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactDetailsError;
}


most_phonbkfi_tclMsgGetContactDetailsError::~most_phonbkfi_tclMsgGetContactDetailsError()
{}

tBool most_phonbkfi_tclMsgGetContactDetailsError::operator==(const most_phonbkfi_tclMsgGetContactDetailsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactDetailsMethodResult::most_phonbkfi_tclMsgGetContactDetailsMethodResult(const most_phonbkfi_tclMsgGetContactDetailsMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oContactDetails = coRef.oContactDetails;
}
most_phonbkfi_tclMsgGetContactDetailsMethodResult& most_phonbkfi_tclMsgGetContactDetailsMethodResult::operator=(const most_phonbkfi_tclMsgGetContactDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oContactDetails = coRef.oContactDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgGetContactDetailsMethodResult::vDestroy()
{
   oContactDetails.vDestroy(); 
}

most_phonbkfi_tclMsgGetContactDetailsMethodResult::most_phonbkfi_tclMsgGetContactDetailsMethodResult()
:oContactDetails()
 {}

tS32 most_phonbkfi_tclMsgGetContactDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactDetailsMethodResult;
}


most_phonbkfi_tclMsgGetContactDetailsMethodResult::~most_phonbkfi_tclMsgGetContactDetailsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgGetContactDetailsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactDetails.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oContactDetails);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oContactDetails);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactDetailsMethodResult::operator==(const most_phonbkfi_tclMsgGetContactDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oContactDetails == roRef.oContactDetails);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactPhotoMethodStart::most_phonbkfi_tclMsgGetContactPhotoMethodStart(const most_phonbkfi_tclMsgGetContactPhotoMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgGetContactPhotoMethodStart& most_phonbkfi_tclMsgGetContactPhotoMethodStart::operator=(const most_phonbkfi_tclMsgGetContactPhotoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetContactPhotoMethodStart::most_phonbkfi_tclMsgGetContactPhotoMethodStart()
:u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgGetContactPhotoMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactPhotoMethodStart;
}


most_phonbkfi_tclMsgGetContactPhotoMethodStart::~most_phonbkfi_tclMsgGetContactPhotoMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetContactPhotoMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactPhotoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactPhotoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactPhotoMethodStart::operator==(const most_phonbkfi_tclMsgGetContactPhotoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactPhotoError::most_phonbkfi_tclMsgGetContactPhotoError(const most_phonbkfi_tclMsgGetContactPhotoError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetContactPhotoError& most_phonbkfi_tclMsgGetContactPhotoError::operator=(const most_phonbkfi_tclMsgGetContactPhotoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetContactPhotoError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactPhotoError;
}


most_phonbkfi_tclMsgGetContactPhotoError::~most_phonbkfi_tclMsgGetContactPhotoError()
{}

tBool most_phonbkfi_tclMsgGetContactPhotoError::operator==(const most_phonbkfi_tclMsgGetContactPhotoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactPhotoMethodResult::most_phonbkfi_tclMsgGetContactPhotoMethodResult(const most_phonbkfi_tclMsgGetContactPhotoMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   oContactPhoto = coRef.oContactPhoto;
}
most_phonbkfi_tclMsgGetContactPhotoMethodResult& most_phonbkfi_tclMsgGetContactPhotoMethodResult::operator=(const most_phonbkfi_tclMsgGetContactPhotoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   oContactPhoto = coRef.oContactPhoto;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetContactPhotoMethodResult::most_phonbkfi_tclMsgGetContactPhotoMethodResult()
:u32ContactHandle(0)
,oContactPhoto()
 {}

tS32 most_phonbkfi_tclMsgGetContactPhotoMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactPhotoMethodResult;
}


most_phonbkfi_tclMsgGetContactPhotoMethodResult::~most_phonbkfi_tclMsgGetContactPhotoMethodResult()
{}

tU32 most_phonbkfi_tclMsgGetContactPhotoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactPhoto.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactPhotoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> oContactPhoto);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactPhotoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << oContactPhoto);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactPhotoMethodResult::operator==(const most_phonbkfi_tclMsgGetContactPhotoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (oContactPhoto == roRef.oContactPhoto);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAddContactMethodStart::most_phonbkfi_tclMsgAddContactMethodStart(const most_phonbkfi_tclMsgAddContactMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oContactDetails = coRef.oContactDetails;
}
most_phonbkfi_tclMsgAddContactMethodStart& most_phonbkfi_tclMsgAddContactMethodStart::operator=(const most_phonbkfi_tclMsgAddContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oContactDetails = coRef.oContactDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgAddContactMethodStart::vDestroy()
{
   oContactDetails.vDestroy(); 
}

most_phonbkfi_tclMsgAddContactMethodStart::most_phonbkfi_tclMsgAddContactMethodStart()
:u8DeviceHandle(0)
,oContactDetails()
 {}

tS32 most_phonbkfi_tclMsgAddContactMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AddContactMethodStart;
}


most_phonbkfi_tclMsgAddContactMethodStart::~most_phonbkfi_tclMsgAddContactMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgAddContactMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactDetails.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgAddContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oContactDetails);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAddContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oContactDetails);
   return oOut;
}

tBool most_phonbkfi_tclMsgAddContactMethodStart::operator==(const most_phonbkfi_tclMsgAddContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oContactDetails == roRef.oContactDetails);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAddContactError::most_phonbkfi_tclMsgAddContactError(const most_phonbkfi_tclMsgAddContactError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgAddContactError& most_phonbkfi_tclMsgAddContactError::operator=(const most_phonbkfi_tclMsgAddContactError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgAddContactError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AddContactError;
}


most_phonbkfi_tclMsgAddContactError::~most_phonbkfi_tclMsgAddContactError()
{}

tBool most_phonbkfi_tclMsgAddContactError::operator==(const most_phonbkfi_tclMsgAddContactError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAddContactMethodResult::most_phonbkfi_tclMsgAddContactMethodResult(const most_phonbkfi_tclMsgAddContactMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactAddStatus = coRef.e8ContactAddStatus;
}
most_phonbkfi_tclMsgAddContactMethodResult& most_phonbkfi_tclMsgAddContactMethodResult::operator=(const most_phonbkfi_tclMsgAddContactMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactAddStatus = coRef.e8ContactAddStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgAddContactMethodResult::most_phonbkfi_tclMsgAddContactMethodResult()
:u32ContactHandle(0)
,e8ContactAddStatus()
 {}

tS32 most_phonbkfi_tclMsgAddContactMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AddContactMethodResult;
}


most_phonbkfi_tclMsgAddContactMethodResult::~most_phonbkfi_tclMsgAddContactMethodResult()
{}

tU32 most_phonbkfi_tclMsgAddContactMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgAddContactMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> e8ContactAddStatus);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAddContactMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << e8ContactAddStatus);
   return oOut;
}

tBool most_phonbkfi_tclMsgAddContactMethodResult::operator==(const most_phonbkfi_tclMsgAddContactMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (e8ContactAddStatus == roRef.e8ContactAddStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDeleteContactMethodStart::most_phonbkfi_tclMsgDeleteContactMethodStart(const most_phonbkfi_tclMsgDeleteContactMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgDeleteContactMethodStart& most_phonbkfi_tclMsgDeleteContactMethodStart::operator=(const most_phonbkfi_tclMsgDeleteContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDeleteContactMethodStart::most_phonbkfi_tclMsgDeleteContactMethodStart()
:u8DeviceHandle(0)
,u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgDeleteContactMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DeleteContactMethodStart;
}


most_phonbkfi_tclMsgDeleteContactMethodStart::~most_phonbkfi_tclMsgDeleteContactMethodStart()
{}

tU32 most_phonbkfi_tclMsgDeleteContactMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgDeleteContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDeleteContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgDeleteContactMethodStart::operator==(const most_phonbkfi_tclMsgDeleteContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDeleteContactError::most_phonbkfi_tclMsgDeleteContactError(const most_phonbkfi_tclMsgDeleteContactError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDeleteContactError& most_phonbkfi_tclMsgDeleteContactError::operator=(const most_phonbkfi_tclMsgDeleteContactError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDeleteContactError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DeleteContactError;
}


most_phonbkfi_tclMsgDeleteContactError::~most_phonbkfi_tclMsgDeleteContactError()
{}

tBool most_phonbkfi_tclMsgDeleteContactError::operator==(const most_phonbkfi_tclMsgDeleteContactError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDeleteContactMethodResult::most_phonbkfi_tclMsgDeleteContactMethodResult(const most_phonbkfi_tclMsgDeleteContactMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactDeleteStatus = coRef.e8ContactDeleteStatus;
}
most_phonbkfi_tclMsgDeleteContactMethodResult& most_phonbkfi_tclMsgDeleteContactMethodResult::operator=(const most_phonbkfi_tclMsgDeleteContactMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactDeleteStatus = coRef.e8ContactDeleteStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDeleteContactMethodResult::most_phonbkfi_tclMsgDeleteContactMethodResult()
:u32ContactHandle(0)
,e8ContactDeleteStatus()
 {}

tS32 most_phonbkfi_tclMsgDeleteContactMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DeleteContactMethodResult;
}


most_phonbkfi_tclMsgDeleteContactMethodResult::~most_phonbkfi_tclMsgDeleteContactMethodResult()
{}

tU32 most_phonbkfi_tclMsgDeleteContactMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgDeleteContactMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> e8ContactDeleteStatus);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDeleteContactMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << e8ContactDeleteStatus);
   return oOut;
}

tBool most_phonbkfi_tclMsgDeleteContactMethodResult::operator==(const most_phonbkfi_tclMsgDeleteContactMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (e8ContactDeleteStatus == roRef.e8ContactDeleteStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgEditContactMethodStart::most_phonbkfi_tclMsgEditContactMethodStart(const most_phonbkfi_tclMsgEditContactMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   oContactDetails = coRef.oContactDetails;
}
most_phonbkfi_tclMsgEditContactMethodStart& most_phonbkfi_tclMsgEditContactMethodStart::operator=(const most_phonbkfi_tclMsgEditContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   oContactDetails = coRef.oContactDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgEditContactMethodStart::vDestroy()
{
   oContactDetails.vDestroy(); 
}

most_phonbkfi_tclMsgEditContactMethodStart::most_phonbkfi_tclMsgEditContactMethodStart()
:u8DeviceHandle(0)
,u32ContactHandle(0)
,oContactDetails()
 {}

tS32 most_phonbkfi_tclMsgEditContactMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_EditContactMethodStart;
}


most_phonbkfi_tclMsgEditContactMethodStart::~most_phonbkfi_tclMsgEditContactMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgEditContactMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactDetails.u32GetSize(u16MajorVersion);
   return 5 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgEditContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> oContactDetails);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgEditContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << oContactDetails);
   return oOut;
}

tBool most_phonbkfi_tclMsgEditContactMethodStart::operator==(const most_phonbkfi_tclMsgEditContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (oContactDetails == roRef.oContactDetails);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgEditContactError::most_phonbkfi_tclMsgEditContactError(const most_phonbkfi_tclMsgEditContactError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgEditContactError& most_phonbkfi_tclMsgEditContactError::operator=(const most_phonbkfi_tclMsgEditContactError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgEditContactError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_EditContactError;
}


most_phonbkfi_tclMsgEditContactError::~most_phonbkfi_tclMsgEditContactError()
{}

tBool most_phonbkfi_tclMsgEditContactError::operator==(const most_phonbkfi_tclMsgEditContactError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgEditContactMethodResult::most_phonbkfi_tclMsgEditContactMethodResult(const most_phonbkfi_tclMsgEditContactMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactEditStatus = coRef.e8ContactEditStatus;
}
most_phonbkfi_tclMsgEditContactMethodResult& most_phonbkfi_tclMsgEditContactMethodResult::operator=(const most_phonbkfi_tclMsgEditContactMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactEditStatus = coRef.e8ContactEditStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgEditContactMethodResult::most_phonbkfi_tclMsgEditContactMethodResult()
:u32ContactHandle(0)
,e8ContactEditStatus()
 {}

tS32 most_phonbkfi_tclMsgEditContactMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_EditContactMethodResult;
}


most_phonbkfi_tclMsgEditContactMethodResult::~most_phonbkfi_tclMsgEditContactMethodResult()
{}

tU32 most_phonbkfi_tclMsgEditContactMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgEditContactMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> e8ContactEditStatus);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgEditContactMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << e8ContactEditStatus);
   return oOut;
}

tBool most_phonbkfi_tclMsgEditContactMethodResult::operator==(const most_phonbkfi_tclMsgEditContactMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (e8ContactEditStatus == roRef.e8ContactEditStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::most_phonbkfi_tclMsgCreateCallHistoryListMethodStart(const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8CallHistoryType = coRef.e8CallHistoryType;
   e8CallHistorySortType = coRef.e8CallHistorySortType;
}
most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::operator=(const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8CallHistoryType = coRef.e8CallHistoryType;
   e8CallHistorySortType = coRef.e8CallHistorySortType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::most_phonbkfi_tclMsgCreateCallHistoryListMethodStart()
:u8DeviceHandle(0)
,e8CallHistoryType()
,e8CallHistorySortType()
 {}

tS32 most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreateCallHistoryListMethodStart;
}


most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::~most_phonbkfi_tclMsgCreateCallHistoryListMethodStart()
{}

tU32 most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8CallHistoryType);
   (tVoid) (oIn >> e8CallHistorySortType);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8CallHistoryType);
   (tVoid) (oOut << e8CallHistorySortType);
   return oOut;
}

tBool most_phonbkfi_tclMsgCreateCallHistoryListMethodStart::operator==(const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8CallHistoryType == roRef.e8CallHistoryType);
   bResult = bResult && (e8CallHistorySortType == roRef.e8CallHistorySortType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreateCallHistoryListError::most_phonbkfi_tclMsgCreateCallHistoryListError(const most_phonbkfi_tclMsgCreateCallHistoryListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgCreateCallHistoryListError& most_phonbkfi_tclMsgCreateCallHistoryListError::operator=(const most_phonbkfi_tclMsgCreateCallHistoryListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgCreateCallHistoryListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreateCallHistoryListError;
}


most_phonbkfi_tclMsgCreateCallHistoryListError::~most_phonbkfi_tclMsgCreateCallHistoryListError()
{}

tBool most_phonbkfi_tclMsgCreateCallHistoryListError::operator==(const most_phonbkfi_tclMsgCreateCallHistoryListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::most_phonbkfi_tclMsgCreateCallHistoryListMethodResult(const most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
}
most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::operator=(const most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::most_phonbkfi_tclMsgCreateCallHistoryListMethodResult()
:u8DeviceHandle(0)
,u16ListHandle(0)
,u16ListLength(0)
 {}

tS32 most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreateCallHistoryListMethodResult;
}


most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::~most_phonbkfi_tclMsgCreateCallHistoryListMethodResult()
{}

tU32 most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u16ListLength);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u16ListLength);
   return oOut;
}

tBool most_phonbkfi_tclMsgCreateCallHistoryListMethodResult::operator==(const most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u16ListLength == roRef.u16ListLength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart()
:u16ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListMethodStart;
}


most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::~most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart()
{}

tU32 most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart::operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestSliceCallHistoryListError::most_phonbkfi_tclMsgRequestSliceCallHistoryListError(const most_phonbkfi_tclMsgRequestSliceCallHistoryListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgRequestSliceCallHistoryListError& most_phonbkfi_tclMsgRequestSliceCallHistoryListError::operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgRequestSliceCallHistoryListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListError;
}


most_phonbkfi_tclMsgRequestSliceCallHistoryListError::~most_phonbkfi_tclMsgRequestSliceCallHistoryListError()
{}

tBool most_phonbkfi_tclMsgRequestSliceCallHistoryListError::operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oCallHistoryListSliceResult = coRef.oCallHistoryListSliceResult;
}
most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oCallHistoryListSliceResult = coRef.oCallHistoryListSliceResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult()
:oCallHistoryListSliceResult()
 {}

tS32 most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListMethodResult;
}


most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::~most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oCallHistoryListSliceResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oCallHistoryListSliceResult);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oCallHistoryListSliceResult);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult::operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oCallHistoryListSliceResult == roRef.oCallHistoryListSliceResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::operator=(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearMissedCallIndicatorMethodStart;
}


most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::~most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart()
{}

tU32 most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart::operator==(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearMissedCallIndicatorError::most_phonbkfi_tclMsgClearMissedCallIndicatorError(const most_phonbkfi_tclMsgClearMissedCallIndicatorError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgClearMissedCallIndicatorError& most_phonbkfi_tclMsgClearMissedCallIndicatorError::operator=(const most_phonbkfi_tclMsgClearMissedCallIndicatorError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgClearMissedCallIndicatorError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearMissedCallIndicatorError;
}


most_phonbkfi_tclMsgClearMissedCallIndicatorError::~most_phonbkfi_tclMsgClearMissedCallIndicatorError()
{}

tBool most_phonbkfi_tclMsgClearMissedCallIndicatorError::operator==(const most_phonbkfi_tclMsgClearMissedCallIndicatorError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::operator=(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearMissedCallIndicatorMethodResult;
}


most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::~most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult()
{}

tU32 most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult::operator==(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchPhoneBookMethodStart::most_phonbkfi_tclMsgSearchPhoneBookMethodStart(const most_phonbkfi_tclMsgSearchPhoneBookMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   sPhoneNumber = coRef.sPhoneNumber;
   sEmailAddress = coRef.sEmailAddress;
}
most_phonbkfi_tclMsgSearchPhoneBookMethodStart& most_phonbkfi_tclMsgSearchPhoneBookMethodStart::operator=(const most_phonbkfi_tclMsgSearchPhoneBookMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   sPhoneNumber = coRef.sPhoneNumber;
   sEmailAddress = coRef.sEmailAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgSearchPhoneBookMethodStart::vDestroy()
{
   sPhoneNumber.vDestroy(); 
   sEmailAddress.vDestroy(); 
}

most_phonbkfi_tclMsgSearchPhoneBookMethodStart::most_phonbkfi_tclMsgSearchPhoneBookMethodStart()
:u8DeviceHandle(0)
,sPhoneNumber()
,sEmailAddress()
 {}

tS32 most_phonbkfi_tclMsgSearchPhoneBookMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchPhoneBookMethodStart;
}


most_phonbkfi_tclMsgSearchPhoneBookMethodStart::~most_phonbkfi_tclMsgSearchPhoneBookMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgSearchPhoneBookMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPhoneNumber.u32GetSize(u16MajorVersion);
   u32DynamicSize += sEmailAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgSearchPhoneBookMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> sPhoneNumber);
   (tVoid) (oIn >> sEmailAddress);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSearchPhoneBookMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << sPhoneNumber);
   (tVoid) (oOut << sEmailAddress);
   return oOut;
}

tBool most_phonbkfi_tclMsgSearchPhoneBookMethodStart::operator==(const most_phonbkfi_tclMsgSearchPhoneBookMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (sPhoneNumber == roRef.sPhoneNumber);
   bResult = bResult && (sEmailAddress == roRef.sEmailAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchPhoneBookError::most_phonbkfi_tclMsgSearchPhoneBookError(const most_phonbkfi_tclMsgSearchPhoneBookError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSearchPhoneBookError& most_phonbkfi_tclMsgSearchPhoneBookError::operator=(const most_phonbkfi_tclMsgSearchPhoneBookError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSearchPhoneBookError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchPhoneBookError;
}


most_phonbkfi_tclMsgSearchPhoneBookError::~most_phonbkfi_tclMsgSearchPhoneBookError()
{}

tBool most_phonbkfi_tclMsgSearchPhoneBookError::operator==(const most_phonbkfi_tclMsgSearchPhoneBookError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchPhoneBookMethodResult::most_phonbkfi_tclMsgSearchPhoneBookMethodResult(const most_phonbkfi_tclMsgSearchPhoneBookMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   u8DeviceHandle = coRef.u8DeviceHandle;
   sFirstName = coRef.sFirstName;
   sLastName = coRef.sLastName;
   e8ContactDetailType = coRef.e8ContactDetailType;
}
most_phonbkfi_tclMsgSearchPhoneBookMethodResult& most_phonbkfi_tclMsgSearchPhoneBookMethodResult::operator=(const most_phonbkfi_tclMsgSearchPhoneBookMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   u8DeviceHandle = coRef.u8DeviceHandle;
   sFirstName = coRef.sFirstName;
   sLastName = coRef.sLastName;
   e8ContactDetailType = coRef.e8ContactDetailType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgSearchPhoneBookMethodResult::vDestroy()
{
   sFirstName.vDestroy(); 
   sLastName.vDestroy(); 
}

most_phonbkfi_tclMsgSearchPhoneBookMethodResult::most_phonbkfi_tclMsgSearchPhoneBookMethodResult()
:u32ContactHandle(0)
,u8DeviceHandle(0)
,sFirstName()
,sLastName()
,e8ContactDetailType()
 {}

tS32 most_phonbkfi_tclMsgSearchPhoneBookMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchPhoneBookMethodResult;
}


most_phonbkfi_tclMsgSearchPhoneBookMethodResult::~most_phonbkfi_tclMsgSearchPhoneBookMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgSearchPhoneBookMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sFirstName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sLastName.u32GetSize(u16MajorVersion);
   return 6 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgSearchPhoneBookMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> sFirstName);
   (tVoid) (oIn >> sLastName);
   (tVoid) (oIn >> e8ContactDetailType);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSearchPhoneBookMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << sFirstName);
   (tVoid) (oOut << sLastName);
   (tVoid) (oOut << e8ContactDetailType);
   return oOut;
}

tBool most_phonbkfi_tclMsgSearchPhoneBookMethodResult::operator==(const most_phonbkfi_tclMsgSearchPhoneBookMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (sFirstName == roRef.sFirstName);
   bResult = bResult && (sLastName == roRef.sLastName);
   bResult = bResult && (e8ContactDetailType == roRef.e8ContactDetailType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::operator=(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart()
:u16ListHandle(0)
 {}

tS32 most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ReleaseCallHistoryListMethodStart;
}


most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::~most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart()
{}

tU32 most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart::operator==(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgReleaseCallHistoryListError::most_phonbkfi_tclMsgReleaseCallHistoryListError(const most_phonbkfi_tclMsgReleaseCallHistoryListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgReleaseCallHistoryListError& most_phonbkfi_tclMsgReleaseCallHistoryListError::operator=(const most_phonbkfi_tclMsgReleaseCallHistoryListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgReleaseCallHistoryListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ReleaseCallHistoryListError;
}


most_phonbkfi_tclMsgReleaseCallHistoryListError::~most_phonbkfi_tclMsgReleaseCallHistoryListError()
{}

tBool most_phonbkfi_tclMsgReleaseCallHistoryListError::operator==(const most_phonbkfi_tclMsgReleaseCallHistoryListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::operator=(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult()
:u16ListHandle(0)
 {}

tS32 most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ReleaseCallHistoryListMethodResult;
}


most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::~most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult()
{}

tU32 most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult::operator==(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::operator=(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart()
:u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactPhotoInfoMethodStart;
}


most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::~most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart::operator==(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactPhotoInfoError::most_phonbkfi_tclMsgGetContactPhotoInfoError(const most_phonbkfi_tclMsgGetContactPhotoInfoError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetContactPhotoInfoError& most_phonbkfi_tclMsgGetContactPhotoInfoError::operator=(const most_phonbkfi_tclMsgGetContactPhotoInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetContactPhotoInfoError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactPhotoInfoError;
}


most_phonbkfi_tclMsgGetContactPhotoInfoError::~most_phonbkfi_tclMsgGetContactPhotoInfoError()
{}

tBool most_phonbkfi_tclMsgGetContactPhotoInfoError::operator==(const most_phonbkfi_tclMsgGetContactPhotoInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoImageSize = coRef.u32PhotoImageSize;
}
most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::operator=(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32PhotoImageSize = coRef.u32PhotoImageSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::vDestroy()
{
   sMIMEImageSubtype.vDestroy(); 
}

most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult()
:u32ContactHandle(0)
,sMIMEImageSubtype()
,u32PhotoImageSize(0)
 {}

tS32 most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactPhotoInfoMethodResult;
}


most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::~most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sMIMEImageSubtype.u32GetSize(u16MajorVersion);
   return 8 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> sMIMEImageSubtype);
   (tVoid) (oIn >> u32PhotoImageSize);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << sMIMEImageSubtype);
   (tVoid) (oOut << u32PhotoImageSize);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult::operator==(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (sMIMEImageSubtype == roRef.sMIMEImageSubtype);
   bResult = bResult && (u32PhotoImageSize == roRef.u32PhotoImageSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::operator=(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetDeviceCallHistorySupportMethodStart;
}


most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::~most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart::operator==(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetDeviceCallHistorySupportError::most_phonbkfi_tclMsgGetDeviceCallHistorySupportError(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& most_phonbkfi_tclMsgGetDeviceCallHistorySupportError::operator=(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetDeviceCallHistorySupportError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetDeviceCallHistorySupportError;
}


most_phonbkfi_tclMsgGetDeviceCallHistorySupportError::~most_phonbkfi_tclMsgGetDeviceCallHistorySupportError()
{}

tBool most_phonbkfi_tclMsgGetDeviceCallHistorySupportError::operator==(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oCallHistoryTypeSupport = coRef.oCallHistoryTypeSupport;
   bCallHistoryDateTimeSupport = coRef.bCallHistoryDateTimeSupport;
}
most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::operator=(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oCallHistoryTypeSupport = coRef.oCallHistoryTypeSupport;
   bCallHistoryDateTimeSupport = coRef.bCallHistoryDateTimeSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult()
:u8DeviceHandle(0)
,oCallHistoryTypeSupport()
,bCallHistoryDateTimeSupport(0)
 {}

tS32 most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetDeviceCallHistorySupportMethodResult;
}


most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::~most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult()
{}

tU32 most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oCallHistoryTypeSupport.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oCallHistoryTypeSupport);
   (tVoid) (oIn >> bCallHistoryDateTimeSupport);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oCallHistoryTypeSupport);
   (tVoid) (oOut << bCallHistoryDateTimeSupport);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult::operator==(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oCallHistoryTypeSupport == roRef.oCallHistoryTypeSupport);
   bResult = bResult && (bCallHistoryDateTimeSupport == roRef.bCallHistoryDateTimeSupport);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   sPhoneNumberDigits = coRef.sPhoneNumberDigits;
}
most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::operator=(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPhoneNumberDigits = coRef.sPhoneNumberDigits;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::vDestroy()
{
   sPhoneNumberDigits.vDestroy(); 
}

most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart()
:sPhoneNumberDigits()
 {}

tS32 most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutocompletePhoneNumberEntryMethodStart;
}


most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::~most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPhoneNumberDigits.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPhoneNumberDigits);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPhoneNumberDigits);
   return oOut;
}

tBool most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart::operator==(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPhoneNumberDigits == roRef.sPhoneNumberDigits);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError::most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError::operator=(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutocompletePhoneNumberEntryError;
}


most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError::~most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError()
{}

tBool most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError::operator==(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   bAutocompleteMatch = coRef.bAutocompleteMatch;
   sAutocompleteMatchPhoneNumber = coRef.sAutocompleteMatchPhoneNumber;
   u8NumberOfMatches = coRef.u8NumberOfMatches;
   oAutocompleteMultipleMatchList = coRef.oAutocompleteMultipleMatchList;
}
most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::operator=(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bAutocompleteMatch = coRef.bAutocompleteMatch;
   sAutocompleteMatchPhoneNumber = coRef.sAutocompleteMatchPhoneNumber;
   u8NumberOfMatches = coRef.u8NumberOfMatches;
   oAutocompleteMultipleMatchList = coRef.oAutocompleteMultipleMatchList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::vDestroy()
{
   sAutocompleteMatchPhoneNumber.vDestroy(); 
}

most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult()
:bAutocompleteMatch(0)
,sAutocompleteMatchPhoneNumber()
,u8NumberOfMatches(0)
,oAutocompleteMultipleMatchList()
 {}

tS32 most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutocompletePhoneNumberEntryMethodResult;
}


most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::~most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sAutocompleteMatchPhoneNumber.u32GetSize(u16MajorVersion);
   u32DynamicSize += oAutocompleteMultipleMatchList.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutocompleteMatch);
   (tVoid) (oIn >> sAutocompleteMatchPhoneNumber);
   (tVoid) (oIn >> u8NumberOfMatches);
   (tVoid) (oIn >> oAutocompleteMultipleMatchList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutocompleteMatch);
   (tVoid) (oOut << sAutocompleteMatchPhoneNumber);
   (tVoid) (oOut << u8NumberOfMatches);
   (tVoid) (oOut << oAutocompleteMultipleMatchList);
   return oOut;
}

tBool most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult::operator==(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutocompleteMatch == roRef.bAutocompleteMatch);
   bResult = bResult && (sAutocompleteMatchPhoneNumber == roRef.sAutocompleteMatchPhoneNumber);
   bResult = bResult && (u8NumberOfMatches == roRef.u8NumberOfMatches);
   bResult = bResult && (oAutocompleteMultipleMatchList == roRef.oAutocompleteMultipleMatchList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgClearPhoneBookDataMethodStart::most_phonbkfi_tclMsgClearPhoneBookDataMethodStart()
 {}

tS32 most_phonbkfi_tclMsgClearPhoneBookDataMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearPhoneBookDataMethodStart;
}


most_phonbkfi_tclMsgClearPhoneBookDataMethodStart::~most_phonbkfi_tclMsgClearPhoneBookDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearPhoneBookDataError::most_phonbkfi_tclMsgClearPhoneBookDataError(const most_phonbkfi_tclMsgClearPhoneBookDataError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgClearPhoneBookDataError& most_phonbkfi_tclMsgClearPhoneBookDataError::operator=(const most_phonbkfi_tclMsgClearPhoneBookDataError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgClearPhoneBookDataError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearPhoneBookDataError;
}


most_phonbkfi_tclMsgClearPhoneBookDataError::~most_phonbkfi_tclMsgClearPhoneBookDataError()
{}

tBool most_phonbkfi_tclMsgClearPhoneBookDataError::operator==(const most_phonbkfi_tclMsgClearPhoneBookDataError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::most_phonbkfi_tclMsgClearPhoneBookDataMethodResult(const most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   bDummyResult = coRef.bDummyResult;
}
most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::operator=(const most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bDummyResult = coRef.bDummyResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::most_phonbkfi_tclMsgClearPhoneBookDataMethodResult()
:bDummyResult(0)
 {}

tS32 most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearPhoneBookDataMethodResult;
}


most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::~most_phonbkfi_tclMsgClearPhoneBookDataMethodResult()
{}

tU32 most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDummyResult);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDummyResult);
   return oOut;
}

tBool most_phonbkfi_tclMsgClearPhoneBookDataMethodResult::operator==(const most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDummyResult == roRef.bDummyResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart()
:u16ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceMethodStart;
}


most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::~most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart()
{}

tU32 most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart::operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestPhoneBookListSliceError::most_phonbkfi_tclMsgRequestPhoneBookListSliceError(const most_phonbkfi_tclMsgRequestPhoneBookListSliceError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgRequestPhoneBookListSliceError& most_phonbkfi_tclMsgRequestPhoneBookListSliceError::operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgRequestPhoneBookListSliceError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceError;
}


most_phonbkfi_tclMsgRequestPhoneBookListSliceError::~most_phonbkfi_tclMsgRequestPhoneBookListSliceError()
{}

tBool most_phonbkfi_tclMsgRequestPhoneBookListSliceError::operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oPhoneBookListSliceResult = coRef.oPhoneBookListSliceResult;
}
most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oPhoneBookListSliceResult = coRef.oPhoneBookListSliceResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult()
:oPhoneBookListSliceResult()
 {}

tS32 most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceMethodResult;
}


most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::~most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oPhoneBookListSliceResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oPhoneBookListSliceResult);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oPhoneBookListSliceResult);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult::operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oPhoneBookListSliceResult == roRef.oPhoneBookListSliceResult);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart::most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart()
 {}

tS32 most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhoneBookMethodStart;
}


most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart::~most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearVehiclePhoneBookError::most_phonbkfi_tclMsgClearVehiclePhoneBookError(const most_phonbkfi_tclMsgClearVehiclePhoneBookError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgClearVehiclePhoneBookError& most_phonbkfi_tclMsgClearVehiclePhoneBookError::operator=(const most_phonbkfi_tclMsgClearVehiclePhoneBookError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgClearVehiclePhoneBookError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhoneBookError;
}


most_phonbkfi_tclMsgClearVehiclePhoneBookError::~most_phonbkfi_tclMsgClearVehiclePhoneBookError()
{}

tBool most_phonbkfi_tclMsgClearVehiclePhoneBookError::operator==(const most_phonbkfi_tclMsgClearVehiclePhoneBookError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   bDummyResult = coRef.bDummyResult;
}
most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::operator=(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bDummyResult = coRef.bDummyResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult()
:bDummyResult(0)
 {}

tS32 most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhoneBookMethodResult;
}


most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::~most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult()
{}

tU32 most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDummyResult);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDummyResult);
   return oOut;
}

tBool most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult::operator==(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDummyResult == roRef.bDummyResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart()
:u16ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListExtendedMethodStart;
}


most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::~most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart()
{}

tU32 most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart::operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError::most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError::operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListExtendedError;
}


most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError::~most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError()
{}

tBool most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError::operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oCallHistoryListSliceResultExtended = coRef.oCallHistoryListSliceResultExtended;
}
most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oCallHistoryListSliceResultExtended = coRef.oCallHistoryListSliceResultExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult()
:oCallHistoryListSliceResultExtended()
 {}

tS32 most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestSliceCallHistoryListExtendedMethodResult;
}


most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::~most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oCallHistoryListSliceResultExtended.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oCallHistoryListSliceResultExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oCallHistoryListSliceResultExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult::operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oCallHistoryListSliceResultExtended == roRef.oCallHistoryListSliceResultExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
}
most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u16WindowSize = coRef.u16WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart()
:u16ListHandle(0)
,u32WindowStart(0)
,u16WindowSize(0)
 {}

tS32 most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceExtendedMethodStart;
}


most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::~most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart()
{}

tU32 most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u16WindowSize);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u16WindowSize);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart::operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u16WindowSize == roRef.u16WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError::most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError::operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceExtendedError;
}


most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError::~most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError()
{}

tBool most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError::operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   oPhoneBookListSliceResultExtended = coRef.oPhoneBookListSliceResultExtended;
}
most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   oPhoneBookListSliceResultExtended = coRef.oPhoneBookListSliceResultExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult()
:u16ListHandle(0)
,oPhoneBookListSliceResultExtended()
 {}

tS32 most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_RequestPhoneBookListSliceExtendedMethodResult;
}


most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::~most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oPhoneBookListSliceResultExtended.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> oPhoneBookListSliceResultExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << oPhoneBookListSliceResultExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult::operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (oPhoneBookListSliceResultExtended == roRef.oPhoneBookListSliceResultExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchContactsMethodStart::most_phonbkfi_tclMsgSearchContactsMethodStart(const most_phonbkfi_tclMsgSearchContactsMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oDeviceHandleList = coRef.oDeviceHandleList;
   u16FieldSelector = coRef.u16FieldSelector;
   sSearchString = coRef.sSearchString;
   e8SearchSortType = coRef.e8SearchSortType;
   u16MaxReportedMatches = coRef.u16MaxReportedMatches;
}
most_phonbkfi_tclMsgSearchContactsMethodStart& most_phonbkfi_tclMsgSearchContactsMethodStart::operator=(const most_phonbkfi_tclMsgSearchContactsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oDeviceHandleList = coRef.oDeviceHandleList;
   u16FieldSelector = coRef.u16FieldSelector;
   sSearchString = coRef.sSearchString;
   e8SearchSortType = coRef.e8SearchSortType;
   u16MaxReportedMatches = coRef.u16MaxReportedMatches;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgSearchContactsMethodStart::vDestroy()
{
   sSearchString.vDestroy(); 
}

most_phonbkfi_tclMsgSearchContactsMethodStart::most_phonbkfi_tclMsgSearchContactsMethodStart()
:oDeviceHandleList()
,u16FieldSelector(0)
,sSearchString()
,e8SearchSortType()
,u16MaxReportedMatches(0)
 {}

tS32 most_phonbkfi_tclMsgSearchContactsMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchContactsMethodStart;
}


most_phonbkfi_tclMsgSearchContactsMethodStart::~most_phonbkfi_tclMsgSearchContactsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgSearchContactsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeviceHandleList.u32GetSize(u16MajorVersion);
   u32DynamicSize += sSearchString.u32GetSize(u16MajorVersion);
   return 5 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgSearchContactsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceHandleList);
   (tVoid) (oIn >> u16FieldSelector);
   (tVoid) (oIn >> sSearchString);
   (tVoid) (oIn >> e8SearchSortType);
   (tVoid) (oIn >> u16MaxReportedMatches);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSearchContactsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceHandleList);
   (tVoid) (oOut << u16FieldSelector);
   (tVoid) (oOut << sSearchString);
   (tVoid) (oOut << e8SearchSortType);
   (tVoid) (oOut << u16MaxReportedMatches);
   return oOut;
}

tBool most_phonbkfi_tclMsgSearchContactsMethodStart::operator==(const most_phonbkfi_tclMsgSearchContactsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceHandleList == roRef.oDeviceHandleList);
   bResult = bResult && (u16FieldSelector == roRef.u16FieldSelector);
   bResult = bResult && (sSearchString == roRef.sSearchString);
   bResult = bResult && (e8SearchSortType == roRef.e8SearchSortType);
   bResult = bResult && (u16MaxReportedMatches == roRef.u16MaxReportedMatches);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchContactsError::most_phonbkfi_tclMsgSearchContactsError(const most_phonbkfi_tclMsgSearchContactsError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSearchContactsError& most_phonbkfi_tclMsgSearchContactsError::operator=(const most_phonbkfi_tclMsgSearchContactsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSearchContactsError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchContactsError;
}


most_phonbkfi_tclMsgSearchContactsError::~most_phonbkfi_tclMsgSearchContactsError()
{}

tBool most_phonbkfi_tclMsgSearchContactsError::operator==(const most_phonbkfi_tclMsgSearchContactsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSearchContactsMethodResult::most_phonbkfi_tclMsgSearchContactsMethodResult(const most_phonbkfi_tclMsgSearchContactsMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16NumberOfMatches = coRef.u16NumberOfMatches;
   bMatchLimitExceeded = coRef.bMatchLimitExceeded;
   oContactMatchList = coRef.oContactMatchList;
}
most_phonbkfi_tclMsgSearchContactsMethodResult& most_phonbkfi_tclMsgSearchContactsMethodResult::operator=(const most_phonbkfi_tclMsgSearchContactsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16NumberOfMatches = coRef.u16NumberOfMatches;
   bMatchLimitExceeded = coRef.bMatchLimitExceeded;
   oContactMatchList = coRef.oContactMatchList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgSearchContactsMethodResult::vDestroy()
{
}

most_phonbkfi_tclMsgSearchContactsMethodResult::most_phonbkfi_tclMsgSearchContactsMethodResult()
:u16NumberOfMatches(0)
,bMatchLimitExceeded(0)
,oContactMatchList()
 {}

tS32 most_phonbkfi_tclMsgSearchContactsMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SearchContactsMethodResult;
}


most_phonbkfi_tclMsgSearchContactsMethodResult::~most_phonbkfi_tclMsgSearchContactsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgSearchContactsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactMatchList.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgSearchContactsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16NumberOfMatches);
   (tVoid) (oIn >> bMatchLimitExceeded);
   (tVoid) (oIn >> oContactMatchList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSearchContactsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16NumberOfMatches);
   (tVoid) (oOut << bMatchLimitExceeded);
   (tVoid) (oOut << oContactMatchList);
   return oOut;
}

tBool most_phonbkfi_tclMsgSearchContactsMethodResult::operator==(const most_phonbkfi_tclMsgSearchContactsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16NumberOfMatches == roRef.u16NumberOfMatches);
   bResult = bResult && (bMatchLimitExceeded == roRef.bMatchLimitExceeded);
   bResult = bResult && (oContactMatchList == roRef.oContactMatchList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgStartPbDownloadMethodStart::most_phonbkfi_tclMsgStartPbDownloadMethodStart(const most_phonbkfi_tclMsgStartPbDownloadMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgStartPbDownloadMethodStart& most_phonbkfi_tclMsgStartPbDownloadMethodStart::operator=(const most_phonbkfi_tclMsgStartPbDownloadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgStartPbDownloadMethodStart::most_phonbkfi_tclMsgStartPbDownloadMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgStartPbDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_StartPbDownloadMethodStart;
}


most_phonbkfi_tclMsgStartPbDownloadMethodStart::~most_phonbkfi_tclMsgStartPbDownloadMethodStart()
{}

tU32 most_phonbkfi_tclMsgStartPbDownloadMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgStartPbDownloadMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgStartPbDownloadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgStartPbDownloadMethodStart::operator==(const most_phonbkfi_tclMsgStartPbDownloadMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgStartPbDownloadError::most_phonbkfi_tclMsgStartPbDownloadError(const most_phonbkfi_tclMsgStartPbDownloadError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgStartPbDownloadError& most_phonbkfi_tclMsgStartPbDownloadError::operator=(const most_phonbkfi_tclMsgStartPbDownloadError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgStartPbDownloadError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_StartPbDownloadError;
}


most_phonbkfi_tclMsgStartPbDownloadError::~most_phonbkfi_tclMsgStartPbDownloadError()
{}

tBool most_phonbkfi_tclMsgStartPbDownloadError::operator==(const most_phonbkfi_tclMsgStartPbDownloadError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgStartPbDownloadMethodResult::most_phonbkfi_tclMsgStartPbDownloadMethodResult(const most_phonbkfi_tclMsgStartPbDownloadMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgStartPbDownloadMethodResult& most_phonbkfi_tclMsgStartPbDownloadMethodResult::operator=(const most_phonbkfi_tclMsgStartPbDownloadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgStartPbDownloadMethodResult::most_phonbkfi_tclMsgStartPbDownloadMethodResult()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgStartPbDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_StartPbDownloadMethodResult;
}


most_phonbkfi_tclMsgStartPbDownloadMethodResult::~most_phonbkfi_tclMsgStartPbDownloadMethodResult()
{}

tU32 most_phonbkfi_tclMsgStartPbDownloadMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgStartPbDownloadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgStartPbDownloadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgStartPbDownloadMethodResult::operator==(const most_phonbkfi_tclMsgStartPbDownloadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u8DownloadOnOffState = coRef.u8DownloadOnOffState;
}
most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::operator=(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u8DownloadOnOffState = coRef.u8DownloadOnOffState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart()
:u8DeviceHandle(0)
,u8DownloadOnOffState(0)
 {}

tS32 most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SwitchDownloadOnOffStateMethodStart;
}


most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::~most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart()
{}

tU32 most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u8DownloadOnOffState);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u8DownloadOnOffState);
   return oOut;
}

tBool most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart::operator==(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u8DownloadOnOffState == roRef.u8DownloadOnOffState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSwitchDownloadOnOffStateError::most_phonbkfi_tclMsgSwitchDownloadOnOffStateError(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& most_phonbkfi_tclMsgSwitchDownloadOnOffStateError::operator=(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSwitchDownloadOnOffStateError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SwitchDownloadOnOffStateError;
}


most_phonbkfi_tclMsgSwitchDownloadOnOffStateError::~most_phonbkfi_tclMsgSwitchDownloadOnOffStateError()
{}

tBool most_phonbkfi_tclMsgSwitchDownloadOnOffStateError::operator==(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u8DownloadOnOffState = coRef.u8DownloadOnOffState;
}
most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::operator=(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u8DownloadOnOffState = coRef.u8DownloadOnOffState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult()
:u8DeviceHandle(0)
,u8DownloadOnOffState(0)
 {}

tS32 most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SwitchDownloadOnOffStateMethodResult;
}


most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::~most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult()
{}

tU32 most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u8DownloadOnOffState);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u8DownloadOnOffState);
   return oOut;
}

tBool most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult::operator==(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u8DownloadOnOffState == roRef.u8DownloadOnOffState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreateContactListMethodStart::most_phonbkfi_tclMsgCreateContactListMethodStart(const most_phonbkfi_tclMsgCreateContactListMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8PhoneBkContactListType = coRef.e8PhoneBkContactListType;
   e8PhoneBkContactSortType = coRef.e8PhoneBkContactSortType;
}
most_phonbkfi_tclMsgCreateContactListMethodStart& most_phonbkfi_tclMsgCreateContactListMethodStart::operator=(const most_phonbkfi_tclMsgCreateContactListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8PhoneBkContactListType = coRef.e8PhoneBkContactListType;
   e8PhoneBkContactSortType = coRef.e8PhoneBkContactSortType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCreateContactListMethodStart::most_phonbkfi_tclMsgCreateContactListMethodStart()
:u8DeviceHandle(0)
,e8PhoneBkContactListType()
,e8PhoneBkContactSortType()
 {}

tS32 most_phonbkfi_tclMsgCreateContactListMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreateContactListMethodStart;
}


most_phonbkfi_tclMsgCreateContactListMethodStart::~most_phonbkfi_tclMsgCreateContactListMethodStart()
{}

tU32 most_phonbkfi_tclMsgCreateContactListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_phonbkfi_tclMsgCreateContactListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8PhoneBkContactListType);
   (tVoid) (oIn >> e8PhoneBkContactSortType);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCreateContactListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8PhoneBkContactListType);
   (tVoid) (oOut << e8PhoneBkContactSortType);
   return oOut;
}

tBool most_phonbkfi_tclMsgCreateContactListMethodStart::operator==(const most_phonbkfi_tclMsgCreateContactListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8PhoneBkContactListType == roRef.e8PhoneBkContactListType);
   bResult = bResult && (e8PhoneBkContactSortType == roRef.e8PhoneBkContactSortType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreateContactListError::most_phonbkfi_tclMsgCreateContactListError(const most_phonbkfi_tclMsgCreateContactListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgCreateContactListError& most_phonbkfi_tclMsgCreateContactListError::operator=(const most_phonbkfi_tclMsgCreateContactListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgCreateContactListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreateContactListError;
}


most_phonbkfi_tclMsgCreateContactListError::~most_phonbkfi_tclMsgCreateContactListError()
{}

tBool most_phonbkfi_tclMsgCreateContactListError::operator==(const most_phonbkfi_tclMsgCreateContactListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCreateContactListMethodResult::most_phonbkfi_tclMsgCreateContactListMethodResult(const most_phonbkfi_tclMsgCreateContactListMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
}
most_phonbkfi_tclMsgCreateContactListMethodResult& most_phonbkfi_tclMsgCreateContactListMethodResult::operator=(const most_phonbkfi_tclMsgCreateContactListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCreateContactListMethodResult::most_phonbkfi_tclMsgCreateContactListMethodResult()
:u16ListHandle(0)
,u16ListLength(0)
 {}

tS32 most_phonbkfi_tclMsgCreateContactListMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CreateContactListMethodResult;
}


most_phonbkfi_tclMsgCreateContactListMethodResult::~most_phonbkfi_tclMsgCreateContactListMethodResult()
{}

tU32 most_phonbkfi_tclMsgCreateContactListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgCreateContactListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u16ListLength);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCreateContactListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u16ListLength);
   return oOut;
}

tBool most_phonbkfi_tclMsgCreateContactListMethodResult::operator==(const most_phonbkfi_tclMsgCreateContactListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u16ListLength == roRef.u16ListLength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetContactPhotoMethodStart::most_phonbkfi_tclMsgSetContactPhotoMethodStart(const most_phonbkfi_tclMsgSetContactPhotoMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   oVehicleContactPhoto = coRef.oVehicleContactPhoto;
}
most_phonbkfi_tclMsgSetContactPhotoMethodStart& most_phonbkfi_tclMsgSetContactPhotoMethodStart::operator=(const most_phonbkfi_tclMsgSetContactPhotoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   oVehicleContactPhoto = coRef.oVehicleContactPhoto;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSetContactPhotoMethodStart::most_phonbkfi_tclMsgSetContactPhotoMethodStart()
:u32ContactHandle(0)
,oVehicleContactPhoto()
 {}

tS32 most_phonbkfi_tclMsgSetContactPhotoMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetContactPhotoMethodStart;
}


most_phonbkfi_tclMsgSetContactPhotoMethodStart::~most_phonbkfi_tclMsgSetContactPhotoMethodStart()
{}

tU32 most_phonbkfi_tclMsgSetContactPhotoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oVehicleContactPhoto.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgSetContactPhotoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> oVehicleContactPhoto);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSetContactPhotoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << oVehicleContactPhoto);
   return oOut;
}

tBool most_phonbkfi_tclMsgSetContactPhotoMethodStart::operator==(const most_phonbkfi_tclMsgSetContactPhotoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (oVehicleContactPhoto == roRef.oVehicleContactPhoto);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetContactPhotoError::most_phonbkfi_tclMsgSetContactPhotoError(const most_phonbkfi_tclMsgSetContactPhotoError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSetContactPhotoError& most_phonbkfi_tclMsgSetContactPhotoError::operator=(const most_phonbkfi_tclMsgSetContactPhotoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSetContactPhotoError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetContactPhotoError;
}


most_phonbkfi_tclMsgSetContactPhotoError::~most_phonbkfi_tclMsgSetContactPhotoError()
{}

tBool most_phonbkfi_tclMsgSetContactPhotoError::operator==(const most_phonbkfi_tclMsgSetContactPhotoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetContactPhotoMethodResult::most_phonbkfi_tclMsgSetContactPhotoMethodResult(const most_phonbkfi_tclMsgSetContactPhotoMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgSetContactPhotoMethodResult& most_phonbkfi_tclMsgSetContactPhotoMethodResult::operator=(const most_phonbkfi_tclMsgSetContactPhotoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSetContactPhotoMethodResult::most_phonbkfi_tclMsgSetContactPhotoMethodResult()
:u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgSetContactPhotoMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetContactPhotoMethodResult;
}


most_phonbkfi_tclMsgSetContactPhotoMethodResult::~most_phonbkfi_tclMsgSetContactPhotoMethodResult()
{}

tU32 most_phonbkfi_tclMsgSetContactPhotoMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgSetContactPhotoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSetContactPhotoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgSetContactPhotoMethodResult::operator==(const most_phonbkfi_tclMsgSetContactPhotoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCancelPbDownloadMethodStart::most_phonbkfi_tclMsgCancelPbDownloadMethodStart(const most_phonbkfi_tclMsgCancelPbDownloadMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgCancelPbDownloadMethodStart& most_phonbkfi_tclMsgCancelPbDownloadMethodStart::operator=(const most_phonbkfi_tclMsgCancelPbDownloadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCancelPbDownloadMethodStart::most_phonbkfi_tclMsgCancelPbDownloadMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgCancelPbDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CancelPbDownloadMethodStart;
}


most_phonbkfi_tclMsgCancelPbDownloadMethodStart::~most_phonbkfi_tclMsgCancelPbDownloadMethodStart()
{}

tU32 most_phonbkfi_tclMsgCancelPbDownloadMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgCancelPbDownloadMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCancelPbDownloadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgCancelPbDownloadMethodStart::operator==(const most_phonbkfi_tclMsgCancelPbDownloadMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCancelPbDownloadError::most_phonbkfi_tclMsgCancelPbDownloadError(const most_phonbkfi_tclMsgCancelPbDownloadError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgCancelPbDownloadError& most_phonbkfi_tclMsgCancelPbDownloadError::operator=(const most_phonbkfi_tclMsgCancelPbDownloadError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgCancelPbDownloadError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CancelPbDownloadError;
}


most_phonbkfi_tclMsgCancelPbDownloadError::~most_phonbkfi_tclMsgCancelPbDownloadError()
{}

tBool most_phonbkfi_tclMsgCancelPbDownloadError::operator==(const most_phonbkfi_tclMsgCancelPbDownloadError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgCancelPbDownloadMethodResult::most_phonbkfi_tclMsgCancelPbDownloadMethodResult(const most_phonbkfi_tclMsgCancelPbDownloadMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgCancelPbDownloadMethodResult& most_phonbkfi_tclMsgCancelPbDownloadMethodResult::operator=(const most_phonbkfi_tclMsgCancelPbDownloadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgCancelPbDownloadMethodResult::most_phonbkfi_tclMsgCancelPbDownloadMethodResult()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgCancelPbDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_CancelPbDownloadMethodResult;
}


most_phonbkfi_tclMsgCancelPbDownloadMethodResult::~most_phonbkfi_tclMsgCancelPbDownloadMethodResult()
{}

tU32 most_phonbkfi_tclMsgCancelPbDownloadMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgCancelPbDownloadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgCancelPbDownloadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgCancelPbDownloadMethodResult::operator==(const most_phonbkfi_tclMsgCancelPbDownloadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetContactPositionMethodStart::most_phonbkfi_tclMsgSetContactPositionMethodStart(const most_phonbkfi_tclMsgSetContactPositionMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   u32ContactPosition = coRef.u32ContactPosition;
}
most_phonbkfi_tclMsgSetContactPositionMethodStart& most_phonbkfi_tclMsgSetContactPositionMethodStart::operator=(const most_phonbkfi_tclMsgSetContactPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   u32ContactPosition = coRef.u32ContactPosition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSetContactPositionMethodStart::most_phonbkfi_tclMsgSetContactPositionMethodStart()
:u32ContactHandle(0)
,u32ContactPosition(0)
 {}

tS32 most_phonbkfi_tclMsgSetContactPositionMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetContactPositionMethodStart;
}


most_phonbkfi_tclMsgSetContactPositionMethodStart::~most_phonbkfi_tclMsgSetContactPositionMethodStart()
{}

tU32 most_phonbkfi_tclMsgSetContactPositionMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 8;
}

fi_tclInContext& most_phonbkfi_tclMsgSetContactPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> u32ContactPosition);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSetContactPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << u32ContactPosition);
   return oOut;
}

tBool most_phonbkfi_tclMsgSetContactPositionMethodStart::operator==(const most_phonbkfi_tclMsgSetContactPositionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (u32ContactPosition == roRef.u32ContactPosition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetContactPositionError::most_phonbkfi_tclMsgSetContactPositionError(const most_phonbkfi_tclMsgSetContactPositionError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSetContactPositionError& most_phonbkfi_tclMsgSetContactPositionError::operator=(const most_phonbkfi_tclMsgSetContactPositionError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSetContactPositionError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetContactPositionError;
}


most_phonbkfi_tclMsgSetContactPositionError::~most_phonbkfi_tclMsgSetContactPositionError()
{}

tBool most_phonbkfi_tclMsgSetContactPositionError::operator==(const most_phonbkfi_tclMsgSetContactPositionError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetContactPositionMethodResult::most_phonbkfi_tclMsgSetContactPositionMethodResult(const most_phonbkfi_tclMsgSetContactPositionMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgSetContactPositionMethodResult& most_phonbkfi_tclMsgSetContactPositionMethodResult::operator=(const most_phonbkfi_tclMsgSetContactPositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSetContactPositionMethodResult::most_phonbkfi_tclMsgSetContactPositionMethodResult()
:u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgSetContactPositionMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetContactPositionMethodResult;
}


most_phonbkfi_tclMsgSetContactPositionMethodResult::~most_phonbkfi_tclMsgSetContactPositionMethodResult()
{}

tU32 most_phonbkfi_tclMsgSetContactPositionMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgSetContactPositionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSetContactPositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgSetContactPositionMethodResult::operator==(const most_phonbkfi_tclMsgSetContactPositionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAddContactExtendedMethodStart::most_phonbkfi_tclMsgAddContactExtendedMethodStart(const most_phonbkfi_tclMsgAddContactExtendedMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oContactDetailsExtended = coRef.oContactDetailsExtended;
}
most_phonbkfi_tclMsgAddContactExtendedMethodStart& most_phonbkfi_tclMsgAddContactExtendedMethodStart::operator=(const most_phonbkfi_tclMsgAddContactExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oContactDetailsExtended = coRef.oContactDetailsExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgAddContactExtendedMethodStart::vDestroy()
{
   oContactDetailsExtended.vDestroy(); 
}

most_phonbkfi_tclMsgAddContactExtendedMethodStart::most_phonbkfi_tclMsgAddContactExtendedMethodStart()
:u8DeviceHandle(0)
,oContactDetailsExtended()
 {}

tS32 most_phonbkfi_tclMsgAddContactExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AddContactExtendedMethodStart;
}


most_phonbkfi_tclMsgAddContactExtendedMethodStart::~most_phonbkfi_tclMsgAddContactExtendedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgAddContactExtendedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactDetailsExtended.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgAddContactExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oContactDetailsExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAddContactExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oContactDetailsExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgAddContactExtendedMethodStart::operator==(const most_phonbkfi_tclMsgAddContactExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oContactDetailsExtended == roRef.oContactDetailsExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAddContactExtendedError::most_phonbkfi_tclMsgAddContactExtendedError(const most_phonbkfi_tclMsgAddContactExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgAddContactExtendedError& most_phonbkfi_tclMsgAddContactExtendedError::operator=(const most_phonbkfi_tclMsgAddContactExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgAddContactExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AddContactExtendedError;
}


most_phonbkfi_tclMsgAddContactExtendedError::~most_phonbkfi_tclMsgAddContactExtendedError()
{}

tBool most_phonbkfi_tclMsgAddContactExtendedError::operator==(const most_phonbkfi_tclMsgAddContactExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAddContactExtendedMethodResult::most_phonbkfi_tclMsgAddContactExtendedMethodResult(const most_phonbkfi_tclMsgAddContactExtendedMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactAddStatusExtended = coRef.e8ContactAddStatusExtended;
}
most_phonbkfi_tclMsgAddContactExtendedMethodResult& most_phonbkfi_tclMsgAddContactExtendedMethodResult::operator=(const most_phonbkfi_tclMsgAddContactExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactAddStatusExtended = coRef.e8ContactAddStatusExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgAddContactExtendedMethodResult::most_phonbkfi_tclMsgAddContactExtendedMethodResult()
:u32ContactHandle(0)
,e8ContactAddStatusExtended()
 {}

tS32 most_phonbkfi_tclMsgAddContactExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AddContactExtendedMethodResult;
}


most_phonbkfi_tclMsgAddContactExtendedMethodResult::~most_phonbkfi_tclMsgAddContactExtendedMethodResult()
{}

tU32 most_phonbkfi_tclMsgAddContactExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgAddContactExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> e8ContactAddStatusExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAddContactExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << e8ContactAddStatusExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgAddContactExtendedMethodResult::operator==(const most_phonbkfi_tclMsgAddContactExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (e8ContactAddStatusExtended == roRef.e8ContactAddStatusExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgEditContactExtendedMethodStart::most_phonbkfi_tclMsgEditContactExtendedMethodStart(const most_phonbkfi_tclMsgEditContactExtendedMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   oContactDetailsExtended = coRef.oContactDetailsExtended;
}
most_phonbkfi_tclMsgEditContactExtendedMethodStart& most_phonbkfi_tclMsgEditContactExtendedMethodStart::operator=(const most_phonbkfi_tclMsgEditContactExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   oContactDetailsExtended = coRef.oContactDetailsExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgEditContactExtendedMethodStart::vDestroy()
{
   oContactDetailsExtended.vDestroy(); 
}

most_phonbkfi_tclMsgEditContactExtendedMethodStart::most_phonbkfi_tclMsgEditContactExtendedMethodStart()
:u8DeviceHandle(0)
,u32ContactHandle(0)
,oContactDetailsExtended()
 {}

tS32 most_phonbkfi_tclMsgEditContactExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_EditContactExtendedMethodStart;
}


most_phonbkfi_tclMsgEditContactExtendedMethodStart::~most_phonbkfi_tclMsgEditContactExtendedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgEditContactExtendedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactDetailsExtended.u32GetSize(u16MajorVersion);
   return 5 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgEditContactExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> oContactDetailsExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgEditContactExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << oContactDetailsExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgEditContactExtendedMethodStart::operator==(const most_phonbkfi_tclMsgEditContactExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (oContactDetailsExtended == roRef.oContactDetailsExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgEditContactExtendedError::most_phonbkfi_tclMsgEditContactExtendedError(const most_phonbkfi_tclMsgEditContactExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgEditContactExtendedError& most_phonbkfi_tclMsgEditContactExtendedError::operator=(const most_phonbkfi_tclMsgEditContactExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgEditContactExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_EditContactExtendedError;
}


most_phonbkfi_tclMsgEditContactExtendedError::~most_phonbkfi_tclMsgEditContactExtendedError()
{}

tBool most_phonbkfi_tclMsgEditContactExtendedError::operator==(const most_phonbkfi_tclMsgEditContactExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgEditContactExtendedMethodResult::most_phonbkfi_tclMsgEditContactExtendedMethodResult(const most_phonbkfi_tclMsgEditContactExtendedMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactEditStatusExtended = coRef.e8ContactEditStatusExtended;
}
most_phonbkfi_tclMsgEditContactExtendedMethodResult& most_phonbkfi_tclMsgEditContactExtendedMethodResult::operator=(const most_phonbkfi_tclMsgEditContactExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   e8ContactEditStatusExtended = coRef.e8ContactEditStatusExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgEditContactExtendedMethodResult::most_phonbkfi_tclMsgEditContactExtendedMethodResult()
:u32ContactHandle(0)
,e8ContactEditStatusExtended()
 {}

tS32 most_phonbkfi_tclMsgEditContactExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_EditContactExtendedMethodResult;
}


most_phonbkfi_tclMsgEditContactExtendedMethodResult::~most_phonbkfi_tclMsgEditContactExtendedMethodResult()
{}

tU32 most_phonbkfi_tclMsgEditContactExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgEditContactExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   (tVoid) (oIn >> e8ContactEditStatusExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgEditContactExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   (tVoid) (oOut << e8ContactEditStatusExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgEditContactExtendedMethodResult::operator==(const most_phonbkfi_tclMsgEditContactExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   bResult = bResult && (e8ContactEditStatusExtended == roRef.e8ContactEditStatusExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::operator=(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart()
:u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactDetailsExtendedMethodStart;
}


most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::~most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart::operator==(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactDetailsExtendedError::most_phonbkfi_tclMsgGetContactDetailsExtendedError(const most_phonbkfi_tclMsgGetContactDetailsExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetContactDetailsExtendedError& most_phonbkfi_tclMsgGetContactDetailsExtendedError::operator=(const most_phonbkfi_tclMsgGetContactDetailsExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetContactDetailsExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactDetailsExtendedError;
}


most_phonbkfi_tclMsgGetContactDetailsExtendedError::~most_phonbkfi_tclMsgGetContactDetailsExtendedError()
{}

tBool most_phonbkfi_tclMsgGetContactDetailsExtendedError::operator==(const most_phonbkfi_tclMsgGetContactDetailsExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oContactDetailsExtended = coRef.oContactDetailsExtended;
}
most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::operator=(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oContactDetailsExtended = coRef.oContactDetailsExtended;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::vDestroy()
{
   oContactDetailsExtended.vDestroy(); 
}

most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult()
:oContactDetailsExtended()
 {}

tS32 most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetContactDetailsExtendedMethodResult;
}


most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::~most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContactDetailsExtended.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oContactDetailsExtended);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oContactDetailsExtended);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult::operator==(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oContactDetailsExtended == roRef.oContactDetailsExtended);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::operator=(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhonebookExtendedMethodStart;
}


most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::~most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart()
{}

tU32 most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart::operator==(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError::most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError::operator=(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhonebookExtendedError;
}


most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError::~most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError()
{}

tBool most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError::operator==(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::operator=(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult()
:u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ClearVehiclePhonebookExtendedMethodResult;
}


most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::~most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult()
{}

tU32 most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult::operator==(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bAutomaticDL = coRef.bAutomaticDL;
}
most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::operator=(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bAutomaticDL = coRef.bAutomaticDL;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart()
:u8DeviceHandle(0)
,bAutomaticDL(0)
 {}

tS32 most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetAutomaticContactDownloadMethodStart;
}


most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::~most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart()
{}

tU32 most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bAutomaticDL);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bAutomaticDL);
   return oOut;
}

tBool most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart::operator==(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bAutomaticDL == roRef.bAutomaticDL);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetAutomaticContactDownloadError::most_phonbkfi_tclMsgSetAutomaticContactDownloadError(const most_phonbkfi_tclMsgSetAutomaticContactDownloadError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgSetAutomaticContactDownloadError& most_phonbkfi_tclMsgSetAutomaticContactDownloadError::operator=(const most_phonbkfi_tclMsgSetAutomaticContactDownloadError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgSetAutomaticContactDownloadError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetAutomaticContactDownloadError;
}


most_phonbkfi_tclMsgSetAutomaticContactDownloadError::~most_phonbkfi_tclMsgSetAutomaticContactDownloadError()
{}

tBool most_phonbkfi_tclMsgSetAutomaticContactDownloadError::operator==(const most_phonbkfi_tclMsgSetAutomaticContactDownloadError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bAutomaticDL = coRef.bAutomaticDL;
}
most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::operator=(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bAutomaticDL = coRef.bAutomaticDL;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult()
:u8DeviceHandle(0)
,bAutomaticDL(0)
 {}

tS32 most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_SetAutomaticContactDownloadMethodResult;
}


most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::~most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult()
{}

tU32 most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bAutomaticDL);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bAutomaticDL);
   return oOut;
}

tBool most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult::operator==(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bAutomaticDL == roRef.bAutomaticDL);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::operator=(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart()
:u16ListHandle(0)
,u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetPositionForContactHandleMethodStart;
}


most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::~most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart()
{}

tU32 most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 6;
}

fi_tclInContext& most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart::operator==(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetPositionForContactHandleError::most_phonbkfi_tclMsgGetPositionForContactHandleError(const most_phonbkfi_tclMsgGetPositionForContactHandleError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgGetPositionForContactHandleError& most_phonbkfi_tclMsgGetPositionForContactHandleError::operator=(const most_phonbkfi_tclMsgGetPositionForContactHandleError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgGetPositionForContactHandleError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetPositionForContactHandleError;
}


most_phonbkfi_tclMsgGetPositionForContactHandleError::~most_phonbkfi_tclMsgGetPositionForContactHandleError()
{}

tBool most_phonbkfi_tclMsgGetPositionForContactHandleError::operator==(const most_phonbkfi_tclMsgGetPositionForContactHandleError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32Position = coRef.u32Position;
   u16ListHandle = coRef.u16ListHandle;
   u32ContactHandle = coRef.u32ContactHandle;
}
most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::operator=(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32Position = coRef.u32Position;
   u16ListHandle = coRef.u16ListHandle;
   u32ContactHandle = coRef.u32ContactHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult()
:u32Position(0)
,u16ListHandle(0)
,u32ContactHandle(0)
 {}

tS32 most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_GetPositionForContactHandleMethodResult;
}


most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::~most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult()
{}

tU32 most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Position);
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32ContactHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Position);
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32ContactHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult::operator==(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Position == roRef.u32Position);
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32ContactHandle == roRef.u32ContactHandle);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgFavoritesChangedUpReg::most_phonbkfi_tclMsgFavoritesChangedUpReg()
 {}

tS32 most_phonbkfi_tclMsgFavoritesChangedUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_FavoritesChangedUpReg;
}


most_phonbkfi_tclMsgFavoritesChangedUpReg::~most_phonbkfi_tclMsgFavoritesChangedUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgFavoritesChangedRelUpReg::most_phonbkfi_tclMsgFavoritesChangedRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgFavoritesChangedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_FavoritesChangedRelUpReg;
}


most_phonbkfi_tclMsgFavoritesChangedRelUpReg::~most_phonbkfi_tclMsgFavoritesChangedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgFavoritesChangedStatus::most_phonbkfi_tclMsgFavoritesChangedStatus(const most_phonbkfi_tclMsgFavoritesChangedStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   e8ListChangeType = coRef.e8ListChangeType;
   u32ListSize = coRef.u32ListSize;
   u32NumItems = coRef.u32NumItems;
   oChangedFavorites = coRef.oChangedFavorites;
}
most_phonbkfi_tclMsgFavoritesChangedStatus& most_phonbkfi_tclMsgFavoritesChangedStatus::operator=(const most_phonbkfi_tclMsgFavoritesChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ListChangeType = coRef.e8ListChangeType;
   u32ListSize = coRef.u32ListSize;
   u32NumItems = coRef.u32NumItems;
   oChangedFavorites = coRef.oChangedFavorites;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgFavoritesChangedStatus::most_phonbkfi_tclMsgFavoritesChangedStatus()
:e8ListChangeType()
,u32ListSize(0)
,u32NumItems(0)
,oChangedFavorites()
 {}

tS32 most_phonbkfi_tclMsgFavoritesChangedStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_FavoritesChangedStatus;
}


most_phonbkfi_tclMsgFavoritesChangedStatus::~most_phonbkfi_tclMsgFavoritesChangedStatus()
{}

tU32 most_phonbkfi_tclMsgFavoritesChangedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oChangedFavorites.u32GetSize(u16MajorVersion);
   return 9 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgFavoritesChangedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ListChangeType);
   (tVoid) (oIn >> u32ListSize);
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oChangedFavorites);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgFavoritesChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ListChangeType);
   (tVoid) (oOut << u32ListSize);
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oChangedFavorites);
   return oOut;
}

tBool most_phonbkfi_tclMsgFavoritesChangedStatus::operator==(const most_phonbkfi_tclMsgFavoritesChangedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ListChangeType == roRef.e8ListChangeType);
   bResult = bResult && (u32ListSize == roRef.u32ListSize);
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oChangedFavorites == roRef.oChangedFavorites);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgListChangeUpReg::most_phonbkfi_tclMsgListChangeUpReg()
 {}

tS32 most_phonbkfi_tclMsgListChangeUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ListChangeUpReg;
}


most_phonbkfi_tclMsgListChangeUpReg::~most_phonbkfi_tclMsgListChangeUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgListChangeRelUpReg::most_phonbkfi_tclMsgListChangeRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgListChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ListChangeRelUpReg;
}


most_phonbkfi_tclMsgListChangeRelUpReg::~most_phonbkfi_tclMsgListChangeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgListChangeStatus::most_phonbkfi_tclMsgListChangeStatus(const most_phonbkfi_tclMsgListChangeStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   e8ListType = coRef.e8ListType;
   e8ListChangeType = coRef.e8ListChangeType;
   u16ListLength = coRef.u16ListLength;
   u32NumItems = coRef.u32NumItems;
   oChangeItems = coRef.oChangeItems;
}
most_phonbkfi_tclMsgListChangeStatus& most_phonbkfi_tclMsgListChangeStatus::operator=(const most_phonbkfi_tclMsgListChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   e8ListType = coRef.e8ListType;
   e8ListChangeType = coRef.e8ListChangeType;
   u16ListLength = coRef.u16ListLength;
   u32NumItems = coRef.u32NumItems;
   oChangeItems = coRef.oChangeItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgListChangeStatus::most_phonbkfi_tclMsgListChangeStatus()
:u16ListHandle(0)
,e8ListType()
,e8ListChangeType()
,u16ListLength(0)
,u32NumItems(0)
,oChangeItems()
 {}

tS32 most_phonbkfi_tclMsgListChangeStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ListChangeStatus;
}


most_phonbkfi_tclMsgListChangeStatus::~most_phonbkfi_tclMsgListChangeStatus()
{}

tU32 most_phonbkfi_tclMsgListChangeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oChangeItems.u32GetSize(u16MajorVersion);
   return 10 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgListChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> e8ListChangeType);
   (tVoid) (oIn >> u16ListLength);
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oChangeItems);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgListChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << e8ListChangeType);
   (tVoid) (oOut << u16ListLength);
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oChangeItems);
   return oOut;
}

tBool most_phonbkfi_tclMsgListChangeStatus::operator==(const most_phonbkfi_tclMsgListChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (e8ListChangeType == roRef.e8ListChangeType);
   bResult = bResult && (u16ListLength == roRef.u16ListLength);
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oChangeItems == roRef.oChangeItems);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgMissedCallIndicatorUpReg::most_phonbkfi_tclMsgMissedCallIndicatorUpReg()
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorUpReg;
}


most_phonbkfi_tclMsgMissedCallIndicatorUpReg::~most_phonbkfi_tclMsgMissedCallIndicatorUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg::most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorRelUpReg;
}


most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg::~most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgMissedCallIndicatorStatus::most_phonbkfi_tclMsgMissedCallIndicatorStatus(const most_phonbkfi_tclMsgMissedCallIndicatorStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32NumMissedCalls = coRef.u32NumMissedCalls;
}
most_phonbkfi_tclMsgMissedCallIndicatorStatus& most_phonbkfi_tclMsgMissedCallIndicatorStatus::operator=(const most_phonbkfi_tclMsgMissedCallIndicatorStatus& coRef)
{
   if (this == &coRef) return *this;
   u32NumMissedCalls = coRef.u32NumMissedCalls;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgMissedCallIndicatorStatus::most_phonbkfi_tclMsgMissedCallIndicatorStatus()
:u32NumMissedCalls(0)
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorStatus;
}


most_phonbkfi_tclMsgMissedCallIndicatorStatus::~most_phonbkfi_tclMsgMissedCallIndicatorStatus()
{}

tU32 most_phonbkfi_tclMsgMissedCallIndicatorStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgMissedCallIndicatorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumMissedCalls);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgMissedCallIndicatorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumMissedCalls);
   return oOut;
}

tBool most_phonbkfi_tclMsgMissedCallIndicatorStatus::operator==(const most_phonbkfi_tclMsgMissedCallIndicatorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumMissedCalls == roRef.u32NumMissedCalls);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportUpReg;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportRelUpReg;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportGet;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError::operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportError;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError()
{}

tBool most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError::operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   bPhoneBookSupport = coRef.bPhoneBookSupport;
   bCCHListSupport = coRef.bCCHListSupport;
   bICHListSupport = coRef.bICHListSupport;
   bOCHListSupport = coRef.bOCHListSupport;
   bMCHListSupport = coRef.bMCHListSupport;
   bContactListSortView = coRef.bContactListSortView;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& coRef)
{
   if (this == &coRef) return *this;
   bPhoneBookSupport = coRef.bPhoneBookSupport;
   bCCHListSupport = coRef.bCCHListSupport;
   bICHListSupport = coRef.bICHListSupport;
   bOCHListSupport = coRef.bOCHListSupport;
   bMCHListSupport = coRef.bMCHListSupport;
   bContactListSortView = coRef.bContactListSortView;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus()
:bPhoneBookSupport(0)
,bCCHListSupport(0)
,bICHListSupport(0)
,bOCHListSupport(0)
,bMCHListSupport(0)
,bContactListSortView(0)
,u8DeviceHandle(0)
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportStatus;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus()
{}

tU32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 7;
}

fi_tclInContext& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bPhoneBookSupport);
   (tVoid) (oIn >> bCCHListSupport);
   (tVoid) (oIn >> bICHListSupport);
   (tVoid) (oIn >> bOCHListSupport);
   (tVoid) (oIn >> bMCHListSupport);
   (tVoid) (oIn >> bContactListSortView);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bPhoneBookSupport);
   (tVoid) (oOut << bCCHListSupport);
   (tVoid) (oOut << bICHListSupport);
   (tVoid) (oOut << bOCHListSupport);
   (tVoid) (oOut << bMCHListSupport);
   (tVoid) (oOut << bContactListSortView);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus::operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bPhoneBookSupport == roRef.bPhoneBookSupport);
   bResult = bResult && (bCCHListSupport == roRef.bCCHListSupport);
   bResult = bResult && (bICHListSupport == roRef.bICHListSupport);
   bResult = bResult && (bOCHListSupport == roRef.bOCHListSupport);
   bResult = bResult && (bMCHListSupport == roRef.bMCHListSupport);
   bResult = bResult && (bContactListSortView == roRef.bContactListSortView);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg()
 {}

tS32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderUpReg;
}


most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg::~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderRelUpReg;
}


most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg::~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet()
 {}

tS32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderGet;
}


most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet::~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   e8PreferredPhoneBookSortOrder = coRef.e8PreferredPhoneBookSortOrder;
}
most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::operator=(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& coRef)
{
   if (this == &coRef) return *this;
   e8PreferredPhoneBookSortOrder = coRef.e8PreferredPhoneBookSortOrder;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet()
:e8PreferredPhoneBookSortOrder()
 {}

tS32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderPureSet;
}


most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet()
{}

tU32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PreferredPhoneBookSortOrder);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PreferredPhoneBookSortOrder);
   return oOut;
}

tBool most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet::operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PreferredPhoneBookSortOrder == roRef.e8PreferredPhoneBookSortOrder);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError::operator=(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderError;
}


most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError::~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError()
{}

tBool most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError::operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   e8PreferredPhoneBookSortOrder = coRef.e8PreferredPhoneBookSortOrder;
}
most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::operator=(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PreferredPhoneBookSortOrder = coRef.e8PreferredPhoneBookSortOrder;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus()
:e8PreferredPhoneBookSortOrder()
 {}

tS32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredPhoneBookSortOrderStatus;
}


most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus()
{}

tU32 most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PreferredPhoneBookSortOrder);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PreferredPhoneBookSortOrder);
   return oOut;
}

tBool most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus::operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PreferredPhoneBookSortOrder == roRef.e8PreferredPhoneBookSortOrder);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDownloadStateUpReg::most_phonbkfi_tclMsgDownloadStateUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadStateUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateUpReg;
}


most_phonbkfi_tclMsgDownloadStateUpReg::~most_phonbkfi_tclMsgDownloadStateUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadStateRelUpReg::most_phonbkfi_tclMsgDownloadStateRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateRelUpReg;
}


most_phonbkfi_tclMsgDownloadStateRelUpReg::~most_phonbkfi_tclMsgDownloadStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadStateError::most_phonbkfi_tclMsgDownloadStateError(const most_phonbkfi_tclMsgDownloadStateError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDownloadStateError& most_phonbkfi_tclMsgDownloadStateError::operator=(const most_phonbkfi_tclMsgDownloadStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDownloadStateError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateError;
}


most_phonbkfi_tclMsgDownloadStateError::~most_phonbkfi_tclMsgDownloadStateError()
{}

tBool most_phonbkfi_tclMsgDownloadStateError::operator==(const most_phonbkfi_tclMsgDownloadStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadStateStatus::most_phonbkfi_tclMsgDownloadStateStatus(const most_phonbkfi_tclMsgDownloadStateStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oDownloadStateStream = coRef.oDownloadStateStream;
}
most_phonbkfi_tclMsgDownloadStateStatus& most_phonbkfi_tclMsgDownloadStateStatus::operator=(const most_phonbkfi_tclMsgDownloadStateStatus& coRef)
{
   if (this == &coRef) return *this;
   oDownloadStateStream = coRef.oDownloadStateStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDownloadStateStatus::most_phonbkfi_tclMsgDownloadStateStatus()
:oDownloadStateStream()
 {}

tS32 most_phonbkfi_tclMsgDownloadStateStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateStatus;
}


most_phonbkfi_tclMsgDownloadStateStatus::~most_phonbkfi_tclMsgDownloadStateStatus()
{}

tU32 most_phonbkfi_tclMsgDownloadStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDownloadStateStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgDownloadStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDownloadStateStream);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDownloadStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDownloadStateStream);
   return oOut;
}

tBool most_phonbkfi_tclMsgDownloadStateStatus::operator==(const most_phonbkfi_tclMsgDownloadStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDownloadStateStream == roRef.oDownloadStateStream);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDownloadStateExtendedUpReg::most_phonbkfi_tclMsgDownloadStateExtendedUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadStateExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedUpReg;
}


most_phonbkfi_tclMsgDownloadStateExtendedUpReg::~most_phonbkfi_tclMsgDownloadStateExtendedUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg::most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedRelUpReg;
}


most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg::~most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadStateExtendedError::most_phonbkfi_tclMsgDownloadStateExtendedError(const most_phonbkfi_tclMsgDownloadStateExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDownloadStateExtendedError& most_phonbkfi_tclMsgDownloadStateExtendedError::operator=(const most_phonbkfi_tclMsgDownloadStateExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDownloadStateExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedError;
}


most_phonbkfi_tclMsgDownloadStateExtendedError::~most_phonbkfi_tclMsgDownloadStateExtendedError()
{}

tBool most_phonbkfi_tclMsgDownloadStateExtendedError::operator==(const most_phonbkfi_tclMsgDownloadStateExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadStateExtendedStatus::most_phonbkfi_tclMsgDownloadStateExtendedStatus(const most_phonbkfi_tclMsgDownloadStateExtendedStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oDownloadStateExtendedStream = coRef.oDownloadStateExtendedStream;
}
most_phonbkfi_tclMsgDownloadStateExtendedStatus& most_phonbkfi_tclMsgDownloadStateExtendedStatus::operator=(const most_phonbkfi_tclMsgDownloadStateExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   oDownloadStateExtendedStream = coRef.oDownloadStateExtendedStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDownloadStateExtendedStatus::most_phonbkfi_tclMsgDownloadStateExtendedStatus()
:oDownloadStateExtendedStream()
 {}

tS32 most_phonbkfi_tclMsgDownloadStateExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadStateExtendedStatus;
}


most_phonbkfi_tclMsgDownloadStateExtendedStatus::~most_phonbkfi_tclMsgDownloadStateExtendedStatus()
{}

tU32 most_phonbkfi_tclMsgDownloadStateExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDownloadStateExtendedStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgDownloadStateExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDownloadStateExtendedStream);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDownloadStateExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDownloadStateExtendedStream);
   return oOut;
}

tBool most_phonbkfi_tclMsgDownloadStateExtendedStatus::operator==(const most_phonbkfi_tclMsgDownloadStateExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDownloadStateExtendedStream == roRef.oDownloadStateExtendedStream);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDownloadProgressUpReg::most_phonbkfi_tclMsgDownloadProgressUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressUpReg;
}


most_phonbkfi_tclMsgDownloadProgressUpReg::~most_phonbkfi_tclMsgDownloadProgressUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadProgressRelUpReg::most_phonbkfi_tclMsgDownloadProgressRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressRelUpReg;
}


most_phonbkfi_tclMsgDownloadProgressRelUpReg::~most_phonbkfi_tclMsgDownloadProgressRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadProgressGet::most_phonbkfi_tclMsgDownloadProgressGet()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressGet;
}


most_phonbkfi_tclMsgDownloadProgressGet::~most_phonbkfi_tclMsgDownloadProgressGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadProgressError::most_phonbkfi_tclMsgDownloadProgressError(const most_phonbkfi_tclMsgDownloadProgressError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDownloadProgressError& most_phonbkfi_tclMsgDownloadProgressError::operator=(const most_phonbkfi_tclMsgDownloadProgressError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDownloadProgressError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressError;
}


most_phonbkfi_tclMsgDownloadProgressError::~most_phonbkfi_tclMsgDownloadProgressError()
{}

tBool most_phonbkfi_tclMsgDownloadProgressError::operator==(const most_phonbkfi_tclMsgDownloadProgressError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadProgressStatus::most_phonbkfi_tclMsgDownloadProgressStatus(const most_phonbkfi_tclMsgDownloadProgressStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32NumberOfContacts = coRef.u32NumberOfContacts;
}
most_phonbkfi_tclMsgDownloadProgressStatus& most_phonbkfi_tclMsgDownloadProgressStatus::operator=(const most_phonbkfi_tclMsgDownloadProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u32NumberOfContacts = coRef.u32NumberOfContacts;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDownloadProgressStatus::most_phonbkfi_tclMsgDownloadProgressStatus()
:u8DeviceHandle(0)
,u32NumberOfContacts(0)
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressStatus;
}


most_phonbkfi_tclMsgDownloadProgressStatus::~most_phonbkfi_tclMsgDownloadProgressStatus()
{}

tU32 most_phonbkfi_tclMsgDownloadProgressStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_phonbkfi_tclMsgDownloadProgressStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u32NumberOfContacts);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDownloadProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u32NumberOfContacts);
   return oOut;
}

tBool most_phonbkfi_tclMsgDownloadProgressStatus::operator==(const most_phonbkfi_tclMsgDownloadProgressStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u32NumberOfContacts == roRef.u32NumberOfContacts);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDownloadProgressListUpReg::most_phonbkfi_tclMsgDownloadProgressListUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressListUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressListUpReg;
}


most_phonbkfi_tclMsgDownloadProgressListUpReg::~most_phonbkfi_tclMsgDownloadProgressListUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadProgressListRelUpReg::most_phonbkfi_tclMsgDownloadProgressListRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressListRelUpReg;
}


most_phonbkfi_tclMsgDownloadProgressListRelUpReg::~most_phonbkfi_tclMsgDownloadProgressListRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadProgressListGet::most_phonbkfi_tclMsgDownloadProgressListGet()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressListGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressListGet;
}


most_phonbkfi_tclMsgDownloadProgressListGet::~most_phonbkfi_tclMsgDownloadProgressListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadProgressListError::most_phonbkfi_tclMsgDownloadProgressListError(const most_phonbkfi_tclMsgDownloadProgressListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDownloadProgressListError& most_phonbkfi_tclMsgDownloadProgressListError::operator=(const most_phonbkfi_tclMsgDownloadProgressListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDownloadProgressListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressListError;
}


most_phonbkfi_tclMsgDownloadProgressListError::~most_phonbkfi_tclMsgDownloadProgressListError()
{}

tBool most_phonbkfi_tclMsgDownloadProgressListError::operator==(const most_phonbkfi_tclMsgDownloadProgressListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadProgressListStatus::most_phonbkfi_tclMsgDownloadProgressListStatus(const most_phonbkfi_tclMsgDownloadProgressListStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oDownloadProgressList = coRef.oDownloadProgressList;
}
most_phonbkfi_tclMsgDownloadProgressListStatus& most_phonbkfi_tclMsgDownloadProgressListStatus::operator=(const most_phonbkfi_tclMsgDownloadProgressListStatus& coRef)
{
   if (this == &coRef) return *this;
   oDownloadProgressList = coRef.oDownloadProgressList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDownloadProgressListStatus::most_phonbkfi_tclMsgDownloadProgressListStatus()
:oDownloadProgressList()
 {}

tS32 most_phonbkfi_tclMsgDownloadProgressListStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadProgressListStatus;
}


most_phonbkfi_tclMsgDownloadProgressListStatus::~most_phonbkfi_tclMsgDownloadProgressListStatus()
{}

tU32 most_phonbkfi_tclMsgDownloadProgressListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDownloadProgressList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgDownloadProgressListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDownloadProgressList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDownloadProgressListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDownloadProgressList);
   return oOut;
}

tBool most_phonbkfi_tclMsgDownloadProgressListStatus::operator==(const most_phonbkfi_tclMsgDownloadProgressListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDownloadProgressList == roRef.oDownloadProgressList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDownloadOnOffListUpReg::most_phonbkfi_tclMsgDownloadOnOffListUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadOnOffListUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListUpReg;
}


most_phonbkfi_tclMsgDownloadOnOffListUpReg::~most_phonbkfi_tclMsgDownloadOnOffListUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadOnOffListRelUpReg::most_phonbkfi_tclMsgDownloadOnOffListRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDownloadOnOffListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListRelUpReg;
}


most_phonbkfi_tclMsgDownloadOnOffListRelUpReg::~most_phonbkfi_tclMsgDownloadOnOffListRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDownloadOnOffListGet::most_phonbkfi_tclMsgDownloadOnOffListGet()
 {}

tS32 most_phonbkfi_tclMsgDownloadOnOffListGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListGet;
}


most_phonbkfi_tclMsgDownloadOnOffListGet::~most_phonbkfi_tclMsgDownloadOnOffListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadOnOffListError::most_phonbkfi_tclMsgDownloadOnOffListError(const most_phonbkfi_tclMsgDownloadOnOffListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDownloadOnOffListError& most_phonbkfi_tclMsgDownloadOnOffListError::operator=(const most_phonbkfi_tclMsgDownloadOnOffListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDownloadOnOffListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListError;
}


most_phonbkfi_tclMsgDownloadOnOffListError::~most_phonbkfi_tclMsgDownloadOnOffListError()
{}

tBool most_phonbkfi_tclMsgDownloadOnOffListError::operator==(const most_phonbkfi_tclMsgDownloadOnOffListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDownloadOnOffListStatus::most_phonbkfi_tclMsgDownloadOnOffListStatus(const most_phonbkfi_tclMsgDownloadOnOffListStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oDownloadOnOffStateList = coRef.oDownloadOnOffStateList;
}
most_phonbkfi_tclMsgDownloadOnOffListStatus& most_phonbkfi_tclMsgDownloadOnOffListStatus::operator=(const most_phonbkfi_tclMsgDownloadOnOffListStatus& coRef)
{
   if (this == &coRef) return *this;
   oDownloadOnOffStateList = coRef.oDownloadOnOffStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDownloadOnOffListStatus::most_phonbkfi_tclMsgDownloadOnOffListStatus()
:oDownloadOnOffStateList()
 {}

tS32 most_phonbkfi_tclMsgDownloadOnOffListStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DownloadOnOffListStatus;
}


most_phonbkfi_tclMsgDownloadOnOffListStatus::~most_phonbkfi_tclMsgDownloadOnOffListStatus()
{}

tU32 most_phonbkfi_tclMsgDownloadOnOffListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDownloadOnOffStateList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgDownloadOnOffListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDownloadOnOffStateList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDownloadOnOffListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDownloadOnOffStateList);
   return oOut;
}

tBool most_phonbkfi_tclMsgDownloadOnOffListStatus::operator==(const most_phonbkfi_tclMsgDownloadOnOffListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDownloadOnOffStateList == roRef.oDownloadOnOffStateList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg::most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg()
 {}

tS32 most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListUpReg;
}


most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg::~most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg::most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListRelUpReg;
}


most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg::~most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgAutomaticContactDownloadListGet::most_phonbkfi_tclMsgAutomaticContactDownloadListGet()
 {}

tS32 most_phonbkfi_tclMsgAutomaticContactDownloadListGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListGet;
}


most_phonbkfi_tclMsgAutomaticContactDownloadListGet::~most_phonbkfi_tclMsgAutomaticContactDownloadListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAutomaticContactDownloadListError::most_phonbkfi_tclMsgAutomaticContactDownloadListError(const most_phonbkfi_tclMsgAutomaticContactDownloadListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgAutomaticContactDownloadListError& most_phonbkfi_tclMsgAutomaticContactDownloadListError::operator=(const most_phonbkfi_tclMsgAutomaticContactDownloadListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgAutomaticContactDownloadListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListError;
}


most_phonbkfi_tclMsgAutomaticContactDownloadListError::~most_phonbkfi_tclMsgAutomaticContactDownloadListError()
{}

tBool most_phonbkfi_tclMsgAutomaticContactDownloadListError::operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::most_phonbkfi_tclMsgAutomaticContactDownloadListStatus(const most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oAutomaticContactDownloadList = coRef.oAutomaticContactDownloadList;
}
most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::operator=(const most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& coRef)
{
   if (this == &coRef) return *this;
   oAutomaticContactDownloadList = coRef.oAutomaticContactDownloadList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::most_phonbkfi_tclMsgAutomaticContactDownloadListStatus()
:oAutomaticContactDownloadList()
 {}

tS32 most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_AutomaticContactDownloadListStatus;
}


most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::~most_phonbkfi_tclMsgAutomaticContactDownloadListStatus()
{}

tU32 most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAutomaticContactDownloadList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAutomaticContactDownloadList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAutomaticContactDownloadList);
   return oOut;
}

tBool most_phonbkfi_tclMsgAutomaticContactDownloadListStatus::operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAutomaticContactDownloadList == roRef.oAutomaticContactDownloadList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedUpReg;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedRelUpReg;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedGet;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError::operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedError;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError()
{}

tBool most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError::operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oDevicePhoneBookFeatureSupportList = coRef.oDevicePhoneBookFeatureSupportList;
}
most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   oDevicePhoneBookFeatureSupportList = coRef.oDevicePhoneBookFeatureSupportList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus()
:oDevicePhoneBookFeatureSupportList()
 {}

tS32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_DevicePhoneBookFeatureSupportExtendedStatus;
}


most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus()
{}

tU32 most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDevicePhoneBookFeatureSupportList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDevicePhoneBookFeatureSupportList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDevicePhoneBookFeatureSupportList);
   return oOut;
}

tBool most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus::operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDevicePhoneBookFeatureSupportList == roRef.oDevicePhoneBookFeatureSupportList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgProbablyLockedDevicesUpReg::most_phonbkfi_tclMsgProbablyLockedDevicesUpReg()
 {}

tS32 most_phonbkfi_tclMsgProbablyLockedDevicesUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesUpReg;
}


most_phonbkfi_tclMsgProbablyLockedDevicesUpReg::~most_phonbkfi_tclMsgProbablyLockedDevicesUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg::most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesRelUpReg;
}


most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg::~most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgProbablyLockedDevicesGet::most_phonbkfi_tclMsgProbablyLockedDevicesGet()
 {}

tS32 most_phonbkfi_tclMsgProbablyLockedDevicesGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesGet;
}


most_phonbkfi_tclMsgProbablyLockedDevicesGet::~most_phonbkfi_tclMsgProbablyLockedDevicesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgProbablyLockedDevicesError::most_phonbkfi_tclMsgProbablyLockedDevicesError(const most_phonbkfi_tclMsgProbablyLockedDevicesError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgProbablyLockedDevicesError& most_phonbkfi_tclMsgProbablyLockedDevicesError::operator=(const most_phonbkfi_tclMsgProbablyLockedDevicesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgProbablyLockedDevicesError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesError;
}


most_phonbkfi_tclMsgProbablyLockedDevicesError::~most_phonbkfi_tclMsgProbablyLockedDevicesError()
{}

tBool most_phonbkfi_tclMsgProbablyLockedDevicesError::operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgProbablyLockedDevicesStatus::most_phonbkfi_tclMsgProbablyLockedDevicesStatus(const most_phonbkfi_tclMsgProbablyLockedDevicesStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oProbablyLockedDevices = coRef.oProbablyLockedDevices;
}
most_phonbkfi_tclMsgProbablyLockedDevicesStatus& most_phonbkfi_tclMsgProbablyLockedDevicesStatus::operator=(const most_phonbkfi_tclMsgProbablyLockedDevicesStatus& coRef)
{
   if (this == &coRef) return *this;
   oProbablyLockedDevices = coRef.oProbablyLockedDevices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgProbablyLockedDevicesStatus::most_phonbkfi_tclMsgProbablyLockedDevicesStatus()
:oProbablyLockedDevices()
 {}

tS32 most_phonbkfi_tclMsgProbablyLockedDevicesStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_ProbablyLockedDevicesStatus;
}


most_phonbkfi_tclMsgProbablyLockedDevicesStatus::~most_phonbkfi_tclMsgProbablyLockedDevicesStatus()
{}

tU32 most_phonbkfi_tclMsgProbablyLockedDevicesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oProbablyLockedDevices.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgProbablyLockedDevicesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oProbablyLockedDevices);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgProbablyLockedDevicesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oProbablyLockedDevices);
   return oOut;
}

tBool most_phonbkfi_tclMsgProbablyLockedDevicesStatus::operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oProbablyLockedDevices == roRef.oProbablyLockedDevices);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgMissedCallIndicatorListUpReg::most_phonbkfi_tclMsgMissedCallIndicatorListUpReg()
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorListUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListUpReg;
}


most_phonbkfi_tclMsgMissedCallIndicatorListUpReg::~most_phonbkfi_tclMsgMissedCallIndicatorListUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg::most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListRelUpReg;
}


most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg::~most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgMissedCallIndicatorListGet::most_phonbkfi_tclMsgMissedCallIndicatorListGet()
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorListGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListGet;
}


most_phonbkfi_tclMsgMissedCallIndicatorListGet::~most_phonbkfi_tclMsgMissedCallIndicatorListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgMissedCallIndicatorListError::most_phonbkfi_tclMsgMissedCallIndicatorListError(const most_phonbkfi_tclMsgMissedCallIndicatorListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgMissedCallIndicatorListError& most_phonbkfi_tclMsgMissedCallIndicatorListError::operator=(const most_phonbkfi_tclMsgMissedCallIndicatorListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgMissedCallIndicatorListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListError;
}


most_phonbkfi_tclMsgMissedCallIndicatorListError::~most_phonbkfi_tclMsgMissedCallIndicatorListError()
{}

tBool most_phonbkfi_tclMsgMissedCallIndicatorListError::operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgMissedCallIndicatorListStatus::most_phonbkfi_tclMsgMissedCallIndicatorListStatus(const most_phonbkfi_tclMsgMissedCallIndicatorListStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oMissedCallIndicatorList = coRef.oMissedCallIndicatorList;
}
most_phonbkfi_tclMsgMissedCallIndicatorListStatus& most_phonbkfi_tclMsgMissedCallIndicatorListStatus::operator=(const most_phonbkfi_tclMsgMissedCallIndicatorListStatus& coRef)
{
   if (this == &coRef) return *this;
   oMissedCallIndicatorList = coRef.oMissedCallIndicatorList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgMissedCallIndicatorListStatus::most_phonbkfi_tclMsgMissedCallIndicatorListStatus()
:oMissedCallIndicatorList()
 {}

tS32 most_phonbkfi_tclMsgMissedCallIndicatorListStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MissedCallIndicatorListStatus;
}


most_phonbkfi_tclMsgMissedCallIndicatorListStatus::~most_phonbkfi_tclMsgMissedCallIndicatorListStatus()
{}

tU32 most_phonbkfi_tclMsgMissedCallIndicatorListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMissedCallIndicatorList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgMissedCallIndicatorListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMissedCallIndicatorList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgMissedCallIndicatorListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMissedCallIndicatorList);
   return oOut;
}

tBool most_phonbkfi_tclMsgMissedCallIndicatorListStatus::operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMissedCallIndicatorList == roRef.oMissedCallIndicatorList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgPreferredSortOrderListUpReg::most_phonbkfi_tclMsgPreferredSortOrderListUpReg()
 {}

tS32 most_phonbkfi_tclMsgPreferredSortOrderListUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListUpReg;
}


most_phonbkfi_tclMsgPreferredSortOrderListUpReg::~most_phonbkfi_tclMsgPreferredSortOrderListUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg::most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListRelUpReg;
}


most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg::~most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgPreferredSortOrderListGet::most_phonbkfi_tclMsgPreferredSortOrderListGet()
 {}

tS32 most_phonbkfi_tclMsgPreferredSortOrderListGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListGet;
}


most_phonbkfi_tclMsgPreferredSortOrderListGet::~most_phonbkfi_tclMsgPreferredSortOrderListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPreferredSortOrderListPureSet::most_phonbkfi_tclMsgPreferredSortOrderListPureSet(const most_phonbkfi_tclMsgPreferredSortOrderListPureSet& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oPreferredSortOrderList = coRef.oPreferredSortOrderList;
}
most_phonbkfi_tclMsgPreferredSortOrderListPureSet& most_phonbkfi_tclMsgPreferredSortOrderListPureSet::operator=(const most_phonbkfi_tclMsgPreferredSortOrderListPureSet& coRef)
{
   if (this == &coRef) return *this;
   oPreferredSortOrderList = coRef.oPreferredSortOrderList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgPreferredSortOrderListPureSet::most_phonbkfi_tclMsgPreferredSortOrderListPureSet()
:oPreferredSortOrderList()
 {}

tS32 most_phonbkfi_tclMsgPreferredSortOrderListPureSet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListPureSet;
}


most_phonbkfi_tclMsgPreferredSortOrderListPureSet::~most_phonbkfi_tclMsgPreferredSortOrderListPureSet()
{}

tU32 most_phonbkfi_tclMsgPreferredSortOrderListPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oPreferredSortOrderList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgPreferredSortOrderListPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oPreferredSortOrderList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgPreferredSortOrderListPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oPreferredSortOrderList);
   return oOut;
}

tBool most_phonbkfi_tclMsgPreferredSortOrderListPureSet::operator==(const most_phonbkfi_tclMsgPreferredSortOrderListPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oPreferredSortOrderList == roRef.oPreferredSortOrderList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPreferredSortOrderListError::most_phonbkfi_tclMsgPreferredSortOrderListError(const most_phonbkfi_tclMsgPreferredSortOrderListError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgPreferredSortOrderListError& most_phonbkfi_tclMsgPreferredSortOrderListError::operator=(const most_phonbkfi_tclMsgPreferredSortOrderListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgPreferredSortOrderListError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListError;
}


most_phonbkfi_tclMsgPreferredSortOrderListError::~most_phonbkfi_tclMsgPreferredSortOrderListError()
{}

tBool most_phonbkfi_tclMsgPreferredSortOrderListError::operator==(const most_phonbkfi_tclMsgPreferredSortOrderListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPreferredSortOrderListStatus::most_phonbkfi_tclMsgPreferredSortOrderListStatus(const most_phonbkfi_tclMsgPreferredSortOrderListStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   oPreferredSortOrderList = coRef.oPreferredSortOrderList;
}
most_phonbkfi_tclMsgPreferredSortOrderListStatus& most_phonbkfi_tclMsgPreferredSortOrderListStatus::operator=(const most_phonbkfi_tclMsgPreferredSortOrderListStatus& coRef)
{
   if (this == &coRef) return *this;
   oPreferredSortOrderList = coRef.oPreferredSortOrderList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgPreferredSortOrderListStatus::most_phonbkfi_tclMsgPreferredSortOrderListStatus()
:oPreferredSortOrderList()
 {}

tS32 most_phonbkfi_tclMsgPreferredSortOrderListStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PreferredSortOrderListStatus;
}


most_phonbkfi_tclMsgPreferredSortOrderListStatus::~most_phonbkfi_tclMsgPreferredSortOrderListStatus()
{}

tU32 most_phonbkfi_tclMsgPreferredSortOrderListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oPreferredSortOrderList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_phonbkfi_tclMsgPreferredSortOrderListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oPreferredSortOrderList);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgPreferredSortOrderListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oPreferredSortOrderList);
   return oOut;
}

tBool most_phonbkfi_tclMsgPreferredSortOrderListStatus::operator==(const most_phonbkfi_tclMsgPreferredSortOrderListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oPreferredSortOrderList == roRef.oPreferredSortOrderList);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgPhonebookLanguageUpReg::most_phonbkfi_tclMsgPhonebookLanguageUpReg()
 {}

tS32 most_phonbkfi_tclMsgPhonebookLanguageUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageUpReg;
}


most_phonbkfi_tclMsgPhonebookLanguageUpReg::~most_phonbkfi_tclMsgPhonebookLanguageUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgPhonebookLanguageRelUpReg::most_phonbkfi_tclMsgPhonebookLanguageRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgPhonebookLanguageRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageRelUpReg;
}


most_phonbkfi_tclMsgPhonebookLanguageRelUpReg::~most_phonbkfi_tclMsgPhonebookLanguageRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgPhonebookLanguageGet::most_phonbkfi_tclMsgPhonebookLanguageGet()
 {}

tS32 most_phonbkfi_tclMsgPhonebookLanguageGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageGet;
}


most_phonbkfi_tclMsgPhonebookLanguageGet::~most_phonbkfi_tclMsgPhonebookLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPhonebookLanguageSet::most_phonbkfi_tclMsgPhonebookLanguageSet(const most_phonbkfi_tclMsgPhonebookLanguageSet& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
most_phonbkfi_tclMsgPhonebookLanguageSet& most_phonbkfi_tclMsgPhonebookLanguageSet::operator=(const most_phonbkfi_tclMsgPhonebookLanguageSet& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgPhonebookLanguageSet::most_phonbkfi_tclMsgPhonebookLanguageSet()
:e8Language()
 {}

tS32 most_phonbkfi_tclMsgPhonebookLanguageSet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageSet;
}


most_phonbkfi_tclMsgPhonebookLanguageSet::~most_phonbkfi_tclMsgPhonebookLanguageSet()
{}

tU32 most_phonbkfi_tclMsgPhonebookLanguageSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgPhonebookLanguageSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgPhonebookLanguageSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool most_phonbkfi_tclMsgPhonebookLanguageSet::operator==(const most_phonbkfi_tclMsgPhonebookLanguageSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPhonebookLanguageError::most_phonbkfi_tclMsgPhonebookLanguageError(const most_phonbkfi_tclMsgPhonebookLanguageError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgPhonebookLanguageError& most_phonbkfi_tclMsgPhonebookLanguageError::operator=(const most_phonbkfi_tclMsgPhonebookLanguageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgPhonebookLanguageError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageError;
}


most_phonbkfi_tclMsgPhonebookLanguageError::~most_phonbkfi_tclMsgPhonebookLanguageError()
{}

tBool most_phonbkfi_tclMsgPhonebookLanguageError::operator==(const most_phonbkfi_tclMsgPhonebookLanguageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgPhonebookLanguageStatus::most_phonbkfi_tclMsgPhonebookLanguageStatus(const most_phonbkfi_tclMsgPhonebookLanguageStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
most_phonbkfi_tclMsgPhonebookLanguageStatus& most_phonbkfi_tclMsgPhonebookLanguageStatus::operator=(const most_phonbkfi_tclMsgPhonebookLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgPhonebookLanguageStatus::most_phonbkfi_tclMsgPhonebookLanguageStatus()
:e8Language()
 {}

tS32 most_phonbkfi_tclMsgPhonebookLanguageStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_PhonebookLanguageStatus;
}


most_phonbkfi_tclMsgPhonebookLanguageStatus::~most_phonbkfi_tclMsgPhonebookLanguageStatus()
{}

tU32 most_phonbkfi_tclMsgPhonebookLanguageStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_phonbkfi_tclMsgPhonebookLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgPhonebookLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool most_phonbkfi_tclMsgPhonebookLanguageStatus::operator==(const most_phonbkfi_tclMsgPhonebookLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

most_phonbkfi_tclMsgMaxContactCountUpReg::most_phonbkfi_tclMsgMaxContactCountUpReg()
 {}

tS32 most_phonbkfi_tclMsgMaxContactCountUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MaxContactCountUpReg;
}


most_phonbkfi_tclMsgMaxContactCountUpReg::~most_phonbkfi_tclMsgMaxContactCountUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgMaxContactCountRelUpReg::most_phonbkfi_tclMsgMaxContactCountRelUpReg()
 {}

tS32 most_phonbkfi_tclMsgMaxContactCountRelUpReg::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MaxContactCountRelUpReg;
}


most_phonbkfi_tclMsgMaxContactCountRelUpReg::~most_phonbkfi_tclMsgMaxContactCountRelUpReg()
{}

//=============================================================================

most_phonbkfi_tclMsgMaxContactCountGet::most_phonbkfi_tclMsgMaxContactCountGet()
 {}

tS32 most_phonbkfi_tclMsgMaxContactCountGet::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MaxContactCountGet;
}


most_phonbkfi_tclMsgMaxContactCountGet::~most_phonbkfi_tclMsgMaxContactCountGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgMaxContactCountError::most_phonbkfi_tclMsgMaxContactCountError(const most_phonbkfi_tclMsgMaxContactCountError& coRef)
   : most_phonbkfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_phonbkfi_tclMsgMaxContactCountError& most_phonbkfi_tclMsgMaxContactCountError::operator=(const most_phonbkfi_tclMsgMaxContactCountError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_phonbkfi_tclMsgMaxContactCountError::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MaxContactCountError;
}


most_phonbkfi_tclMsgMaxContactCountError::~most_phonbkfi_tclMsgMaxContactCountError()
{}

tBool most_phonbkfi_tclMsgMaxContactCountError::operator==(const most_phonbkfi_tclMsgMaxContactCountError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_phonbkfi_tclMsgMaxContactCountStatus::most_phonbkfi_tclMsgMaxContactCountStatus(const most_phonbkfi_tclMsgMaxContactCountStatus& coRef)
   : most_phonbkfi_tclMsgBaseMessage(coRef)
{
   u32MaxContactsCount = coRef.u32MaxContactsCount;
}
most_phonbkfi_tclMsgMaxContactCountStatus& most_phonbkfi_tclMsgMaxContactCountStatus::operator=(const most_phonbkfi_tclMsgMaxContactCountStatus& coRef)
{
   if (this == &coRef) return *this;
   u32MaxContactsCount = coRef.u32MaxContactsCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_phonbkfi_tclMsgMaxContactCountStatus::most_phonbkfi_tclMsgMaxContactCountStatus()
:u32MaxContactsCount(0)
 {}

tS32 most_phonbkfi_tclMsgMaxContactCountStatus::s32GetTypeId() const
{
   return (tS32) most_phonbkfi_tclToken::EN_MSG_MaxContactCountStatus;
}


most_phonbkfi_tclMsgMaxContactCountStatus::~most_phonbkfi_tclMsgMaxContactCountStatus()
{}

tU32 most_phonbkfi_tclMsgMaxContactCountStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_phonbkfi_tclMsgMaxContactCountStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32MaxContactsCount);
   return oIn;
}

fi_tclOutContext& most_phonbkfi_tclMsgMaxContactCountStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32MaxContactsCount);
   return oOut;
}

tBool most_phonbkfi_tclMsgMaxContactCountStatus::operator==(const most_phonbkfi_tclMsgMaxContactCountStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32MaxContactsCount == roRef.u32MaxContactsCount);
   return bResult;
}

