#ifndef MOST_PHONBKFILANGUAGE_HEADER
#define MOST_PHONBKFILANGUAGE_HEADER

class most_phonbkfi_tclInContext;
class most_phonbkfi_tclOutContext;
class most_phonbkfi_tclVisitorBase;

class MY_DECL most_phonbkfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  most_phonbkfi_tclDescription(fi_tclInContext* poIn, most_phonbkfi_tclVisitorBase* poVisit);
  most_phonbkfi_tclDescription(fi_tclOutContext* poOut, most_phonbkfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(most_phonbkfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(most_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ most_phonbkfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  most_phonbkfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<most_phonbkfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<most_phonbkfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline most_phonbkfi_tclDescription::most_phonbkfi_tclDescription(fi_tclInContext* poIn, most_phonbkfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline most_phonbkfi_tclDescription::most_phonbkfi_tclDescription(fi_tclOutContext* poOut, most_phonbkfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

