#ifndef MOST_BTSETFILANGUAGE_HEADER
#define MOST_BTSETFILANGUAGE_HEADER

class most_btsetfi_tclInContext;
class most_btsetfi_tclOutContext;
class most_btsetfi_tclVisitorBase;

class MY_DECL most_btsetfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  most_btsetfi_tclDescription(fi_tclInContext* poIn, most_btsetfi_tclVisitorBase* poVisit);
  most_btsetfi_tclDescription(fi_tclOutContext* poOut, most_btsetfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(most_btsetfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(most_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ most_btsetfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  most_btsetfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<most_btsetfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<most_btsetfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline most_btsetfi_tclDescription::most_btsetfi_tclDescription(fi_tclInContext* poIn, most_btsetfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline most_btsetfi_tclDescription::most_btsetfi_tclDescription(fi_tclOutContext* poOut, most_btsetfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

