#ifndef _PROTOCOLCONNECTIONSM_H_
#define _PROTOCOLCONNECTIONSM_H_

/* generated code: do not edit */

#include "SMF.h"

#include "BmAllTypes.h"

namespace bmcore {

#define PROTOCOLCONNECTIONSM_NAME "ProtocolConnectionSm"

class ProtocolConnectionSm: public SMF {
public:
	ProtocolConnectionSm() :
	CANCEL_WAITING_CONNECT_LOCAL(0),
	CONNECTED(0),
	CONNECTION_FAILED(0),
	CONNECTION_REQUEST_SENT(0),
	CONNECT_LOCAL(0),
	CONNECT_REMOTE(0),
	CONTINUE_CONNECTING(0),
	DEFAULT(0),
	DISCONNECT(0),
	DISCONNECTED(0),
	DISCONNECTION_FAILED(0),
	DONE(0),
	FORCE_STATE_DISCONNECTED(0),
	INIT(0),
	STOP_SM(0),
	dummy_do_not_use(0)
	{
		SetSMName(PROTOCOLCONNECTIONSM_NAME);
	}

	/* enums for states */
	enum ProtocolConnectionSm_states {
		topProtocolConnection,
		ProtocolConnection,
		Final,
		Disconnected,
		Connected,
		Disconnecting,
		Stopped,
		DelayConnecting,
		Connecting,
		LocalConnectionRequest,
	};

	// generated virtual implementations of user callback functions
	virtual int accept() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int connect() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int connectingToBeDelayed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int disconnect() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterConnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterDelayConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterDisconnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterDisconnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int exitDelayConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int exitDisconnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleAlreadyConnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDisconnect(const DisconnectedReason _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDisconnectedInDisconnected(const DisconnectedReason _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDone() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleForceStateDisconnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleStopSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int messageNotConsumed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int requestReleaseIfPossible() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int resetCanBeReleasedFlag() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int saveDisconnectedReason(const DisconnectedReason _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int saveRfcommDevicePath(const RfcommDevicePathChrArr _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int sendConnectLocal() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	int ParameterCONNECTED(char *parameterString, const size_t size, const RfcommDevicePathChrArr _1)
	{
		return (Marshal(parameterString, size-1, RFCOMMDEVICEPATHCHRARR_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterDISCONNECT(char *parameterString, const size_t size, const DisconnectedReason _1)
	{
		return (Marshal(parameterString, size-1, DISCONNECTEDREASON_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterDISCONNECTED(char *parameterString, const size_t size, const DisconnectedReason _1)
	{
		return (Marshal(parameterString, size-1, DISCONNECTEDREASON_FORMAT , _1) != 0 ? 0 : -1);
	}


protected:

	// generates static call functions for all state machine user callbacks
	static int acceptCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->accept();
	}

	static int connectCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->connect();
	}

	static int connectingToBeDelayedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->connectingToBeDelayed();
	}

	static int disconnectCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->disconnect();
	}

	static int enterConnectedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->enterConnected();
	}

	static int enterConnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->enterConnecting();
	}

	static int enterDelayConnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->enterDelayConnecting();
	}

	static int enterDisconnectedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->enterDisconnected();
	}

	static int enterDisconnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->enterDisconnecting();
	}

	static int exitDelayConnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->exitDelayConnecting();
	}

	static int exitDisconnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectionSm *)(state->_this))->exitDisconnecting();
	}

	static int handleAlreadyConnectedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->handleAlreadyConnected();
	}

	static int handleDisconnectCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		DisconnectedReason _1 = DISCONNECTEDREASON_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, DISCONNECTEDREASON_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectionSm *)(trans->_this))->handleDisconnect(_1);
		return ret;
	}

	static int handleDisconnectedInDisconnectedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		DisconnectedReason _1 = DISCONNECTEDREASON_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, DISCONNECTEDREASON_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectionSm *)(trans->_this))->handleDisconnectedInDisconnected(_1);
		return ret;
	}

	static int handleDoneCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->handleDone();
	}

	static int handleForceStateDisconnectedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->handleForceStateDisconnected();
	}

	static int handleStopSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->handleStopSm();
	}

	static int initSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->initSm();
	}

	static int messageNotConsumedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->messageNotConsumed();
	}

	static int requestReleaseIfPossibleCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->requestReleaseIfPossible();
	}

	static int resetCanBeReleasedFlagCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->resetCanBeReleasedFlag();
	}

	static int saveDisconnectedReasonCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		DisconnectedReason _1 = DISCONNECTEDREASON_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, DISCONNECTEDREASON_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectionSm *)(trans->_this))->saveDisconnectedReason(_1);
		return ret;
	}

	static int saveRfcommDevicePathCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		RfcommDevicePathChrArr _1 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, RFCOMMDEVICEPATHCHRARR_FORMAT  ,_1 );
		}
		ret = ((ProtocolConnectionSm *)(trans->_this))->saveRfcommDevicePath(_1);
		return ret;
	}

	static int sendConnectLocalCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectionSm *)(trans->_this))->sendConnectLocal();
	}


public:

	/* used external events */
	SMF::tEvent *CANCEL_WAITING_CONNECT_LOCAL;
	SMF::tEvent *CONNECTED;
	SMF::tEvent *CONNECTION_FAILED;
	SMF::tEvent *CONNECTION_REQUEST_SENT;
	SMF::tEvent *CONNECT_LOCAL;
	SMF::tEvent *CONNECT_REMOTE;
	SMF::tEvent *CONTINUE_CONNECTING;
	SMF::tEvent *DEFAULT;
	SMF::tEvent *DISCONNECT;
	SMF::tEvent *DISCONNECTED;
	SMF::tEvent *DISCONNECTION_FAILED;
	SMF::tEvent *DONE;
	SMF::tEvent *FORCE_STATE_DISCONNECTED;
	SMF::tEvent *INIT;
	SMF::tEvent *STOP_SM;
	int dummy_do_not_use;


virtual void Create()
{
	if (_created) {
		/* SM was already created => return now */
		return;
	}

	_created = true;

	/* state machine definition */


	/* create new compound state */
	tState *topProtocolConnection_14b267b491980000000000000000965 = CreateCompoundState("topProtocolConnection", topProtocolConnection, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *ProtocolConnection_14cc663f76680000000000000000B97 = CreateCompoundState("ProtocolConnection", ProtocolConnection, NULL, NULL, NULL, NULL);

	/* create final states */
	tState *Final_14b2abb3fa5800000000000000009A4 = CreateFinalState("Final", Final, NULL, NULL);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, Final_14b2abb3fa5800000000000000009A4);

	/* create states */
	tState *Disconnected_14b267b491980000000000000000966 = CreateState("Disconnected", Disconnected, enterDisconnectedCall, "enterDisconnected", NULL, NULL);
	tState *Connected_14b267b49198000000000000000096B = CreateState("Connected", Connected, enterConnectedCall, "enterConnected", NULL, NULL);
	tState *Disconnecting_14b267b49198000000000000000096C = CreateState("Disconnecting", Disconnecting, enterDisconnectingCall, "enterDisconnecting", exitDisconnectingCall, "exitDisconnecting");
	tState *Stopped_14b2abb3fa5800000000000000009A3 = CreateState("Stopped", Stopped, NULL, NULL, NULL, NULL);
	tState *DelayConnecting_14be056067580000000000000000B55 = CreateState("DelayConnecting", DelayConnecting, enterDelayConnectingCall, "enterDelayConnecting", exitDelayConnectingCall, "exitDelayConnecting");

	/* create new compound state */
	tState *Connecting_1512bf697b280000000000000000B7F = CreateCompoundState("Connecting", Connecting, enterConnectingCall, "enterConnecting", NULL, NULL);

	/* create states */
	tState *LocalConnectionRequest_1512bf697b280000000000000000B80 = CreateState("LocalConnectionRequest", LocalConnectionRequest, connectCall, "connect", NULL, NULL);

	/* create states */
	tTransition *Init_14b267b491980000000000000000967 = CreateTransition("Init", NULL, NULL, initSmCall, "initSm", Disconnected_14b267b491980000000000000000966);

	/* set the init transition */
	SetInitTransition(topProtocolConnection_14b267b491980000000000000000965, Init_14b267b491980000000000000000967);

	/* Add in states */
	AddState(topProtocolConnection_14b267b491980000000000000000965, ProtocolConnection_14cc663f76680000000000000000B97);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, Connecting_1512bf697b280000000000000000B7F);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, Disconnected_14b267b491980000000000000000966);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, Connected_14b267b49198000000000000000096B);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, Disconnecting_14b267b49198000000000000000096C);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, Stopped_14b2abb3fa5800000000000000009A3);
	AddState(ProtocolConnection_14cc663f76680000000000000000B97, DelayConnecting_14be056067580000000000000000B55);
	AddState(Connecting_1512bf697b280000000000000000B7F, LocalConnectionRequest_1512bf697b280000000000000000B80);

	/* create events */
	CANCEL_WAITING_CONNECT_LOCAL = CreateEvent("CANCEL_WAITING_CONNECT_LOCAL");
	CONNECTED = CreateEvent("CONNECTED");
	CONNECTION_FAILED = CreateEvent("CONNECTION_FAILED");
	CONNECTION_REQUEST_SENT = CreateEvent("CONNECTION_REQUEST_SENT");
	CONNECT_LOCAL = CreateEvent("CONNECT_LOCAL");
	CONNECT_REMOTE = CreateEvent("CONNECT_REMOTE");
	CONTINUE_CONNECTING = CreateEvent("CONTINUE_CONNECTING");
	DEFAULT = CreateEvent("DEFAULT");
	DISCONNECT = CreateEvent("DISCONNECT");
	DISCONNECTED = CreateEvent("DISCONNECTED");
	DISCONNECTION_FAILED = CreateEvent("DISCONNECTION_FAILED");
	DONE = CreateEvent("DONE");
	FORCE_STATE_DISCONNECTED = CreateEvent("FORCE_STATE_DISCONNECTED");
	INIT = CreateEvent("INIT");
	STOP_SM = CreateEvent("STOP_SM");

	/* create event transitions */

	/* create internal transactions */
/*2*/	tTransition *Connected2Connected_ConnectLocal_P15692a19070800000000000000009FC = CreateEventTransition(CONNECT_LOCAL, "CONNECTED2CONNECTED_CONNECTLOCAL", NULL, NULL,  handleAlreadyConnectedCall,  "handleAlreadyConnected", NULL);
/*2*/	tTransition *Disconnected2Disconnected_CancelWaitingConnectLocal_P15669604ea5800000000000000009F0 = CreateEventTransition(CANCEL_WAITING_CONNECT_LOCAL, "DISCONNECTED2DISCONNECTED_CANCELWAITINGCONNECTLOCAL", NULL, NULL,  requestReleaseIfPossibleCall,  "requestReleaseIfPossible", NULL);
/*2*/	tTransition *Disconnected2Disconnected_Connected_P15650192814800000000000000009EC = CreateEventTransition(CONNECTED, "DISCONNECTED2DISCONNECTED_CONNECTED", NULL, NULL,  sendConnectLocalCall,  "sendConnectLocal", NULL);
/*2*/	tTransition *Disconnected2Disconnected_ConnectionFailed_P15669604ea5800000000000000009EE = CreateEventTransition(CONNECTION_FAILED, "DISCONNECTED2DISCONNECTED_CONNECTIONFAILED", NULL, NULL,  requestReleaseIfPossibleCall,  "requestReleaseIfPossible", NULL);
/*2*/	tTransition *Disconnected2Disconnected_ContinueConnecting_P15669604ea5800000000000000009F1 = CreateEventTransition(CONTINUE_CONNECTING, "DISCONNECTED2DISCONNECTED_CONTINUECONNECTING", NULL, NULL,  requestReleaseIfPossibleCall,  "requestReleaseIfPossible", NULL);
/*2*/	tTransition *Disconnected2Disconnected_Disconnect_P14bda91d2fb800000000000000009AA = CreateEventTransition(DISCONNECT, "DISCONNECTED2DISCONNECTED_DISCONNECT", NULL, NULL,  requestReleaseIfPossibleCall,  "requestReleaseIfPossible", NULL);
/*2*/	tTransition *Disconnected2Disconnected_Disconnected_P15650192814800000000000000009E8 = CreateEventTransition(DISCONNECTED, "DISCONNECTED2DISCONNECTED_DISCONNECTED", NULL, NULL,  handleDisconnectedInDisconnectedCall,  "handleDisconnectedInDisconnected", NULL);
/*2*/	tTransition *Disconnected2Disconnected_ForceStateDisconnected_P15669604ea5800000000000000009EF = CreateEventTransition(FORCE_STATE_DISCONNECTED, "DISCONNECTED2DISCONNECTED_FORCESTATEDISCONNECTED", NULL, NULL,  requestReleaseIfPossibleCall,  "requestReleaseIfPossible", NULL);
/*2*/	tTransition *Disconnected2Disconnected_ServiceSearchFinished_P15669604ea5800000000000000009FA = CreateEventTransition(CONNECTION_REQUEST_SENT, "DISCONNECTED2DISCONNECTED_SERVICESEARCHFINISHED", NULL, NULL,  requestReleaseIfPossibleCall,  "requestReleaseIfPossible", NULL);
/*2*/	tTransition *Disconnecting2Disconnecting_Connected_P14b2a4aadd180000000000000000995 = CreateEventTransition(CONNECTED, "DISCONNECTING2DISCONNECTING_CONNECTED", NULL, NULL,  disconnectCall,  "disconnect", NULL);
/*2*/	tTransition *Disconnecting2Disconnecting_DisconnectionFailed_P14b2a4aadd180000000000000000998 = CreateEventTransition(DISCONNECTION_FAILED, "DISCONNECTING2DISCONNECTING_DISCONNECTIONFAILED", NULL, NULL,  disconnectCall,  "disconnect", NULL);
/*2*/	tTransition *ProtocolConnection2ProtocolConnection_ConnectLocal_P150b3d8644280000000000000000B7B = CreateEventTransition(CONNECT_LOCAL, "PROTOCOLCONNECTION2PROTOCOLCONNECTION_CONNECTLOCAL", NULL, NULL,  resetCanBeReleasedFlagCall,  "resetCanBeReleasedFlag", NULL);
/*2*/	tTransition *ProtocolConnection2ProtocolConnection_ConnectRemote_P150b3d8644280000000000000000B72 = CreateEventTransition(CONNECT_REMOTE, "PROTOCOLCONNECTION2PROTOCOLCONNECTION_CONNECTREMOTE", NULL, NULL,  acceptCall,  "accept", NULL);
/*2*/	tTransition *ProtocolConnection2ProtocolConnection_Default_P14cc663f76680000000000000000B9F = CreateEventTransition(DEFAULT, "PROTOCOLCONNECTION2PROTOCOLCONNECTION_DEFAULT", NULL, NULL,  messageNotConsumedCall,  "messageNotConsumed", NULL);

	/* create event transitions */
/*7*/	tTransition *Connected2Disconnected_Disconnected_14b267b49198000000000000000097D = CreateEventTransition(DISCONNECTED, "Connected2Disconnected_Disconnected", NULL, NULL, saveDisconnectedReasonCall, "saveDisconnectedReason", Disconnected_14b267b491980000000000000000966);
/*7*/	tTransition *Connected2Disconnecting_Disconnect_14b267b491980000000000000000976 = CreateEventTransition(DISCONNECT, "Connected2Disconnecting_Disconnect", NULL, NULL, handleDisconnectCall, "handleDisconnect", Disconnecting_14b267b49198000000000000000096C);
/*7*/	tTransition *Connecting2Connected_Connected_14b267b491980000000000000000974 = CreateEventTransition(CONNECTED, "Connecting2Connected_Connected", NULL, NULL, saveRfcommDevicePathCall, "saveRfcommDevicePath", Connected_14b267b49198000000000000000096B);
/*7*/	tTransition *Connecting2Disconnected_ConnectionFailed_14b267b49198000000000000000097E = CreateEventTransition(DISCONNECTED, "Connecting2Disconnected_ConnectionFailed", NULL, NULL, saveDisconnectedReasonCall, "saveDisconnectedReason", Disconnected_14b267b491980000000000000000966);
/*7*/	tTransition *Connecting2Disconnecting_Disconnect_14b267b49198000000000000000097A = CreateEventTransition(DISCONNECT, "Connecting2Disconnecting_Disconnect", NULL, NULL, handleDisconnectCall, "handleDisconnect", Disconnecting_14b267b49198000000000000000096C);
/*7*/	tTransition *DelayConnecting2Connecting_ConnectExtern_14be056067580000000000000000B66 = CreateEventTransition(CONNECT_REMOTE, "DelayConnecting2Connecting_ConnectExtern", NULL, NULL, acceptCall, "accept", Connecting_1512bf697b280000000000000000B7F);
/*7*/	tTransition *DelayConnecting2Connecting_ContinueConnecting_14be056067580000000000000000B56 = CreateEventTransition(CONTINUE_CONNECTING, "DelayConnecting2Connecting_ContinueConnecting", NULL, NULL, NULL, NULL, LocalConnectionRequest_1512bf697b280000000000000000B80);
/*7*/	tTransition *DelayConnecting2Disconnected_CancelWaitingConnectLocal_1535703d12480000000000000000B83 = CreateEventTransition(CANCEL_WAITING_CONNECT_LOCAL, "DelayConnecting2Disconnected_CancelWaitingConnectLocal", NULL, NULL, NULL, NULL, Disconnected_14b267b491980000000000000000966);
/*7*/	tTransition *DelayConnecting2Disconnected_Disconnect_14be056067580000000000000000B6F = CreateEventTransition(DISCONNECT, "DelayConnecting2Disconnected_Disconnect", NULL, NULL, NULL, NULL, Disconnected_14b267b491980000000000000000966);
/*7*/	tTransition *Disconnected2Connecting_ConnectRemote_14b267b49198000000000000000096E = CreateEventTransition(CONNECT_REMOTE, "Disconnected2Connecting_ConnectRemote", NULL, NULL, acceptCall, "accept", Connecting_1512bf697b280000000000000000B7F);
/*7*/	tTransition *Disconnecting2Connecting_ConnectLocal_150b3d8644280000000000000000B75 = CreateEventTransition(CONNECT_LOCAL, "Disconnecting2Connecting_ConnectLocal", NULL, NULL, NULL, NULL, LocalConnectionRequest_1512bf697b280000000000000000B80);
/*7*/	tTransition *Disconnecting2Connecting_ConnectRemote_150b3d8644280000000000000000B78 = CreateEventTransition(CONNECT_REMOTE, "Disconnecting2Connecting_ConnectRemote", NULL, NULL, acceptCall, "accept", Connecting_1512bf697b280000000000000000B7F);
/*7*/	tTransition *Disconnecting2Disconnected_Disconnected_14b267b491980000000000000000978 = CreateEventTransition(DISCONNECTED, "Disconnecting2Disconnected_Disconnected", NULL, NULL, saveDisconnectedReasonCall, "saveDisconnectedReason", Disconnected_14b267b491980000000000000000966);
/*7*/	tTransition *Disconnecting2Disconnected_ForceStateDisconnected_14b2abb3fa5800000000000000009A1 = CreateEventTransition(FORCE_STATE_DISCONNECTED, "Disconnecting2Disconnected_ForceStateDisconnected", NULL, NULL, handleForceStateDisconnectedCall, "handleForceStateDisconnected", Disconnected_14b267b491980000000000000000966);
/*7*/	tTransition *ProtocolConnection2Final_Done_14cc663f76680000000000000000B98 = CreateEventTransition(DONE, "ProtocolConnection2Final_Done", NULL, NULL, handleDoneCall, "handleDone", Final_14b2abb3fa5800000000000000009A4);
/*7*/	tTransition *ProtocolConnection2Stopped_StopSm_14cc663f76680000000000000000B99 = CreateEventTransition(STOP_SM, "ProtocolConnection2Stopped_StopSm", NULL, NULL, handleStopSmCall, "handleStopSm", Stopped_14b2abb3fa5800000000000000009A3);
/*9*/	tTransition *Disconnected2Cond_ConnectLocal_14b267b491980000000000000000972 = CreateEventConditionalTransition(CONNECT_LOCAL, "Disconnected2Cond_ConnectLocal", ProtocolConnection_14cc663f76680000000000000000B97, NULL, NULL, connectingToBeDelayedCall, "connectingToBeDelayed", NULL, NULL, NULL, NULL, "trueCond2DelayConnecting_True", DelayConnecting_14be056067580000000000000000B55, "falseCond2Connecting_False", LocalConnectionRequest_1512bf697b280000000000000000B80);

	/* add transitions to states */
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Connecting_ConnectRemote_14b267b49198000000000000000096E);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Cond_ConnectLocal_14b267b491980000000000000000972);
	AddTransition(Connecting_1512bf697b280000000000000000B7F, Connecting2Connected_Connected_14b267b491980000000000000000974);
	AddTransition(Connected_14b267b49198000000000000000096B, Connected2Disconnecting_Disconnect_14b267b491980000000000000000976);
	AddTransition(Disconnecting_14b267b49198000000000000000096C, Disconnecting2Disconnected_Disconnected_14b267b491980000000000000000978);
	AddTransition(Connecting_1512bf697b280000000000000000B7F, Connecting2Disconnecting_Disconnect_14b267b49198000000000000000097A);
	AddTransition(Connected_14b267b49198000000000000000096B, Connected2Disconnected_Disconnected_14b267b49198000000000000000097D);
	AddTransition(Connecting_1512bf697b280000000000000000B7F, Connecting2Disconnected_ConnectionFailed_14b267b49198000000000000000097E);
	AddTransition(Disconnecting_14b267b49198000000000000000096C, Disconnecting2Disconnected_ForceStateDisconnected_14b2abb3fa5800000000000000009A1);
	AddTransition(DelayConnecting_14be056067580000000000000000B55, DelayConnecting2Connecting_ContinueConnecting_14be056067580000000000000000B56);
	AddTransition(DelayConnecting_14be056067580000000000000000B55, DelayConnecting2Connecting_ConnectExtern_14be056067580000000000000000B66);
	AddTransition(DelayConnecting_14be056067580000000000000000B55, DelayConnecting2Disconnected_Disconnect_14be056067580000000000000000B6F);
	AddTransition(ProtocolConnection_14cc663f76680000000000000000B97, ProtocolConnection2Final_Done_14cc663f76680000000000000000B98);
	AddTransition(ProtocolConnection_14cc663f76680000000000000000B97, ProtocolConnection2Stopped_StopSm_14cc663f76680000000000000000B99);
	AddTransition(Disconnecting_14b267b49198000000000000000096C, Disconnecting2Connecting_ConnectLocal_150b3d8644280000000000000000B75);
	AddTransition(Disconnecting_14b267b49198000000000000000096C, Disconnecting2Connecting_ConnectRemote_150b3d8644280000000000000000B78);
	AddTransition(DelayConnecting_14be056067580000000000000000B55, DelayConnecting2Disconnected_CancelWaitingConnectLocal_1535703d12480000000000000000B83);
	AddTransition(Disconnecting_14b267b49198000000000000000096C, Disconnecting2Disconnecting_Connected_P14b2a4aadd180000000000000000995);
	AddTransition(Disconnecting_14b267b49198000000000000000096C, Disconnecting2Disconnecting_DisconnectionFailed_P14b2a4aadd180000000000000000998);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_Disconnect_P14bda91d2fb800000000000000009AA);
	AddTransition(ProtocolConnection_14cc663f76680000000000000000B97, ProtocolConnection2ProtocolConnection_Default_P14cc663f76680000000000000000B9F);
	AddTransition(ProtocolConnection_14cc663f76680000000000000000B97, ProtocolConnection2ProtocolConnection_ConnectRemote_P150b3d8644280000000000000000B72);
	AddTransition(ProtocolConnection_14cc663f76680000000000000000B97, ProtocolConnection2ProtocolConnection_ConnectLocal_P150b3d8644280000000000000000B7B);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_Disconnected_P15650192814800000000000000009E8);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_Connected_P15650192814800000000000000009EC);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_ConnectionFailed_P15669604ea5800000000000000009EE);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_ForceStateDisconnected_P15669604ea5800000000000000009EF);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_CancelWaitingConnectLocal_P15669604ea5800000000000000009F0);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_ContinueConnecting_P15669604ea5800000000000000009F1);
	AddTransition(Disconnected_14b267b491980000000000000000966, Disconnected2Disconnected_ServiceSearchFinished_P15669604ea5800000000000000009FA);
	AddTransition(Connected_14b267b49198000000000000000096B, Connected2Connected_ConnectLocal_P15692a19070800000000000000009FC);

	/* set start (compound) state for state machine */
	SetConcurrent(topProtocolConnection_14b267b491980000000000000000965);
	return SetRoot(topProtocolConnection_14b267b491980000000000000000965);
}
};
} // namespace bmcore
// end of generated code

#endif
