#ifndef _DEVICECONNECTIONSM_H_
#define _DEVICECONNECTIONSM_H_

/* generated code: do not edit */

#include "SMF.h"

#include "BmAllTypes.h"

namespace bmcore {

#define DEVICECONNECTIONSM_NAME "DeviceConnectionSm"

class DeviceConnectionSm: public SMF {
public:
	DeviceConnectionSm() :
	ACL_CONNECTION_FAILED(0),
	ALL_PROTOCOLS_DISCONNECTED(0),
	CONNECTED(0),
	CONNECTION_RETRY(0),
	CONNECT_LOCAL(0),
	CONNECT_REMOTE(0),
	CPW_ENDED(0),
	CPW_STARTED(0),
	DEFAULT(0),
	DISCONNECT(0),
	DISCONNECTED(0),
	DISCONNECTION_FAILED(0),
	DISCONNECTION_FINISHED(0),
	DISCONNECTION_RETRY(0),
	DISCONNECT_PROTOCOL(0),
	DONE(0),
	INIT(0),
	STOP_SM(0),
	dummy_do_not_use(0)
	{
		SetSMName(DEVICECONNECTIONSM_NAME);
	}

	/* enums for states */
	enum DeviceConnectionSm_states {
		topDeviceConnection,
		InUse,
		Lost,
		Connecting,
		Connected,
		DeviceConnection,
		Final,
		Stopped,
		Idle,
		Disconnecting,
		DisconnectionFailed,
	};

	// generated virtual implementations of user callback functions
	virtual int connectProtocolLocal(const ProtocolId _1, const UuidChrArr _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int connectProtocolRemote(const ProtocolId _1, const UuidChrArr _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int disconnectDevice() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int disconnectInIdle() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int disconnectProtocol(const ProtocolId _1, const UuidChrArr _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterConnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterDisconnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterDisconnectionFailed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterIdle() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterInUse() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int enterLost() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int exitDisconnectionFailed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int exitLost() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleAllProtocolsDisconnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDeviceDisconnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDisconnect() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDone() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleLostDevice() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleProtocolConnected(const ProtocolId _1, const UuidChrArr _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleStopSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int isDeviceLost() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int messageNotConsumed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int reconnectDevice() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int rejectProtocolConnectionRemote(const ProtocolId _1, const UuidChrArr _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int releaseDcc() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int reserveDcc() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int unreserveDcc() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	int ParameterCONNECTED(char *parameterString, const size_t size, const ProtocolId _1, const UuidChrArr _2)
	{
		return (Marshal(parameterString, size-1, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterCONNECT_LOCAL(char *parameterString, const size_t size, const ProtocolId _1, const UuidChrArr _2)
	{
		return (Marshal(parameterString, size-1, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterCONNECT_REMOTE(char *parameterString, const size_t size, const ProtocolId _1, const UuidChrArr _2)
	{
		return (Marshal(parameterString, size-1, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterDISCONNECT_PROTOCOL(char *parameterString, const size_t size, const ProtocolId _1, const UuidChrArr _2)
	{
		return (Marshal(parameterString, size-1, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT , _1, _2) != 0 ? 0 : -1);
	}


protected:

	// generates static call functions for all state machine user callbacks
	static int connectProtocolLocalCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		ProtocolId _1 = PROTOCOLID_INIT;
		UuidChrArr _2 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT  ,&_1 ,_2 );
		}
		ret = ((DeviceConnectionSm *)(trans->_this))->connectProtocolLocal(_1, _2);
		return ret;
	}

	static int connectProtocolRemoteCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		ProtocolId _1 = PROTOCOLID_INIT;
		UuidChrArr _2 = UUIDCHRARR_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT  ,&_1 ,&_2 );
		}
		ret = ((DeviceConnectionSm *)(trans->_this))->connectProtocolRemote(_1, _2);
		return ret;
	}

	static int disconnectDeviceCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->disconnectDevice();
	}

	static int disconnectInIdleCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->disconnectInIdle();
	}

	static int disconnectProtocolCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		ProtocolId _1 = PROTOCOLID_INIT;
		UuidChrArr _2 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT  ,&_1 ,_2 );
		}
		ret = ((DeviceConnectionSm *)(trans->_this))->disconnectProtocol(_1, _2);
		return ret;
	}

	static int enterConnectedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterConnected();
	}

	static int enterConnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterConnecting();
	}

	static int enterDisconnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterDisconnecting();
	}

	static int enterDisconnectionFailedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterDisconnectionFailed();
	}

	static int enterIdleCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterIdle();
	}

	static int enterInUseCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterInUse();
	}

	static int enterLostCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->enterLost();
	}

	static int exitDisconnectionFailedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->exitDisconnectionFailed();
	}

	static int exitLostCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((DeviceConnectionSm *)(state->_this))->exitLost();
	}

	static int handleAllProtocolsDisconnectedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->handleAllProtocolsDisconnected();
	}

	static int handleDeviceDisconnectedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->handleDeviceDisconnected();
	}

	static int handleDisconnectCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->handleDisconnect();
	}

	static int handleDoneCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->handleDone();
	}

	static int handleLostDeviceCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->handleLostDevice();
	}

	static int handleProtocolConnectedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		ProtocolId _1 = PROTOCOLID_INIT;
		UuidChrArr _2 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT  ,&_1 ,_2 );
		}
		ret = ((DeviceConnectionSm *)(trans->_this))->handleProtocolConnected(_1, _2);
		return ret;
	}

	static int handleStopSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->handleStopSm();
	}

	static int initSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->initSm();
	}

	static int isDeviceLostCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->isDeviceLost();
	}

	static int messageNotConsumedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->messageNotConsumed();
	}

	static int reconnectDeviceCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->reconnectDevice();
	}

	static int rejectProtocolConnectionRemoteCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		ProtocolId _1 = PROTOCOLID_INIT;
		UuidChrArr _2 = UUIDCHRARR_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, PROTOCOLID_FORMAT UUIDCHRARR_FORMAT  ,&_1 ,&_2 );
		}
		ret = ((DeviceConnectionSm *)(trans->_this))->rejectProtocolConnectionRemote(_1, _2);
		return ret;
	}

	static int releaseDccCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->releaseDcc();
	}

	static int reserveDccCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->reserveDcc();
	}

	static int unreserveDccCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((DeviceConnectionSm *)(trans->_this))->unreserveDcc();
	}


public:

	/* used external events */
	SMF::tEvent *ACL_CONNECTION_FAILED;
	SMF::tEvent *ALL_PROTOCOLS_DISCONNECTED;
	SMF::tEvent *CONNECTED;
	SMF::tEvent *CONNECTION_RETRY;
	SMF::tEvent *CONNECT_LOCAL;
	SMF::tEvent *CONNECT_REMOTE;
	SMF::tEvent *CPW_ENDED;
	SMF::tEvent *CPW_STARTED;
	SMF::tEvent *DEFAULT;
	SMF::tEvent *DISCONNECT;
	SMF::tEvent *DISCONNECTED;
	SMF::tEvent *DISCONNECTION_FAILED;
	SMF::tEvent *DISCONNECTION_FINISHED;
	SMF::tEvent *DISCONNECTION_RETRY;
	SMF::tEvent *DISCONNECT_PROTOCOL;
	SMF::tEvent *DONE;
	SMF::tEvent *INIT;
	SMF::tEvent *STOP_SM;
	int dummy_do_not_use;


virtual void Create()
{
	if (_created) {
		/* SM was already created => return now */
		return;
	}

	_created = true;

	/* state machine definition */


	/* create new compound state */
	tState *topDeviceConnection_14b06799e8e80000000000000000867 = CreateCompoundState("topDeviceConnection", topDeviceConnection, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *InUse_14ba145d27d800000000000000009D0 = CreateCompoundState("InUse", InUse, enterInUseCall, "enterInUse", NULL, NULL);

	/* create final states */

	/* create states */
	tState *Lost_14b06799e8e8000000000000000086A = CreateState("Lost", Lost, enterLostCall, "enterLost", exitLostCall, "exitLost");
	tState *Connecting_14b06799e8e8000000000000000086F = CreateState("Connecting", Connecting, enterConnectingCall, "enterConnecting", NULL, NULL);
	tState *Connected_14b06799e8e80000000000000000870 = CreateState("Connected", Connected, enterConnectedCall, "enterConnected", NULL, NULL);

	/* create new compound state */
	tState *DeviceConnection_14cc707811c80000000000000000E7D = CreateCompoundState("DeviceConnection", DeviceConnection, NULL, NULL, NULL, NULL);

	/* create final states */
	tState *Final_14b25739b4e800000000000000009C3 = CreateFinalState("Final", Final, NULL, NULL);
	AddState(DeviceConnection_14cc707811c80000000000000000E7D, Final_14b25739b4e800000000000000009C3);
	tState *Fork_150f1897a8480000000000000000BC6 = CreateForkState("Fork");

	/* create states */
	tState *Stopped_14b25739b4e800000000000000009C2 = CreateState("Stopped", Stopped, NULL, NULL, NULL, NULL);
	tState *Idle_15084d6352080000000000000000BB4 = CreateState("Idle", Idle, enterIdleCall, "enterIdle", NULL, NULL);

	/* create new compound state */
	tState *Disconnecting_1525fcd50bc80000000000000000B06 = CreateCompoundState("Disconnecting", Disconnecting, enterDisconnectingCall, "enterDisconnecting", NULL, NULL);

	/* create states */
	tState *DisconnectionFailed_1535a67fb5e80000000000000000BBD = CreateState("DisconnectionFailed", DisconnectionFailed, enterDisconnectionFailedCall, "enterDisconnectionFailed", exitDisconnectionFailedCall, "exitDisconnectionFailed");

	/* create states */
	tTransition *Init_14b06799e8e8000000000000000086C = CreateTransition("Init", NULL, NULL, initSmCall, "initSm", Idle_15084d6352080000000000000000BB4);

	/* set the init transition */
	SetInitTransition(topDeviceConnection_14b06799e8e80000000000000000867, Init_14b06799e8e8000000000000000086C);

	/* Add in states */
	AddState(topDeviceConnection_14b06799e8e80000000000000000867, DeviceConnection_14cc707811c80000000000000000E7D);
	AddState(InUse_14ba145d27d800000000000000009D0, Disconnecting_1525fcd50bc80000000000000000B06);
	AddState(InUse_14ba145d27d800000000000000009D0, Lost_14b06799e8e8000000000000000086A);
	AddState(InUse_14ba145d27d800000000000000009D0, Connecting_14b06799e8e8000000000000000086F);
	AddState(InUse_14ba145d27d800000000000000009D0, Connected_14b06799e8e80000000000000000870);
	AddState(DeviceConnection_14cc707811c80000000000000000E7D, InUse_14ba145d27d800000000000000009D0);
	AddState(DeviceConnection_14cc707811c80000000000000000E7D, Fork_150f1897a8480000000000000000BC6);
	AddState(DeviceConnection_14cc707811c80000000000000000E7D, Stopped_14b25739b4e800000000000000009C2);
	AddState(DeviceConnection_14cc707811c80000000000000000E7D, Idle_15084d6352080000000000000000BB4);
	AddState(Disconnecting_1525fcd50bc80000000000000000B06, DisconnectionFailed_1535a67fb5e80000000000000000BBD);

	/* create events */
	ACL_CONNECTION_FAILED = CreateEvent("ACL_CONNECTION_FAILED");
	ALL_PROTOCOLS_DISCONNECTED = CreateEvent("ALL_PROTOCOLS_DISCONNECTED");
	CONNECTED = CreateEvent("CONNECTED");
	CONNECTION_RETRY = CreateEvent("CONNECTION_RETRY");
	CONNECT_LOCAL = CreateEvent("CONNECT_LOCAL");
	CONNECT_REMOTE = CreateEvent("CONNECT_REMOTE");
	CPW_ENDED = CreateEvent("CPW_ENDED");
	CPW_STARTED = CreateEvent("CPW_STARTED");
	DEFAULT = CreateEvent("DEFAULT");
	DISCONNECT = CreateEvent("DISCONNECT");
	DISCONNECTED = CreateEvent("DISCONNECTED");
	DISCONNECTION_FAILED = CreateEvent("DISCONNECTION_FAILED");
	DISCONNECTION_FINISHED = CreateEvent("DISCONNECTION_FINISHED");
	DISCONNECTION_RETRY = CreateEvent("DISCONNECTION_RETRY");
	DISCONNECT_PROTOCOL = CreateEvent("DISCONNECT_PROTOCOL");
	DONE = CreateEvent("DONE");
	INIT = CreateEvent("INIT");
	STOP_SM = CreateEvent("STOP_SM");

	/* create event transitions */

	/* create internal transactions */
/*2*/	tTransition *Connected2Connected_ConnectLocal_P14bda99333380000000000000000A06 = CreateEventTransition(CONNECT_LOCAL, "CONNECTED2CONNECTED_CONNECTLOCAL", NULL, NULL,  connectProtocolLocalCall,  "connectProtocolLocal", NULL);
/*2*/	tTransition *Connected2Connected_ConnectRemote_P14bda99333380000000000000000A0C = CreateEventTransition(CONNECT_REMOTE, "CONNECTED2CONNECTED_CONNECTREMOTE", NULL, NULL,  connectProtocolRemoteCall,  "connectProtocolRemote", NULL);
/*2*/	tTransition *Connected2Connected_DisconnectProtocol_P150d7ebcb2680000000000000000BC6 = CreateEventTransition(DISCONNECT_PROTOCOL, "CONNECTED2CONNECTED_DISCONNECTPROTOCOL", NULL, NULL,  disconnectProtocolCall,  "disconnectProtocol", NULL);
/*2*/	tTransition *Connected2Connected_HandleConnected_P150f6edae3880000000000000000A2C = CreateEventTransition(CONNECTED, "CONNECTED2CONNECTED_HANDLECONNECTED", NULL, NULL,  handleProtocolConnectedCall,  "handleProtocolConnected", NULL);
/*2*/	tTransition *Connecting2Connecting_ConnectLocal_P14bda99333380000000000000000A10 = CreateEventTransition(CONNECT_LOCAL, "CONNECTING2CONNECTING_CONNECTLOCAL", NULL, NULL,  connectProtocolLocalCall,  "connectProtocolLocal", NULL);
/*2*/	tTransition *Connecting2Connecting_ConnectRemote_P14bda99333380000000000000000A15 = CreateEventTransition(CONNECT_REMOTE, "CONNECTING2CONNECTING_CONNECTREMOTE", NULL, NULL,  connectProtocolRemoteCall,  "connectProtocolRemote", NULL);
/*2*/	tTransition *Connecting2Connecting_DisconnectProtocol_P150d7ebcb2680000000000000000BC2 = CreateEventTransition(DISCONNECT_PROTOCOL, "CONNECTING2CONNECTING_DISCONNECTPROTOCOL", NULL, NULL,  disconnectProtocolCall,  "disconnectProtocol", NULL);
/*2*/	tTransition *DeviceConnection2DeviceConnection_Default_P14cc707811c80000000000000000E7E = CreateEventTransition(DEFAULT, "DEVICECONNECTION2DEVICECONNECTION_DEFAULT", NULL, NULL,  messageNotConsumedCall,  "messageNotConsumed", NULL);
/*2*/	tTransition *Disconnecting2Disconnecting_AllProtocolsDisconnected_P1535b4eaad580000000000000000BC5 = CreateEventTransition(ALL_PROTOCOLS_DISCONNECTED, "DISCONNECTING2DISCONNECTING_ALLPROTOCOLSDISCONNECTED", NULL, NULL,  handleAllProtocolsDisconnectedCall,  "handleAllProtocolsDisconnected", NULL);
/*2*/	tTransition *Disconnecting2Disconnecting_Disconnected_P1535b4eaad580000000000000000BC8 = CreateEventTransition(DISCONNECTED, "DISCONNECTING2DISCONNECTING_DISCONNECTED", NULL, NULL,  handleDeviceDisconnectedCall,  "handleDeviceDisconnected", NULL);
/*2*/	tTransition *Disconnecting2Disconnecting_RejectProtocolConnectionRemote_P1529345a79980000000000000000CAC = CreateEventTransition(CONNECT_REMOTE, "DISCONNECTING2DISCONNECTING_REJECTPROTOCOLCONNECTIONREMOTE", NULL, NULL,  rejectProtocolConnectionRemoteCall,  "rejectProtocolConnectionRemote", NULL);
/*2*/	tTransition *Idle2Idle_CpwEnded_P15e28af237680000000000000000A25 = CreateEventTransition(CPW_ENDED, "IDLE2IDLE_CPWENDED", NULL, NULL,  releaseDccCall,  "releaseDcc", NULL);
/*2*/	tTransition *Idle2Idle_disconnectInIdle_P15e5ffc34d680000000000000000A2D = CreateEventTransition(DISCONNECT, "IDLE2IDLE_DISCONNECTINIDLE", NULL, NULL,  disconnectInIdleCall,  "disconnectInIdle", NULL);
/*2*/	tTransition *InUse2InUse_CpwEnded_P15e9a8ad6cf80000000000000000A30 = CreateEventTransition(CPW_ENDED, "INUSE2INUSE_CPWENDED", NULL, NULL,  unreserveDccCall,  "unreserveDcc", NULL);
/*2*/	tTransition *InUse2InUse_CpwStarted_P15e28af237680000000000000000A29 = CreateEventTransition(CPW_STARTED, "INUSE2INUSE_CPWSTARTED", NULL, NULL,  reserveDccCall,  "reserveDcc", NULL);

	/* create event transitions */
	tTransition *Idle2Fork_AllProtocolsDisconnected_150f1897a8480000000000000000BC8_B = CreateTransition("Idle2Fork_AllProtocolsDisconnected_B", NULL, NULL, NULL, NULL, Idle_15084d6352080000000000000000BB4);
/*6*/	tTransition *Idle2Fork_AllProtocolsDisconnected_150f1897a8480000000000000000BC8_A = CreateEventTransition(ALL_PROTOCOLS_DISCONNECTED, "Idle2Fork_AllProtocolsDisconnected_A", NULL, NULL, NULL, NULL, Fork_150f1897a8480000000000000000BC6);
/*7*/	tTransition *Connected2Disconnecting_Disconnect_14b06799e8e80000000000000000899 = CreateEventTransition(DISCONNECT, "Connected2Disconnecting_Disconnect", NULL, NULL, handleDisconnectCall, "handleDisconnect", Disconnecting_1525fcd50bc80000000000000000B06);
/*7*/	tTransition *Connecting2Connected_HandleConnected_14b06799e8e80000000000000000889 = CreateEventTransition(CONNECTED, "Connecting2Connected_HandleConnected", NULL, NULL, handleProtocolConnectedCall, "handleProtocolConnected", Connected_14b06799e8e80000000000000000870);
/*7*/	tTransition *Connecting2Disconnecting_14b06799e8e80000000000000000898 = CreateEventTransition(DISCONNECT, "Connecting2Disconnecting", NULL, NULL, handleDisconnectCall, "handleDisconnect", Disconnecting_1525fcd50bc80000000000000000B06);
/*7*/	tTransition *DeviceConnection2Final_Done_14cc707811c80000000000000000E83 = CreateEventTransition(DONE, "DeviceConnection2Final_Done", NULL, NULL, handleDoneCall, "handleDone", Final_14b25739b4e800000000000000009C3);
/*7*/	tTransition *DeviceConnection2Stopped_StopSm_14cc707811c80000000000000000E82 = CreateEventTransition(STOP_SM, "DeviceConnection2Stopped_StopSm", NULL, NULL, handleStopSmCall, "handleStopSm", Stopped_14b25739b4e800000000000000009C2);
/*7*/	tTransition *Disconnecting2Connecting_14b06799e8e80000000000000000897 = CreateEventTransition(CONNECT_LOCAL, "Disconnecting2Connecting", NULL, NULL, connectProtocolLocalCall, "connectProtocolLocal", Connecting_14b06799e8e8000000000000000086F);
/*7*/	tTransition *Disconnecting2DisconnectionFailed_DisconnectionFailed_1535a67fb5e80000000000000000BC2 = CreateEventTransition(DISCONNECTION_FAILED, "Disconnecting2DisconnectionFailed_DisconnectionFailed", NULL, NULL, NULL, NULL, DisconnectionFailed_1535a67fb5e80000000000000000BBD);
/*7*/	tTransition *DisconnectionFailed2Disconnecting_DisconnectionRetry_1535a67fb5e80000000000000000BC3 = CreateEventTransition(DISCONNECTION_RETRY, "DisconnectionFailed2Disconnecting_DisconnectionRetry", NULL, NULL, disconnectDeviceCall, "disconnectDevice", Disconnecting_1525fcd50bc80000000000000000B06);
/*7*/	tTransition *Idle2Connecting_ConnectLocal_14ff56f94d880000000000000000BB1 = CreateEventTransition(CONNECT_LOCAL, "Idle2Connecting_ConnectLocal", NULL, NULL, connectProtocolLocalCall, "connectProtocolLocal", Connecting_14b06799e8e8000000000000000086F);
/*7*/	tTransition *Idle2Connecting_ConnectRemote_14ff56f94d880000000000000000BB8 = CreateEventTransition(CONNECT_REMOTE, "Idle2Connecting_ConnectRemote", NULL, NULL, connectProtocolRemoteCall, "connectProtocolRemote", Connecting_14b06799e8e8000000000000000086F);
/*7*/	tTransition *Lost2Connecting_ConnectionRetry_14b06799e8e8000000000000000087F = CreateEventTransition(CONNECTION_RETRY, "Lost2Connecting_ConnectionRetry", NULL, NULL, reconnectDeviceCall, "reconnectDevice", Connecting_14b06799e8e8000000000000000086F);
/*7*/	tTransition *Lost2Idle_Disconnect_14fdf6221b280000000000000000BCD = CreateEventTransition(DISCONNECT, "Lost2Idle_Disconnect", NULL, NULL, handleDisconnectCall, "handleDisconnect", Idle_15084d6352080000000000000000BB4);
/*7*/	tTransition *WaitingForDisconnected2Idle_DisconnectionFinished_1525fcd50bc80000000000000000B0F = CreateEventTransition(DISCONNECTION_FINISHED, "WaitingForDisconnected2Idle_DisconnectionFinished", NULL, NULL, NULL, NULL, Idle_15084d6352080000000000000000BB4);
/*9*/	tTransition *Connected2CondLostA_AllProtocolsDisconnected_14b06799e8e8000000000000000089D = CreateEventConditionalTransition(ALL_PROTOCOLS_DISCONNECTED, "Connected2CondLostA_AllProtocolsDisconnected", InUse_14ba145d27d800000000000000009D0, NULL, NULL, isDeviceLostCall, "isDeviceLost", handleLostDeviceCall, "handleLostDeviceTrue", NULL, NULL, "trueCondLostA2Lost_True", Connecting_14b06799e8e8000000000000000086F, "falseCondLostA2WaitingForDisconnected_False", Disconnecting_1525fcd50bc80000000000000000B06);
/*9*/	tTransition *Connecting2CondLostB_AllProtocolsDisconnected_14b06799e8e8000000000000000087B = CreateEventConditionalTransition(ALL_PROTOCOLS_DISCONNECTED, "Connecting2CondLostB_AllProtocolsDisconnected", InUse_14ba145d27d800000000000000009D0, NULL, NULL, isDeviceLostCall, "isDeviceLost", NULL, NULL, NULL, NULL, "trueCondLostB2Lost_True", Lost_14b06799e8e8000000000000000086A, "falseCondLostB2Idle_False", Idle_15084d6352080000000000000000BB4);

	/* add transitions to states */
	AddTransition(Connecting_14b06799e8e8000000000000000086F, Connecting2CondLostB_AllProtocolsDisconnected_14b06799e8e8000000000000000087B);
	AddTransition(Lost_14b06799e8e8000000000000000086A, Lost2Connecting_ConnectionRetry_14b06799e8e8000000000000000087F);
	AddTransition(Connecting_14b06799e8e8000000000000000086F, Connecting2Connected_HandleConnected_14b06799e8e80000000000000000889);
	AddTransition(Disconnecting_1525fcd50bc80000000000000000B06, Disconnecting2Connecting_14b06799e8e80000000000000000897);
	AddTransition(Connecting_14b06799e8e8000000000000000086F, Connecting2Disconnecting_14b06799e8e80000000000000000898);
	AddTransition(Connected_14b06799e8e80000000000000000870, Connected2Disconnecting_Disconnect_14b06799e8e80000000000000000899);
	AddTransition(Connected_14b06799e8e80000000000000000870, Connected2CondLostA_AllProtocolsDisconnected_14b06799e8e8000000000000000089D);
	AddTransition(DeviceConnection_14cc707811c80000000000000000E7D, DeviceConnection2Stopped_StopSm_14cc707811c80000000000000000E82);
	AddTransition(DeviceConnection_14cc707811c80000000000000000E7D, DeviceConnection2Final_Done_14cc707811c80000000000000000E83);
	AddTransition(Lost_14b06799e8e8000000000000000086A, Lost2Idle_Disconnect_14fdf6221b280000000000000000BCD);
	AddTransition(Idle_15084d6352080000000000000000BB4, Idle2Connecting_ConnectLocal_14ff56f94d880000000000000000BB1);
	AddTransition(Idle_15084d6352080000000000000000BB4, Idle2Connecting_ConnectRemote_14ff56f94d880000000000000000BB8);
	AddTransition(Idle_15084d6352080000000000000000BB4, Idle2Fork_AllProtocolsDisconnected_150f1897a8480000000000000000BC8_A);
	AddTransition(Fork_150f1897a8480000000000000000BC6, Idle2Fork_AllProtocolsDisconnected_150f1897a8480000000000000000BC8_B);
	AddTransition(Disconnecting_1525fcd50bc80000000000000000B06, WaitingForDisconnected2Idle_DisconnectionFinished_1525fcd50bc80000000000000000B0F);
	AddTransition(Disconnecting_1525fcd50bc80000000000000000B06, Disconnecting2DisconnectionFailed_DisconnectionFailed_1535a67fb5e80000000000000000BC2);
	AddTransition(DisconnectionFailed_1535a67fb5e80000000000000000BBD, DisconnectionFailed2Disconnecting_DisconnectionRetry_1535a67fb5e80000000000000000BC3);
	AddTransition(Connected_14b06799e8e80000000000000000870, Connected2Connected_ConnectLocal_P14bda99333380000000000000000A06);
	AddTransition(Connected_14b06799e8e80000000000000000870, Connected2Connected_ConnectRemote_P14bda99333380000000000000000A0C);
	AddTransition(Connecting_14b06799e8e8000000000000000086F, Connecting2Connecting_ConnectLocal_P14bda99333380000000000000000A10);
	AddTransition(Connecting_14b06799e8e8000000000000000086F, Connecting2Connecting_ConnectRemote_P14bda99333380000000000000000A15);
	AddTransition(DeviceConnection_14cc707811c80000000000000000E7D, DeviceConnection2DeviceConnection_Default_P14cc707811c80000000000000000E7E);
	AddTransition(Connecting_14b06799e8e8000000000000000086F, Connecting2Connecting_DisconnectProtocol_P150d7ebcb2680000000000000000BC2);
	AddTransition(Connected_14b06799e8e80000000000000000870, Connected2Connected_DisconnectProtocol_P150d7ebcb2680000000000000000BC6);
	AddTransition(Connected_14b06799e8e80000000000000000870, Connected2Connected_HandleConnected_P150f6edae3880000000000000000A2C);
	AddTransition(Disconnecting_1525fcd50bc80000000000000000B06, Disconnecting2Disconnecting_RejectProtocolConnectionRemote_P1529345a79980000000000000000CAC);
	AddTransition(Disconnecting_1525fcd50bc80000000000000000B06, Disconnecting2Disconnecting_AllProtocolsDisconnected_P1535b4eaad580000000000000000BC5);
	AddTransition(Disconnecting_1525fcd50bc80000000000000000B06, Disconnecting2Disconnecting_Disconnected_P1535b4eaad580000000000000000BC8);
	AddTransition(Idle_15084d6352080000000000000000BB4, Idle2Idle_CpwEnded_P15e28af237680000000000000000A25);
	AddTransition(InUse_14ba145d27d800000000000000009D0, InUse2InUse_CpwStarted_P15e28af237680000000000000000A29);
	AddTransition(Idle_15084d6352080000000000000000BB4, Idle2Idle_disconnectInIdle_P15e5ffc34d680000000000000000A2D);
	AddTransition(InUse_14ba145d27d800000000000000009D0, InUse2InUse_CpwEnded_P15e9a8ad6cf80000000000000000A30);

	/* set start (compound) state for state machine */
	SetConcurrent(topDeviceConnection_14b06799e8e80000000000000000867);
	return SetRoot(topDeviceConnection_14b06799e8e80000000000000000867);
}
};
} // namespace bmcore
// end of generated code

#endif
