/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     TtfisLoggingBackend.h
 *\brief
 *
 *\author   CM-AI/ESA2
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2015 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_TtfisLoggingBackend_H
#define ASF_CORE_TtfisLoggingBackend_H


#include "asf/core/LoggerAccessorIF.h"
#include "asf/core/LoggingBackendExtern.h"
#include "asf/core/LoggingBackendIF.h"
#include "asf/core/LoggingConst.h"
#include <pthread.h>


/**
  * The TTFis logging backend forwards ASF logs to TTFis
  * with corresponding log levels.
  * The backend will be loaded at runtime by name.
  * The name is given in the configuration file.
  *
  * The attribute "traceClass" defines the TTFis trace class.
  * It can be provided as decimal or hexadecimal number.
  *
  * The attribute "detailedHeader" activates/deactivates
  * additional context information in the log.
  *
  * Example backend configuration:
  * {
  *     "loggerLevel" : {
  *         "*" : "Info"
  *     },
  *
  *     "backend" : "libttfis_logging_backend_so",
  *
  *     "backendConfiguration" : {
  *         "traceClass" : "0x97c0",
  *         "detailedHeader" : "true"
  *     }
  * }
  */
class TtfisLoggingBackend : public ::asf::core::LoggingBackendIF
{
   public:
      TtfisLoggingBackend();
      virtual ~TtfisLoggingBackend();
      virtual bool init(struct InitParameters& parameters);
      virtual ::std::string getBackendDescription ();
      virtual ::std::string getBackendName ();
      virtual void logFormat (const struct LoggingHeader& header, const char* format, va_list argptr);
      virtual void logBuffer (const struct LoggingHeader& header, const uint8* buffer, size_t length);

   private:
      std::string formatDetailedHeader(const struct LoggingHeader& header) const;
      bool getBoolValue(
            const std::map< std::string, std::string >& backendConfiguration,
            const std::string& key,
            bool defaultValue = false) const;
      long int getInteger(
            const std::map<std::string, std::string>& backendConfiguration,
            const std::string& key,
            long int defaultValue = 0) const;
      const char* getLevelName(::asf::core::Logging::Level value) const;

      bool _detailedHeader;
      unsigned short _traceClass;
      pthread_mutexattr_t _attr;
      pthread_mutex_t _mutex;
};


#endif
