/*****************************************************************************
| FILE:         ProcStartup
| PROJECT:      VW / NISSAN
| SW-COMPONENT: Process
|-----------------------------------------------------------------------------
| DESCRIPTION:  Generic Startup functions for ProcessStartup
|
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2011 Bosch Car Multimedia GmbH
| HISTORY:
| Date      | Modification               | Author
| 28.09.11  | Initial revision           | Kollai
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************
|defines and macros (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define TR_CLASS_PROC_STARTUP          0x8200

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROC_STARTUP
#include "trcGenProj/Header/ProcTable.cpp.trc.h"
#endif

/************************************************************************
*defines and macros
************************************************************************/

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_EL_GATEWAY
#define ELGAW_S_IMPORT_INTERFACE_GENERIC
#include "el_gateway_if.h"
// gaw_tclApp has no theServer() function ...
ail_tclAppAdapt* createGateway() {
   return OSAL_NEW gaw_tclApp();
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_IPODAUTH
#define VD_IPODAUTH_S_IMPORT_INTERFACE_GENERIC
#include "VD_IPodAuth_if.h"
// ipodauth_tclMainApp has no theServer() function ...
ail_tclAppAdapt* createIpod() {
   return OSAL_NEW ipodauth_tclMainApp();
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_SENSOR
#define VDS_HW_IMX

#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_TYPES
#include "cmb_fi_if.h"

    #define VARIANT_S_FTR_ENABLE_HUL6
    #define SENSOR_S_IMPORT_INTERFACE_SENSOR_MESSAGE
    #include "vdsensor_if.h"

    #define VDS_NO_DIAG
    #define VDS_HOST_BASED
    #define SENSOR_S_IMPORT_INTERFACE_AIL
    #include "vdsensor_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_DIAG
#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#include "fc_diagnosis_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOMANAGER
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_GENERIC
#include "fc_audiomanager_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIO
#define FC_AUDIO_S_IMPORT_INTERFACE_GENERIC
#include "fc_audio_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOPLAYER
#define FC_AUDIOPLAYER_S_IMPORT_INTERFACE_GENERIC
#include "fc_audioplayer_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TMCTUNER
#define FC_TMCTUNER_S_IMPORT_INTERFACE_GENERIC
#include "fc_tmctuner_if.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_BLUETOOTH
#define FC_BLUETOOTH_S_IMPORT_INTERFACE_GENERIC
#include "FC_Bluetooth_if.h"
#endif

//Messaging build for G3G
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_MESSAGING
#define FC_MESSAGING_S_IMPORT_INTERFACE_GENERIC
#include "FC_Messaging_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TUNERMASTER
#define FC_TUNERMASTER_S_IMPORT_INTERFACE_GENERIC
#include "fc_tunermaster_if.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_TPEG
#define FC_TPEG_S_IMPORT_INTERFACE_GENERIC
#include "fc_tpeg_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VOICE
#define FCVD_VOICE_S_IMPORT_INTERFACE_MSGS
#define FCVD_VOICE_S_IMPORT_INTERFACE_CORE
#include "fcvd_voice_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_KBD
#define VDKBD_S_IMPORT_INTERFACE_GENERIC
#include "vdkbd_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_MMGR
#define VDMMGR_S_IMPORT_INTERFACE_GENERIC
#include "vdmmgr_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_HMIAPP
#define CCA_MAIN_CALLBACK_INTERFACE
#include "hmicca_pif.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_REMOTEDISPLAY
#define FC_REMOTEDISPLAY_VAG_S_IMPORT_INTERFACE_GENERIC
#include "fc_remotedisplay_vag_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CDC
#define FC_CDC_VAG_S_IMPORT_INTERFACE_GENERIC
#include "fc_cdc_vag_if.h"
#endif

/*
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_PHONE
#define FC_PHONE_UGZZC_S_IMPORT_INTERFACE_GENERIC
#include "fc_phone_ugzzc_if.h" 
#endif
*/

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_PHONE
#define FC_PHONE_S_IMPORT_INTERFACE_GENERIC
#include "FC_Phone_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_PHONEBOOK
#define FC_PHONEBOOK_S_IMPORT_INTERFACE_GENERIC
#include "FC_PhoneBook_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_METER
#define FC_METER_S_IMPORT_INTERFACE_GENERIC
#include "fc_meter_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_ADAS
#define VD_ADAS_S_IMPORT_INTERFACE_GENERIC
#include "vd_adas_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_ANIMATION
#define FC_ANIMATION_S_IMPORT_INTERFACE_GENERIC
#include "fc_animation_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VDDIAGLOG
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_GENERIC
#include "vd_diaglog_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_DIMMING
#define VD_DIMMING_S_IMPORT_INTERFACE_GENERIC
#include "vd_dimming_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_INPUT
#define VD_INPUT_S_IMPORT_INTERFACE_GENERIC
#include "vd_input_if.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_UAM
#define FC_UAM_S_IMPORT_INTERFACE_GENERIC
#include "fc_uam_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_HEATCTRL
#define FC_HEATCTRL_S_IMPORT_INTERFACE_GENERIC
#include "fc_HeatCtrl_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CLIMATE
#define FC_CLIMATE_S_IMPORT_INTERFACE_GENERIC
#include "fc_climatectrl_vag_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CLOCK
#define FC_CLOCK_S_IMPORT_INTERFACE_GENERIC
#include "vd_clock_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VEHICLE_DATA
#define VD_VEHICLEDATA_S_IMPORT_INTERFACE_GENERIC
#include "vd_vehicledata_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_DABTUNER
#define FC_DABTUNER_S_IMPORT_INTERFACE_GENERIC
#include "fc_dabtuner_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_OPS
#define FC_OPS_S_IMPORT_INTERFACE_GENERIC
#include "fc_ops_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_PDC
#define FC_PDC_S_IMPORT_INTERFACE_GENERIC
#include "fc_pdc_vag_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_RVC
#define VD_RVC_S_IMPORT_INTERFACE_GENERIC
#include "vd_rvc_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_COMPRESSEDAUDIO
#define FC_COMPRESSEDAUDIO_S_IMPORT_INTERFACE_GENERIC
#include "fc_compressedaudio_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_UPS
#define FC_UPS_S_IMPORT_INTERFACE_GENERIC
#include "fc_ups_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_XMTUNER
#define FC_XMTUNER_S_IMPORT_INTERFACE_GENERIC
#include "fc_xmtuner_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_SXM
#define FC_SXM_S_IMPORT_INTERFACE_GENERIC
#include "fc_sxm_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_IPOD
#define IPOD_S_IMPORT_INTERFACE_GENERIC
#include "fc_ipod_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CCADEMO
#define CCADEMO_S_IMPORT_INTERFACE_GENERIC
#include "fc_demo_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_SDSAPPS
#include "sds_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TELEMATIC
#define FC_TELEMATIC_S_IMPORT_INTERFACE_GENERIC
#include "fc_telematic_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TMC_IP
#include "fc_tmc_ip_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOROUTEMGR
#define FC_AUDIOROUTEMGR_S_IMPORT_INTERFACE_GENERIC
#include "fc_audioroutemgr_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_STREAMROUTER
#define FC_STREAMROUTER_S_IMPORT_INTERFACE_GENERIC
#include "FC_StreamRouter_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_DEVICEMANAGER
#define VD_DEVICEMANAGER_S_IMPORT_INTERFACE_GENERIC
#define VARIANT_S_FTR_ENABLE_DEVMGR_RUN_IN_PROCMWLX
#include "vd_devicemanager_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_SMARTPHONEINTEGRATION
#define FC_SMARTPHONEINTEGRATION_S_IMPORT_INTERFACE_GENERIC
#include "fc_smartphoneintegration_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_DOWNLOAD
#define FC_DOWNLOAD_S_IMPORT_INTERFACE_GENERIC
#include "FC_Download_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOCUES
#define FC_AUDIOCUES_S_IMPORT_INTERFACE_GENERIC
#include "FC_AudioCues_if.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FCBAP
#define FCBAP_S_IMPORT_INTERFACE_GENERIC
#include "FcBap_if.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_BAPCLIENT
#define BAPCLIENT_S_IMPORT_INTERFACE_GENERIC
#include "BapClient_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_APPMGR
#define APPLICATIONMGR_S_IMPORT_INTERFACE_GENERIC
#include "ApplicationMgr_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_MCAN_TCU
#define FC_MCAN_TCU_S_IMPORT_INTERFACE_GENERIC
#include "fc_mcan_tcu_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_USB_TCU
#define FC_USB_TCU_S_IMPORT_INTERFACE_GENERIC
#include "fc_usb_tcu_if.h"
#endif



   /************************************************************************
   |typedefs (scope: module-local)
   |-----------------------------------------------------------------------*/
   /**
   * this array defines all components to be startet by the platform
   * 1st column startup function block
   * 2nd column APPID from x:\di_frameworks\components\cca\ccaservice.h
   * 3rd column Name of ail_application for tracing
   * 4th column void function returning the instance for this component
   * 5th column pointer to the instance for calling bInitInstance() and vDeinitInstance()
   */
   typedef struct tstComponent_tag {
      tU16 AppId;                      // application id of the given component
      tCString szComponentName;        // name of the component for trace
      ail_tclAppAdapt* (*theServer)(tVoid);      // creation function for the given component
      ail_tclAppAdapt* pInstance;  // instance pointer used for destruction
   } tstBootComponent;

   /************************************************************************
   | variable definition (scope: module-local)
   |-----------------------------------------------------------------------*/
   tstBootComponent _garBaseApps[] = {
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_EL_GATEWAY
      {CCA_C_U16_APP_GATEWAY,      "Gateway",          (ail_tclAppAdapt*(*)(tVoid))createGateway, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_IPODAUTH
      {CCA_C_U16_APP_IPODAUTH,     "VdIpodAuth",       (ail_tclAppAdapt*(*)(tVoid))createIpod, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_SENSOR
      {CCA_C_U16_APP_SENSOR,       "VdSensor",         (ail_tclAppAdapt*(*)(tVoid))vds_poCreateApplication, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_DIAG
      {CCA_C_U16_APP_DIAGDEBUG,    "FcDiagnosis",      (ail_tclAppAdapt*(*)(tVoid))diagnostics_tclApp::theServer, 0},
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VDDIAGLOG
      {CCA_C_U16_APP_DIAGLOG,      "VdDiagLog",        vdDiagLog_tclAppProxy::theServer, 0},
    //  {CCA_C_U16_APP_DIAGLOG,      "VdDiagLog",        (ail_tclAppAdapt*(*)(tVoid))vdDiagLog_tclAppProxy::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOPLAYER
      {CCA_C_U16_APP_CDVD,         "FcAudioPlayer",    (ail_tclAppAdapt*(*)(tVoid))audioplayer_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOMANAGER
      {CCA_C_U16_APP_AUDIO,  "FcAudiomanager",    (ail_tclAppAdapt*(*)(tVoid))fc_audiomanager_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TMCTUNER
      {CCA_C_U16_APP_TUNER,        "FcTmcTuner",       (ail_tclAppAdapt*(*)(tVoid))tuner_tclApp::theServer, 0},
#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TUNERMASTER
      {CCA_C_U16_APP_TUNERMASTER,  "FcTunerMaster",    (ail_tclAppAdapt*(*)(tVoid))tunmaster_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_TPEG
      { CCA_C_U16_APP_FC_TPEG,         "FcTpeg",       (ail_tclAppAdapt*(*)(tVoid))fc_tpeg_tclMain::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VOICE
      {CCA_C_U16_APP_VOICE,        "FcVdVoice",        (ail_tclAppAdapt*(*)(tVoid))tclVoice::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_KBD
      { CCA_C_U16_APP_KBD,          "VdKbd",            (ail_tclAppAdapt*(*)(tVoid))vdkbd_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_MMGR
      { CCA_C_U16_APP_MMGR,         "VdMmgr",           (ail_tclAppAdapt*(*)(tVoid))vdmmgr_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_HMIAPP
      { CCA_C_U16_APP_UI,           "HmiApp",           (ail_tclAppAdapt*(*)(tVoid))hmicca_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_REMOTEDISPLAY
      { CCA_C_U16_APP_FC_REMOTE_DISPLAY,"FcRpd",        (ail_tclAppAdapt*(*)(tVoid))fc_rpd_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CDC
      { CCA_C_U16_APP_CDCVD,        "FcCdcApp",         (ail_tclAppAdapt*(*)(tVoid))fc_CDC_MainApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_INPUT
      { CCA_C_U16_APP_VD_INPUT,          "vd_input",            (ail_tclAppAdapt*(*)(tVoid))vd_input_tclMain::theServer, 0},
#endif
/*
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_PHONE
      { CCA_C_U16_APP_TELEFON,      "FcPhone",          (ail_tclAppAdapt*(*)(tVoid))fc_phone_ugzzc_tclApp::theServer, 0},
#endif
*/
#ifdef CONNECTIVITY_PROCESS_STARTUP_GEN3	  

	#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_BLUETOOTH
					{CCA_C_U16_APP_BLUETOOTH,   "FcBluetooth",             (ail_tclAppAdapt*(*)(tVoid))fc_bluetooth_tclApp::theServer, 0},
	#endif
	
	//Messaging build for G3G
	#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_MESSAGING
		  { CCA_C_U16_APP_MESSAGING,      "FcMessaging",          (ail_tclAppAdapt*(*)(tVoid))fc_messaging_tclApp::theServer, 0},
	#endif
	
	#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_PHONE
		  { CCA_C_U16_APP_TELEFON,      "FcPhone",          (ail_tclAppAdapt*(*)(tVoid))fc_phone_tclApp::theServer, 0},
	#endif

	#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_PHONEBOOK
		  { CCA_C_U16_APP_PHONEBOOK, "FcPhonebook", (ail_tclAppAdapt*(*)(tVoid))fc_phonebook_tclApp::theServer, 0},
	#endif
#endif //CONNECTIVITY_PROCESS_STARTUP_GEN3

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_MCAN_TCU
      { CCA_C_U16_APP_FC_MCAN_TCU ,"FcMcanTcu",          (ail_tclAppAdapt*(*)(tVoid))fc_mcan_tcu_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_METER
      { CCA_C_U16_APP_FC_MCAN_METER,"FcMeter",          (ail_tclAppAdapt*(*)(tVoid))met_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_ADAS
      { CCA_C_U16_APP_VD_ADASIS,    "VdAdas",           (ail_tclAppAdapt*(*)(tVoid))vd_adas_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_DIMMING
      { CCA_C_U16_APP_VD_DIMMING,   "VdDimming",        (ail_tclAppAdapt*(*)(tVoid))vd_dimming_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_UAM
      { CCA_C_U16_APP_FC_UAM,       "FcUam",            (ail_tclAppAdapt*(*)(tVoid))fc_uam_tclMainApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_HEATCTRL
      { CCA_C_U16_APP_FC_HEATCTRL,  "FcHeatCtrl",       (ail_tclAppAdapt*(*)(tVoid))fc_heatctrl_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CLIMATE
      { CCA_C_U16_APP_FC_CLIMATE,   "FcClimate",        (ail_tclAppAdapt*(*)(tVoid))fc_climate_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_CLOCK
      { CCA_C_U16_APP_VD_CLOCK,     "VdClock",          (ail_tclAppAdapt*(*)(tVoid))vdclk_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VEHICLE_DATA
      { CCA_C_U16_APP_VD_VEHICLE_DATA, "VdVehicleData", (ail_tclAppAdapt*(*)(tVoid))vd_vehicledata_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_DABTUNER
      { CCA_C_U16_APP_FC_DABTUNER,  "FcDabTuner",       (ail_tclAppAdapt*(*)(tVoid))fc_dabtuner_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_XMTUNER
      { CCA_C_U16_APP_FC_XM_TUNER,  "FcXmTuner",        (ail_tclAppAdapt*(*)(tVoid))xmtun_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_SXM
      { CCA_C_U16_APP_FC_SXM,  "FcSxm",        (ail_tclAppAdapt*(*)(tVoid))fc_sxm_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_IPOD
      { CCA_C_U16_APP_FC_IPOD,       "FciPod",          (ail_tclAppAdapt*(*)(tVoid))ipod_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_OPS
      { CCA_C_U16_APP_FC_OPS,       "FcOps",            (ail_tclAppAdapt*(*)(tVoid))OPSServer_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_PDC
      { CCA_C_U16_APP_FC_PDC,       "FcPdc",            (ail_tclAppAdapt*(*)(tVoid))fc_pdc_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_RVC
      { CCA_C_U16_APP_VD_RVC,       "FcRvc",            (ail_tclAppAdapt*(*)(tVoid))vd_rvc_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_ANIMATION
      { CCA_C_U16_APP_ANIMATION,       "FcAnimation",            (ail_tclAppAdapt*(*)(tVoid))fc_animation_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_COMPRESSEDAUDIO
      { CCA_C_U16_APP_MP3,          "FcCpra",           (ail_tclAppAdapt*(*)(tVoid))compressedaudio_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_UPS
      { CCA_C_U16_APP_FC_UPS,        "FcUps",           (ail_tclAppAdapt*(*)(tVoid))fc_ups::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_TELEMATIC
      { CCA_C_U16_APP_FC_TELEMATIC,        "FcTelematic",           (ail_tclAppAdapt*(*)(tVoid))fc_Telematic_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOROUTEMGR
      { CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR,    "FcAudioRouteMgr",        (ail_tclAppAdapt*(*)(tVoid))fc_audioroutemgr_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_STREAMROUTER
      { CCA_C_U16_APP_STREAMROUTER,    "FcStreamrouter",        (ail_tclAppAdapt*(*)(tVoid))fc_streamrouter_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_VD_DEVICEMANAGER
      { CCA_C_U16_APP_DEVICEMANAGER, "VdDeviceManager", (ail_tclAppAdapt*(*)(tVoid))vd_devicemanager_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_SMARTPHONEINTEGRATION
      { CCA_C_U16_APP_SMARTPHONEINTEGRATION,        "FcSmartphoneintegration",           (ail_tclAppAdapt*(*)(tVoid))fc_smartphoneintegration_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_DOWNLOAD
      { CCA_C_U16_APP_DOWNLOAD,      "FcDownload",      (ail_tclAppAdapt*(*)(tVoid))fc_download_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_AUDIOCUES
      { CCA_C_U16_APP_AUDIOCUES,      "FcAudioCues",      (ail_tclAppAdapt*(*)(tVoid))fc_audiocues_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FCBAP
      { CCA_C_U16_APP_FC_CANCOMM,        "FcBap",           (ail_tclAppAdapt*(*)(tVoid))FcBap_tclMain::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_BAPCLIENT
      { CCA_C_U16_APP_FCM_CARCUSTOMIZATION,        "BapClient",           (ail_tclAppAdapt*(*)(tVoid))BapClient_tclMain::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_APPMGR
      { CCA_C_U16_APP_UI,           "AppMgr",     (ail_tclAppAdapt*(*)(tVoid))ApplicationMgr_tclApp::theServer, 0},
#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_ENABLE_FC_USB_TCU
      { CCA_C_U16_APP_FC_USB_TCU,      "fc_usb_tcu",      (ail_tclAppAdapt*(*)(tVoid))fc_usb_tcu_tclApp::theServer, 0},
#endif
      {0,      "nop",          NULL, 0}
   };

tVoid vStartCCAApplications(tVoid)
{
    tstBootComponent* pThisComp=0;
    // start the system
    for(pThisComp=_garBaseApps; pThisComp && pThisComp->theServer; pThisComp++)
    {
        tU32 u32Time = OSAL_ClockGetElapsedTime();
        ETG_TRACE_USR1(("vStartCCAApplications(): AppID: %d: construct now: %d (Application '%s').", pThisComp->AppId, u32Time, pThisComp->szComponentName ));
        ail_tclAppAdapt* poThisApp = pThisComp->theServer();
        ETG_TRACE_USR1(("vStartCCAApplications(): AppID: %d: constructed -> duration '%d ms' (Application '%s').", pThisComp->AppId, OSAL_ClockGetElapsedTime()-u32Time, pThisComp->szComponentName));

        if(poThisApp) {
            pThisComp->pInstance = poThisApp; // save it in table
            if ( poThisApp->bInitInstance(0, pThisComp->AppId) == FALSE )
            {
                  ETG_TRACE_FATAL(("!!! vStartCCAApplications(): AppID: %d: bInitInstance FAILED", pThisComp->AppId ));
            }
        }
        ETG_TRACE_USR1(("vStartCCAApplications(): AppID: %d: started now: %d (Application '%s').", pThisComp->AppId, OSAL_ClockGetElapsedTime(), pThisComp->szComponentName));
    } // for()
}

   tVoid vStopCCAApplications(tVoid)
   {
      tstBootComponent* pThisComp=0;
      // start the system
      for(pThisComp=_garBaseApps; pThisComp && pThisComp->theServer; pThisComp++){
         if (pThisComp->pInstance == 0) {
            continue; // seems the comp is already deinitialized
         }
         pThisComp->pInstance->vDeinitInstance();
         pThisComp->pInstance =0;
      } // for()
   }

/************************************************************************
|end of file ProcBase.cpp
|-----------------------------------------------------------------------*/
