/*
    C socket server example, handles multiple clients using threads
*/
 
#include<stdio.h>
#include<string.h>    //strlen
#include<stdlib.h>    //strlen
#include<sys/socket.h>
#include<arpa/inet.h> //inet_addr
#include<unistd.h>    //write
#include<pthread.h>   //for threading , link with lpthread
#include<errno.h>

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"
#include "dp_generic_if.h"

//#include <map>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#include <map>


#define TR_CLASS_PROC_STARTUP_DYN          0x8201

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROC_STARTUP_DYN
#include "trcGenProj/Header/procip.cpp.trc.h"
#endif

extern "C" void _exit(int status);


typedef struct {
    tU16  u16AppId;
    tBool bTerminate;
} TSockInfo;

std::map<int, TSockInfo> tSocketInfo;


//the thread function
void *connection_handler(void *);
void *vSocketSrvThread(void *pPort);
tVoid vTraceOutRegistry(const tChar *szBaseName, int sock);
tVoid vGetKdsEntry(tChar* strKdsConfigElement, tChar* strKdsConfigItem, int sock);
tVoid vStartClient(tU16 u16AppId, int sock);
tVoid vStopClient();

#define PROCIP_SOCKET_CMD_GET_KDS_ELEMENT         0
#define PROCIP_SOCKET_CMD_GET_REGISTRY            1
#define PROCIP_SOCKET_CMD_START_CCA_MSG_HDL       2
#define PROCIP_SOCKET_CMD_SEND_CCA_MSG            3
#define PROCIP_SOCKET_CMD_TERMINATE_CONNECTION    4

//int main(int args, char **argv) {
tS32 s32RunEnv(void){


    int iPort = 2355;
    int socket_desc , client_sock , c , *new_sock;
    struct sockaddr_in server , client;
    
    // Start Trace
    ET_TRACE_OPEN;

    amt_bInit();
    scd_init();

    //Create socket
    socket_desc = socket(AF_INET , SOCK_STREAM , 0);
    if (socket_desc == -1)
    {
        ETG_TRACE_FATAL(("Could not create socket"));
        ETG_TRACE_FATAL(("%s", strerror(errno)));
    }
    ETG_TRACE_FATAL(("Socket created"));
     
    //Prepare the sockaddr_in structure
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons( iPort );
     
    //Bind
    if( bind(socket_desc,(struct sockaddr *)&server , sizeof(server)) < 0)
    {
        //print the error message
        ETG_TRACE_FATAL(("bind failed. Error"));
        ETG_TRACE_FATAL(("%s", strerror(errno)));
        return 0;
    }
    ETG_TRACE_FATAL(("bind done"));
     
    //Listen
    listen(socket_desc , 3);
     
    //Accept and incoming connection
    ETG_TRACE_FATAL(("Waiting for incoming connections..."));
    c = sizeof(struct sockaddr_in);
     
     
    //Accept and incoming connection
    ETG_TRACE_FATAL(("Waiting for incoming connections..."));
    c = sizeof(struct sockaddr_in);
    while( (client_sock = accept(socket_desc, (struct sockaddr *)&client, (socklen_t*)&c)) )
    {
        ETG_TRACE_FATAL(("Connection accepted"));
         
        pthread_t sniffer_thread;
        new_sock = (int*)malloc(1);
        *new_sock = client_sock;

        if( pthread_create( &sniffer_thread , NULL ,  connection_handler , (void*) new_sock) < 0)
        {
            ETG_TRACE_FATAL(("could not create thread"));
            ETG_TRACE_FATAL(("%s", strerror(errno)));
            return 0;
        }
         
        //Now join the thread , so that we dont terminate before the thread
        //pthread_join( sniffer_thread , NULL);
        ETG_TRACE_FATAL(("Handler assigned"));
    }
     
    if (client_sock < 0)
    {
        ETG_TRACE_FATAL(("accept failed"));
        ETG_TRACE_FATAL(("%s", strerror(errno)));
        return 0;
    }
     
    return 0;
}
 
class amt_tclBaseStreamMessage : public amt_tclBaseMessage
{
public:
    amt_tclBaseStreamMessage (tU8 *pStreamData){
        tU32 u32Size = * ( (tU32*)( pStreamData + AMT_C_U32_BASEMSG_SIZE ) ); // lint !e826 Suspicious pointer-to-pointer conversion (area too small)

        vSetDynMsgSize(0);
        vAddDynMsgSize(u32Size);

        // Allocate in Shared Memory
        bAllocateMessage();

        vSetStreamU8(0, pStreamData, u32Size, u32Size);
    }

};

tVoid vPostMessage(amt_tclBaseMessage *poMessage);

/*
 * This will handle connection for each client
 * */ 
void *connection_handler(void *socket_desc)
{
    //Get the socket descriptor
    int sock = *(int*)socket_desc;
    int read_size;
    char *message , client_message[2000];
     
    //Send some messages to the client
    //message = "Greetings! I am your connection handler\n";
    //write(sock , message , strlen(message));
     
    //message = "Now type something and i shall repeat what you type \n";
    //write(sock , message , strlen(message));
     
    //Receive a message from client
    while( (read_size = recv(sock , client_message , 2000 , 0)) > 0 )
    {
        char* pStartData = strchr(client_message, ':');
        int iCmd = 255;
        if (pStartData != NULL) {
            pStartData[0] = 0;
            pStartData += 1;
            iCmd = atoi(client_message);
            ETG_TRACE_FATAL(("ClientMessageReceived: Command: %d (sock: %d), data: '%s' ", iCmd, sock, pStartData));
            switch (iCmd) {
            case PROCIP_SOCKET_CMD_GET_REGISTRY:
            { //get registry info with given basefolder
                tChar           szBaseName[256];
                OSAL_szStringCopy( (tString)szBaseName, "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/");
                OSAL_szStringConcat( (tString)szBaseName, pStartData);
                vTraceOutRegistry(szBaseName, sock);
            }
            break;
            case PROCIP_SOCKET_CMD_START_CCA_MSG_HDL:
            { // start CCA message handler
                vStartClient(atoi(pStartData),sock);
            }
            break;
            case PROCIP_SOCKET_CMD_SEND_CCA_MSG:
            {  // convert string stream to bin container
                tU8 au8Data[400] = {0};
                for (tU16 i=0; i<strlen(pStartData)/2;i++) {
                    char cData[3]={pStartData[2*i], pStartData[(2*i)+1], 0};
                    au8Data[i] = strtol(cData, NULL, 16);
                }

                amt_tclBaseStreamMessage oMyBaseMsg( (tU8*)au8Data);
                vPostMessage(&oMyBaseMsg);
            }
            break;
            case PROCIP_SOCKET_CMD_TERMINATE_CONNECTION:
            {
                tSocketInfo[sock].bTerminate = TRUE;
            }
            break;
            case PROCIP_SOCKET_CMD_GET_KDS_ELEMENT:
            {
                tChar*  strKdsConfigElement = pStartData;
                tChar*  pSeperator = strchr(pStartData, ';');
                if (pSeperator!= NULL) {
                    pSeperator[0] = 0;
                    tChar*  strKdsConfigItem = pSeperator+1;
                    vGetKdsEntry(strKdsConfigElement, strKdsConfigItem,sock);
                }
            }
            break;
            default:
                write(sock , client_message , strlen(client_message));
                ETG_TRACE_FATAL(("ClientMessageReceived: Unknown commad: %d", iCmd));
                break;
            }
        } else {
            //Send the message back to client
            write(sock , client_message , strlen(client_message));
            ETG_TRACE_FATAL(("ClientMessageReceived: Cannot interpret: '%s'", client_message));
        }
    }
     
    if(read_size == 0)
    {
        ETG_TRACE_FATAL(("Client disconnected"));
    }
    else if(read_size == -1)
    {
        ETG_TRACE_FATAL(("recv failed"));
    }
         
    //Free the socket pointer
    free(socket_desc);
     
    return 0;
}

tVoid vTraceOutRegistry(const tChar *szBaseName, int sock){
   tS8                   as8Name[200];
   tS32                  as32Data[255];

   OSAL_trIOCtrlDir      rDir;
   OSAL_trIOCtrlDir      rDirV;
   OSAL_trIOCtrlRegistry rReg;
   OSAL_tIODescriptor    fd;

   ETG_TRACE_FATAL( ( "PTH: %s", szBaseName ) );

   {
       char szFolder[256] = {0};
       sprintf(szFolder, "BaseFolder: '%s';",szBaseName);
       write(sock , szFolder , strlen(szFolder));
   }

   fd = OSAL_IOOpen(szBaseName, OSAL_EN_READONLY);
   if (fd != OSAL_ERROR){

      /* First, recursively show all the subkeys */
      rDir.fd        = fd;
      rDir.s32Cookie = 0;

      while (OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_REGREADDIR, ( intptr_t ) & rDir) != OSAL_ERROR){
         OSAL_szStringNCopy( (tString)as8Name, szBaseName, sizeof( as8Name ) );
         OSAL_szStringNConcat( (tString)as8Name, "/",                         sizeof( as8Name ) );
         OSAL_szStringNConcat( (tString)as8Name, (tString)rDir.dirent.s8Name, sizeof( as8Name ) );

         //vTraceOutRegistry( (tString)as8Name, sock);
         ETG_TRACE_FATAL( ( "VAL Folder: '%64s'", (const tChar*)as8Name) );
         {
             char szData[256] = {0};
             sprintf(szData, "Folder: '%s';",(const tChar*)as8Name);
             write(sock , szData , strlen(szData));
         }

      }

      /* Now show all the values of this key */
      rDirV.fd        = fd;
      rDirV.s32Cookie = 0;

      while (OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_REGENUMVALUE, ( intptr_t ) & rDirV) != OSAL_ERROR){
         rReg.pcos8Name = rDirV.dirent.s8Name;
         rReg.ps8Value  = (tU8*)as32Data;
         rReg.u32Size   = sizeof( as32Data );

         if (OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_REGGETVALUE, ( intptr_t ) & rReg) != OSAL_ERROR){
            // This is correct because not all traces come out if this is missing
            if (rReg.s32Type == OSAL_C_S32_VALUE_S32){
               ETG_TRACE_FATAL( ( "VAL number: '%32s' 0x%08x (%d)", (const tChar*)rDirV.dirent.s8Name, as32Data[0], as32Data[0] ) );
               {
                   char szData[256] = {0};
                   sprintf(szData, "Key: '%s', Value: '%d';",(const tChar*)rDirV.dirent.s8Name, as32Data[0]);
                   write(sock , szData , strlen(szData));
               }
            } else if (rReg.s32Type == OSAL_C_S32_VALUE_STRING){
               ETG_TRACE_FATAL( ( "VAL string: '%32s' '%s'", (const tChar*)rDirV.dirent.s8Name, (const tChar*)as32Data ) );
               {
                   char szData[256] = {0};
                   sprintf(szData, "Key: '%s', String: '%s';",(const tChar*)rDirV.dirent.s8Name, (const tChar*)as32Data);
                   write(sock , szData , strlen(szData));
               }
            }
         }
      }
      OSAL_s32IOClose(fd);
   }
} // vTraceOutRegistry

tVoid vGetKdsEntry(tChar* strKdsConfigElement, tChar* strKdsConfigItem, int sock) {

    tU8 au8Data[256] = {0};
    ETG_TRACE_FATAL(("vGetKdsEntry(): '%40s' , '%40s')", strKdsConfigElement, strKdsConfigItem));

    if ( DP_S32_NO_ERR == DP_s32GetConfigItem(strKdsConfigElement, strKdsConfigItem, au8Data, 256) ){
        char szData[400] = {0};
        OSAL_szStringConcat( szData, "KdsElementInfo:");
        memcpy((szData+strlen("KdsElementInfo:")+1), au8Data, 256);
        write(sock , szData , 400);
    } else {
        char szData[400] = {0};
        OSAL_szStringConcat( szData, "KdsElementFailed");
        write(sock , szData , strlen(szData));
    }

}

tVoid vCcaMsgHandlerThread(tVoid *pvArg);

tVoid vStartClient(tU16 u16AppId, int sock) {


   TSockInfo tSockTmp = {u16AppId, FALSE};
   tSocketInfo[sock] = tSockTmp;

   tChar            szMyProcSpecName[32] = {0};
   

   // start receiving thread
   sprintf(szMyProcSpecName, "CcaSimu%04x", u16AppId);

   OSAL_trThreadAttribute rAttr;
   rAttr.szName       = (tString)szMyProcSpecName;
   rAttr.s32StackSize = 4096;
   rAttr.u32Priority  = 100;
   rAttr.pfEntry      = (OSAL_tpfThreadEntry)vCcaMsgHandlerThread;
   rAttr.pvArg        = ( tPVoid ) sock;

   OSAL_tThreadID hThreadId = OSAL_ThreadSpawn(&rAttr);
   if ( hThreadId == OSAL_ERROR ){
      ETG_TRACE_ERR( ( "vStartClient(): Failed to spawn thread!" ) );
   }
}

tVoid vCcaMsgHandlerThread(tVoid *pvArg){

   int sock = (intptr_t)pvArg;

   tU16 u16AppId = tSocketInfo[sock].u16AppId;

   // create message queue
   OSAL_tMQueueHandle _hCcaInQueue = OSAL_C_INVALID_HANDLE;

   tChar          szName[32];

   OSALUTIL_s32SaveNPrintFormat(szName, sizeof( szName ), "mbx_%d", u16AppId);

   _hCcaInQueue = OSAL_C_INVALID_HANDLE;
   if (OSAL_ERROR == OSAL_s32MessageQueueOpen(szName, OSAL_EN_READWRITE, &_hCcaInQueue)){
       if (OSAL_ERROR == OSAL_s32MessageQueueCreate(
           szName,
           20,
           SCD_MAILBOX_MAX_MESSAGE_LENGTH,
           OSAL_EN_READWRITE,
           &_hCcaInQueue
           )
           ){
               ETG_TRACE_FATAL( ( "vCcaMsgHandlerThread(): FAILED to open/create queue." ) );
       }
   }
   while (!tSocketInfo[sock].bTerminate && (_hCcaInQueue != OSAL_C_INVALID_HANDLE)){
      amt_tclBaseMessage oMsgObject;
      tS32               s32RetVal = OSAL_s32MessageQueueWait(
         _hCcaInQueue,
         (tU8*)oMsgObject.prGetOSALMsgHandle(), /*pointer of the MsgHandle field*/
         sizeof( OSAL_trMessage ),
         OSAL_NULL,
         1000
         );

      //ETG_TRACE_FATAL( ( "vCcaMsgHandlerThread(): s32RetVal: %x",  s32RetVal) );
      if (s32RetVal != OSAL_ERROR){
         // gets the pointer to shared memory
         if (sizeof( OSAL_trMessage ) == s32RetVal){
            oMsgObject.pu8SharedMemBase = OSAL_pu8MessageContentGet(* ( oMsgObject.prGetOSALMsgHandle() ), OSAL_EN_READWRITE);
            if (oMsgObject.pu8SharedMemBase != OSAL_NULL){
               // send message to host via socket
               write(sock , oMsgObject.pu8SharedMemBase , oMsgObject.u32GetSize());

               ETG_TRACE_FATAL(("vCcaMsgHandlerThread(): Send CCA message on sock: %d)", sock));

               //ETG_TRACE_FATAL( ( "CCAMSG: RCV: %*x.!", ETG_LIST_LEN(oMsgObject.u32GetSize() ), ETG_LIST_PTR_T8(oMsgObject.pu8SharedMemBase) ) );
               //ETG_TRACE_FATAL( ( "CCAMSG: END." ) );
            }
         } else {
            if (OSAL_u32ErrorCode() != OSAL_E_TIMEOUT){
               // error
            } else {
               // timeout
            }
         }
      } else {
         // ETG_TRACE_ERR_CLS((SPM_TRACE_CLASS_SPM, "bMessageQueueWait, receive error: %s", OSAL_coszErrorText(OSAL_u32ErrorCode())));
      }
   }

   //OSAL_s32MessageQueueDelete(szName);
} // vCcaMsgHandlerThread


tVoid vPostMessage(amt_tclBaseMessage *poMessage){

   tU16 u16TargetID = poMessage->u16GetTargetAppID();

   OSAL_tMQueueHandle hAppMsgQueue = scd_OpenQueue(u16TargetID);
   /* send message */
   if (hAppMsgQueue != OSAL_C_INVALID_HANDLE){
      tS32 s32Retval = OSAL_s32MessageQueuePost(hAppMsgQueue,
                                           (tCU8*)poMessage->prGetOSALMsgHandle(),
                                           sizeof( OSAL_trMessage ),
                                           OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST);
      if (s32Retval == OSAL_OK){
      } else {
        ETG_TRACE_FATAL(("vPostMessage: post to app '%d' failed.", u16TargetID));
         poMessage->bDelete();
      }
   } else {
       ETG_TRACE_FATAL(("vPostMessage: Cannot open queue for  app '%d'", u16TargetID));
   }

   return;
} // bPostMessage

#ifdef __cplusplus
   extern "C" {
#endif

      tVoid vStartApp(tVoid) {
         printf("And now start proccess() --> procip.\n");
         tS32 s32Ret = s32RunEnv();
         if (s32Ret == OSAL_OK) {
            _exit(1);
         }
         return;
      }

#ifdef __cplusplus
   }
#endif

