
// OSALSocketInterface.h: interface for the OSALSocketInterface class.

#ifndef __OSAL_SOCKET_INTERFACE_H__
#define __OSAL_SOCKET_INTERFACE_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef VASCO_OS_WINNT // for Sleep() and CriticalSection
//#define NOMINMAX
//#include "windows.h"
#endif
#ifdef VASCO_OS_LINUX
#include <pthread.h>
#endif

#define  AHL_S_IMPORT_INTERFACE_STREAMER
#define  AHL_S_IMPORT_INTERFACE_ENDIAN
#include "ahl_if.h"

#include <map>
#include <string>
#include "socket.h"

class OSALSocketInterface : public OSALInterface  
{
public:
    OSALSocketInterface();
    OSALSocketInterface(int s32SocketNo,const char* coszHostName);
    virtual ~OSALSocketInterface();
    virtual bool bInit(bool bEnableLog = false);
    virtual bool bEnd();

    virtual int s32MsgQueueWait(OSAL_tMQueueHandle uiHandle, tU32 u32BufSize, tU32 u32TimeOut, unsigned char*pu8MsgBuf,tU32 &u32Prio);
    virtual int s32MsgQueuePost(OSAL_tMQueueHandle uiHandle, tU32 u32MsgSize, unsigned char* ps8Msg, tU32 u32Prio);
    virtual int s32MsgQueueClose(OSAL_tMQueueHandle uiHandle);
    virtual int s32MsgQueueOpen(const char* szQueueName,tU32 u32Access,OSAL_tMQueueHandle& uiHandle);
    virtual int s32MsgQueueCreate(const char* szQueueName,tU32 s32MaxMsgs,tU32 s32MaxLength, tU32 u32Access, OSAL_tMQueueHandle& uiHandle);
    virtual int s32MsgQueueDelete(const char* szQueueName);

    virtual int s32MsgPoolClose();
    virtual int s32MsgPoolOpen();
    virtual int s32MsgPoolCreate(tU32 u32PoolSize);
    virtual int s32MsgPoolDelete();

    virtual OSAL_tShMemHandle hSharedMemoryCreate( const char* szName, int access, tU32 u32Size );
    virtual OSAL_tShMemHandle hSharedMemoryOpen( const char* szName, int access );
    virtual int s32SharedMemoryClose( OSAL_tShMemHandle handle );
    virtual int s32SharedMemoryDelete (const char *szName);

    virtual void *pvSharedMemoryMap( OSAL_tShMemHandle handle,
        int access, 
        tU32 length, 
        tU32 offset  );

    virtual int s32SharedMemoryUnmap    (void * sharedMemory, tU32 size);

    virtual OSAL_tIODescriptor s32IOOpen(tU32 u32Access, const char* szFileName);
    virtual OSAL_tIODescriptor s32IOCreate(tU32 u32Access, const char* szFileName);
    virtual int s32IOClose(OSAL_tIODescriptor s32Descriptor);
    virtual int s32IOCtrl(OSAL_tIODescriptor s32Descriptor, tS32 s32Fun, tS32 s32Size, unsigned char *ps8Arg);
    virtual int s32IOCtrl(OSAL_tIODescriptor s32Descriptor, tS32 s32Fun, intptr_t iArg);
    virtual int s32IORemove(const char* szFileName);
    virtual int s32IORead(OSAL_tIODescriptor s32Descriptor, tU32 u32BufSize, unsigned char* pu8Buf);
    virtual int s32IOWrite(OSAL_tIODescriptor s32Descriptor, tU32 u32Size, unsigned char* pu8Buf);

    /* OSAL-IO-Funktionen - Debug-Funktionen nur fuer die Bench und osal_pure / NT! */
    virtual int s32IOEngFct (const char *device, tS32 s32Fun, unsigned char *ps8Arg, tS32 s32ArgSize);
    virtual int s32IOFakeExclAccess         (const char *device);
    virtual int s32IOReleaseFakedExclAccess (const char *device);

    /* This function only works with osal_pure/NT and application started with MiniSPM! */
    virtual int s32MiniSPMInitiateShutdown();

    /* This function is used to register for timeout callback */
    /* u32TmOutValue value should be specified in milliseconds */
    virtual int s32SetTimeoutEventHandler( Socket_tpfTimeoutCallback pCallback, void *pvArg, tU32 u32TmOutValue );

    /* OSAL Util-IO Funktionen */
    virtual int s32FSeek(OSAL_tIODescriptor fd,int offset, int origin);
    virtual int s32FTell(OSAL_tIODescriptor fd);
    virtual int s32FGetpos( OSAL_tIODescriptor fd, intptr_t *ptr );
    virtual int s32FSetpos( OSAL_tIODescriptor fd, const intptr_t *ptr );
    virtual int s32FGetSize(OSAL_tIODescriptor fd);
    virtual int s32CreateDir(OSAL_tIODescriptor fd,const char* szDirectory);
    virtual int s32RemoveDir(OSAL_tIODescriptor fd,const char* szDirectory);
    virtual intptr_t prOpenDir(const char* szDirectory);
    virtual intptr_t prReadDir( intptr_t pDir );
    virtual int s32CloseDir( intptr_t pDir );



private:

    virtual tS32 s32ReceiveErrorCode(tU32& u32ErrorCode);

    const int m_cu32Times;  // Divide by
    const int m_cu32Factor; // Receive timeout factor
    char* szHostName;
    FILE* log;
    int s32SocketNumber;
    SimpleClient* clientSocket;

#ifdef VASCO_OS_WINNT
    void* m_pPostCS;
    void* m_pReceiveCS;
#endif
#ifdef VASCO_OS_LINUX
    pthread_mutex_t mPostMutex;
    pthread_mutex_t mRecieveMutex;
#endif

    /** time out vars **/
    bool m_bTimeOutFlag;

    std::map<OSAL_tMQueueHandle, std::string> *m_poQueueNameMap;
    std::map<void *, intptr_t> *m_poSharedMemoryMap;
    int s32MsgQueueTimedWait(OSAL_tMQueueHandle uiHandle, tU32 u32BufSize, 
                             tU32 u32TimeOut, unsigned char *pu8MsgBuf,
                             tU32 &u32Prio, tU32 u32RecvTimeout = 0);

};

#endif // __OSAL_SOCKET_INTERFACE_H__
