// OSALInterface.h: interface for the OSALInterface class.

#ifndef __OSAL_INTERFACE_H__
#define __OSAL_INTERFACE_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define OSAL_S_IMPORT_INTERFACE_TYPES
#define OSAL_S_IMPORT_INTERFACE_THREADING
#include "osal_if.h"

#define OSALRPC_E_OSALAPI_TIMEOUT   (unsigned int)466964

class OSALInterface  
{
public:
    OSALInterface();
    virtual ~OSALInterface();
    virtual bool bInit(bool bEnableLog) = 0;
    virtual bool bEnd() = 0;

    virtual int s32MsgQueueWait(OSAL_tMQueueHandle uiHandle, tU32 u32BufSize, tU32 u32TimeOut, unsigned char*pu8MsgBuf,tU32 &u32Prio) = 0;
    virtual int s32MsgQueuePost(OSAL_tMQueueHandle uiHandle, tU32 u32MsgSize, unsigned char* ps8Msg, tU32 u32Prio) = 0;
    virtual int s32MsgQueueClose(OSAL_tMQueueHandle uiHandle) = 0;
    virtual int s32MsgQueueOpen(const char* szQueueName,tU32 u32Access,OSAL_tMQueueHandle& uiHandle) = 0;
    virtual int s32MsgQueueCreate(const char* szQueueName,tU32 s32MaxMsgs, tU32 s32MaxLength, tU32 u32Access, OSAL_tMQueueHandle& uiHandle) = 0;
    virtual int s32MsgQueueDelete(const char* szQueueName) = 0;

    virtual int s32MsgPoolCreate(tU32 u32PoolSize) = 0;
    virtual int s32MsgPoolDelete() = 0;
    virtual int s32MsgPoolClose() = 0;
    virtual int s32MsgPoolOpen() = 0;

    virtual OSAL_tShMemHandle  hSharedMemoryCreate   (const char* szName, int access, unsigned int u32Size) = 0;
    virtual OSAL_tShMemHandle  hSharedMemoryOpen     (const char* szName, int access) = 0;
    virtual int  s32SharedMemoryClose  (OSAL_tShMemHandle handle) = 0;
    virtual int  s32SharedMemoryDelete (const char *szName) = 0;

    virtual void *pvSharedMemoryMap( OSAL_tShMemHandle handle,
        int access, 
        unsigned int length, 
        unsigned int offset  ) = 0;

    virtual int s32SharedMemoryUnmap    (void * sharedMemory, unsigned int size) = 0;

    virtual OSAL_tIODescriptor s32IOOpen(tU32 u32Access, const char* szFileName) = 0;
    virtual OSAL_tIODescriptor s32IOCreate(tU32 u32Access, const char* szFileName) = 0;
    virtual int s32IOClose(OSAL_tIODescriptor fd) = 0;
    virtual int s32IOCtrl(OSAL_tIODescriptor fd, tS32 s32Fun, tS32 s32Size, unsigned char *ps8Arg) = 0;
    virtual int s32IOCtrl(OSAL_tIODescriptor fd, tS32 s32Fun, intptr_t iArg) = 0;
    virtual int s32IORemove(const char* szFileName) = 0;
    virtual int s32IORead(OSAL_tIODescriptor fd, tU32 u32BufSize, unsigned char* pu8Buf) = 0;
    virtual int s32IOWrite(OSAL_tIODescriptor fd, tU32 u32Size, unsigned char* pu8Buf) = 0;

    /* OSAL-IO-Funktionen - Debug-Funktionen nur fuer die Bench und osal_pure / NT! */
    virtual int s32IOEngFct (const char *device, tS32 s32Fun, unsigned char *ps8Arg, tS32 s32ArgSize) = 0;
    virtual int s32IOFakeExclAccess         (const char *device) = 0;
    virtual int s32IOReleaseFakedExclAccess (const char *device) = 0;

    /* This function only works with osal_pure/NT and application started with MiniSPM! */
    virtual int s32MiniSPMInitiateShutdown() = 0;

    /* OSAL Util-IO Funktionen */
    virtual int s32FSeek( OSAL_tIODescriptor fd, int offset, int origin ) = 0;
    virtual int s32FTell( OSAL_tIODescriptor fd ) = 0;
    virtual int s32FGetpos( OSAL_tIODescriptor fd, intptr_t *ptr ) = 0;
    virtual int s32FSetpos( OSAL_tIODescriptor fd, const intptr_t *ptr ) = 0;

    virtual int s32FGetSize(OSAL_tIODescriptor fd) = 0;
    virtual int s32CreateDir(OSAL_tIODescriptor fd,const char* szDirectory) = 0;
    virtual int s32RemoveDir(OSAL_tIODescriptor fd,const char* szDirectory) = 0;
    virtual intptr_t prOpenDir(const char* szDirectory) = 0;
    virtual intptr_t prReadDir(OSAL_tIODescriptor pDir) = 0;
    virtual int s32CloseDir(OSAL_tIODescriptor pDir) = 0;

protected:
    unsigned int u32LastErrorCode;
};

#endif // __OSAL_INTERFACE_H__
