#include "string.h"
#include "ByteArrayReader.h"
#include "string"


ByteArrayReader::ByteArrayReader (tU8 *pucByteArray, tU32 u32ArraySize)
: m_pucByteArray (pucByteArray)
, m_u32ArraySize (u32ArraySize)
, m_u32Pos (0)
{
}

tU32 ByteArrayReader::u32GetBytesLeft()
{
   return m_u32ArraySize - m_u32Pos;
}

bool ByteArrayReader::bReadU32 (tU32 *u32Value)
{
   return bReadRaw ((tU8 *) u32Value, 4);
}

bool ByteArrayReader::bReadS32 (tS32 *s32Value)
{
   return bReadRaw ((tU8 *) s32Value, 4);
}

tU32 ByteArrayReader::bPeekUpcomingStringLength ()
{
   tS32 i=0;
   while (i+m_u32Pos < m_u32ArraySize)
   {
      if (m_pucByteArray[i+m_u32Pos] == '\0')
      {
         // Terminierung gefunden!
         break;
      }
      ++i;
   }

   if ( !(i+m_u32Pos < m_u32ArraySize) )
   {
      // Keine Null-Terminierung gefunden...
      i = 0;
   }

   return i;
}

bool ByteArrayReader::bReadString (char *data)
{
   bool bSuccess = false;
   tS32 size = bPeekUpcomingStringLength();
   if (size != 0)
   {
      strcpy (data, (const char *) (m_pucByteArray+m_u32Pos));
      m_u32Pos += size;
      bSuccess = true;
   }

   return bSuccess;
}



bool ByteArrayReader::bReadRaw (tU8 *data, tU32 size)
{
   /*
    *  Groessencheck
    */
   bool bSuccess = false;
   
   if (m_u32Pos + size <= m_u32ArraySize)
   {
      memcpy (data, m_pucByteArray + m_u32Pos, size);
      m_u32Pos += size;
      bSuccess = true;
   }

   return bSuccess;
}
