/*****************************************************************************
| FILE:         MstSend.cpp
| PROJECT:      platform
| SW-COMPONENT: OSAL CORE
|-----------------------------------------------------------------------------
| DESCRIPTION:  This is the implementation file for the OSAL 
|               MST test main function.
|                
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:      
| Date      | Modification               | Author
| 09.02.18  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************ 
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/
#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"

#include "MstSendCommands.h"
/************************************************************************ 
|defines and macros (scope: module-local) 
|-----------------------------------------------------------------------*/
#define MSG_LEN   64

/************************************************************************ 
|typedefs (scope: module-local) 
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************ 
| variable definition (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: global)
|-----------------------------------------------------------------------*/


#ifdef __cplusplus
extern "C" {
#endif

void PingPongTest(int socket,int msecs, char* pRecMqName)
{
   OSAL_tMQueueHandle hMQ1;
   OSAL_tMQueueHandle hMQ2;
   tU32 u32Prio = 0;
   char cRecBuf[MSG_LEN];
   memset(cRecBuf,0,MSG_LEN);
   snprintf(cRecBuf,MSG_LEN,"MST_ANSWER_MQ%d",getpid());
   s32MessageQueueOpen(socket,pRecMqName, OSAL_EN_READWRITE,hMQ1);
   s32MessageQueueCreate(socket,cRecBuf,10,MSG_LEN,OSAL_EN_READWRITE,hMQ2);
   s32MessageQueuePost(socket,hMQ1,(tPCU8)cRecBuf,(tU32)strlen(cRecBuf),0);
   memset(cRecBuf,0,MSG_LEN);
   s32MessageQueueWait(socket,hMQ2,(tPU8)cRecBuf,MSG_LEN,u32Prio,msecs);
   TraceString("MST SND received %s",cRecBuf);
   s32MessageQueueClose( socket,hMQ1 );
   s32MessageQueueClose( socket,hMQ2 );
   snprintf(cRecBuf,MSG_LEN,"MST_ANSWER_MQ%d",getpid());
   s32MessageQueueDelete(socket,cRecBuf);
}


#ifdef __cplusplus
}
#endif

/************************************************************************
|end of fileMAin.cpp
|-----------------------------------------------------------------------*/
