/*****************************************************************************
| FILE:         MstCommands.cpp
| PROJECT:      platform
| SW-COMPONENT: OSAL CORE
|-----------------------------------------------------------------------------
| DESCRIPTION:  This is the implementation file for the OSAL 
|               MST test. Implementation of communication commands
|                
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:      
| Date      | Modification               | Author
| 09.02.18  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************ 
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/

#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"
#include "ostrace.h"

#define OSALRPC_INTERFACE_SERVER
#define OSALRPC_INTERFACE_COMMANDCODES
#include "osalrpcserver_if.h"

#define  AHL_S_IMPORT_INTERFACE_STREAMER
#define  AHL_S_IMPORT_INTERFACE_ENDIAN
#include "ahl_if.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <unistd.h>

/************************************************************************ 
|defines and macros (scope: module-local) 
|-----------------------------------------------------------------------*/
//#define PRINT_HEX_DATA

/************************************************************************ 
|typedefs (scope: module-local) 
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************ 
| variable definition (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: global)
|-----------------------------------------------------------------------*/


#ifdef __cplusplus
extern "C" {
#endif

tS32 s32MessageQueueCreate(int socket, tCString coszName, 
                                             tU32 u32MaxMessages, 
                                             tU32 u32MaxLength,
                                             tU32 u32Access, 
                                             OSAL_tMQueueHandle& phMQ)
{

    tS32 s32MsgQueueCreateCmd = OSAL_S32MESSAGEQUEUECREATE;
    tS32 s32ReturnValue = OSAL_ERROR;
    tS32 s32StringLength = OSAL_ERROR;
    tU32 u32TotalMessageLength = 0;

    s32StringLength = OSAL_u32StringLength( coszName );
    u32TotalMessageLength = 16+ s32StringLength + 1;

    ahl_tclStreamer oSendStream( u32TotalMessageLength );
    oSendStream << s32MsgQueueCreateCmd;
    oSendStream.vWriteStringToStream (coszName,s32StringLength+1);
    oSendStream << u32MaxMessages;
    oSendStream << u32MaxLength;
    oSendStream << u32Access;

    char* pcSendBuffer = (tChar*)OSAL_pvMemoryAllocate( u32TotalMessageLength );
    if(pcSendBuffer != OSAL_NULL )
    {
       OSAL_pvMemoryCopy(pcSendBuffer, oSendStream.pGetStream(), u32TotalMessageLength );
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND->",(tPCU8)pcSendBuffer,u32TotalMessageLength);
#endif
       if(send(socket,pcSendBuffer,u32TotalMessageLength,0) < 0)
       {
          TraceString("MST SND writing on stream socket error %d",errno);
       }
       OSAL_vMemoryFree(pcSendBuffer );
    }
 
    tChar aReceiveBuffer[MESSAGEQUEUECREATE_ANSWER_LENGTH];
    tU32 u32LastErrorCode;
    if(recv(socket,aReceiveBuffer,MESSAGEQUEUECREATE_ANSWER_LENGTH,0) < 0)
    {
       TraceString("MST SND writing on stream socket error %d",errno);
    }
    else
    {
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND<-",(tPCU8)aReceiveBuffer,MESSAGEQUEUECREATE_ANSWER_LENGTH);
#endif
       ahl_tclStreamer oOutputStream;
       oOutputStream.vSetStreamBuffer( (tPC8)aReceiveBuffer,
                                     MESSAGEQUEUECREATE_ANSWER_LENGTH,
                                     MESSAGEQUEUECREATE_ANSWER_LENGTH );
       oOutputStream >> u32LastErrorCode;
       oOutputStream >> s32ReturnValue;
       oOutputStream >> phMQ;
       TraceString("MST SND s32MessageQueueCreate %s Handle %p Error Code:0x%x returns %d",
	               coszName,phMQ,u32LastErrorCode,s32ReturnValue);
	}
    return s32ReturnValue;
}

tS32 s32MessageQueueDelete(int socket, tCString coszName )
{
    tS32 s32MsgQueueDeleteCmd = OSAL_S32MESSAGEQUEUEDELETE;
    tS32 s32ReturnValue = OSAL_ERROR;
    tS32 s32StringLength = OSAL_ERROR;
    tU32 u32TotalMessageLength = 0;

    s32StringLength = OSAL_u32StringLength( coszName );
    u32TotalMessageLength = 4 + s32StringLength + 1;

    ahl_tclStreamer oSendStream( u32TotalMessageLength );
    oSendStream << s32MsgQueueDeleteCmd;
    oSendStream.vWriteStringToStream (coszName,s32StringLength+1);

    char* pcSendBuffer = (tChar*)OSAL_pvMemoryAllocate( u32TotalMessageLength );
    if(pcSendBuffer != OSAL_NULL )
    {
       OSAL_pvMemoryCopy(pcSendBuffer, oSendStream.pGetStream(), u32TotalMessageLength );
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND->",(tPCU8)pcSendBuffer,u32TotalMessageLength);
#endif
       if(send(socket,pcSendBuffer,u32TotalMessageLength,0) < 0)
       {
          TraceString("MST SND writing on stream socket error %d",errno);
       }
       OSAL_vMemoryFree(pcSendBuffer );
	}
 
    tChar aReceiveBuffer[MESSAGEQUEUEDELETE_ANSWER_LENGTH];
    tU32 u32LastErrorCode;
    if(recv(socket,aReceiveBuffer,MESSAGEQUEUEDELETE_ANSWER_LENGTH,0) < 0)
    {
       TraceString("MST SND writing on stream socket error %d",errno);
    }
    else
    {
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND<-",(tPCU8)aReceiveBuffer,MESSAGEQUEUEDELETE_ANSWER_LENGTH);
#endif
       ahl_tclStreamer oOutputStream;
       oOutputStream.vSetStreamBuffer( (tPC8)aReceiveBuffer,
                                       MESSAGEQUEUEDELETE_ANSWER_LENGTH,
                                       MESSAGEQUEUEDELETE_ANSWER_LENGTH );
       oOutputStream >> u32LastErrorCode;
       oOutputStream >> s32ReturnValue;
       TraceString("MST SND s32MessageQueueDelete %s Error Code:0x%x returns %d",
	               coszName,u32LastErrorCode,s32ReturnValue);
    }
    return s32ReturnValue;
}



tS32 s32MessageQueueOpen(int socket, tCString coszName, tU32 u32Access, OSAL_tMQueueHandle& phMQ)
{
    tS32 s32MsgQueueOpenCmd = OSAL_S32MESSAGEQUEUEOPEN;
    tS32 s32ReturnValue = OSAL_ERROR;
    tS32 s32StringLength = OSAL_ERROR;
    tU32 u32TotalMessageLength = 0;

    s32StringLength = OSAL_u32StringLength( coszName );

    u32TotalMessageLength = s32StringLength + 1 + 8 ;

    ahl_tclStreamer oSendStream( u32TotalMessageLength );
    oSendStream << s32MsgQueueOpenCmd;
    oSendStream.vWriteStringToStream (coszName,s32StringLength+1);
    oSendStream << u32Access;

    char* pcSendBuffer = (tChar*)OSAL_pvMemoryAllocate( u32TotalMessageLength );
    if(pcSendBuffer != OSAL_NULL )
    {
       OSAL_pvMemoryCopy(pcSendBuffer, oSendStream.pGetStream(), u32TotalMessageLength );
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND->",(tPCU8)pcSendBuffer,u32TotalMessageLength);
#endif
       if(send(socket,pcSendBuffer,u32TotalMessageLength,0) < 0)
       {
          TraceString("MST SND writing on stream socket error %d",errno);
       }
       OSAL_vMemoryFree(pcSendBuffer );
    }
 
    tChar aReceiveBuffer[MESSAGEQUEUEOPEN_ANSWER_LENGTH];
	tU32 u32LastErrorCode;
    if(recv(socket,aReceiveBuffer,MESSAGEQUEUEOPEN_ANSWER_LENGTH,0) < 0)
    {
       TraceString("MST SND writing on stream socket error %d",errno);
    }
    else
    {
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND<-",(tPCU8)aReceiveBuffer,MESSAGEQUEUEOPEN_ANSWER_LENGTH);
#endif
       ahl_tclStreamer oOutputStream;
       oOutputStream.vSetStreamBuffer( (tPC8)aReceiveBuffer,
                                     MESSAGEQUEUEOPEN_ANSWER_LENGTH,
                                     MESSAGEQUEUEOPEN_ANSWER_LENGTH );
       oOutputStream >> u32LastErrorCode;
       oOutputStream >> s32ReturnValue;
       oOutputStream >> phMQ;
       TraceString("MST SND s32MessageQueueOpen %s Handle %p Error Code:0x%x returns %d",
	               coszName,phMQ,u32LastErrorCode,s32ReturnValue);
    }
    return s32ReturnValue;
}


tS32 s32MessageQueueClose(int socket, OSAL_tMQueueHandle hMQ )
{
    tS32 s32MsgQueueCloseCmd = OSAL_S32MESSAGEQUEUECLOSE;
    tS32 s32ReturnValue = OSAL_ERROR;
    tU32 u32TotalMessageLength = (tU32)sizeof(OSAL_tMQueueHandle) + 4;

    ahl_tclStreamer oSendStream(u32TotalMessageLength);
    oSendStream << s32MsgQueueCloseCmd;
    oSendStream << hMQ;

    char* pcSendBuffer = (tChar*)OSAL_pvMemoryAllocate( u32TotalMessageLength );
    if(pcSendBuffer != OSAL_NULL )
    {
       OSAL_pvMemoryCopy(pcSendBuffer, oSendStream.pGetStream(), u32TotalMessageLength );
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND->",(tPCU8)pcSendBuffer,u32TotalMessageLength);
#endif
       if(send(socket,pcSendBuffer,u32TotalMessageLength,0) < 0)
       {
          TraceString("MST SND writing on stream socket error %d",errno);
       }
	   free(pcSendBuffer);
    }
 
    tChar aReceiveBuffer[MESSAGEQUEUECLOSE_ANSWER_LENGTH];
    tU32 u32LastErrorCode;
    if(recv(socket,aReceiveBuffer,MESSAGEQUEUECLOSE_ANSWER_LENGTH,0) < 0)
    {
       TraceString("MST SND writing on stream socket error %d",errno);
    }
    else
    {
#ifdef PRINT_HEX_DATA
      vTraceHexDump("SND<-",(tPCU8)aReceiveBuffer,MESSAGEQUEUECLOSE_ANSWER_LENGTH);
#endif
      ahl_tclStreamer oOutputStream;
      oOutputStream.vSetStreamBuffer( (tPC8)aReceiveBuffer,
                                      MESSAGEQUEUECLOSE_ANSWER_LENGTH,
                                     MESSAGEQUEUECLOSE_ANSWER_LENGTH );
      oOutputStream >> u32LastErrorCode;
      oOutputStream >> s32ReturnValue;
      TraceString("MST SND s32MessageQueueClose Handle %p Error Code:0x%x returns %d",
	               hMQ,u32LastErrorCode,s32ReturnValue);
    }
 
    return s32ReturnValue;
}

tS32 s32MessageQueuePost(int socket, OSAL_tMQueueHandle hMQ, tPCU8 pcou8Msg, tU32 u32Length,tU32 u32Prio )
{
    tS32 s32MsgQueuePostCmd = OSAL_S32MESSAGEQUEUEPOST;
    tS32 s32ReturnValue = OSAL_ERROR;
    tU32 u32TotalMessageLength = 12 + (tU32)sizeof(OSAL_tMQueueHandle) + u32Length+1;

    ahl_tclStreamer oSendStream( u32TotalMessageLength );
    oSendStream << s32MsgQueuePostCmd;
    oSendStream << hMQ;
    oSendStream << u32Length;
    oSendStream.vWriteStringToStream((const char*)pcou8Msg,u32Length+1);
    oSendStream << u32Prio;

    char* pcSendBuffer = (tChar*)OSAL_pvMemoryAllocate( u32TotalMessageLength );
    if(pcSendBuffer != OSAL_NULL )
    {
       OSAL_pvMemoryCopy(pcSendBuffer, oSendStream.pGetStream(), u32TotalMessageLength );
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND->",(tPCU8)pcSendBuffer,u32TotalMessageLength);
#endif
       if(send(socket,pcSendBuffer,u32TotalMessageLength,0) < 0)
       {
          TraceString("MST SND writing on stream socket error %d",errno);
       }
       free(pcSendBuffer );
    }
 
    tChar aReceiveBuffer[MESSAGEQUEUEPOST_ANSWER_LENGTH];
    tU32 u32LastErrorCode;
    if(recv(socket,aReceiveBuffer,MESSAGEQUEUEPOST_ANSWER_LENGTH,0) < 0)
    {
       TraceString("MST SND writing on stream socket error %d",errno);
    }
    else
    {
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND<-",(tPCU8)aReceiveBuffer,u32TotalMessageLength);
#endif
       ahl_tclStreamer oOutputStream;
       oOutputStream.vSetStreamBuffer( (tPC8)aReceiveBuffer,
                                     MESSAGEQUEUEPOST_ANSWER_LENGTH,
                                     MESSAGEQUEUEPOST_ANSWER_LENGTH );
       oOutputStream >> u32LastErrorCode;
       oOutputStream >> s32ReturnValue;
       TraceString("MST SND s32MessageQueuePost Handle %p Error Code:0x%x returns %d",
	               hMQ,u32LastErrorCode,s32ReturnValue);
    }
    return s32ReturnValue;
}

tS32 s32MessageQueueWait(int socket, OSAL_tMQueueHandle hMQ, tPU8 pu8Buffer, tU32 u32Length,tU32& pu32Prio, tU32 u32Msec )
{
    tS32 s32MsgQueueWaitCmd = OSAL_S32MESSAGEQUEUEWAIT;
    tU32 u32Size = OSAL_ERROR;
    tU32 u32TotalMessageLength = 12 + (tU32)sizeof(OSAL_tMQueueHandle);

    ahl_tclStreamer oSendStream(u32TotalMessageLength);
    oSendStream << s32MsgQueueWaitCmd;
    oSendStream << hMQ;
    oSendStream << u32Length;
    oSendStream << u32Msec;

    char* pcSendBuffer = (tChar*)OSAL_pvMemoryAllocate( u32TotalMessageLength );
    if(pcSendBuffer != OSAL_NULL )
    {
       OSAL_pvMemoryCopy(pcSendBuffer, oSendStream.pGetStream(), u32TotalMessageLength );
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND->",(tPCU8)pcSendBuffer,u32TotalMessageLength);
#endif
       if(send(socket,pcSendBuffer,u32TotalMessageLength,0) < 0)
       {
          TraceString("MST SND writing on stream socket error %d",errno);
       }
        free(pcSendBuffer );
    }
 
    tChar aReceiveBuffer[MESSAGEQUEUEWAIT_ANSWER_LENGTH+u32Length];
    tU32 u32LastErrorCode;
    if(recv(socket,aReceiveBuffer,MESSAGEQUEUEWAIT_ANSWER_LENGTH+u32Length,0) < 0)
    {
       TraceString("MST SND writing on stream socket error %d",errno);
    }
    else
    {
#ifdef PRINT_HEX_DATA
       vTraceHexDump("SND<-",(tPCU8)aReceiveBuffer,MESSAGEQUEUEWAIT_ANSWER_LENGTH+u32Length);
#endif
       ahl_tclStreamer oOutputStream;

       oOutputStream.vSetStreamBuffer((tPC8)aReceiveBuffer,
                                      MESSAGEQUEUEWAIT_ANSWER_LENGTH+u32Length,
                                      MESSAGEQUEUEWAIT_ANSWER_LENGTH+u32Length );
       oOutputStream >> u32LastErrorCode;
       oOutputStream >> u32Size;
       ahl_tclStreamer pcMessage( u32Size );
       TraceString("MST SND s32MessageQueueWait Handle %p Error Code:0x%x returns %d",
	               hMQ,u32LastErrorCode,u32Size);

//       tChar *pBuffer = (tChar*)OSAL_pvMemoryAllocate( 8 + u32Size );
//       if ( pBuffer == OSAL_NULL ) return OSAL_ERROR;

       if(u32LastErrorCode == OSAL_E_NOERROR)
       {
          oOutputStream.rfReadStream(pcMessage);
          oOutputStream >> pu32Prio;
          OSAL_pvMemoryCopy( pu8Buffer, pcMessage.pGetStream(), u32Size );
       }
    }
    return u32Size;
}

#ifdef __cplusplus
}
#endif

/************************************************************************
|end of fileMAin.cpp
|-----------------------------------------------------------------------*/
