/*****************************************************************************
| FILE:         MstSend.cpp
| PROJECT:      platform
| SW-COMPONENT: OSAL CORE
|-----------------------------------------------------------------------------
| DESCRIPTION:  This is the implementation file for the OSAL 
|               MST test main function of the MST client process
|                
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:      
| Date      | Modification               | Author
| 09.02.18  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************ 
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/

#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"
#include "ostrace.h"

#define OSALRPC_INTERFACE_SERVER
#define OSALRPC_INTERFACE_COMMANDCODES
#include "osalrpcserver_if.h"

#define  AHL_S_IMPORT_INTERFACE_STREAMER
#define  AHL_S_IMPORT_INTERFACE_ENDIAN
#include "ahl_if.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <unistd.h>



#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************ 
|defines and macros (scope: module-local) 
|-----------------------------------------------------------------------*/

/************************************************************************ 
|typedefs (scope: module-local) 
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************ 
| variable definition (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: global)
|-----------------------------------------------------------------------*/
extern void PingPongTest(int socket,int msecs, char* pRecMqName);



/*****************************************************************************
 *
 * FUNCTION:    CreateSocket
 *
 * DESCRIPTION: cretes a socket client
 *
 * PARAMETER:   char*  TCP/IP address
 *              int    Port number 
 *
 * RETURNVALUE: s32ReturnValue
 *                 it is the function return value:
 *                 - socket ID if everything goes right;
 *                 - -1 otherwise.
 * HISTORY:
 * Date      |   Modification                         | Authors
 * 09.02.18  | Initial revision                       | MRK2HI
 * --.--.--  | ----------------                       | -----
 *
 *****************************************************************************/
int CreateSocket(char* pAddress, int Port)
{
   int sock = -1;
   struct sockaddr_in destination;
   struct hostent *hp;

   sock = socket(AF_INET,SOCK_STREAM,0);
   if(sock < 0)
   {
      TraceString("MST SND error:%d open stream socket",errno);
   }
   else
   {
      destination.sin_family = AF_INET;
      hp = gethostbyname(pAddress);
      if(hp == NULL)
      {
         TraceString("MST SND  %s unknown host.\n",pAddress);
      }
	  else
	  {
         memcpy((char *) &destination.sin_addr, (char *) hp -> h_addr, hp -> h_length);
         destination.sin_port = htons((uint16_t)Port);

         /* open connection */
         if(connect(sock,(const sockaddr*)&destination,sizeof(struct sockaddr_in)) < 0)
         {
            TraceString("MST SND error:%d connecting stream socket",errno);
		 }
      }
   }
   return sock;
}

/*****************************************************************************
 *
 * FUNCTION:    vReadRegistryConf
 *
 * DESCRIPTION: This function reads runtime configuration from registry
 *
 * PARAMETER:    char*  TCP/IP address
 *               int*    Port number 
 *               char* Reception Queue name
 *
 * RETURNVALUE: none
 *
 * HISTORY:
 * Date      |   Modification                         | Authors
 * 09.02.18  | Initial revision                       | MRK2HI
 * --.--.--  | ----------------                       | -----
 *
 *****************************************************************************/
void vReadRegistryConf(char* pAddress, int* Port, char* RecMqName)
{
   OSAL_tIODescriptor s32DevDesc = 0;
   OSAL_trIOCtrlRegistry hReg;

   if((s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY"/"REGISTRY_BASE_PATH"/VERSIONS/OSAL",OSAL_EN_READWRITE)) != OSAL_ERROR )
   {
	  if(*pAddress == 0)
	  {
         hReg.pcos8Name =  (tPCS8)"SOCKET";
         hReg.s32Type   =  OSAL_C_S32_VALUE_STRING;
         hReg.ps8Value  =  (tPU8)pAddress;
         hReg.u32Size   =  32;
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST SND Take TCP/IP adress %s from registry ",pAddress);
         }
	  }
	  if(*Port == -1)
	  {
         hReg.pcos8Name =  (tPCS8)"PORT";
         hReg.s32Type   =  OSAL_C_S32_VALUE_S32;
         hReg.ps8Value  =  (tPU8)Port;
         hReg.u32Size   =  sizeof(tU32);
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST SND Take Port number %d from registry ",*Port);
         }
	  }
	  if(*RecMqName == 0)
	  {
         hReg.pcos8Name =  (tPCS8)"MST_REC_MQ";
         hReg.s32Type   =  OSAL_C_S32_VALUE_STRING;
         hReg.ps8Value  =  (tPU8)RecMqName;
         hReg.u32Size   =  32;
         if(OSAL_s32IOControl(s32DevDesc,OSAL_C_S32_IOCTRL_REGGETVALUE,(uintptr_t)&hReg) == OSAL_OK)
         {
           TraceString("MST SND Take MQ name from registry Socket %s ",RecMqName);
         }
	  }
      OSAL_s32IOClose(s32DevDesc);
   }
}

	
/*****************************************************************************
 *
 * FUNCTION:    main
 *
 * DESCRIPTION: This function implements the process
 *
 * PARAMETER:    int argc
 *               char** argv
 *
 * RETURNVALUE: none
 *
 * HISTORY:
 * Date      |   Modification                         | Authors
 * 09.02.18  | Initial revision                       | MRK2HI
 * --.--.--  | ----------------                       | -----
 *
 *****************************************************************************/
int main(int argc,char** argv)
{
   int opt,msecs = 1000000;
   char  szIpAddress[32] = {0};
   char  szRecMqName[32] = {0};
   tS32  s32Port = -1;
   int socket = -1;
   
   /* check for given parameter at commandline */
   while ((opt = getopt (argc, argv, "t:p:a:h")) != -1)
   {
      switch (opt)
      {
         case 't':// check timeout for process living
              msecs = atoi(optarg);
            break;
         case 'p':
              s32Port = atoi(optarg);
            break;
         case 'a':
              if(strlen(optarg) < 32)strncpy(szIpAddress,(char*)optarg,strlen(optarg));
            break;
         case 'q':
		      if(strlen(optarg) < 32)strncpy(szRecMqName,(char*)optarg,strlen(optarg));
            break;
         case 'h':// print help output
              TraceString("Usage: %s [-t msecs] [-a 127.0.0.1] [-p 123000] [-q MST_TEST_QUEUE] ",argv[0]);
              TraceString("       [-t msecs] lifetime of the process in msec default is 0");
              TraceString("       [-a] tcp/ip adress like 127.0.0.1");
              TraceString("       [-p] prot number to be used");
              TraceString("       [-q] Message queue name used by in receiver application");
             break;
         default: 
              TraceString("Check command option with %s -h ",argv[0]);
             break;
      }
   }
   /* check for configuration via registry if values are not set */
   vReadRegistryConf(&szIpAddress[0],&s32Port,&szRecMqName[0]);
   /* create socket connection to osalprc_out.out*/
   socket = CreateSocket(&szIpAddress[0],s32Port);
   
   if(socket != -1)
   {
     PingPongTest(socket,msecs,&szRecMqName[0]);
    
     close(socket);
   }
   
   OSAL_vProcessExit();
}


#ifdef __cplusplus
}
#endif

/************************************************************************
|end of MstSend.cpp
|-----------------------------------------------------------------------*/
