/*****************************************************************************
| FILE:         osalashmem.cpp
| PROJECT:      platform
| SW-COMPONENT: OSAL CORE
|-----------------------------------------------------------------------------
| DESCRIPTION:  This is the implementation file for the OSAL
|               (Operating System Abstraction Layer) Shared Memory-Functions.
|
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2010 Robert Bosch GmbH
| HISTORY:      
| Date      | Modification               | Author
| 03.10.05  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/
#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"

#include "ostrace.h"

#ifdef ANDROID

#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************
|defines and macros (scope: module-local)
|-----------------------------------------------------------------------*/

//#define BINDERDEV  "/dev/binder"
#define BINDERDEV  "/dev/vndbinder"
/************************************************************************
|typedefs (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/
void*              pServiceHandle = NULL;
tpGetAShMem        pGetAShMem = NULL;
tpRelAShMem        pRelAShMem = NULL;
tpCheckService     pCheckService = NULL;
tpConnectService   pCreateService = NULL;
tpConnectService   pConnectService = NULL;
tpOsalBinderBacktrace pOsalBinderBacktrace = NULL;
tpSwitchOnOff      pSwitchOnOff  = NULL;

/************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------*/
extern int hLiShMem;
extern int hLiResShMem;
extern int hRegShMemHandle;


/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function implementation (scope: module-local)
|-----------------------------------------------------------------------*/
#include "linux/ioctl.h"
#include "linux/android/binder.h"



int binderFd = -1;
static void* binderbuffer = NULL;

void vLooper(__u32 Command)
{
   struct binder_write_read bwr;
  // binder_transaction_data rData;
   __u32 wrbuffer[4] = {0,0,0,0};
   wrbuffer[0] = Command;
/*   rData.target.handle = 0;
   rData.cookie       = 0;
   rData.code         = 0;
   rData.flags        = TF_ONE_WAY|TF_ACCEPT_FDS;
   rData.sender_pid   = getpid();
   rData.sender_euid  = geteuid();
   rData.data_size    = sizeof(__u32);
   rData.offsets_size = 0;
   memcpy(&rData.data.buf[0],&rData.sender_pid,sizeof(rData.sender_pid));
   memcpy(&wrbuffer[1],&rData,sizeof(binder_transaction_data));*/
   bwr.write_size = sizeof(__u32); /*bytes to write*/
   bwr.write_consumed = 0; /*bytes consumed*/
   bwr.write_buffer = (uintptr_t)&wrbuffer;
   bwr.read_size = 0; /*bytes to be read*/
   bwr.read_consumed = 0;
   if(ioctl(binderFd, BINDER_WRITE_READ, &bwr) == -1)
   {
      TraceString("vLooper ioctl ENTER_LOOPER failed %d",errno);
   }
   else
   {
       if(bwr.write_consumed == sizeof(__u32))
       {
          TraceString("vLooper ioctl ENTER_LOOPER succeeded!");
       }
   }
}

tS32 s32OpenBinder(void)
{
   tS32 s32Ret = OSAL_ERROR;
   if(binderFd == -1)
   {
      binderFd  = open(BINDERDEV, O_RDWR | O_NONBLOCK | O_CLOEXEC);
      if(binderFd != -1)
      {
         TraceString("Open binder succeeded");
         struct binder_version version;
         if(ioctl(binderFd, BINDER_VERSION, &version) == -1)
         {
            TraceString("BINDER_VERSION ioctl failed %d",errno);
         }
         else
         {
            TraceString("BINDER_VERSION version %d",version.protocol_version);
         }
         size_t maxThreads = 15;
         if(ioctl(binderFd, BINDER_SET_MAX_THREADS, &maxThreads) == -1)
         {
            TraceString("BINDER_SET_MAX_THREADS ioctl failed %d",errno);
         }
         
         binderbuffer = mmap(NULL, 64*1024, PROT_READ, MAP_SHARED, binderFd, 0);
         TraceString("BINDER fd %d mapped to 0x%x",binderFd,binderbuffer);
         struct binder_write_read bwr;
         __u32 Cmd = BC_REGISTER_LOOPER;
         bwr.write_size = sizeof(__u32); /*bytes to write*/
         bwr.write_consumed = 0; /*bytes consumed*/
         bwr.write_buffer = (uintptr_t)&Cmd;
         bwr.read_size = 0; /*bytes to be read*/
         bwr.read_consumed = 0;
         if(ioctl(binderFd, BINDER_WRITE_READ, &bwr) == -1)
         {
             TraceString("vLooper ioctl BC_REGISTER_LOOPER failed %d",errno);
         }
         Cmd = BC_ENTER_LOOPER;
         if(ioctl(binderFd, BINDER_WRITE_READ, &bwr) == -1)
         {
             TraceString("vLooper ioctl ENTER_LOOPER failed %d",errno);
         }
         s32Ret = OSAL_OK;
      }
      else
      {
         s32Ret = OSAL_ERROR;
         TraceString("Open binder failed %d",errno);
      }
   }
   else
   {
       s32Ret = OSAL_OK;
   }
   return s32Ret;
}


tS32 s32WriteHandleToBinder(void)
{
#ifdef SINGLE_PROCESS_OSAL
  return OSAL_OK;
#else
  tS32 s32Ret = OSAL_ERROR;
  if(s32OpenBinder() == OSAL_OK)
  {    
      struct binder_write_read bwr;
      binder_transaction_data rData;
      __u32 wrbuffer[64];
  
      wrbuffer[0] = BC_TRANSACTION; //protocol tag
      rData.target.handle = hLiShMem;
      rData.cookie       = 0;
      rData.code         = 0; // function code of a service
      rData.flags        = TF_ONE_WAY|TF_ACCEPT_FDS;
      rData.sender_pid   = getpid();
      rData.sender_euid  = geteuid();
      rData.data_size    = 3*sizeof(int);
      rData.offsets_size = 0;
	  
//      memcpy(&rData.data.buf[0],&hLiShMem,sizeof(int));
//      memcpy(&rData.data.buf[sizeof(int)],&hLiResShMem,sizeof(int));
//      memcpy(&rData.data.buf[2*sizeof(int)],&hRegShMemHandle,sizeof(int));
  
//      memcpy(&wrbuffer[1],&rData,sizeof(binder_transaction_data));

      bwr.write_size = /*sizeof(wrbuffer)+ */sizeof(binder_transaction_data); /*bytes to write*/
      bwr.write_consumed = 0; /*bytes consumed*/
      bwr.write_buffer = (uintptr_t)&rData;
      bwr.read_size = 0; /*bytes to be read*/
      bwr.read_consumed = 0;
      if(ioctl(binderFd, BINDER_WRITE_READ, &bwr) == -1)
      {
          TraceString("s32WriteHandleToBinder ioctl failed %d",errno);
      }
      else
      {
          s32Ret = OSAL_OK;
      }
 
      TraceString("s32WriteHandleToBinder %d ioctl BC_TRANSACTION write_consumed %d bwr.read_consumed %d",wrbuffer[1],bwr.write_consumed,bwr.read_consumed);
  }
  return s32Ret;
#endif      
}


tS32 s32ReadHandleFromBinder(void)
{
#ifdef SINGLE_PROCESS_OSAL
  return OSAL_OK;
#else
  tS32 s32Ret = OSAL_ERROR;
  if(s32OpenBinder() == OSAL_OK)
  {
    DIR *pDir;
    struct dirent *pDEntry;
    int Pid = 0;
	
    pDir = opendir(VOLATILE_DIR"/OSAL/Processes");
    while( NULL != (pDEntry = readdir( pDir )) )
    {
        /* find fisrt OSAL process to identify PID of first process*/
        if(pDEntry->d_name[0] != '.')
        {
            Pid = atoi(pDEntry->d_name);
			TraceString("First OSAL process has PID:%d",Pid);
        }
    }
     binder_transaction_data rData;
     __u32 rdbuffer[64];
     rdbuffer[0] = BR_TRANSACTION;
     rData.target.handle = binderFd;
     rData.cookie       = 0;
     rData.code         = 0;//ADD_SERVICE_TRANSACTION;
     rData.flags        = TF_ONE_WAY|TF_ACCEPT_FDS;
     rData.sender_pid   = Pid;
     rData.sender_euid  = 0;
     rData.data_size    = 3*sizeof(int);
     rData.offsets_size = 0;
     memcpy(&rdbuffer[1],&rData,sizeof(binder_transaction_data));

     struct binder_write_read bwr;
     bwr.read_buffer = (uintptr_t)rdbuffer;
     bwr.read_size = 3*sizeof(__u32) + sizeof(binder_transaction_data);
     bwr.write_size     = 0; /*bytes to write*/
     bwr.write_consumed = 0; /*bytes consumed*/
     bwr.write_buffer = 0;
     s32Ret = 0;
      while(1)
      {
         if(ioctl(binderFd, BINDER_WRITE_READ, &bwr) == -1)
         {
             TraceString("s32ReadHandleFromBinder ioctl WRITE_READ failed %d",errno);
       /*      if(errno == EAGAIN)
             {
               struct timespec tim = {0,0};
               tim.tv_sec = 0 ;
               tim.tv_nsec = 20000;     
   
               nanosleep(&tim, NULL);
                s32Ret++;
                if(s32Ret == 10)
                {
                    s32Ret = OSAL_ERROR;
                    break;
                }
             }
             else*/
             {
                 break;
             }
         }
         else
         {
            hLiShMem        = rData.data.buf[0];
            hLiResShMem     = rData.data.buf[1];
            hRegShMemHandle = rData.data.buf[2];
            s32Ret = OSAL_OK;
            break;
         }
      }
      TraceString("s32WriteHandleToBinder %d ioctl write_consumed %d bwr.read_consumed %d",rdbuffer[1],bwr.write_consumed,bwr.read_consumed);
      s32Ret = OSAL_OK;
  }
  return s32Ret;
#endif
}

int ashmem_pin_region(int fd, size_t offset, size_t len)
{
   struct ashmem_pin pin = { (__u32)offset, (__u32)len };
   return ioctl(fd, ASHMEM_PIN, &pin);
}

int ashmem_create_region(const char *name, size_t size)
{
   int fd, ret;
   fd = open(ASHMEM_NAME_DEF, O_RDWR);
   if (fd < 0)
   {
      TraceString("ashmem_create_region open %s with size:%d return error %d",name,size,errno);
      return fd;
   }
   if (name) 
   {
      char buf[ASHMEM_NAME_LEN] = {0};
      strncpy(buf,name,strlen(name));
      ret = ioctl(fd, ASHMEM_SET_NAME, buf);
      if (ret < 0)
      {
         TraceString("ashmem_create_region ioctl SET_NAME %s with size:%d return error %d",name,size,errno);
         goto error;
      }
   }

   ret = ioctl(fd, ASHMEM_SET_SIZE, size);
   if (ret < 0)
   {
      TraceString("ashmem_create_region ioctl SET_SIZE %s with size:%d return error %d",name,size,errno);
      goto error;
   }
      
 //  TraceString("ashmem_create_region created %s with size:%d ",name,size);
	  
   return fd;

error:
   close(fd);
   return ret;
}

int ashmem_set_prot_region(int fd, int prot)
{
   return ioctl(fd, ASHMEM_SET_PROT_MASK, prot);
}


int ashmem_unpin_region(int fd, size_t offset, size_t len)
{
   struct ashmem_pin pin = { (__u32)offset, (__u32)len };
   return ioctl(fd, ASHMEM_UNPIN, &pin);
}

int ashmem_get_size_region(int fd)
{
  return ioctl(fd, ASHMEM_GET_SIZE, NULL);
}


int LoadOsalService(void)
{
   TraceString("Try to load %s in PID:%d",OSAL_BINDER_LIB_NAME,getpid());
   dlerror();    /* Clear any existing error */
   pServiceHandle = dlopen(OSAL_BINDER_LIB_NAME, RTLD_NOW );
   if(pServiceHandle == NULL)
   {
       TraceString("Try to load %s in PID:%d",OSAL_BINDER_LIB_NAME,getpid());
       return -1;
   }
   else
   {
      pGetAShMem       = (tpGetAShMem)(dlsym(pServiceHandle, (const char*)"s32GetAndroidSharedMemory"));
      pRelAShMem       = (tpRelAShMem)(dlsym(pServiceHandle, (const char*)"s32RelAndroidSharedMemory"));
      pCheckService    = (tpCheckService)(dlsym(pServiceHandle, (const char*)"CheckForOsalService"));
      pCreateService   = (tpConnectService)(dlsym(pServiceHandle, (const char*)"InitServerProcess"));
      pConnectService  = (tpConnectService)(dlsym(pServiceHandle, (const char*)"InitClientProcess"));
      pSwitchOnOff     = (tpSwitchOnOff)(dlsym(pServiceHandle, (const char*)"Switch"));
       
      if((pOsalBinderBacktrace = (tpOsalBinderBacktrace)(dlsym(pServiceHandle, (const char*)"OsalBinderBacktrace"))) ==NULL)
      {
         TraceString("OSAL addon function %s not fount in %s -> %s","OsalBinderBacktrace",OSAL_BINDER_LIB_NAME,dlerror());
      }
      if((!pCreateService)||(!pConnectService)||(!pCheckService)||(!pGetAShMem)||(!pRelAShMem))
      {
         TraceString("OSAL functions not fount in %s -> %s",OSAL_BINDER_LIB_NAME,dlerror());
         dlclose(pServiceHandle);
         return -1;
      }
      else
      {
         return 0;
      }
   }
}

#ifdef __cplusplus
}
#endif


#endif


/************************************************************************
|end of file
|-----------------------------------------------------------------------*/
