/************************************************************************
| FILE:         osalmqueue.h
| PROJECT:      platform
| SW-COMPONENT: OSAL
|------------------------------------------------------------------------
| DESCRIPTION:  This is the header file for RB tree definitions
|
|------------------------------------------------------------------------
| COPYRIGHT:    (c) 2016 Robert Bosch GmbH
| HISTORY:
| Date      | Modification               | Author
| 10.07.16  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----

|************************************************************************/
#if !defined (OSALMQUEUE_HEADER)
   #define OSALMQUEUE_HEADER

/************************************************************************
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************
| feature configuration
| (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|defines and macros (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototypes (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************/
/* function for global OSAL Lock   configuration                        */
/************************************************************************/

/************************************************************************/
/* function for using specific OSAL Lock functions                      */
/************************************************************************/
#ifdef OSAL_RNG_BUF
OSAL_DECL tS32 OSAL_s32CreateRingBuffer(tCString coszName, tU32 u32Size,OSAL_tenAccess enAccess,OSAL_tMQueueHandle* pHandle);
OSAL_DECL tS32 OSAL_s32OpenRingBuffer(tCString coszName,OSAL_tenAccess enAccess,OSAL_tMQueueHandle* pHandle);
OSAL_DECL tS32 OSAL_s32CloseRingBuffer(OSAL_tMQueueHandle Handle);
OSAL_DECL tS32 OSAL_s32DeleteRingBuffer(tCString coszName);
OSAL_DECL tU32 OSAL_u32WriteToRingBuffer(OSAL_tMQueueHandle Handle,char* Buffer, tU32 Size,tU32 u32TimeOut);
OSAL_DECL tU32 OSAL_u32ReadFromRingBuffer(OSAL_tMQueueHandle Handle,char* Buffer, tU32 BufSize,tU32 u32TimeOut);
OSAL_DECL tS32 OSAL_u32RingBufferNotify(OSAL_tMQueueHandle Handle,OSAL_tpfCallback pCallback,tPVoid pvArg);
OSAL_DECL tS32 OSAL_s32RingBufferStatus( OSAL_tMQueueHandle Handle,tPU32 pu32Message);
#endif

#ifdef OSAL_SHM_MQ
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueCreate(tCString coszName, tU32 u32MaxMessages, tU32 u32MaxLength,OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueOpen(tCString coszName, OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueClose(OSAL_tMQueueHandle hMQ);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueDelete(tCString coszName);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueuePost(OSAL_tMQueueHandle hMQ, tPCU8 pcou8Msg, tU32 u32Length, tU32 u32Prio);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueWait(OSAL_tMQueueHandle hMQ, tPU8 pu8Buffer, tU32 u32Length, tPU32 pu32Prio, OSAL_tMSecond msec);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueNotify(OSAL_tMQueueHandle hMQ,OSAL_tpfCallback pCallback,tPVoid pvArg);
OSAL_DECL tS32 OSAL_s32ShMemMessageQueueStatus( OSAL_tMQueueHandle hMQ,tPU32 pu32MaxMessage,tPU32 pu32MaxLength,tPU32 pu32Message);
#endif

#ifdef OSAL_QNX_MQ
OSAL_DECL int QNX_MessageQueueCreate(tCString coszName, tU32 u32MaxMessages, tU32 u32MaxLength,OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ);
OSAL_DECL int QNX_MessageQueueDelete(tCString coszName);
OSAL_DECL int QNX_MessageQueueOpen(tCString coszName, OSAL_tenAccess enAccess, OSAL_tMQueueHandle* phMQ);
OSAL_DECL int QNX_MessageQueueClose(OSAL_tMQueueHandle hMQ);
OSAL_DECL int QNX_MessageQueuePost(OSAL_tMQueueHandle hMQ, tPCU8 pcou8Msg, tU32 u32Length, tU32 u32Prio);
OSAL_DECL int QNX_MessageQueueWait( OSAL_tMQueueHandle hMQ,tPU8 pu8Buffer,tU32 u32Length, tPU32 pu32Prio, OSAL_tMSecond msec);
OSAL_DECL int QNX_s32MessageQueueStatus(OSAL_tMQueueHandle hMQ, tPU32 pu32MaxMessages, tPU32 pu32MaxLength, tPU32 pu32Messages);
#endif

#ifdef __cplusplus
}
#endif

#else
#error osalmqueue.h included several times
#endif
