/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         writeprofilerAppComponent.h
  * @brief        This is header file contains writeprofiler Application Implemetation.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Timer.h"
#include "org/bosch/cm/lcm/lcmbaseappcomponent/LcmBaseAppComponent.h"

namespace excessive_write { namespace sources {

using namespace ::org::bosch::cm::lcm::lcmbaseappcomponent;

class writeprofilerAppComponent : public BaseComponent,
	private LcmApplicationControlIF
{
private:
DECLARE_CLASS_LOGGER( );

public:
writeprofilerAppComponent( );
virtual ~writeprofilerAppComponent( );
// ServiceAvailableIF implementation
virtual void onAvailable( const boost::shared_ptr < Proxy >& proxy,
                          const ServiceStateChange         & stateChange );

virtual void onUnavailable( const boost::shared_ptr < Proxy >& proxy,
                            const ServiceStateChange         & stateChange );

// TimerCallbackIF implementation
virtual void onExpired( asf::core::Timer                            & timer,
                        boost::shared_ptr < asf::core::TimerPayload > payload );

// LCM Interface implementation
virtual _NsmErrorStatus_e OnAppModeChange( _Nsm_Shutdown_Type_e newAppMode,
                                           _Nsm_Shutdown_Type_e oldAppMode );

virtual bool   OnAppWatchdog( );

virtual void   OnLcmRegistered( );

// handling persistency
virtual void onLoadPersistency( );

virtual void onSavePersistency( );

virtual void OnAppLifecycleRequestCompleteError( _NsmErrorStatus_e  error,
                                                 const std::string& name = "",
                                                 const std::string& message = "" );

virtual void OnAppLifecycleRequestCompleteResponse( _NsmErrorStatus_e response );

virtual void onAppRegisterShutdownClientError( _NsmErrorStatus_e  error,
                                               const std::string& name = "",
                                               const std::string& message = "" );

virtual void onAppRegisterShutdownClientResponse( _NsmErrorStatus_e response );

virtual void onAppUnRegisterShutdownClientError( _NsmErrorStatus_e  error,
                                                 const std::string& name = "",
                                                 const std::string& message = "" );

virtual void onAppUnRegisterShutdownClientResponse( _NsmErrorStatus_e response );

private:
LcmBaseAppComponent _lcmAppComponent;
};

}
}

