/*
 * types.h
 *
 *  Created on: Jul 4, 2019
 *      Author: RAP5COB
 */


#ifndef TYPES_H_
#define TYPES_H_
#include <stdint.h>
#include <stddef.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>

//Bytes to GB conversion
#define SIZE_IN_GB(x) (tU32)((x) >> 30 )
#define SIZE_IN_MB(x) (tU32)((x) >> 20 )


typedef int64_t       tS64;
typedef uint64_t      tU64;
typedef int32_t       tS32;
typedef uint32_t      tU32;
typedef uint8_t       tU8;
typedef char 		  tS8;
typedef char*		  tPS8;
typedef const char*	  tPC8;
typedef unsigned char tBool;
#define TRUE                        (1)
#define FALSE                       (0)


typedef enum
{
	REFRESH_NOERROR            =  0,
	REFRESH_INVALID_ARGUMENT   = -1,
	REFRESH_ACCESS_ERROR       = -2,
	REFRESH_OPEN_ERROR         = -3,
	REFRESH_NO_MEMORY          = -4,
	REFRESH_READ_ERROR         = -5,
	REFRESH_SEEK_ERROR         = -6,
	REFRESH_CONVERSION_ERROR   = -7,
	REFRESH_INVALID_FILESIZE   = -8,
	REFRESH_EMPTY_METAFILE     = -9,
	REFRESH_CORRUPTED_FILE     = -10,
	REFRESH_OUT_OF_RANGE       = -11,
	REFRESH_RENAME_ERROR       = -12,
	REFRESH_TOTALSIZE_ERROR    = -13,
	REFRESH_DEVICE_FOUND       = -14,
	REFRESH_NODEVICE           = -15,
	REFRESH_ERROR  			   = -16,
	REFRESH_NOT_NEEDED		   = 100,
	REFRESH_NEEDED			   = 101,
	URGENT_REFRESH_NEEDED	   = 102,
	URGENT_REFRESH_NOT_NEEDED  = 103	
}ErrorValues;

#ifdef __cplusplus
extern "C" {
#endif
tPC8 concatPath(tPC8 s1 , tPC8 s2);
tU32 u32AlignDeviceSize(tU32 num);
tS32 s32CheckAndCreateDir(tPC8 cMetaDataFilePath);

#ifdef __cplusplus
}
#endif
void tVSignalHandlerSetup();

tS32 s32CreateDirs(tPC8 s8Path,mode_t mode);


#endif /* TYPES_H_ */
