/***************************************************************************
*FILE        : inc2soc_testfunctions.h   
*
*SW-COMPONENT : Google Testing framework
*
*DESCRIPTION  : This file contains headers and macros for the inc2soc Google@target test cases for Gnss and POS
*               devices.
*
*AUTHOR       : Akshatha Nagaraju (RBEI/ECF1)
*
*COPYRIGHT    : (C) COPYRIGHT RBEI - All Rights Reserved
******************************************************************************/

#ifndef INC2SOC_GOOGLETEST_TARGET_HEADER
#define INC2SOC_GOOGLETEST_TARGET_HEADER

#include "gtest/gtest.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include <poll.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include "OsalConf.h"
#include "ostypes.h"
#include "grp.h"
#include "pwd.h"

/****************************************************************************
   Defines and Macros(scope: Local to file)
****************************************************************************/
#define SOCKET_PATH_GNSS "/tmp/sock_gnss"
#define SOCKET_PATH_POS "/tmp/sock_sensors"
#define CLIENT_MSG_QUE_POS "QueToClientPos"
#define CLIENT_MSG_QUE_GNSS "QueToClientGnss"
#define MAX_DATA (8192)
#define MAX_CLIENT_MESSAGE (2)
#define CLIENT_MSG_PRIO (1)
#define OSAL_CLIENT_WAITTIME ((OSAL_tMSecond)5000)
#define ERROR_VALUE (-1)

OSAL_tMQueueHandle hldMsgQueuePos=0;
OSAL_tMQueueHandle hldMsgQueueGnss=0;

OSAL_tMQueueHandle hldClientMsgQueuePos=0;
OSAL_tMQueueHandle hldClientMsgQueueGnss=0;


#endif

