#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"


#include "errmem.h"

const char  default_backup_devname[]=ERRMEM_FILE"_backup"; //OSAL_C_STRING_ERRMEM_AS_FILE;
char        devname[64];

#define ERRMEM_MAX_FILE_SIZE        (20 * 1024 * 1024) /* 10 KB Max Errmem File */

/*************************************/
/* TODO: Only applies to 'u32TraceAll' */
/* Overwriting using the registry is not supported */
tVoid HandleMaxErrMemFilesize(tS32 u32Size){

  struct stat trFileStatInfo;
  int nError = stat(ERRMEM_FILE, &trFileStatInfo);
  if(nError >= 0){
    if(u32Size == 0)u32Size = ERRMEM_MAX_FILE_SIZE;
    if(u32Size < trFileStatInfo.st_size){
      TraceString("ERRMEM: Current Errmem Filesize = %d KB --> rename !", trFileStatInfo.st_size >> 10);

      nError = rename(ERRMEM_FILE, default_backup_devname);
      if(nError < 0){
      TraceString("ERRMEM: rename error:  (errno:%d)", errno);
      }

    }    
  }else{
      TraceString("ERRMEM: stat error:  (errno:%d)", errno);
  }
  return;
}

tS32 ERRMEM_S32IOOpen_File(tS32 s32Id, tCString szName, 
                      OSAL_tenAccess enAccess, uintptr_t *pu32FD,
                      tU16 app_id)
{
    int                 fd;
    (void)app_id;
    (void)s32Id;
    (void)szName;

    *pu32FD = 0;
    if((enAccess == 0)||(enAccess > OSAL_EN_READWRITE))
    {
       return(OSAL_E_INVALIDVALUE); 
    }
    fd = open(ERRMEM_FILE, O_CREAT | O_RDWR | O_APPEND, OSAL_ACCESS_RIGTHS);
    if (fd != -1)
    {
		*pu32FD = (tU32)fd;
		return OSAL_E_NOERROR;
    }
    else
    {
        return OSAL_E_DOESNOTEXIST;
    }
}

tS32 ERRMEM_S32IOClose_File(tS32 s32ID, uintptr_t u32FD)
{
   (void) s32ID;
   tS32 n = close((int)u32FD);

   if(n == 0)
      return OSAL_E_NOERROR;
   
   return OSAL_E_UNKNOWN;
}

tS32 ERRMEM_s32IORead_File(tS32 s32ID, uintptr_t u32FD, tPS8 buffer,
                      tU32 size, uintptr_t *ret_size)
{
    (void) s32ID;
    intptr_t n = read((int)u32FD, buffer, size);
    if(n == 0) 		
    {
           return OSAL_E_IOERROR;
    }
    *ret_size = (uintptr_t)n;
    return (tS32)n;
}

tS32 ERRMEM_s32IOWrite_File(tS32 s32ID, uintptr_t u32FD, tPCS8 buffer,tU32 size, uintptr_t *ret_size)
{
    (void) s32ID;
    *ret_size = (uintptr_t)write((int)u32FD, buffer, size);
    if (*ret_size > 0)
    {
	    (void)fsync((int)u32FD);
    }
    return (tS32)*ret_size;
}

tS32 ERRMEM_s32IOControl_File(tS32 s32ID, uintptr_t u32fd, tS32 io_func, intptr_t param)
{
    intptr_t *version;
    tS32 rc = OSAL_E_NOTSUPPORTED;
    char errstr[64];
   (void) s32ID;

    switch (io_func)
    {
        case OSAL_C_S32_IOCTRL_VERSION:
            version = (intptr_t *)param;
            *version = 1;
            rc = OSAL_E_NOERROR;
            break;
        case OSAL_C_S32_IOCTRL_ERRMEM_CLEAR:
        	rc = ftruncate((int)u32fd, 0);
        	if( rc == -1)
        	{
        	    snprintf(errstr, sizeof(errstr),"OSAL_EM_ERASE error! (errno:%d)", errno);
        	    TraceString(errstr);
        	    rc = OSAL_E_IOERROR;
        	} else {
        		rc = OSAL_E_NOERROR;
        	}
        	break;
        default:
        	break;
    }
    return rc;
}


