/*******************************************************************************
*
* FILE:         dev_wup_inc.h
*
* SW-COMPONENT: Device Wake-Up
*
* PROJECT:      ADIT Gen3 Platform
*
* DESCRIPTION:  Local header with Inter-Node-Communication (INC) related
*               definitions.
*
* AUTHOR:       CM-AI/ECO3-Kalms
*
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _DEV_WUP_INC_H_
#define _DEV_WUP_INC_H_

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/* -------------------------------------------------------------------------- */
/* INC message related defines  (little endian, least significant byte first) */
/* -------------------------------------------------------------------------- */

#define DEV_WUP_C_U8_INC_MSG_CAT_MAJOR_VERSION_NUMBER                    ((tU8)   3)
#define DEV_WUP_C_U8_INC_MSG_CAT_MINOR_VERSION_NUMBER                    ((tU8)   0)

#define DEV_WUP_C_U8_INC_MSG_SEND                                        ((tU8)0x01)
#define DEV_WUP_C_U8_INC_MSG_RECEIVE                                     ((tU8)0x02)

// Message codes and lengths

#define DEV_WUP_C_U8_INC_MSGID_C_GET_DATA                                ((tU8)0x20)

#define DEV_WUP_C_U8_INC_MSGID_R_REJECT                                  ((tU8)0x21)
#define DEV_WUP_C_U8_INC_MSGLEN_R_REJECT                                 ((tU8)0x03)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_CTRL_RESET_EXECUTION           ((tU8)0x30)
                                                                              
#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_CTRL_RESET_EXECUTION           ((tU8)0x31)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_CTRL_RESET_EXECUTION          ((tU8)0x01)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_PROC_RESET_REQUEST             ((tU8)0x32)
                                                                              
#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_PROC_RESET_REQUEST             ((tU8)0x33)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_PROC_RESET_REQUEST            ((tU8)0x02)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_STARTUP_FINISHED               ((tU8)0x34)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_STARTUP_FINISHED               ((tU8)0x35)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_STARTUP_FINISHED              ((tU8)0x01)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_EXTEND_POWER_OFF_TIMEOUT       ((tU8)0x36)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_EXTEND_POWER_OFF_TIMEOUT       ((tU8)0x37)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_EXTEND_POWER_OFF_TIMEOUT      ((tU8)0x03)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_CPU_SUPERVISION_ERROR_WARNING  ((tU8)0x39)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_CPU_SUPERVISION_ERROR_WARNING ((tU8)0x02)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_WAKEUP_EVENT_ACK               ((tU8)0x42)
                                                                              
#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_WAKEUP_EVENT_ACK               ((tU8)0x43)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_WAKEUP_EVENT_ACK              ((tU8)0x03)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_WAKEUP_STATE_ACK               ((tU8)0x44)
                                                                              
#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_WAKEUP_STATE_ACK               ((tU8)0x45)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_WAKEUP_STATE_ACK              ((tU8)0x03)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_WAKEUP_STATE_VECTOR            ((tU8)0x47)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_WAKEUP_STATE_VECTOR           ((tU8)0x05)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_WAKEUP_STATE                   ((tU8)0x49)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_WAKEUP_STATE                  ((tU8)0x05)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_WAKEUP_EVENT                   ((tU8)0x4D)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_WAKEUP_EVENT                  ((tU8)0x04)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_WAKEUP_REASON                  ((tU8)0x4F)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_WAKEUP_REASON                 ((tU8)0x02)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_SHUTDOWN_IN_PROGRESS           ((tU8)0x50)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_SHUTDOWN_IN_PROGRESS           ((tU8)0x51)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_SHUTDOWN_IN_PROGRESS          ((tU8)0x01)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_SET_WAKEUP_CONFIG              ((tU8)0x52)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_SET_WAKEUP_CONFIG              ((tU8)0x53)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_SET_WAKEUP_CONFIG             ((tU8)0x05)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_DMVERITY_CHECK_RESULT          ((tU8)0x54)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_DMVERITY_CHECK_RESULT          ((tU8)0x55)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_DMVERITY_CHECK_RESULT         ((tU8)0x01)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_FASTSHUTDOWN_STATE             ((tU8)0x56)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_FASTSHUTDOWN_STATE             ((tU8)0x57)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_FASTSHUTDOWN_STATE            ((tU8)0x01)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_INDICATE_CLIENT_APP_STATE      ((tU8)0xC0)
                                                                              
#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_INDICATE_CLIENT_APP_STATE      ((tU8)0xC1)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_INDICATE_CLIENT_APP_STATE     ((tU8)0x06)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_STARTUP_INFO                   ((tU8)0xC3)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_STARTUP_INFO                  ((tU8)0x04)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_REQ_CLIENT_APP_STATE           ((tU8)0xC5)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_REQ_CLIENT_APP_STATE          ((tU8)0x02)

#define DEV_WUP_C_U8_INC_MSGID_SPMS_SPM_C_REQ_CLIENT_BOOT_MODE           ((tU8)0xC6)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_REQ_CLIENT_BOOT_MODE           ((tU8)0xC7)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_REQ_CLIENT_BOOT_MODE          ((tU8)0x02)

#define DEV_WUP_C_U8_INC_MSGID_SPM_SPMS_R_OPERATIONAL_STATE_REQ          ((tU8)0xC9)
#define DEV_WUP_C_U8_INC_MSGLEN_SPM_SPMS_R_OPERATIONAL_STATE_REQ         ((tU8)0x02)

#define DEV_WUP_C_U8_INC_MSGID_INVALID                                   ((tU8)0xFF)

// Message parameters

#define DEV_WUP_C_U8_GET_DATA_MODE_ALL_DATA                              ((tU8)0x00)
#define DEV_WUP_C_U8_GET_DATA_MODE_AS_SPECIFIED                          ((tU8)0x10)

#define DEV_WUP_C_U8_RESET_REASON_AP_INTENDED                            ((tU8)0x00)
#define DEV_WUP_C_U8_RESET_REASON_AP_EXCEPTIONAL                         ((tU8)0x01)

#define DEV_WUP_C_U8_SHUTDOWN_NOT_ALLOWED                                ((tU8)0x00)
#define DEV_WUP_C_U8_SHUTDOWN_ALLOWED                                    ((tU8)0x01)
#define DEV_WUP_C_U8_SHUTDOWN_CANCELED                                   ((tU8)0x02)


#define DEV_WUP_C_U8_REJECT_OK                                           ((tU8)0xFF)
#define DEV_WUP_C_U8_REJECT_NO_REASON                                    ((tU8)0x00)
#define DEV_WUP_C_U8_REJECT_UNKNOWN_MESSAGE                              ((tU8)0x01)
#define DEV_WUP_C_U8_REJECT_INVALID_PARAMETER                            ((tU8)0x02)
#define DEV_WUP_C_U8_REJECT_TEMPORARY_UNAVAILABLE                        ((tU8)0x03)
#define DEV_WUP_C_U8_REJECT_VERSION_MISMATCH                             ((tU8)0x04)
#define DEV_WUP_C_U8_REJECT_NOT_SUPPORTED                                ((tU8)0x05)
#define DEV_WUP_C_U8_REJECT_SEQUENCE_ERROR                               ((tU8)0x06)

#define DEV_WUP_C_U8_MSG_CAT_VERSION_CHECK_RESULT_OK                     ((tU8)0x01)
#define DEV_WUP_C_U8_MSG_CAT_VERSION_CHECK_RESULT_MISMATCH               ((tU8)0x04)

#define DEV_WUP_C_U8_BOOT_MODE_EMMC                                      ((tU8)0x00)
#define DEV_WUP_C_U8_BOOT_MODE_USB                                       ((tU8)0x01)

#define DEV_WUP_C_U8_PREVENT_VCC_RESET_BITMASK_ALL                       ((tU8)0x01)
#define DEV_WUP_C_U8_PREVENT_VCC_RESET_BITMASK_COM_WD                    ((tU8)0x02)

/* -------------------------------------------------------------------------- */

#endif //_DEV_WUP_INC_H_
