/************************************************************************
 | FILE:         cdaudio_cdtext.h
 | PROJECT:      Gen2
 | SW-COMPONENT: CDAUDIO driver
 |------------------------------------------------------------------------*/
/* ******************************************************FileHeaderBegin** *//**
 * @file    cdaudio_cdtext.h
 *
 * @brief   This file includes cd-text stuff for the cdaudio driver.
 *
 * @author  srt2hi
 *
 * @date
 *
 * @version
 *
 * @note
 *  &copy; Bosch
 *
 *//* ***************************************************FileHeaderEnd******* */

#if !defined (CDAUDIO_CDTEXT_H)
#define CDAUDIO_CDTEXT_H

/************************************************************************
 | includes of component-internal interfaces
 | (scope: component-local)
 |-----------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif

/************************************************************************
 |defines and macros (scope: global)
 |-----------------------------------------------------------------------*/
#define CDAUDIO_CDTEXT_MAX_TRACK_NUMBER 99  /*track 0 - 99*/
/*
 * The first 4 bytes of CD text raw data contain special information.
 * The first 2 bytes contain the size of the raw data excluding itself(2 bytes).
 * The 3rd byte contains the track number of the first track and the 4th byte
 * contains the track number of the last track. 0th Track indicates the Album Name.
 */
#define CDAUDIO_CDTEXT_ATA_BUFFER_TEXTDATA_OFFSET 4
#define CDAUDIO_CDTEXT_SIZE_BYTE_OFFSET           2
/* 
 * The CD text raw data is divided into packets.
 * There are 18 bytes per packet.
 */
#define CDAUDIO_CDTEXT_ATA_BUFFER_BYTES_PER_LINE  18
/* 
 * The first 4 bytes of a packet are 4 headers. The first header indicates
 * the type of information(Track or artist) that the packet contains. 0x80 
 * means the packet contains Track/Album Name and 0x81 indicates that it 
 * contains the information about the Artist. The second 
 * header when masked with 0x7F gives the track number to which the 1st byte of
 * CD Text (12 bytes after headers) info belongs to. The third header contains 
 * the sequence number of the packet. The fourth header when masked with 0x0F
 * gives the number of bytes of the current track(2nd header) present in the
 * previous packet.
 */
#define CDAUDIO_CDTEXT_PACKET_TEXT_OFFSET         4
#define CDAUDIO_CDTEXT_ATA_BUFFER_TRACKNO_MASK    0x7f
#define CDAUDIO_CDTEXT_ATA_BUFFER_CHARPOS_MASK    0x0f
/* 
 * The next 12 bytes contain CD Text that is the  Track name or
 * artist name strings. The last 2 bytes are CRC fields.
 */
#define CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE   12

#define CDAUDIO_ATA_MAX_CD_TRACK_TITLE_SIZE  128
//#define CDAUDIO_ARRAY_SIZE(ar) (sizeof(ar) / sizeof(ar[0]))

/************************************************************************
 |typedefs and struct defs (scope: global)
 |-----------------------------------------------------------------------*/

/************************************************************************
 | variable declaration (scope: global)
 |-----------------------------------------------------------------------*/

/************************************************************************
 |function prototypes (scope: global)
 |-----------------------------------------------------------------------*/

tU32 CDAUDIO_u32CDTextInit(tDevCDData *pShMem);
tVoid CDAUDIO_vCDTextDestroy(tDevCDData *pShMem);
tVoid CDAUDIO_vCDTEXTClear(tDevCDData *pShMem);
tVoid CDAUDIO_vCDTEXTDebug(tDevCDData *pShMem);

tU32 CDAUDIO_u32GetText(tDevCDData *pShMem, OSAL_tSemHandle hSem, tU8 u8Track,
                        tU8 *pu8Title, tU8 *pu8Artist, tU32 u32TextBufferSize);

#ifdef __cplusplus
}
#endif

#else //CDAUDIO_CDTEXT_H
#error cdaudio_cdtext.h included several times
#endif //#else //CDAUDIO_CDTEXT_H
