

#ifndef OSAL_EXT_H
#define OSAL_EXT_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define USE_IMPLICIT_TRACE_INITIALIZATION


void OSEXAssert(bool value);

class MsgList;

class OSEXSemaphore
{
   private:
      OSAL_tSemHandle m_hSem;

      static const tU32 C_NAME_LENGTH = 256;
      tC8 m_szName[C_NAME_LENGTH];

   public:
      static const unsigned int C_TIMEOUT_FOREVER = OSAL_C_U32_INFINITE;

      enum tenSemResult
      {
         EN_RES_OK,
         EN_RES_ERROR,
         EN_RES_TIMEOUT
      };

      OSEXSemaphore(tU32 u32InitialValue = 0);
      virtual ~OSEXSemaphore();

      tenSemResult enWait(unsigned int u32TimeOut = C_TIMEOUT_FOREVER);
      void vPost();

   private:
      bool bInit(tU32 u32InitialValue);
};


class OSEXMutex : private OSEXSemaphore
{
   private:
      tU32 m_u32Counter;

   public:
      OSEXMutex();
      virtual ~OSEXMutex();

      void vLock();
      void vUnlock();

   private:
      bool bInit();//lint !e1511
};



class OSEXMsgQueue
{
   public:
      class OSEXMessage
      {
      private:
         tU32 m_u32MsgType;
         void *m_pPayload;

      public:
         OSEXMessage (tU32 u32MsgType, void *pPayload)
            : m_u32MsgType (u32MsgType)
            , m_pPayload (pPayload)
         {
         }

         tU32 u32GetType()
         {
            return m_u32MsgType;
         }

         void *pGetPayload()
         {
            return m_pPayload;
         }
      };

   private:
      OSEXSemaphore m_oListSemaphore;
      OSEXMutex     m_oListMutex;

      MsgList *m_poMsgList;

   public:
      static const unsigned int C_TIMEOUT_FOREVER = OSAL_C_U32_INFINITE;

      OSEXMsgQueue();
      virtual ~OSEXMsgQueue();

      /**
      *  @return Pointer to Message or NULL if timeout occurs
      */
      OSEXMessage *poWaitMessage (unsigned int u32Timeout = C_TIMEOUT_FOREVER);

      /**
      *  sends a message to receiver.
      */
      void vAddMessage (OSEXMessage *poMsg);

};





class OSEXThread
{
   public:
      class OSEXRunnable
      {
         public:
            virtual ~OSEXRunnable();
            virtual void run() = 0;
      };

   private:
      OSEXRunnable *m_poRunnable;
      OSAL_tThreadID m_hThread;

      OSEXMutex m_oMutex;
      OSEXSemaphore m_oSemaphore;
      tU32 m_u32NumberOfJoiners;

   public:
      OSEXThread(OSEXRunnable *poRunnable);
      virtual ~OSEXThread();

      bool bStart(const char *szName = NULL, tS32 s32Stack = 10000, tU32 u32Prio = OSAL_C_U32_THREAD_PRIORITY_NORMAL);
      void vJoin();

   private:
      static void vEntryHelper(void *__this);
      void vThreadDone();
};


#define OSEX_USE_TRACE  static OSEXTrace s_oOSEXTrace
#define OSEXTRACE(x) s_oOSEXTrace.vTrace x;


class OSEXTrace
{
   private:
      OSAL_tIODescriptor m_hTrace;

#ifdef USE_IMPLICIT_TRACE_INITIALIZATION
      tU32 m_u32InitWaiters;
#endif

   public:
      OSEXTrace();
      ~OSEXTrace();

      void vTrace (TR_tenTraceClass enClass, TR_tenTraceLevel enLevel, const char *szFmt, ...);
      bool bIsActive (TR_tenTraceClass enClass, TR_tenTraceLevel enLevel);

   private:
      void vCheckHandle();
};




#endif      //   OSAL_EXT_H


