#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "osalex.h"

#include <list>


//do not extent class MsgList; its only there to hide usage of stl from header file 
class MsgList : public std::list<OSEXMsgQueue::OSEXMessage *>
{
};

void OSEXAssert(bool value)
{
   if (value == false)
   {
      int *p = 0;
      *p = 5;//lint !e413
   }
}



OSEXSemaphore::OSEXSemaphore(tU32 u32InitialValue)
{
   if (bInit(u32InitialValue) == false)
   {
      OSEXAssert(0);
   }
}


OSEXSemaphore::~OSEXSemaphore()
{
   OSAL_s32SemaphoreClose(m_hSem);
   m_hSem = OSAL_E_INVALIDVALUE;
   OSAL_s32SemaphoreDelete(m_szName);
   m_szName[0] = '\0';
}


bool OSEXSemaphore::bInit(tU32 u32InitialValue)
{
   bool bSuccess = false;
   
   static tU32 s_u32Id = 0;
   OSALUTIL_s32SaveNPrintFormat( m_szName, C_NAME_LENGTH, "OSEXSem_0x%X_%03u_0x%X", 
                                 OSAL_ProcessWhoAmI(),
                                 s_u32Id++,
                                 this);

   if (OSAL_s32SemaphoreCreate(m_szName, &m_hSem, u32InitialValue) == OSAL_OK)
   {
      bSuccess = true;
   }
   return bSuccess;
}


OSEXSemaphore::tenSemResult OSEXSemaphore::enWait(unsigned int u32TimeOut)
{
   tenSemResult enResult = EN_RES_ERROR;
   
   if (OSAL_s32SemaphoreWait(m_hSem, u32TimeOut) == OSAL_ERROR)
   {
      if (OSAL_u32ErrorCode() == OSAL_E_TIMEOUT)
      {
         enResult = EN_RES_TIMEOUT;
      }
   }
   else
   {
      enResult = EN_RES_OK;
   }
   return enResult;
}


void OSEXSemaphore::vPost()
{
   OSAL_s32SemaphorePost(m_hSem);
}


OSEXMutex::OSEXMutex()
: OSEXSemaphore(1)
, m_u32Counter(0)
{
}


OSEXMutex::~OSEXMutex()
{
}


void OSEXMutex::vLock()
{
   OSEXSemaphore::enWait();
   if (++m_u32Counter != 1)
   {
      OSEXAssert(0);
   }
}



void OSEXMutex::vUnlock()
{
   if (--m_u32Counter != 0)
   {
      OSEXAssert(0);
   }
   OSEXSemaphore::vPost();
}



OSEXMsgQueue::OSEXMsgQueue()
{
   m_poMsgList = new MsgList();
}


OSEXMsgQueue::~OSEXMsgQueue()
{
   delete m_poMsgList;
   m_poMsgList = 0;
}


OSEXMsgQueue::OSEXMessage *OSEXMsgQueue::poWaitMessage (unsigned int u32Timeout)
{
   OSEXMessage *poResult = NULL;

   if (m_oListSemaphore.enWait(u32Timeout) == OSEXSemaphore::EN_RES_OK)
   {
      m_oListMutex.vLock();
      poResult = m_poMsgList->front();
      m_poMsgList->pop_front();
      m_oListMutex.vUnlock();
   }

   return poResult;
}


void OSEXMsgQueue::vAddMessage (OSEXMsgQueue::OSEXMessage *poMsg)
{
   m_oListMutex.vLock();
   m_poMsgList->push_back (poMsg);
   m_oListSemaphore.vPost();
   m_oListMutex.vUnlock();
}



    
OSEXThread::OSEXThread(OSEXThread::OSEXRunnable *poRunnable)
: m_poRunnable (poRunnable)
, m_hThread(OSAL_ERROR)
, m_u32NumberOfJoiners(0)
{
}


OSEXThread::~OSEXThread()
{
   vJoin();
}

OSEXThread::OSEXRunnable::~OSEXRunnable()
{
}

void OSEXThread::vEntryHelper(void *__this)
{
   OSEXThread *_this = (OSEXThread *) __this;
   _this->m_poRunnable->run();

   _this->vThreadDone();
}


bool OSEXThread::bStart(const char *szName, tS32 s32Stack, tU32 u32Prio)
{
   bool bSuccess = false;
   
   m_oMutex.vLock();
   if (m_hThread == OSAL_ERROR)
   {
      tC8 szGenName[256];
      static tU32 s_u32Id = 0;
      OSALUTIL_s32SaveNPrintFormat( szGenName, 256, "OSEXThread_0x%X_0x%X_%03u", 
                                    OSAL_ProcessWhoAmI(), 
                                    OSAL_ThreadWhoAmI(), 
                                    s_u32Id++  );

      OSAL_trThreadAttribute rAttr ;
      rAttr.szName            = (szName == NULL) ? szGenName : (tC8 *)szName;
      rAttr.u32Priority       = u32Prio;
      rAttr.s32StackSize      = s32Stack;
      rAttr.pfEntry           = OSEXThread::vEntryHelper;
      rAttr.pvArg             = this;
      m_hThread = OSAL_ThreadSpawn(&rAttr);

      if (m_hThread != OSAL_ERROR)
      {
         bSuccess = true;
      }
   }
   m_oMutex.vUnlock();

   return bSuccess;
}


void OSEXThread::vJoin()
{
   if (m_hThread != OSAL_ThreadWhoAmI())
   {
      bool bDoWait = false;

      // Als Joiner anmelden...
      m_oMutex.vLock();
      if (m_hThread != OSAL_ERROR)
      {
         bDoWait = true;
         ++m_u32NumberOfJoiners;
      }
      m_oMutex.vUnlock();

      if (bDoWait == true)
      {
         m_oSemaphore.enWait();
      }
   }
   else
   {
      OSEXTrace oTrace;
      oTrace.vTrace ((TR_tenTraceClass) 0, (TR_tenTraceLevel) 0, "OSEXThread::vJoin, Critical: Thread with id=%u tries to join itself!", m_hThread);
   }
}


void OSEXThread::vThreadDone()
{
   m_oMutex.vLock();

   while (m_u32NumberOfJoiners > 0)
   {
      m_oSemaphore.vPost();
      --m_u32NumberOfJoiners;
   }

   m_hThread = OSAL_ERROR;

   m_oMutex.vUnlock();

   // because of self Termination...
   OSAL_vThreadExit();
}




OSEXTrace::OSEXTrace()
: m_hTrace ( OSAL_ERROR )
#ifdef USE_IMPLICIT_TRACE_INITIALIZATION
, m_u32InitWaiters (0)
#endif
{
#ifndef USE_IMPLICIT_TRACE_INITIALIZATION
   m_hTrace = OSAL_IOOpen("/dev/trace", OSAL_EN_WRITEONLY);
#endif
}


OSEXTrace::~OSEXTrace()
{
#ifndef USE_IMPLICIT_TRACE_INITIALIZATION
   /*
    * When implizit -> dont close handles!
    * This of course will give resource-leaks,
    * but this feature is meant for the case, that static objects
    * are not allowed to call OSAL-Functions in destructors or constructors!
    */
   if (m_hTrace != OSAL_ERROR)
   {
      OSAL_s32IOClose(m_hTrace);
      m_hTrace = OSAL_ERROR;
   }
#endif
}

//lint -e{40,10,1055}
void OSEXTrace::vTrace (TR_tenTraceClass enClass, TR_tenTraceLevel enLevel, const char *szFmt, ...)
{
   vCheckHandle();
   if (m_hTrace != OSAL_ERROR && bIsActive (enClass, enLevel) == true)
   {
      char tmp[256];
      OSAL_tVarArgList arglist;
      OSAL_VarArgStart(arglist, szFmt);
      OSALUTIL_s32SaveVarNPrintFormat (tmp, 256, szFmt, arglist);
      OSAL_VarArgEnd(arglist);
      char tmp2[256];
      OSALUTIL_s32SaveNPrintFormat (tmp2, 256, "tid=%u %s", OSAL_ThreadWhoAmI(), tmp);
      OSALUTIL_s32TraceWrite(m_hTrace, enLevel, enClass, (tPCS8) tmp2, OSAL_u32StringLength(tmp2)+1);
   }
}


bool OSEXTrace::bIsActive (TR_tenTraceClass enClass, TR_tenTraceLevel enLevel)
{
   bool bActive = false;

   vCheckHandle();
   if (m_hTrace != OSAL_ERROR)
   {
      OSAL_trIOCtrlActivTrace rtrIOCtrlActivTrace;

      rtrIOCtrlActivTrace.enTraceClass = enClass;
      rtrIOCtrlActivTrace.enTraceLevel = enLevel;
      rtrIOCtrlActivTrace.bIsActive = FALSE;
      if (     OSAL_s32IOControl (m_hTrace, OSAL_C_S32_IOCTRL_ISACTIVE, (intptr_t)&rtrIOCtrlActivTrace) == OSAL_OK
            && rtrIOCtrlActivTrace.bIsActive == TRUE )
      {
         bActive = true;
      }
   }
   return bActive;
}


void OSEXTrace::vCheckHandle()
{
#ifdef USE_IMPLICIT_TRACE_INITIALIZATION
   if (m_hTrace == OSAL_ERROR)
   {
      /*
       *  Semaphore erzeugen
       *  wenn erzeugen nicht klappt (weil already existing)
       *    -> jemand anders erzeugt gerade das Handle
       */
      char szInitName[256];
      char szWaitName[256];
      char szAckName[256];
      char szAckOkName[256];
      OSALUTIL_s32SaveNPrintFormat (szInitName,   256, "OSEXTRACE_INIT_0x%08X", this);
      OSALUTIL_s32SaveNPrintFormat (szWaitName,   256, "OSEXTRACE_WAIT_0x%08X", this);
      OSALUTIL_s32SaveNPrintFormat (szAckName,    256, "OSEXTRACE_ACK_0x%08X", this);
      OSALUTIL_s32SaveNPrintFormat (szAckOkName,  256, "OSEXTRACE_ACKOK_0x%08X", this);

      OSAL_tSemHandle hSemInit   = OSAL_C_INVALID_HANDLE;
      OSAL_tSemHandle hWaitInit  = OSAL_C_INVALID_HANDLE;
      OSAL_tSemHandle hAckInit   = OSAL_C_INVALID_HANDLE;
      OSAL_tSemHandle hAckOkInit = OSAL_C_INVALID_HANDLE;
      
      if (OSAL_s32SemaphoreCreate(szInitName, &hSemInit, 0) == OSAL_OK)
      {
         m_hTrace = OSAL_IOOpen("/dev/trace", OSAL_EN_WRITEONLY);

         OSAL_s32SemaphoreClose(hSemInit);
         OSAL_s32SemaphoreDelete(szInitName);

         /*
          *  Versuche, Zugriff auf die m_u32InitWaiters zu bekommen...
          */
         if (OSAL_s32SemaphoreCreate(szWaitName, &hWaitInit, 0) == OSAL_ERROR)
         {
            if (OSAL_s32SemaphoreOpen(szWaitName, &hWaitInit) == OSAL_ERROR)
            {
               // this is bad...
               OSEXAssert(0);
            }
            else
            {
               // Wenn ich die Semaphore selbst erzeugt habe, hat sie schon
               // den Wert "0"... also besitze ich sie dann schon!
               OSAL_s32SemaphoreWait(hWaitInit, OSAL_C_U32_INFINITE);
            }
         }

         if (OSAL_s32SemaphoreCreate(szAckName, &hAckInit, 0) == OSAL_ERROR)
         {
            if (OSAL_s32SemaphoreOpen(szAckName, &hAckInit) == OSAL_ERROR)
            {
               // this is bad...
               OSEXAssert(0);
            }
         }

         if (OSAL_s32SemaphoreCreate(szAckOkName, &hAckOkInit, 0) == OSAL_ERROR)
         {
            if (OSAL_s32SemaphoreOpen(szAckOkName, &hAckOkInit) == OSAL_ERROR)
            {
               // this is bad...
               OSEXAssert(0);
            }
         }

         while (m_u32InitWaiters > 0)
         {
            tU32 u32Posted = 0;
            while (m_u32InitWaiters > 0)
            {
               --m_u32InitWaiters;
               ++u32Posted;
               OSAL_s32SemaphorePost(hAckInit);
            }
            OSAL_s32SemaphorePost(hWaitInit);
            
            while (u32Posted > 0)
            {
               --u32Posted;
               OSAL_s32SemaphoreWait(hAckOkInit, OSAL_C_U32_INFINITE);
            }
            
            OSAL_s32SemaphoreWait(hWaitInit, OSAL_C_U32_INFINITE);
         }
         OSAL_s32SemaphorePost(hWaitInit);

         OSAL_s32SemaphoreClose(hWaitInit);
         OSAL_s32SemaphoreDelete(szWaitName);
         
         OSAL_s32SemaphoreClose(hAckInit);
         OSAL_s32SemaphoreDelete(szAckName);
         
         OSAL_s32SemaphoreClose(hAckOkInit);
         OSAL_s32SemaphoreDelete(szAckOkName);
      }
      else
      {
         /*
          *  Versuche, Zugriff auf die m_u32InitWaiters zu bekommen...
          */
         if (OSAL_s32SemaphoreCreate(szWaitName, &hWaitInit, 0) == OSAL_ERROR)
         {
            if (OSAL_s32SemaphoreOpen(szWaitName, &hWaitInit) == OSAL_ERROR)
            {
               // mmh... das haette jetzt eigentlich nicht sein sollen...
               // keine Ahnung was ich jetzt machen soll...
               return;
            }
            else
            {
               // Wenn ich die Semaphore selbst erzeugt habe, hat sie schon
               // den Wert "0"... also besitze ich sie dann schon!
               OSAL_s32SemaphoreWait(hWaitInit, OSAL_C_U32_INFINITE);
            }
         }

         if (m_hTrace != OSAL_ERROR)
         {
            // Mittlerweile ist das Handle offen...
            OSAL_s32SemaphorePost(hWaitInit);
            OSAL_s32SemaphoreClose(hWaitInit);
            hWaitInit = OSAL_C_INVALID_HANDLE;
         }

         if (hWaitInit != OSAL_C_INVALID_HANDLE)
         {
            ++m_u32InitWaiters;

            if (OSAL_s32SemaphoreCreate(szAckName, &hAckInit, 0) == OSAL_ERROR)
            {
               if (OSAL_s32SemaphoreOpen(szAckName, &hAckInit) == OSAL_ERROR)
               {
                  // jetzt weiss ich auch nicht mehr...
                  // aber zumindest den m_u32InitWaiters wieder absenken...
                  --m_u32InitWaiters;
                  OSAL_s32SemaphorePost(hWaitInit);
                  OSAL_s32SemaphoreClose(hWaitInit);
                  return;
               }
            }
            if (OSAL_s32SemaphoreOpen(szAckOkName, &hAckOkInit) == OSAL_ERROR)
            {
               // jetzt weiss ich auch nicht mehr...
               // aber zumindest den m_u32InitWaiters wieder absenken...
               --m_u32InitWaiters;
               OSAL_s32SemaphorePost(hWaitInit);
               OSAL_s32SemaphoreClose(hWaitInit);

               OSAL_s32SemaphoreClose(hAckInit);
               return;
            }

            OSAL_s32SemaphorePost(hWaitInit);
            OSAL_s32SemaphoreClose(hWaitInit);

            OSAL_s32SemaphoreWait(hAckInit, OSAL_C_U32_INFINITE);
            OSAL_s32SemaphoreClose(hAckInit);

            OSAL_s32SemaphorePost  (hAckOkInit);
            OSAL_s32SemaphoreClose (hAckOkInit);
         }
      }
   }
#endif     //   USE_IMPLICIT_TRACE_INITIALIZATION
}

