#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/* --OSAL_tclThread. */

OSAL_tclThread::OSAL_tclThread():hThreadId(OSAL_ERROR)
{
   rThreadAttribute.szName = OSAL_NULL;
}

OSAL_tclThread::~OSAL_tclThread()
{
   if (rThreadAttribute.szName) 
      OSAL_vMemoryFree((tPVoid)rThreadAttribute.szName);
}

// --Diese Hilfsfunktion dient zum Anstarten einer berladenen Methode eines Threads (Tricky!!!)
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_PRE_FUNC
    #pragma push
    #pragma Ono_tailcall
#endif
tVoid OSAL_tclThread::vEntryHelper(tPVoid pvArg)
{
 #if (OSAL_OS!=OSAL_TENGINE)
	//8 Byte Align Stack Pointer
	ARM_EIGHTBYTEALIGNSTACKPOINTER

 #endif
		// --Als Parameter mu ein Zeiger auf ein OSAL_tclThread bergeben werden!!!
		OSAL_tclThread* poThread=(OSAL_tclThread*)pvArg;
		// --Rufe nun die Einstiegsmethode auf.         
		poThread->vEntry();

 #if (OSAL_OS!=OSAL_TENGINE)
	//restore original Stack Pointer
	ARM_RESTORESTACKPOINTER
 #endif
}
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_POST_FUNC
    #pragma pop
#endif

OSAL_tIODescriptor OSAL_tclThread::s32Create( tCString coszName, 
                                tU32 u32Priority,
                                tS32 s32Stacksize )
{
   return s32Build(OSAL_EN_CREATE , coszName, u32Priority, s32Stacksize);
}
OSAL_tThreadID OSAL_tclThread::s32Spawn( tCString coszName,
                                         tU32 u32Priority,
                                         tS32 s32Stacksize )
{
   return s32Build(OSAL_EN_SPAWN , coszName, u32Priority, s32Stacksize);
}

OSAL_tThreadID OSAL_tclThread::s32Build(OSAL_tenCreationType enCreationType,
                              tCString& coszrfName, 
                              tU32 u32Priority,
                              tS32 s32Stacksize)
{
   OSAL_tThreadID returnValue = OSAL_OK;
   do
   {
      if (OSAL_NULL == coszrfName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         returnValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         OSAL_ERROR: Dirty OSAL hack.
      */
      if (OSAL_ERROR != this->hThreadId)
      {
         /*
            There is a handle already stored in this object.
         */
         returnValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      if (NULL != this->rThreadAttribute.szName)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->rThreadAttribute.szName);
         this->rThreadAttribute.szName = NULL;
      }
      /*
         Save the name in the object.
      */
      returnValue = this->s32SaveName( coszrfName, this->rThreadAttribute.szName );
      if (OSAL_OK == returnValue)
      {
         this->rThreadAttribute.u32Priority=u32Priority;
         this->rThreadAttribute.s32StackSize = s32Stacksize; 
         this->rThreadAttribute.pfEntry=vEntryHelper; // <--Tricky!
         this->rThreadAttribute.pvArg=this; // <--Tricky!
         if (OSAL_EN_CREATE == enCreationType)
         {
            /*
               Call the OSAL function to create a new thread.
            */
            returnValue = OSAL_ThreadCreate( &this->rThreadAttribute ); //--create a new thread
         }
         else
         {
            /*
               Call the OSAL function to spawn a new thread.
            */
            returnValue = OSAL_ThreadSpawn( &this->rThreadAttribute ); //--create a new thread
         }
      }
      else
      {
         break;
      }
      if (OSAL_ERROR == returnValue)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->rThreadAttribute.szName );
         this->rThreadAttribute.szName = NULL;
      }
      else
      {
         /*
            Save the object internal values.
         
            Dirty OSAL hack.
         */
         this->hThreadId = returnValue;
         returnValue = OSAL_OK;
      }
   }
   while (FALSE);
   return returnValue;
}
tS32 OSAL_tclThread::s32Activate()
{
   return OSAL_s32ThreadActivate(hThreadId);
}
tS32 OSAL_tclThread::s32Delete()
{
   tS32 s32OsalResult = OSAL_ERROR;
   if (hThreadId != OSAL_ERROR)
   {
      s32OsalResult = OSAL_s32ThreadDelete(hThreadId);
   }
   else
   {
      //--thread does not exist
      OSAL_vSetErrorCode( OSAL_E_DOESNOTEXIST );
   }
   if (OSAL_NULL != this->rThreadAttribute.szName)
   {
      /*
         Delete the name string.
      */
      OSAL_vMemoryFree( (tPVoid)this->rThreadAttribute.szName);
      this->rThreadAttribute.szName = OSAL_NULL;
   }
   hThreadId = OSAL_ERROR;
   return s32OsalResult;
}
tS32 OSAL_tclThread::s32Suspend()
{
   return OSAL_s32ThreadSuspend(hThreadId);
}
tS32 OSAL_tclThread::s32Resume()
{
   return OSAL_s32ThreadResume(hThreadId);
}
tS32 OSAL_tclThread::s32SetPriority(tU32 u32Priority)
{
   this->rThreadAttribute.u32Priority=u32Priority;
   return OSAL_s32ThreadPriority(hThreadId,u32Priority);
}
tS32 OSAL_tclThread::s32GetThreadControlBlock(OSAL_trThreadControlBlock* prThreadControlBlock)
{
   return OSAL_s32ThreadControlBlock(hThreadId,prThreadControlBlock);
}
tS32 OSAL_tclThread::s32Wait(OSAL_tMSecond msec)
{
   return OSAL_s32ThreadWait(msec);
}
/* --OSAL_tclProcess. */

OSAL_tclProcess::OSAL_tclProcess():hProcessId(OSAL_ERROR)
{
   rProcessAttribute.szName= OSAL_NULL;
   rProcessAttribute.szAppName= OSAL_NULL;
   rProcessAttribute.szCommandLine = OSAL_NULL;
}

OSAL_tclProcess::~OSAL_tclProcess()
{
    vResetAttributes();
}

OSAL_tThreadID OSAL_tclProcess::s32Spawn(tCString szName,
                               tCString szAppName, 
                               tCString szCommandLine)
{
   intptr_t s32ErrorValue = OSAL_OK;
   do
   {
      if (( OSAL_NULL == szName )
          ||
          ( OSAL_NULL == szAppName )
          ||
          ( OSAL_NULL == szCommandLine ))
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         OSAL_ERROR: Dirty OSAL hack.
      */
      if (OSAL_ERROR != this->hProcessId)
      {
         /*
            There is a handle already stored in this object.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      /*
         Save the process name in the object.
      */
      s32ErrorValue = this->s32SaveName( szName, (tCString&)this->rProcessAttribute.szName );
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Save the application name in the object.
         */
         s32ErrorValue = this->s32SaveName( szAppName, (tCString&)this->rProcessAttribute.szAppName );
      }
      else
      {
         vResetAttributes();
         break;
      }
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Save the command line in the object.
         */
         s32ErrorValue = this->s32SaveName( szCommandLine, (tCString&)this->rProcessAttribute.szCommandLine );
      }
      else
      {
         vResetAttributes();
         break;
      }
      if (OSAL_ERROR == s32ErrorValue)
      {
         vResetAttributes();
         break;
      }
      else
      {
         s32ErrorValue = OSAL_ProcessSpawn(&rProcessAttribute);
      }
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Save the object internal values.
         
            Dirty OSAL hack.
         */
         this->hProcessId = s32ErrorValue;
         s32ErrorValue = OSAL_OK;
      }
      else
      {
         vResetAttributes();
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
tS32 OSAL_tclProcess::s32Delete()
{
   tS32 s32OsalResult = OSAL_ERROR;
   if (hProcessId != OSAL_ERROR)
   {
      s32OsalResult = OSAL_s32ProcessDelete(hProcessId);
      if (s32OsalResult != OSAL_ERROR)
      {
         vResetAttributes();
         hProcessId = OSAL_ERROR;
      }
   }
   else
   {
      //--process does not exist
      OSAL_vSetErrorCode( OSAL_E_DOESNOTEXIST );
   }
   return s32OsalResult;
}
tS32 OSAL_tclProcess::s32GetProcessControlBlock(OSAL_trProcessControlBlock* prProcessControlBlock)
{
   return OSAL_s32ProcessControlBlock(hProcessId,prProcessControlBlock);
}
/*
   This methode resets the member variable rProcessAttribute.
*/
tVoid OSAL_tclProcess::vResetAttributes()
{
   if (OSAL_NULL != rProcessAttribute.szName)
   {
      /*
         Delete the name string.
      */
      OSAL_vMemoryFree( (tPVoid)this->rProcessAttribute.szName);
      this->rProcessAttribute.szName = OSAL_NULL;
   }
   if (OSAL_NULL != rProcessAttribute.szAppName)
   {
      /*
         Delete the name string.
      */
      OSAL_vMemoryFree( (tPVoid)this->rProcessAttribute.szAppName);
      this->rProcessAttribute.szAppName = OSAL_NULL;
   }
   if (OSAL_NULL != rProcessAttribute.szCommandLine)
   {
      /*
         Delete the name string.
      */
      OSAL_vMemoryFree( (tPVoid)this->rProcessAttribute.szCommandLine);
      this->rProcessAttribute.szCommandLine = OSAL_NULL;
   }
}
