/************************************************************* +MHDR * .MA *

 .FILE             [ osalfile.cpp  ]

 .SW-COMPONENT      osal

 .DESCRIPTION
  This file includes the implementation of the class OSAL_tclFile

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTHOR               [ G. Stuebner                                      ]

 .HISTORY

  Date     | Name            Modification
 ----------|---------------------------------------------------------------
  15.01.02 | CM-DI/ESA2-Sb  New
  13.02.02 | CM-DI/EST-Wg   class definition changed
           |                (methode names, return values and algorithms 
           |                changed)            
************************************************************** -MHDR * .ME */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include<string>

OSAL_tclFile::OSAL_tclFile()
{
   this->hFileID    = OSAL_ERROR;
   this->szFileName = OSAL_NULL;
}
OSAL_tclFile::~OSAL_tclFile()
{
   if (hFileID != OSAL_ERROR)
   {
      OSAL_s32IOClose( this->hFileID );
   }
   OSAL_vMemoryFree( (tPVoid)this->szFileName);
   this->szFileName = NULL;
} 
OSAL_tIODescriptor OSAL_tclFile::s32Create(tCString coszName, OSAL_tenAccess enAccess)
{
   OSAL_tIODescriptor s32ErrorValue = OSAL_OK;
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         OSAL_ERROR: Dirty OSAL hack.
      */
      if (OSAL_ERROR != this->hFileID)
      {
         /*
            There is a handle already stored in this object.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      if (NULL != this->szFileName)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szFileName);
         this->szFileName = NULL;
      }
      s32ErrorValue = this->s32SaveName( coszName, this->szFileName );
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Call the OSAL function to create a new file.
         */
         s32ErrorValue = (tS32)OSAL_IOCreate(coszName, enAccess);
      }
      else
      {
         break;
      }
      if (OSAL_ERROR == s32ErrorValue)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szFileName);
         this->szFileName = NULL;
      }
      else
      {
         /*
            Save the object internal values.
         
            Dirty OSAL hack.
         */
         this->hFileID = s32ErrorValue;
         s32ErrorValue = OSAL_OK;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
tS32 OSAL_tclFile::s32Open(tCString coszName, OSAL_tenAccess enAccess)
{
   tS32 s32ErrorValue = OSAL_OK;
   /*
      This member stores temporary the name of the file.
   */
   tCString szTempName = this->szFileName;
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         Check whether there is already a handle saved in the object.
      
         OSAL_ERROR: Dirty OSAL hack.
      */
      if (OSAL_ERROR != this->hFileID)
      {
         /*
            Set the error to tell the user there exists already an 
            opened file.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_ALREADYEXISTS );
         break;
      }
      s32ErrorValue = this->s32SaveName( coszName, this->szFileName );
      /*
         Check whether there is already a name saved in the object.
      */
      if (OSAL_OK == s32ErrorValue)
      {
	     OSAL_tIODescriptor fd = OSAL_IOOpen( coszName, enAccess );
         if (OSAL_ERROR != fd)
         {
            /*
               Save the object internal values.
            
               OSAL_ERROR: Dirty OSAL hack.
            */
            this->hFileID = fd;
            /*
               Delete the new name string.
            */
            OSAL_vMemoryFree( (tPVoid)szTempName );
            s32ErrorValue = OSAL_OK;
         }
         else
         {
            /*
               Delete the new name string.
            */
            OSAL_vMemoryFree( (tPVoid)this->szFileName );
            /*
               Restore the last name.
            */
            this->szFileName = szTempName;
         }
      }
      else
      {
         /*
            Restore the last name.
         */
         this->szFileName = szTempName;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
tS32 OSAL_tclFile::s32Open(OSAL_tenAccess enAccess)
{
   tS32 s32ErrorValue = OSAL_OK;
   do
   {
      /*
         Check whether there is already a handle saved in the object.
      
         OSAL_ERROR: Dirty OSAL hack.
      */
      if (OSAL_ERROR != this->hFileID)
      {
         /*
            Set the error to tell the user there exists already an 
            opened file.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_ALREADYEXISTS );
         break;
      }
      if (NULL == this->szFileName)
      {
         /*
            Set the error to tell the user there is no name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      OSAL_tIODescriptor fd = OSAL_IOOpen( this->szFileName, enAccess );
      if (OSAL_ERROR == fd)
      {
         /*
            Initialise the internal value.
         
            OSAL_ERROR: Dirty OSAL hack.
         */
         this->hFileID = OSAL_ERROR;
      }
      else
      {
         /*
            Save the object internal value.
         
            OSAL_ERROR: Dirty OSAL hack.
         */
         this->hFileID = s32ErrorValue;
         s32ErrorValue = OSAL_OK;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
tS32 OSAL_tclFile::s32Close()
{
   tS32 s32ErrorValue = OSAL_OK;
   s32ErrorValue = OSAL_s32IOClose( this->hFileID );
   if (OSAL_OK == s32ErrorValue)
   {
      /*
         OSAL_ERROR: Dirty OSAL hack.
      */
      this->hFileID = OSAL_ERROR;
   }
   return s32ErrorValue;
}
tS32 OSAL_tclFile::s32Remove()
{
   tS32 s32ErrorValue = OSAL_OK;
   tU32 u32ErrorCode = OSAL_E_NOERROR;
   do
   {
      /*
         OSAL_ERROR: Dirty OSAL hack.
      */
      if (OSAL_ERROR != this->hFileID)
      {
         /*
            The file is still open. Close them.
         */
         s32ErrorValue = this->s32Close();
      }
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Reset the value of the handel.
         
            OSAL_ERROR: Dirty OSAL hack.
         */
         this->hFileID = OSAL_ERROR;
      }
      else
      {
         break;
      }
      s32ErrorValue = OSAL_s32IORemove( this->szFileName );
      u32ErrorCode = OSAL_u32ErrorCode();
      if (( OSAL_OK == s32ErrorValue )
          ||
          (
             ( OSAL_ERROR == s32ErrorValue )
             &&
             ( OSAL_E_DOESNOTEXIST == u32ErrorCode)
          ))
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szFileName);
         this->szFileName = NULL;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
tS32 OSAL_tclFile::s32Control(tS32 s32Fun, intptr_t s32Arg)
{
   tS32 s32OsalResult = OSAL_ERROR;
   if (this->hFileID != OSAL_ERROR)
   {
      s32OsalResult = OSAL_s32IOControl(hFileID, s32Fun, s32Arg);
   }
   else
   {
      //--file does not exist
          OSAL_vSetErrorCode( OSAL_E_NOFILEDESCRIPTOR );
   }
   return s32OsalResult;
}
tS32 OSAL_tclFile::s32Write(tPCS8 pcos8Buffer, tU32 u32Length)
{
   tS32 s32OsalResult = OSAL_ERROR;
   if (this->hFileID != OSAL_ERROR)
   {
      s32OsalResult = OSAL_s32IOWrite(hFileID, pcos8Buffer, u32Length);
   }
   else
   {
      //--file does not exist
          OSAL_vSetErrorCode( OSAL_E_NOFILEDESCRIPTOR );
   }
   return s32OsalResult;
}
tS32 OSAL_tclFile::s32Read(tPS8 ps8Buffer, tU32 u32MaxLength)
{
   tS32 s32OsalResult = OSAL_ERROR;
   if (this->hFileID != OSAL_ERROR)
   {
      s32OsalResult = OSAL_s32IORead(hFileID, ps8Buffer, u32MaxLength);
   }
   else
   {
      //--file does not exist
          OSAL_vSetErrorCode( OSAL_E_NOFILEDESCRIPTOR );
   }
   return s32OsalResult;
}
/*  
tS32 OSAL_tclFile::s32IOWriteAsync(OSAL_trAsyncControl* prAIO)
{
   return OSAL_s32IOWriteAsync(prAIO);
}

tS32 OSAL_tclFile::s32IOReadAsync(OSAL_trAsyncControl* prAIO)
{
   return OSAL_s32IOReadAsync(prAIO);
}

tS32 OSAL_tclFile::s32IOCancelAsync(OSAL_trAsyncControl* prAIO)
{
   return OSAL_s32IOCancelAsync(hFileID, prAIO);
}

tS32 OSAL_tclFile::s32IOErrorAsync(OSAL_trAsyncControl* prAIO)
{
   return OSAL_s32IOErrorAsync(prAIO);
}

tS32 OSAL_tclFile::s32IOReturnAsync(OSAL_trAsyncControl* prAIO)
{
   return
}
*/
tCString OSAL_tclFile::coszGetName() const
{
   return this->szFileName;
}

namespace osutilio
{
   bool getRealPath( const std::string& osalFileOrDir
                   , std::string& realFileOrDir )
   {
      OSAL_trOsalRealPath trRealPath;
      OSAL_tIODescriptor fd = OSAL_IOOpen( osalFileOrDir.c_str(), OSAL_EN_READONLY );

      realFileOrDir.clear();
      trRealPath.szRealPath[0] = 0;

      if( fd != OSAL_ERROR )
      {
        if( OSAL_ERROR != OSAL_s32IOControl( fd, OSAL_C_S32_IOCTRL_FIOGET_REAL_PATH, (intptr_t)&trRealPath ) )
        {
          realFileOrDir = (const char*)trRealPath.szRealPath;
        }
        (void)OSAL_s32IOClose( fd );
      }

      return !realFileOrDir.empty();
   }
}
