/************************************************************* +MHDR * .MA *

 .FILE             [ osevent.cpp  ]

 .SW-COMPONENT      osal

 .DESCRIPTION
  This file contains the implementation of the class OSAL_tclEvent.

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTHOR               [ U. Walkling                                      ]

 .HISTORY

  Date     | Name            Modification
 ----------|---------------------------------------------------------------
  28.01.02 | CM-DI/EST-Wg    New
  12.02.02 | CM-DI/EST-Wg    include osal.h replaced
  01.03.02 | CM-DI/EST-Wg    destructor: name deleted if exists
           |                 NULL -> OSAL_NULL
           |                 s32Close: check first the handle before calling
           |                 the OSAL-close function.
************************************************************** -MHDR * .ME */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/* Constructor of this class. */
OSAL_tclEvent::OSAL_tclEvent()
{
   /*
      Initialisation of the member variables of the class.
   */
   szName = OSAL_NULL;
   hEventHandle = OSAL_C_INVALID_HANDLE;
}
/* Destructor of this class. */
OSAL_tclEvent::~OSAL_tclEvent()
{
   this->s32Close();
   if (OSAL_NULL != this->szName)
   {
      /*
         Delete the name string.
      */
      OSAL_vMemoryFree( (tPVoid)this->szName);
      this->szName = OSAL_NULL;
   }
}
/*
   This methode creates a field of events. 
   If the creation of the field of events has finished without
   an error the s32Open methode is called afterwards.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)

   Additional Errors or meaning:
   OSAL_E_UNKNOWN: A handle already stored in this object.
   OSAL_E_NOSPACE: There is no space to save the name.
*/
tS32 OSAL_tclEvent::s32Create( tCString coszName /* I */)
{
   tS32 s32ErrorValue = OSAL_OK;
   /*
      This member stores the temporary handle of the field of events.
   */
   OSAL_tEventHandle hTempEventHandle = OSAL_C_INVALID_HANDLE;
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      if (OSAL_C_INVALID_HANDLE != this->hEventHandle)
      {
         /*
            There is a handle already stored in this object.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      if (OSAL_NULL != this->szName)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szName);
         this->szName = OSAL_NULL;
      }
      s32ErrorValue = this->s32SaveName( coszName, this->szName );
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Call the OSAL function to create the field of events.
         */
         s32ErrorValue = OSAL_s32EventCreate( coszName, 
                                              &hTempEventHandle);
      }
      else
      {
         break;
      }
      if (OSAL_ERROR == s32ErrorValue)
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szName);
         this->szName = OSAL_NULL;
      }
      /*
         Save the object internal Values.
      */
      this->hEventHandle = hTempEventHandle;
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode opens a field of events.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)

   Additional Errors or meaning:
   OSAL_E_ALREADYEXISTS: There exists already an opened field of events.
   OSAL_E_NOSPACE: There is no space to save the name.
*/
tS32 OSAL_tclEvent::s32Open( tCString coszName /* (I) */ )
{
   tS32 s32ErrorValue = OSAL_OK;
   /*
      This member stores the temporary handle of the field of events.
   */
   OSAL_tEventHandle hTempEventHandle = OSAL_C_INVALID_HANDLE;
   /*
      This member stores temporary the name of the field of events.
   */
   tCString szTempName = this->szName;
   do
   {
      if (OSAL_NULL == coszName)
      {
         /*
            There is a NULL pointer as name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_INVALIDVALUE );
         break;
      }
      /*
         Check whether there is already a handle saved in the object.
      */
      if (OSAL_C_INVALID_HANDLE != this->hEventHandle)
      {
         /*
            Set the error to tell the user there exists already an 
            opened field of events.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_ALREADYEXISTS );
         break;
      }
      s32ErrorValue = this->s32SaveName( coszName, this->szName );
      /*
         Check whether there is already a name saved in the object.
      */
      if (OSAL_OK == s32ErrorValue)
      {
         s32ErrorValue = OSAL_s32EventOpen( coszName, 
                                            &hTempEventHandle );
         if (OSAL_OK == s32ErrorValue)
         {
            /*
               Save the object internal values.
            */
            this->hEventHandle = hTempEventHandle;
            /*
               Delete the new name string.
            */
            OSAL_vMemoryFree( (tPVoid)szTempName );
         }
         else
         {
            /*
               Delete the new name string.
            */
            OSAL_vMemoryFree( (tPVoid)this->szName );
            /*
               Restore the last name.
            */
            this->szName = szTempName;
         }
      }
      else
      {
         /*
            Restore the last name.
         */
         this->szName = szTempName;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode opens a field of events with the name stored
   in this object.
   (This is an additional method!)

   Additional Errors or meaning:
   OSAL_E_ALREADYEXISTS: There exists already an opened field of events.
   OSAL_E_UNKNOWN: There is no name saved in the object. 
                   (Use s32Open( tCString coszName ) )
*/
tS32 OSAL_tclEvent::s32Open()
{
   tS32 s32ErrorValue = OSAL_OK;
   do
   {
      /*
         Check whether there is already a handle saved in the object.
      */
      if (OSAL_C_INVALID_HANDLE != this->hEventHandle)
      {
         /*
            Set the error to tell the user there exists already an 
            opened field of events.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_ALREADYEXISTS );
         break;
      }
      if (OSAL_NULL == this->szName)
      {
         /*
            Set the error to tell the user there is no name specified.
         */
         s32ErrorValue = OSAL_ERROR;
         OSAL_vSetErrorCode( OSAL_E_UNKNOWN );
         break;
      }
      s32ErrorValue = OSAL_s32EventOpen( this->szName, 
                                         &this->hEventHandle );
      if (OSAL_ERROR == s32ErrorValue)
      {
         /*
            Save the object internal values.
         */
         this->hEventHandle = OSAL_C_INVALID_HANDLE;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode closes a field of events.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
*/
tS32 OSAL_tclEvent::s32Close( )
{
   tS32 s32ErrorValue = OSAL_OK;
   if (OSAL_C_INVALID_HANDLE != this->hEventHandle)
   {
      s32ErrorValue = OSAL_s32EventClose( this->hEventHandle );
      if (OSAL_OK == s32ErrorValue)
      {
         this->hEventHandle = OSAL_C_INVALID_HANDLE;
      }
   }
   return s32ErrorValue;
}
/*
   This methode deletes the field of events. 
   Before deleting the field of events the methode s32Close will be
   performed to close the field of events. After performing this 
   methode this field of events object provides no event 
   functionality but it is possible to create a new field of events 
   in the same object.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
*/
tS32 OSAL_tclEvent::s32Delete( )
{
   tS32 s32ErrorValue = OSAL_OK;
   tU32 u32ErrorCode = OSAL_E_NOERROR;
   do
   {
      if (OSAL_C_INVALID_HANDLE != this->hEventHandle)
      {
         s32ErrorValue = this->s32Close();
      }
      if (OSAL_OK == s32ErrorValue)
      {
         /*
            Reset the value of the handel.
         */
         this->hEventHandle = OSAL_C_INVALID_HANDLE;
      }
      else
      {
         break;
      }
      s32ErrorValue = OSAL_s32EventDelete( this->szName );
      u32ErrorCode = OSAL_u32ErrorCode();
      if (( OSAL_OK == s32ErrorValue )
          ||
          (
             ( OSAL_ERROR == s32ErrorValue )
             &&
             ( OSAL_E_INVALIDVALUE == u32ErrorCode)
          ))
      {
         /*
            Delete the name string.
         */
         OSAL_vMemoryFree( (tPVoid)this->szName);
         this->szName = OSAL_NULL;
      }
   }
   while (FALSE);
   return s32ErrorValue;
}
/*
   This methode waits for events specified in the parameters.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
*/
tS32 OSAL_tclEvent::s32Wait( OSAL_tEventMask Mask,           /* (I) */
                             OSAL_tenEventMaskFlag enFlags,  /* (I) */
                             OSAL_tMSecond MSec,             /* (I) */
                             OSAL_tEventMask* pResultMask)   /* (->O) */
{
   return OSAL_s32EventWait( this->hEventHandle, /* (I) */
                             Mask,               /* (I) */
                             enFlags,            /* (I) */
                             MSec,               /* (I) */
                             pResultMask)        /* (->O) */;
}
/*
   This methode sents an event.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
*/
tS32 OSAL_tclEvent::s32Post( OSAL_tEventMask Mask,           /* (I) */
                             OSAL_tenEventMaskFlag enFlags ) /* (I) */
{
   return OSAL_s32EventPost( this->hEventHandle, /* (I) */
                             Mask,               /* (I) */
                             enFlags )           /* (I) */;
}
/*
   This methode provides the possibility to get the content of the field
   of events.
   (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse 
    function OSAL_s32EventStatus().)
*/
tS32 OSAL_tclEvent::s32GetStatus( OSAL_tEventMask Mask,          /* (I) */
                                  OSAL_tEventMask* pMask )       /* (->O) */
{
   return OSAL_s32EventStatus( this->hEventHandle, /* (I) */
                               Mask,               /* (I) */
                               pMask )             /* (->O) */;
}
/* 
   The following methods are new and/or with modification 
   to the OSAL specification. 
*/
/*
   To get the name of the created field of events this methode can be used.
   After deletion the field of events there is no name available furthermore.
*/
tCString OSAL_tclEvent::pszGetName()
{
   return this->szName;
}
